/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.LogTools;
import loci.formats.RandomAccessStream;

public class LegacyZVIReader
extends FormatReader {
    private static final byte[] ZVI_SIG = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static final byte[] ZVI_MAGIC_BLOCK_1;
    private static final byte[] ZVI_MAGIC_BLOCK_2;
    private static final byte[] ZVI_MAGIC_BLOCK_3;
    private static final int BUFFER_SIZE = 8192;
    private static final String WHINING = "Sorry, ZVI support is still preliminary.  It will be improved as time permits.";
    private Vector blockList;
    private int bytesPerPixel;
    private int numZ = 0;
    private int numC = 0;
    private int numT = 0;
    private int cFlag = 0;
    private int zFlag = 0;
    private int tFlag = 0;

    static {
        byte[] byArray = new byte[3];
        byArray[0] = 65;
        byArray[2] = 16;
        ZVI_MAGIC_BLOCK_1 = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[0] = 65;
        byArray2[2] = -128;
        ZVI_MAGIC_BLOCK_2 = byArray2;
        byte[] byArray3 = new byte[3];
        byArray3[0] = 32;
        byArray3[2] = 16;
        ZVI_MAGIC_BLOCK_3 = byArray3;
    }

    public LegacyZVIReader() {
        super("Legacy ZVI", "zvi");
    }

    public boolean isThisType(byte[] block) {
        if (block == null) {
            return false;
        }
        int len = block.length < ZVI_SIG.length ? block.length : ZVI_SIG.length;
        int i = 0;
        while (i < len) {
            if (block[i] != ZVI_SIG[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] buf = new byte[((ZVIBlock)this.blockList.elementAt(no)).imageSize];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        ZVIBlock zviBlock = (ZVIBlock)this.blockList.elementAt(no);
        zviBlock.readBytes(this.in, buf);
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        if (debug) {
            this.debug("Reading image #" + no + "...");
        }
        ZVIBlock zviBlock = (ZVIBlock)this.blockList.elementAt(no);
        return zviBlock.readImage(this.in);
    }

    /*
     * Unable to fully structure code
     */
    protected void initFile(String id) throws FormatException, IOException {
        if (LegacyZVIReader.debug) {
            this.debug("LegacyZVIReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.in.order(true);
        pos = 0L;
        this.blockList = new Vector<E>();
        zSet = new HashSet<Integer>();
        cSet = new HashSet<Integer>();
        tSet = new HashSet<Integer>();
        this.numZ = 0;
        this.numC = 0;
        this.numT = 0;
        numI = 0;
        block11: while (true) {
            this.status("Searching for next image");
            header = LegacyZVIReader.findBlock(this.in, LegacyZVIReader.ZVI_MAGIC_BLOCK_1, pos);
            if (header < 0L) break;
            pos = header + (long)LegacyZVIReader.ZVI_MAGIC_BLOCK_1.length;
            if (LegacyZVIReader.debug) {
                this.debug("Found potential image block: " + header);
            }
            this.in.skipBytes(19);
            pos += 19L;
            b = new byte[LegacyZVIReader.ZVI_MAGIC_BLOCK_2.length];
            this.in.readFully(b);
            ok = true;
            i = 0;
            while (i < b.length) {
                if (b[i] != LegacyZVIReader.ZVI_MAGIC_BLOCK_2[i]) {
                    ok = false;
                    break;
                }
                ++pos;
                ++i;
            }
            if (!ok) continue;
            b = new byte[11];
            this.in.readFully(b);
            i = 0;
            while (i < b.length) {
                if (b[i] != 0) {
                    ok = false;
                    break;
                }
                ++pos;
                ++i;
            }
            if (!ok) continue;
            theZ = this.in.readInt();
            theC = this.in.readInt();
            theT = this.in.readInt();
            pos += 12L;
            b = new byte[108];
            this.in.readFully(b);
            i = 0;
            while (i < b.length) {
                if (b[i] != 0) {
                    ok = false;
                    break;
                }
                ++pos;
                ++i;
            }
            if (!ok) continue;
            this.in.skipBytes(89);
            pos += 89L;
            magic3 = new byte[LegacyZVIReader.ZVI_MAGIC_BLOCK_3.length];
            this.in.readFully(magic3);
            i = 0;
            while (i < magic3.length) {
                if (magic3[i] != LegacyZVIReader.ZVI_MAGIC_BLOCK_3[i]) {
                    ok = false;
                    break;
                }
                ++i;
            }
            if (!ok) continue;
            pos += (long)LegacyZVIReader.ZVI_MAGIC_BLOCK_3.length;
            this.status("Reading image header");
            this.core.sizeX[0] = this.in.readInt();
            this.core.sizeY[0] = this.in.readInt();
            alwaysOne = this.in.readInt();
            this.bytesPerPixel = this.in.readInt();
            pixType = this.in.readInt();
            bitDepth = this.in.readInt();
            pos += 24L;
            type = "";
            switch (pixType) {
                case 1: {
                    type = "8 bit rgb tuple, 24 bpp";
                    this.core.pixelType[0] = 1;
                    break;
                }
                case 2: {
                    type = "8 bit rgb quad, 32 bpp";
                    this.core.pixelType[0] = 1;
                    break;
                }
                case 3: {
                    type = "8 bit grayscale";
                    this.core.pixelType[0] = 1;
                    break;
                }
                case 4: {
                    type = "16 bit signed int, 16 bpp";
                    this.core.pixelType[0] = 3;
                    break;
                }
                case 5: {
                    type = "32 bit int, 32 bpp";
                    this.core.pixelType[0] = 5;
                    break;
                }
                case 6: {
                    type = "32 bit float, 32 bpp";
                    this.core.pixelType[0] = 6;
                    break;
                }
                case 7: {
                    type = "64 bit float, 64 bpp";
                    this.core.pixelType[0] = 7;
                    break;
                }
                case 8: {
                    type = "16 bit unsigned short triple, 48 bpp";
                    this.core.pixelType[0] = 3;
                    break;
                }
                case 9: {
                    type = "32 bit int triple, 96 bpp";
                    this.core.pixelType[0] = 5;
                    break;
                }
                default: {
                    type = "undefined pixel type (" + pixType + ")";
                }
            }
            this.addMeta("Width", new Integer(this.core.sizeX[0]));
            this.addMeta("Height", new Integer(this.core.sizeY[0]));
            this.addMeta("PixelType", type);
            this.addMeta("BPP", new Integer(this.bytesPerPixel));
            zviBlock = new ZVIBlock(theZ, theC, theT, this.core.sizeX[0], this.core.sizeY[0], alwaysOne, this.bytesPerPixel, pixType, bitDepth, pos);
            if (LegacyZVIReader.debug) {
                this.debug(zviBlock.toString());
            }
            zSet.add(new Integer(theZ));
            cSet.add(new Integer(theC));
            tSet.add(new Integer(theT));
            if (++numI == 2 && cSet.size() == 2) {
                this.cFlag = 1;
            }
            if (numI == 2 && zSet.size() == 2) {
                this.zFlag = 1;
            }
            if (numI == 2 && tSet.size() == 2) {
                this.tFlag = 1;
            }
            if (numI % 3 == 0 && zSet.size() > 1 && this.cFlag == 1) {
                this.core.currentOrder[0] = "XYCZT";
            }
            if (numI % 3 == 0 && tSet.size() > 1 && this.cFlag == 1) {
                this.core.currentOrder[0] = "XYCTZ";
            }
            if (numI % 3 == 0 && cSet.size() > 1 && this.zFlag == 1) {
                this.core.currentOrder[0] = "XYZCT";
            }
            if (numI % 3 == 0 && tSet.size() > 1 && this.zFlag == 1) {
                this.core.currentOrder[0] = "XYZTC";
            }
            if (numI % 3 == 0 && cSet.size() > 1 && this.tFlag == 1) {
                this.core.currentOrder[0] = "XYTCZ";
            }
            if (numI % 3 == 0 && zSet.size() > 1 && this.tFlag == 1) {
                this.core.currentOrder[0] = "XYTZC";
            }
            if (this.core.currentOrder[0] == null) {
                this.core.currentOrder[0] = "XYZCT";
            }
            this.blockList.add(zviBlock);
            pos += (long)(this.core.sizeX[0] * this.core.sizeY[0] * this.bytesPerPixel);
            this.core.imageCount[0] = this.blockList.size();
            this.core.sizeX[0] = this.openImage(0).getWidth();
            this.core.sizeY[0] = this.openImage(0).getHeight();
            this.core.sizeZ[0] = zSet.size();
            this.core.sizeC[0] = cSet.size();
            this.core.sizeT[0] = tSet.size();
            this.core.rgb[0] = this.bytesPerPixel == 3 || this.bytesPerPixel > 4;
            this.core.interleaved[0] = false;
            this.core.littleEndian[0] = true;
            store = this.getMetadataStore();
            store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), Boolean.FALSE, this.core.currentOrder[0], null, null);
            i = 0;
            while (true) {
                if (i < this.core.sizeC[0]) ** break;
                continue block11;
                store.setLogicalChannel(i, null, null, null, null, null, null, null);
                ++i;
            }
            break;
        }
        this.status("Verifying image count");
        if (this.blockList.isEmpty()) {
            throw new FormatException("No image data found.Sorry, ZVI support is still preliminary.  It will be improved as time permits.");
        }
        this.numZ = zSet.size();
        this.numC = cSet.size();
        this.numT = tSet.size();
        if (this.numZ * this.numC * this.numT != this.blockList.size()) {
            LogTools.println("Warning: image counts do not match. Sorry, ZVI support is still preliminary.  It will be improved as time permits.");
        }
    }

    private static long findBlock(RandomAccessStream in, byte[] block, long start) throws IOException {
        int len;
        long filePos = start;
        long fileSize = in.length();
        byte[] buf = new byte[8192];
        long spot = -1L;
        int step = 0;
        boolean found = false;
        in.seek(start);
        while ((len = (int)(fileSize - filePos)) >= 0) {
            if (len > buf.length) {
                len = buf.length;
            }
            in.readFully(buf, 0, len);
            int i = 0;
            while (i < len) {
                if (buf[i] == block[step]) {
                    if (step == 0) {
                        spot = filePos + (long)i;
                    }
                    if (++step == block.length) {
                        found = true;
                        break;
                    }
                } else {
                    spot = -1L;
                    step = 0;
                }
                ++i;
            }
            if (found || len < buf.length) break;
            filePos += (long)len;
        }
        if (spot >= 0L) {
            in.seek(spot + (long)block.length);
        }
        return spot;
    }

    private class ZVIBlock {
        private int theZ;
        private int theC;
        private int theT;
        private int width;
        private int height;
        private int alwaysOne;
        private int bytesPerPixel;
        private int pixelType;
        private int bitDepth;
        private long imagePos;
        private int numPixels;
        private int imageSize;
        private int numChannels;
        private int bytesPerChannel;

        public ZVIBlock(int theZ, int theC, int theT, int width, int height, int alwaysOne, int bytesPerPixel, int pixelType, int bitDepth, long imagePos) {
            this.theZ = theZ;
            this.theC = theC;
            this.theT = theT;
            this.width = width;
            this.height = height;
            this.alwaysOne = alwaysOne;
            this.bytesPerPixel = bytesPerPixel;
            this.pixelType = pixelType;
            this.bitDepth = bitDepth;
            this.imagePos = imagePos;
            this.numPixels = width * height;
            this.imageSize = this.numPixels * bytesPerPixel;
            int n = this.numChannels = pixelType == 1 ? 3 : 1;
            if (bytesPerPixel % this.numChannels != 0) {
                LogTools.println("Warning: incompatible bytesPerPixel (" + bytesPerPixel + ") and numChannels (" + this.numChannels + "). Assuming grayscale data. " + LegacyZVIReader.WHINING);
                this.numChannels = 1;
            }
            this.bytesPerChannel = bytesPerPixel / this.numChannels;
        }

        public byte[] readBytes(RandomAccessStream raf, byte[] buf) throws IOException, FormatException {
            long fileSize = raf.length();
            if (this.imagePos + (long)this.imageSize > fileSize) {
                throw new FormatException("File is not big enough to contain the pixels (width=" + this.width + "; height=" + this.height + "; bytesPerPixel=" + this.bytesPerPixel + "; imagePos=" + this.imagePos + "; fileSize=" + fileSize + "). " + LegacyZVIReader.WHINING);
            }
            if (buf.length < this.imageSize) {
                throw new FormatException("Buffer too small");
            }
            raf.seek(this.imagePos);
            raf.readFully(buf);
            return buf;
        }

        public BufferedImage readImage(RandomAccessStream raf) throws IOException, FormatException {
            byte[] imageBytes = this.readBytes(raf, new byte[this.imageSize]);
            if (this.bytesPerPixel > 4) {
                this.numChannels = this.bytesPerPixel / 2;
                this.bytesPerPixel /= this.numChannels;
                this.bytesPerChannel = this.bytesPerPixel;
            }
            int index = 0;
            short[][] samples = new short[this.numChannels][this.numPixels * this.bytesPerPixel];
            int i = 0;
            while (i < this.numPixels) {
                int c = this.numChannels - 1;
                while (c >= 0) {
                    byte[] b = new byte[this.bytesPerChannel];
                    System.arraycopy(imageBytes, index, b, 0, this.bytesPerChannel);
                    index += this.bytesPerChannel;
                    samples[c][i] = (short)(DataTools.bytesToShort(b, true) * 8);
                    --c;
                }
                ++i;
            }
            return ImageTools.makeImage(samples, this.width, this.height);
        }

        public String toString() {
            return "Image header block:\n  theZ = " + this.theZ + "\n" + "  theC = " + this.theC + "\n" + "  theT = " + this.theT + "\n" + "  width = " + this.width + "\n" + "  height = " + this.height + "\n" + "  alwaysOne = " + this.alwaysOne + "\n" + "  bytesPerPixel = " + this.bytesPerPixel + "\n" + "  pixelType = " + this.pixelType + "\n" + "  bitDepth = " + this.bitDepth;
        }
    }
}

