/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import loci.formats.CoreMetadata;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LIFReader
extends FormatReader {
    public static final SAXParserFactory SAX_FACTORY = SAXParserFactory.newInstance();
    protected Vector offsets;
    private int[] bitsPerPixel;
    private int[] extraDimensions;
    private int bpp;
    private Vector xcal;
    private Vector ycal;
    private Vector zcal;
    private Vector seriesNames;

    public LIFReader() {
        super("Leica Image File Format", "lif");
    }

    public boolean isThisType(byte[] block) {
        return block[0] == 112;
    }

    public boolean isMetadataComplete() {
        return true;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        this.bpp = this.bitsPerPixel[this.series];
        while (this.bpp % 8 != 0) {
            ++this.bpp;
        }
        byte[] buf = new byte[this.core.sizeX[this.series] * this.core.sizeY[this.series] * (this.bpp / 8) * this.getRGBChannelCount()];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        this.bpp = this.bitsPerPixel[this.series];
        while (this.bpp % 8 != 0) {
            ++this.bpp;
        }
        int bytes = this.bpp / 8;
        if (buf.length < this.core.sizeX[this.series] * this.core.sizeY[this.series] * bytes * this.getRGBChannelCount()) {
            throw new FormatException("Buffer too small.");
        }
        long offset = (Long)this.offsets.get(this.series);
        this.in.seek(offset + (long)(this.core.sizeX[this.series] * this.core.sizeY[this.series] * bytes * no * this.getRGBChannelCount()));
        this.in.read(buf);
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[this.series], this.core.sizeY[this.series], this.getRGBChannelCount(), false, this.bpp / 8, this.core.littleEndian[this.series]);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("LIFReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.offsets = new Vector();
        this.core.littleEndian[0] = true;
        this.in.order(this.core.littleEndian[0]);
        this.xcal = new Vector();
        this.ycal = new Vector();
        this.zcal = new Vector();
        this.status("Reading header");
        byte checkOne = (byte)this.in.read();
        this.in.skipBytes(2);
        byte checkTwo = (byte)this.in.read();
        if (checkOne != 112 && checkTwo != 112) {
            throw new FormatException(String.valueOf(id) + " is not a valid Leica LIF file");
        }
        this.in.skipBytes(4);
        if (this.in.read() != 42) {
            throw new FormatException("Invalid XML description");
        }
        int nc = this.in.readInt();
        String xml = DataTools.stripString(this.in.readString(nc * 2));
        this.status("Finding image offsets");
        while (this.in.getFilePointer() < this.in.length()) {
            if (this.in.readInt() != 112) {
                throw new FormatException("Invalid Memory Block");
            }
            this.in.skipBytes(4);
            if (this.in.read() != 42) {
                throw new FormatException("Invalid Memory Description");
            }
            int blockLength = this.in.readInt();
            if (this.in.read() != 42) {
                this.in.skipBytes(3);
                if (this.in.read() != 42) {
                    throw new FormatException("Invalid Memory Description");
                }
            }
            int descrLength = this.in.readInt();
            this.in.skipBytes(descrLength * 2);
            if (blockLength > 0) {
                this.offsets.add(new Long(this.in.getFilePointer()));
            }
            this.in.skipBytes(blockLength);
        }
        this.initMetadata(xml);
    }

    private void initMetadata(String xml) throws FormatException, IOException {
        String token;
        LIFHandler handler = new LIFHandler();
        xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><LEICA>" + xml + "</LEICA>";
        int i = 0;
        while (i < xml.length()) {
            char c = xml.charAt(i);
            if (Character.isISOControl(c) || !Character.isDefined(c)) {
                xml = xml.replace(c, ' ');
            }
            ++i;
        }
        try {
            SAXParser parser = SAX_FACTORY.newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()), (DefaultHandler)handler);
        }
        catch (ParserConfigurationException exc) {
            throw new FormatException(exc);
        }
        catch (SAXException exc) {
            throw new FormatException(exc);
        }
        Vector<String> elements = new Vector<String>();
        this.seriesNames = new Vector();
        this.status("Populating native metadata");
        StringTokenizer st = new StringTokenizer(xml, ">");
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            elements.add(token.substring(1));
        }
        token = (String)elements.get(0);
        String key = token.substring(0, token.indexOf("\""));
        String value = token.substring(token.indexOf("\"") + 1, token.length() - 1);
        this.addMeta(key, value);
        int ndx = 1;
        int numDatasets = 0;
        Vector<Integer> widths = new Vector<Integer>();
        Vector<Integer> heights = new Vector<Integer>();
        Vector<Integer> zs = new Vector<Integer>();
        Vector<Integer> ts = new Vector<Integer>();
        Vector<Integer> channels = new Vector<Integer>();
        Vector<Integer> bps = new Vector<Integer>();
        Vector<Integer> extraDims = new Vector<Integer>();
        String prefix = "";
        while (ndx < elements.size()) {
            token = (String)elements.get(ndx);
            if (token.startsWith("ScannerSettingRecord")) {
                int index;
                if (token.indexOf("csScanMode") != -1) {
                    index = token.indexOf("Variant") + 7;
                    String ordering = token.substring(index + 2, token.indexOf("\"", index + 3));
                    if ((ordering = ordering.toLowerCase()).indexOf("x") == -1 || ordering.indexOf("y") == -1 || ordering.indexOf("xy") == -1) {
                        int xPos = ordering.indexOf("x");
                        int yPos = ordering.indexOf("y");
                        int zPos = ordering.indexOf("z");
                        int tPos = ordering.indexOf("t");
                        if (xPos < 0) {
                            xPos = 0;
                        }
                        if (yPos < 0) {
                            yPos = 1;
                        }
                        if (zPos < 0) {
                            zPos = 2;
                        }
                        if (tPos < 0) {
                            tPos = 3;
                        }
                        int x = (Integer)widths.get(widths.size() - 1);
                        int y = (Integer)heights.get(widths.size() - 1);
                        int z = (Integer)zs.get(widths.size() - 1);
                        int t = (Integer)ts.get(widths.size() - 1);
                        int[] dimensions = new int[]{x, y, z, t};
                        x = dimensions[xPos];
                        y = dimensions[yPos];
                        z = dimensions[zPos];
                        t = dimensions[tPos];
                        widths.setElementAt(new Integer(x), widths.size() - 1);
                        heights.setElementAt(new Integer(y), heights.size() - 1);
                        zs.setElementAt(new Integer(z), zs.size() - 1);
                        ts.setElementAt(new Integer(t), ts.size() - 1);
                    }
                } else if (token.indexOf("dblVoxel") != -1) {
                    index = token.indexOf("Variant") + 7;
                    String size = token.substring(index + 2, token.indexOf("\"", index + 3));
                    float cal = Float.parseFloat(size) * 1000000.0f;
                    if (token.indexOf("X") != -1) {
                        this.xcal.add(new Float(cal));
                    } else if (token.indexOf("Y") != -1) {
                        this.ycal.add(new Float(cal));
                    } else if (token.indexOf("Z") != -1) {
                        this.zcal.add(new Float(cal));
                    }
                }
            } else if (token.startsWith("Element Name")) {
                this.seriesNames.add(token.substring(token.indexOf("=") + 2, token.length() - 1));
                ++numDatasets;
                int numChannels = 0;
                int extras = 1;
                while (token.indexOf("/ImageDescription") == -1) {
                    if (token.indexOf("=") != -1) {
                        if (token.startsWith("Element Name")) {
                            this.seriesNames.setElementAt(token.substring(token.indexOf("=") + 2, token.length() - 1), this.seriesNames.size() - 1);
                            prefix = (String)this.seriesNames.get(this.seriesNames.size() - 1);
                        }
                        Hashtable<String, String> tmp = new Hashtable<String, String>();
                        while (token.length() > 2) {
                            key = token.substring(0, token.indexOf("\"") - 1);
                            value = token.substring(token.indexOf("\"") + 1, token.indexOf("\"", token.indexOf("\"") + 1));
                            token = token.substring(key.length() + value.length() + 3);
                            key = key.trim();
                            value = value.trim();
                            tmp.put(key, value);
                        }
                        if (tmp.get("ChannelDescription DataType") != null) {
                            if (++numChannels == 1) {
                                bps.add(new Integer((String)tmp.get("Resolution")));
                            }
                        } else if (tmp.get("DimensionDescription DimID") != null) {
                            int w = Integer.parseInt((String)tmp.get("NumberOfElements"));
                            int id = Integer.parseInt((String)tmp.get("DimensionDescription DimID"));
                            switch (id) {
                                case 1: {
                                    widths.add(new Integer(w));
                                    break;
                                }
                                case 2: {
                                    heights.add(new Integer(w));
                                    break;
                                }
                                case 3: {
                                    zs.add(new Integer(w));
                                    break;
                                }
                                case 4: {
                                    ts.add(new Integer(w));
                                    break;
                                }
                                default: {
                                    extras *= w;
                                }
                            }
                        }
                    }
                    if (elements == null || ++ndx >= elements.size()) break;
                    token = (String)elements.get(ndx);
                }
                extraDims.add(new Integer(extras));
                if (numChannels == 0) {
                    ++numChannels;
                }
                channels.add(new Integer(numChannels));
                if (widths.size() < numDatasets && heights.size() < numDatasets) {
                    --numDatasets;
                } else {
                    if (widths.size() < numDatasets) {
                        widths.add(new Integer(1));
                    }
                    if (heights.size() < numDatasets) {
                        heights.add(new Integer(1));
                    }
                    if (zs.size() < numDatasets) {
                        zs.add(new Integer(1));
                    }
                    if (ts.size() < numDatasets) {
                        ts.add(new Integer(1));
                    }
                    if (bps.size() < numDatasets) {
                        bps.add(new Integer(8));
                    }
                }
            }
            ++ndx;
        }
        numDatasets = widths.size();
        this.bitsPerPixel = new int[numDatasets];
        this.extraDimensions = new int[numDatasets];
        this.status("Populating metadata");
        MetadataStore store = this.getMetadataStore();
        this.core = new CoreMetadata(numDatasets);
        Arrays.fill(this.core.orderCertain, true);
        int i2 = 0;
        while (i2 < numDatasets) {
            this.core.sizeX[i2] = (Integer)widths.get(i2);
            this.core.sizeY[i2] = (Integer)heights.get(i2);
            this.core.sizeZ[i2] = (Integer)zs.get(i2);
            this.core.sizeC[i2] = (Integer)channels.get(i2);
            this.core.sizeT[i2] = (Integer)ts.get(i2);
            this.core.currentOrder[i2] = this.core.sizeZ[i2] > this.core.sizeT[i2] ? "XYCZT" : "XYCTZ";
            this.bitsPerPixel[i2] = (Integer)bps.get(i2);
            this.extraDimensions[i2] = (Integer)extraDims.get(i2);
            if (this.extraDimensions[i2] > 1) {
                if (this.core.sizeZ[i2] == 1) {
                    this.core.sizeZ[i2] = this.extraDimensions[i2];
                } else {
                    int n = i2;
                    this.core.sizeT[n] = this.core.sizeT[n] * this.extraDimensions[i2];
                }
                this.extraDimensions[i2] = 1;
            }
            this.core.littleEndian[i2] = true;
            this.core.rgb[i2] = this.core.sizeC[i2] > 1 && this.core.sizeC[i2] < 4;
            this.core.interleaved[i2] = true;
            this.core.imageCount[i2] = this.core.sizeZ[i2] * this.core.sizeT[i2];
            if (!this.core.rgb[i2]) {
                int n = i2;
                this.core.imageCount[n] = this.core.imageCount[n] * this.core.sizeC[i2];
            }
            while (this.bitsPerPixel[i2] % 8 != 0) {
                int n = i2;
                this.bitsPerPixel[n] = this.bitsPerPixel[n] + 1;
            }
            switch (this.bitsPerPixel[i2]) {
                case 8: {
                    this.core.pixelType[i2] = 1;
                    break;
                }
                case 16: {
                    this.core.pixelType[i2] = 3;
                    break;
                }
                case 32: {
                    this.core.pixelType[i2] = 6;
                }
            }
            Integer ii = new Integer(i2);
            String seriesName = (String)this.seriesNames.get(i2);
            if (seriesName == null || seriesName.trim().length() == 0) {
                seriesName = "Series " + (i2 + 1);
            }
            store.setImage(seriesName, null, null, ii);
            store.setPixels(new Integer(this.core.sizeX[i2]), new Integer(this.core.sizeY[i2]), new Integer(this.core.sizeZ[i2]), new Integer(this.core.sizeC[i2]), new Integer(this.core.sizeT[i2]), new Integer(this.core.pixelType[i2]), new Boolean(!this.core.littleEndian[i2]), this.core.currentOrder[i2], ii, null);
            Float xf = i2 < this.xcal.size() ? (Float)this.xcal.get(i2) : null;
            Float yf = i2 < this.ycal.size() ? (Float)this.ycal.get(i2) : null;
            Float zf = i2 < this.zcal.size() ? (Float)this.zcal.get(i2) : null;
            store.setDimensions(xf, yf, zf, null, null, ii);
            int j = 0;
            while (j < this.core.sizeC[i2]) {
                store.setLogicalChannel(j, null, null, null, null, null, null, ii);
                ++j;
            }
            String zoom = (String)this.getMeta(String.valueOf(seriesName) + " - dblZoom");
            store.setDisplayOptions(zoom == null ? null : new Float(zoom), new Boolean(this.core.sizeC[i2] > 1), new Boolean(this.core.sizeC[i2] > 1), new Boolean(this.core.sizeC[i2] > 2), new Boolean(this.isRGB()), null, null, null, null, null, ii, null, null, null, null, null);
            Enumeration keys = this.metadata.keys();
            while (keys.hasMoreElements()) {
                String k = (String)keys.nextElement();
                boolean use = true;
                int j2 = 0;
                while (j2 < this.seriesNames.size()) {
                    if (j2 != i2 && k.startsWith((String)this.seriesNames.get(j2))) {
                        use = false;
                        break;
                    }
                    ++j2;
                }
                if (!use) continue;
                this.core.seriesMetadata[i2].put(k, this.metadata.get(k));
            }
            ++i2;
        }
    }

    class LIFHandler
    extends DefaultHandler {
        private String series;
        private int count = 0;

        LIFHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("Element")) {
                if (!attributes.getValue("Name").equals("DCROISet")) {
                    this.series = attributes.getValue("Name");
                }
            } else if (qName.equals("Experiment")) {
                int i = 0;
                while (i < attributes.getLength()) {
                    LIFReader.this.addMeta(attributes.getQName(i), attributes.getValue(i));
                    ++i;
                }
            } else if (qName.equals("ChannelDescription")) {
                String prefix = String.valueOf(this.series) + " - Channel " + this.count + " - ";
                LIFReader.this.addMeta(String.valueOf(prefix) + "Min", attributes.getValue("Min"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "Max", attributes.getValue("Max"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "Resolution", attributes.getValue("Resolution"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "LUTName", attributes.getValue("LUTName"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "IsLUTInverted", attributes.getValue("IsLUTInverted"));
                ++this.count;
            } else if (qName.equals("DimensionDescription")) {
                String prefix = String.valueOf(this.series) + " - Dimension " + this.count + " - ";
                LIFReader.this.addMeta(String.valueOf(prefix) + "NumberOfElements", attributes.getValue("NumberOfElements"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "Length", attributes.getValue("Length"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "Origin", attributes.getValue("Origin"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "DimID", attributes.getValue("DimID"));
            } else if (qName.equals("ScannerSettingRecord")) {
                String key = String.valueOf(attributes.getValue("Identifier")) + " - " + attributes.getValue("Description");
                LIFReader.this.addMeta(String.valueOf(this.series) + " - " + key, attributes.getValue("Variant"));
            } else if (qName.equals("FilterSettingRecord")) {
                String key = String.valueOf(attributes.getValue("ObjectName")) + " - " + attributes.getValue("Description") + " - " + attributes.getValue("Attribute");
                LIFReader.this.addMeta(String.valueOf(this.series) + " - " + key, attributes.getValue("Variant"));
            } else if (qName.equals("ATLConfocalSettingDefinition")) {
                if (this.series.endsWith(" - Master sequential setting")) {
                    this.series = this.series.replaceAll(" - Master sequential setting", " - Sequential Setting 0");
                }
                if (this.series.indexOf("- Sequential Setting ") == -1) {
                    this.series = String.valueOf(this.series) + " - Master sequential setting";
                } else {
                    int ndx = this.series.indexOf(" - Sequential Setting ") + 22;
                    int n = Integer.parseInt(this.series.substring(ndx));
                    this.series = String.valueOf(this.series.substring(0, ndx)) + String.valueOf(++n);
                }
                int i = 0;
                while (i < attributes.getLength()) {
                    LIFReader.this.addMeta(String.valueOf(this.series) + " - " + attributes.getQName(i), attributes.getValue(i));
                    ++i;
                }
            } else if (qName.equals("Wheel")) {
                String prefix = String.valueOf(this.series) + " - Wheel " + this.count + " - ";
                LIFReader.this.addMeta(String.valueOf(prefix) + "Qualifier", attributes.getValue("Qualifier"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "FilterIndex", attributes.getValue("FilterIndex"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "FilterSpectrumPos", attributes.getValue("FilterSpectrumPos"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "IsSpectrumTurnMode", attributes.getValue("IsSpectrumTurnMode"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "IndexChanged", attributes.getValue("IndexChanged"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "SpectrumChanged", attributes.getValue("SpectrumChanged"));
                ++this.count;
            } else if (qName.equals("WheelName")) {
                String prefix = String.valueOf(this.series) + " - Wheel " + (this.count - 1) + " - WheelName ";
                int ndx = 0;
                while (LIFReader.this.getMeta(String.valueOf(prefix) + ndx) != null) {
                    ++ndx;
                }
                LIFReader.this.addMeta(String.valueOf(prefix) + ndx, attributes.getValue("FilterName"));
            } else if (qName.equals("MultiBand")) {
                String prefix = String.valueOf(this.series) + " - MultiBand Channel " + attributes.getValue("Channel") + " - ";
                LIFReader.this.addMeta(String.valueOf(prefix) + "LeftWorld", attributes.getValue("LeftWorld"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "RightWorld", attributes.getValue("RightWorld"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "DyeName", attributes.getValue("DyeName"));
            } else if (qName.equals("LaserLineSetting")) {
                String prefix = String.valueOf(this.series) + " - LaserLine " + attributes.getValue("LaserLine") + " - ";
                LIFReader.this.addMeta(String.valueOf(prefix) + "IntensityDev", attributes.getValue("IntensityDev"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "IntensityLowDev", attributes.getValue("IntensityLowDev"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "AOBSIntensityDev", attributes.getValue("AOBSIntensityDev"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "AOBSIntensityLowDev", attributes.getValue("AOBSIntensityLowDev"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "EnableDoubleMode", attributes.getValue("EnableDoubleMode"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "LineIndex", attributes.getValue("LineIndex"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "Qualifier", attributes.getValue("Qualifier"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "SequenceIndex", attributes.getValue("SequenceIndex"));
            } else if (qName.equals("Detector")) {
                String prefix = String.valueOf(this.series) + " - Detector Channel " + attributes.getValue("Channel") + " - ";
                LIFReader.this.addMeta(String.valueOf(prefix) + "IsActive", attributes.getValue("IsActive"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "IsReferenceUnitActivatedForCorrection", attributes.getValue("IsReferenceUnitActivatedForCorrection"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "Gain", attributes.getValue("Gain"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "Offset", attributes.getValue("Offset"));
            } else if (qName.equals("Laser")) {
                String prefix = String.valueOf(this.series) + " Laser " + attributes.getValue("LaserName") + " - ";
                LIFReader.this.addMeta(String.valueOf(prefix) + "CanDoLinearOutputPower", attributes.getValue("CanDoLinearOutputPower"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "OutputPower", attributes.getValue("OutputPower"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "Wavelength", attributes.getValue("Wavelength"));
            } else if (qName.equals("TimeStamp")) {
                long high = Long.parseLong(attributes.getValue("HighInteger"));
                long low = Long.parseLong(attributes.getValue("LowInteger"));
                long stamp = 0L;
                high <<= 32;
                if ((int)low < 0) {
                    low &= 0xFFFFFFFFL;
                }
                stamp = high + low;
                long ms = stamp / 10000L;
                Date d = new Date(ms -= 11644444800000L);
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                StringBuffer sb = new StringBuffer();
                fmt.format(d, sb, new FieldPosition(0));
                String n = String.valueOf(this.count);
                while (n.length() < 4) {
                    n = "0" + n;
                }
                LIFReader.this.addMeta(String.valueOf(this.series) + " - TimeStamp " + n, sb.toString());
                ++this.count;
            } else if (qName.equals("ChannelScalingInfo")) {
                String prefix = String.valueOf(this.series) + " - ChannelScalingInfo " + this.count + " - ";
                LIFReader.this.addMeta(String.valueOf(prefix) + "WhiteValue", attributes.getValue("WhiteValue"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "BlackValue", attributes.getValue("BlackValue"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "GammaValue", attributes.getValue("GammaValue"));
                LIFReader.this.addMeta(String.valueOf(prefix) + "Automatic", attributes.getValue("Automatic"));
            } else if (qName.equals("RelTimeStamp")) {
                LIFReader.this.addMeta(String.valueOf(this.series) + " RelTimeStamp " + attributes.getValue("Frame"), attributes.getValue("Time"));
            } else {
                this.count = 0;
            }
        }
    }
}

