/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class KhorosReader
extends FormatReader {
    private byte[] lut;
    private long offset;

    public KhorosReader() {
        super("Khoros XV", "xv");
    }

    public boolean isThisType(byte[] block) {
        return block[0] == -85 && block[1] == 1;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] buf = new byte[this.core.sizeX[0] * this.core.sizeY[0] * this.core.sizeC[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0])];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.core.imageCount[0]) {
            throw new FormatException("Invalid image number: " + no);
        }
        this.in.seek(this.offset + (long)(no * (this.core.sizeX[0] * this.core.sizeY[0] * this.getRGBChannelCount())));
        if (this.lut == null) {
            this.in.read(buf);
        } else {
            int plane = this.core.sizeX[0] * this.core.sizeY[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0]);
            int i = 0;
            while (i < plane) {
                int ndx = this.in.read();
                if (ndx < 0) {
                    ndx += 256;
                }
                buf[i] = this.lut[ndx * 3];
                buf[i + plane] = this.lut[ndx * 3 + 1];
                buf[i + 2 * plane] = this.lut[ndx * 3 + 2];
                ++i;
            }
        }
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core.pixelType[0] == 6) {
            byte[] b = this.openBytes(no);
            float[] f = new float[this.core.sizeX[0] * this.core.sizeY[0] * this.core.sizeC[0]];
            int i = 0;
            while (i < f.length) {
                f[i] = Float.intBitsToFloat(DataTools.bytesToInt(b, i * 4, !this.core.littleEndian[0]));
                ++i;
            }
            return ImageTools.makeImage(f, this.core.sizeX[0], this.core.sizeY[0], this.core.sizeC[0], this.core.interleaved[0]);
        }
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], this.core.sizeC[0], this.core.interleaved[0], FormatTools.getBytesPerPixel(this.core.pixelType[0]), this.core.littleEndian[0]);
    }

    public void close() throws IOException {
        super.close();
        this.lut = null;
        this.offset = 0L;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.in.skipBytes(2);
        int release = this.in.read();
        int version = this.in.read();
        this.in.order(true);
        int dependency = this.in.readInt();
        this.addMeta("Comment", this.in.readString(512));
        this.in.order(dependency == 4 || dependency == 8);
        this.core.sizeX[0] = this.in.readInt();
        this.core.sizeY[0] = this.in.readInt();
        this.in.skipBytes(28);
        this.core.imageCount[0] = this.in.readInt();
        if (this.core.imageCount[0] == 0) {
            this.core.imageCount[0] = 1;
        }
        this.core.sizeC[0] = this.in.readInt();
        int type = this.in.readInt();
        switch (type) {
            case 0: 
            case 1: {
                this.core.pixelType[0] = 1;
                break;
            }
            case 2: {
                this.core.pixelType[0] = 3;
                break;
            }
            case 4: {
                this.core.pixelType[0] = 5;
                break;
            }
            case 5: {
                this.core.pixelType[0] = 6;
                break;
            }
            case 9: {
                this.core.pixelType[0] = 7;
                break;
            }
            default: {
                throw new FormatException("Unsupported pixel type : " + type);
            }
        }
        this.in.skipBytes(12);
        int c = this.in.readInt();
        if (c > 1) {
            this.core.sizeC[0] = c;
            int n = this.in.readInt();
            this.lut = new byte[n * c];
            this.in.skipBytes(436);
            i = 0;
            while (i < this.lut.length) {
                int value = this.in.read();
                if (i < n) {
                    this.lut[i * 3] = (byte)value;
                    this.lut[i * 3 + 1] = (byte)value;
                    this.lut[i * 3 + 2] = (byte)value;
                } else if (i < n * 2) {
                    this.lut[i % n * 3 + 1] = (byte)value;
                } else if (i < n * 3) {
                    this.lut[i % n * 3 + 2] = (byte)value;
                }
                ++i;
            }
        } else {
            this.in.skipBytes(440);
        }
        this.offset = this.in.getFilePointer();
        this.core.sizeZ[0] = this.core.imageCount[0];
        this.core.sizeT[0] = 1;
        this.core.rgb[0] = this.core.sizeC[0] > 1;
        this.core.interleaved[0] = false;
        this.core.littleEndian[0] = dependency == 4 || dependency == 8;
        this.core.currentOrder[0] = "XYCZT";
        MetadataStore store = this.getMetadataStore();
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(this.core.littleEndian[0]), this.core.currentOrder[0], null, null);
        i = 0;
        while (i < this.core.sizeC[0]) {
            store.setLogicalChannel(i, null, null, null, null, this.core.sizeC[0] == 1 ? "monochrome" : "RGB", null, null);
            ++i;
        }
    }
}

