/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.LogTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;

public class IPWReader
extends BaseTiffReader {
    private static final String NO_POI_MSG = "Jakarta POI is required to read IPW files. Please obtain poi-loci.jar from http://loci.wisc.edu/ome/formats.html";
    private static boolean noPOI = false;
    private static ReflectedUniverse r = IPWReader.createReflectedUniverse();
    private Hashtable pixels;
    private Hashtable names;
    private byte[] header;
    private byte[] tags;

    private static ReflectedUniverse createReflectedUniverse() {
        block2: {
            r = null;
            try {
                r = new ReflectedUniverse();
                r.exec("import org.apache.poi.poifs.filesystem.POIFSFileSystem");
                r.exec("import org.apache.poi.poifs.filesystem.DirectoryEntry");
                r.exec("import org.apache.poi.poifs.filesystem.DocumentEntry");
                r.exec("import org.apache.poi.poifs.filesystem.DocumentInputStream");
                r.exec("import java.util.Iterator");
            }
            catch (Throwable t) {
                noPOI = true;
                if (!debug) break block2;
                LogTools.trace(t);
            }
        }
        return r;
    }

    public IPWReader() {
        super("Image-Pro Workspace", "ipw");
    }

    public boolean isThisType(byte[] block) {
        return block[0] == 208 && block[1] == 207 && block[2] == 17 && block[3] == 224;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int c = this.getRGBChannelCount();
        if (c == 2) {
            ++c;
        }
        byte[] buf = new byte[this.core.sizeX[0] * this.core.sizeY[0] * c * FormatTools.getBytesPerPixel(this.core.pixelType[0])];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        try {
            String directory = (String)this.pixels.get(new Integer(no));
            String name = (String)this.names.get(new Integer(no));
            r.setVar("dirName", directory);
            r.exec("root = fs.getRoot()");
            if (!directory.equals("Root Entry")) {
                r.exec("dir = root.getEntry(dirName)");
                r.setVar("entryName", name);
                r.exec("document = dir.getEntry(entryName)");
            } else {
                r.setVar("entryName", name);
                r.exec("document = root.getEntry(entryName)");
            }
            r.exec("dis = new DocumentInputStream(document)");
            r.exec("numBytes = dis.available()");
            int numBytes = (Integer)r.getVar("numBytes");
            byte[] b = new byte[numBytes + 4];
            r.setVar("data", b);
            r.exec("dis.read(data)");
            RandomAccessStream stream = new RandomAccessStream(b);
            this.ifds = TiffTools.getIFDs(stream);
            this.core.littleEndian[0] = TiffTools.isLittleEndian(this.ifds[0]);
            TiffTools.getSamples(this.ifds[0], stream, buf);
            stream.close();
            return buf;
        }
        catch (ReflectException e) {
            noPOI = true;
            return null;
        }
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        byte[] b = this.openBytes(no);
        int bytes = b.length / (this.core.sizeX[0] * this.core.sizeY[0]);
        return ImageTools.makeImage(b, this.core.sizeX[0], this.core.sizeY[0], bytes == 3 ? 3 : 1, false, bytes == 3 ? 1 : bytes, this.core.littleEndian[0]);
    }

    public void close() throws IOException {
        super.close();
        this.pixels = null;
        this.names = null;
        this.header = null;
        this.tags = null;
        String[] vars = new String[]{"dirName", "root", "dir", "document", "dis", "numBytes", "data", "fis", "fs", "iter", "isInstance", "isDocument", "entry", "documentName", "entryName"};
        int i = 0;
        while (i < vars.length) {
            r.setVar(vars[i], null);
            ++i;
        }
    }

    public void initMetadata() throws FormatException, IOException {
        String directory = (String)this.pixels.get(new Integer(0));
        String name = (String)this.names.get(new Integer(0));
        try {
            r.setVar("dirName", directory);
            r.exec("root = fs.getRoot()");
            if (!directory.equals("Root Entry")) {
                r.exec("dir = root.getEntry(dirName)");
                r.setVar("entryName", name);
                r.exec("document = dir.getEntry(entryName)");
            } else {
                r.setVar("entryName", name);
                r.exec("document = root.getEntry(entryName)");
            }
            r.exec("dis = new DocumentInputStream(document)");
            r.exec("numBytes = dis.available()");
            int numBytes = (Integer)r.getVar("numBytes");
            byte[] b = new byte[numBytes + 4];
            r.setVar("data", b);
            r.exec("dis.read(data)");
            RandomAccessStream stream = new RandomAccessStream(b);
            this.ifds = TiffTools.getIFDs(stream);
            stream.close();
        }
        catch (ReflectException numBytes) {
            // empty catch block
        }
        boolean bl = this.core.rgb[0] = TiffTools.getIFDIntValue(this.ifds[0], 277, false, 1) > 1;
        if (!this.core.rgb[0]) {
            this.core.rgb[0] = TiffTools.getIFDIntValue(this.ifds[0], 262, false, 1) == 3;
        }
        this.core.littleEndian[0] = TiffTools.isLittleEndian(this.ifds[0]);
        String description = new String(this.tags, 22, this.tags.length - 22);
        this.addMeta("Image Description", description);
        this.core.sizeZ[0] = 1;
        this.core.sizeC[0] = 1;
        this.core.sizeT[0] = this.getImageCount();
        this.addMeta("slices", "1");
        this.addMeta("channels", "1");
        this.addMeta("frames", new Integer(this.getImageCount()));
        if (description != null) {
            StringTokenizer tokenizer = new StringTokenizer(description, "\n");
            while (tokenizer.hasMoreTokens()) {
                String data;
                String token = tokenizer.nextToken();
                String label = "Timestamp";
                if (token.indexOf("=") != -1) {
                    label = token.substring(0, token.indexOf("="));
                    data = token.substring(token.indexOf("=") + 1);
                } else {
                    data = token.trim();
                }
                this.addMeta(label, data);
                if (label.equals("frames")) {
                    this.core.sizeZ[0] = Integer.parseInt(data);
                    continue;
                }
                if (label.equals("slices")) {
                    this.core.sizeT[0] = Integer.parseInt(data);
                    continue;
                }
                if (!label.equals("channels")) continue;
                this.core.sizeC[0] = Integer.parseInt(data);
            }
        }
        this.addMeta("Version", new String(this.header).trim());
        Hashtable h = this.ifds[0];
        this.core.sizeX[0] = TiffTools.getIFDIntValue(h, 256);
        this.core.sizeY[0] = TiffTools.getIFDIntValue(h, 257);
        this.core.currentOrder[0] = "XY";
        if (this.core.sizeZ[0] == 0) {
            this.core.sizeZ[0] = 1;
        }
        if (this.core.sizeC[0] == 0) {
            this.core.sizeC[0] = 1;
        }
        if (this.core.sizeT[0] == 0) {
            this.core.sizeT[0] = 1;
        }
        if (this.core.rgb[0]) {
            this.core.sizeC[0] = this.core.sizeC[0] * 3;
        }
        int maxNdx = 0;
        int max = 0;
        int[] dims = new int[]{this.core.sizeZ[0], this.core.sizeC[0], this.core.sizeT[0]};
        String[] axes = new String[]{"Z", "C", "T"};
        int i = 0;
        while (i < dims.length) {
            if (dims[i] > max) {
                max = dims[i];
                maxNdx = i;
            }
            ++i;
        }
        this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + axes[maxNdx];
        if (maxNdx != 1) {
            if (this.core.sizeC[0] > 1) {
                this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + "C";
                this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + (maxNdx == 0 ? axes[2] : axes[0]);
            } else {
                this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + (maxNdx == 0 ? axes[2] : axes[0]) + "C";
            }
        } else {
            this.core.currentOrder[0] = this.core.sizeZ[0] > this.core.sizeT[0] ? String.valueOf(this.core.currentOrder[0]) + "ZT" : String.valueOf(this.core.currentOrder[0]) + "TZ";
        }
        int bitsPerSample = TiffTools.getIFDIntValue(this.ifds[0], 258);
        int bitFormat = TiffTools.getIFDIntValue(this.ifds[0], 339);
        while (bitsPerSample % 8 != 0) {
            ++bitsPerSample;
        }
        if (bitsPerSample == 24 || bitsPerSample == 48) {
            bitsPerSample /= 3;
        }
        this.core.pixelType[0] = 1;
        if (bitFormat == 3) {
            this.core.pixelType[0] = 6;
        } else if (bitFormat == 2) {
            switch (bitsPerSample) {
                case 8: {
                    this.core.pixelType[0] = 0;
                    break;
                }
                case 16: {
                    this.core.pixelType[0] = 2;
                    break;
                }
                case 32: {
                    this.core.pixelType[0] = 4;
                }
            }
        } else {
            switch (bitsPerSample) {
                case 8: {
                    this.core.pixelType[0] = 1;
                    break;
                }
                case 16: {
                    this.core.pixelType[0] = 3;
                    break;
                }
                case 32: {
                    this.core.pixelType[0] = 5;
                }
            }
        }
        MetadataStore store = this.getMetadataStore();
        store.setPixels(null, null, new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(!this.isLittleEndian()), this.core.currentOrder[0], null, null);
        store.setImage(null, null, (String)this.getMeta("Version"), null);
        int i2 = 0;
        while (i2 < this.core.sizeC[0]) {
            store.setLogicalChannel(i2, null, null, null, null, null, null, null);
            ++i2;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        block4: {
            if (debug) {
                this.debug("IPWReader.initFile(" + id + ")");
            }
            if (noPOI) {
                throw new FormatException(NO_POI_MSG);
            }
            this.currentId = id;
            this.metadata = new Hashtable();
            this.core = new CoreMetadata(1);
            Arrays.fill(this.core.orderCertain, true);
            this.getMetadataStore().createRoot();
            this.in = new RandomAccessStream(id);
            this.pixels = new Hashtable();
            this.names = new Hashtable();
            try {
                r.setVar("fis", this.in);
                r.exec("fs = new POIFSFileSystem(fis)");
                r.exec("dir = fs.getRoot()");
                this.parseDir(0, r.getVar("dir"));
                this.status("Populating metadata");
                this.initMetadata();
            }
            catch (Throwable t) {
                noPOI = true;
                if (!debug) break block4;
                this.trace(t);
            }
        }
        this.core.interleaved[0] = true;
    }

    protected void parseDir(int depth, Object dir) throws IOException, FormatException, ReflectException {
        r.setVar("dir", dir);
        r.exec("dirName = dir.getName()");
        r.setVar("depth", depth);
        r.exec("iter = dir.getEntries()");
        Iterator iter = (Iterator)r.getVar("iter");
        while (iter.hasNext()) {
            r.setVar("entry", iter.next());
            r.exec("isInstance = entry.isDirectoryEntry()");
            r.exec("isDocument = entry.isDocumentEntry()");
            boolean isInstance = (Boolean)r.getVar("isInstance");
            boolean isDocument = (Boolean)r.getVar("isDocument");
            r.setVar("dir", dir);
            r.exec("dirName = dir.getName()");
            if (isInstance) {
                this.status("Parsing embedded folder (" + (depth + 1) + ")");
                this.parseDir(depth + 1, r.getVar("entry"));
                continue;
            }
            if (!isDocument) continue;
            this.status("Parsing embedded file (" + depth + ")");
            r.exec("entryName = entry.getName()");
            r.exec("dis = new DocumentInputStream(entry)");
            r.exec("numBytes = dis.available()");
            int numbytes = (Integer)r.getVar("numBytes");
            byte[] data = new byte[numbytes + 4];
            r.setVar("data", data);
            r.exec("dis.read(data)");
            RandomAccessStream ds = new RandomAccessStream(data);
            ds.order(true);
            String entryName = (String)r.getVar("entryName");
            String dirName = (String)r.getVar("dirName");
            boolean isContents = entryName.equals("CONTENTS");
            if (isContents) {
                this.header = data;
            } else if (entryName.equals("FrameRate")) {
                this.addMeta("Frame Rate", new Long(ds.readInt()));
            } else if (entryName.equals("FrameInfo")) {
                int i = 0;
                while (i < data.length / 2) {
                    this.addMeta("FrameInfo " + i, new Short(ds.readShort()));
                    ++i;
                }
            } else if (entryName.equals("ImageInfo")) {
                this.tags = data;
            } else if (!entryName.equals("ImageResponse") && entryName.equals("ImageTIFF")) {
                String name = !dirName.equals("Root Entry") ? dirName.substring(11, dirName.length()) : "0";
                Integer imageNum = Integer.valueOf(name);
                this.pixels.put(imageNum, dirName);
                this.names.put(imageNum, entryName);
                this.core.imageCount[0] = this.core.imageCount[0] + 1;
            }
            ds.close();
            r.exec("dis.close()");
            if (!debug) continue;
            this.print(depth + 1, String.valueOf(data.length) + " bytes read.");
        }
    }

    protected void print(int depth, String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < depth) {
            sb.append("  ");
            ++i;
        }
        sb.append(s);
        this.debug(sb.toString());
    }
}

