/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Vector;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class GatanReader
extends FormatReader {
    private long pixelOffset;
    private Vector pixelSizes;
    private int bytesPerPixel;
    protected int pixelDataNum = 0;
    protected int datatype;

    public GatanReader() {
        super("Gatan Digital Micrograph", "dm3");
    }

    public boolean isThisType(byte[] block) {
        if (block == null || block.length < 4) {
            return false;
        }
        return DataTools.bytesToInt(block, false) == 3;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] buf = new byte[this.core.sizeX[0] * this.core.sizeY[0] * this.bytesPerPixel];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no != 0) {
            throw new FormatException("Invalid image number: " + no);
        }
        if (buf.length < this.core.sizeX[0] * this.core.sizeY[0] * this.bytesPerPixel) {
            throw new FormatException("Buffer too small.");
        }
        this.in.seek(this.pixelOffset);
        this.in.read(buf);
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], 1, false, this.bytesPerPixel, this.core.littleEndian[0]);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("GatanReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.pixelOffset = 0L;
        this.status("Verifying Gatan format");
        this.core.littleEndian[0] = false;
        this.pixelSizes = new Vector();
        this.in.order(false);
        if (this.in.readInt() != 3) {
            throw new FormatException("invalid header");
        }
        this.status("Reading tags");
        this.in.skipBytes(4);
        this.core.littleEndian[0] = this.in.readInt() == 1;
        this.in.skipBytes(2);
        this.in.order(!this.core.littleEndian[0]);
        this.parseTags(this.in.readInt(), "initFile");
        this.status("Populating metadata");
        switch (this.datatype) {
            case 1: 
            case 10: {
                this.core.pixelType[0] = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 12: 
            case 13: {
                this.core.pixelType[0] = 6;
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 23: {
                this.core.pixelType[0] = 5;
                break;
            }
            default: {
                this.core.pixelType[0] = 1;
            }
        }
        this.core.sizeZ[0] = 1;
        this.core.sizeC[0] = 1;
        this.core.sizeT[0] = 1;
        this.core.currentOrder[0] = "XYZTC";
        this.core.imageCount[0] = 1;
        this.core.rgb[0] = false;
        this.core.interleaved[0] = false;
        MetadataStore store = this.getMetadataStore();
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(!this.core.littleEndian[0]), this.core.currentOrder[0], null, null);
        Float pixX = new Float(1.0f);
        Float pixY = new Float(1.0f);
        Float pixZ = new Float(1.0f);
        if (this.pixelSizes.size() > 0) {
            pixX = new Float((String)this.pixelSizes.get(0));
        }
        if (this.pixelSizes.size() > 1) {
            pixY = new Float((String)this.pixelSizes.get(1));
        }
        if (this.pixelSizes.size() > 2) {
            pixZ = new Float((String)this.pixelSizes.get(2));
        }
        store.setDimensions(pixX, pixY, pixZ, null, null, null);
        String gamma = (String)this.getMeta("Gamma");
        int i = 0;
        while (i < this.core.sizeC[0]) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null);
            store.setDisplayChannel(new Integer(i), null, null, gamma == null ? null : new Float(gamma), null);
            ++i;
        }
        String mag = (String)this.getMeta("Indicated Magnification");
        store.setObjective(null, null, null, null, mag == null ? null : new Float(mag), null, null);
    }

    private void parseTags(int numTags, String parent) throws IOException {
        int i = 0;
        while (i < numTags) {
            byte type = this.in.readByte();
            int length = this.in.readShort();
            String labelString = this.in.readString(length);
            if (type == 21) {
                this.in.skipBytes(4);
                int n = this.in.readInt();
                int dataType = 0;
                if (n == 1) {
                    String data;
                    dataType = this.in.readInt();
                    this.in.order(this.core.littleEndian[0]);
                    switch (dataType) {
                        case 2: 
                        case 4: {
                            data = "" + this.in.readShort();
                            break;
                        }
                        case 3: 
                        case 5: {
                            data = "" + this.in.readInt();
                            break;
                        }
                        case 6: {
                            data = "" + this.in.readFloat();
                            break;
                        }
                        case 7: {
                            data = "" + this.in.readFloat();
                            this.in.skipBytes(4);
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: {
                            data = "" + this.in.read();
                            break;
                        }
                        default: {
                            data = "0";
                        }
                    }
                    if (parent.equals("Dimensions")) {
                        if (i == 0) {
                            this.core.sizeX[0] = Integer.parseInt(data);
                        } else if (i == 1) {
                            this.core.sizeY[0] = Integer.parseInt(data);
                        }
                    }
                    if (labelString.equals("PixelDepth")) {
                        this.bytesPerPixel = Integer.parseInt(data);
                    } else if (labelString.equals("Scale") && !data.equals("1.0") && !data.equals("0.0")) {
                        this.pixelSizes.add(data);
                    }
                    this.addMeta(labelString, data);
                    if (labelString.equals("DataType")) {
                        this.datatype = Integer.parseInt(data);
                    }
                    this.in.order(!this.core.littleEndian[0]);
                } else if (n == 2) {
                    this.in.order(this.core.littleEndian[0]);
                    dataType = this.in.readInt();
                    if (dataType == 18) {
                        length = this.in.readInt();
                    }
                    this.addMeta(labelString, this.in.readString(length));
                    this.in.order(!this.core.littleEndian[0]);
                } else if (n == 3) {
                    dataType = this.in.readInt();
                    if (dataType == 20) {
                        dataType = this.in.readInt();
                        length = this.in.readInt();
                        if ("Data".equals(labelString)) {
                            ++this.pixelDataNum;
                        }
                        if ("Data".equals(labelString)) {
                            int check = 0;
                            double bpp = 0.5;
                            long pos = this.in.getFilePointer();
                            while (check != 20 && check != 21) {
                                this.in.seek(pos);
                                this.pixelOffset = pos;
                                this.in.skipBytes((int)((bpp *= 2.0) * (double)length));
                                check = this.in.readByte();
                            }
                            this.in.seek((long)((double)pos + bpp * (double)length));
                        } else {
                            int[] data = new int[length];
                            int j = 0;
                            while (j < length) {
                                if (dataType == 2 || dataType == 4) {
                                    data[j] = this.in.readShort();
                                } else if (dataType == 7) {
                                    this.in.skipBytes(8);
                                } else if (dataType == 8 || dataType == 9) {
                                    this.in.skipBytes(1);
                                } else {
                                    data[j] = this.in.readInt();
                                }
                                ++j;
                            }
                        }
                    }
                } else {
                    int j;
                    dataType = this.in.readInt();
                    if (dataType == 15) {
                        int skip = this.in.readInt();
                        int numFields = this.in.readInt();
                        j = 0;
                        while (j < numFields) {
                            skip += this.in.readInt();
                            dataType = this.in.readInt();
                            switch (dataType) {
                                case 2: 
                                case 4: {
                                    skip += 2;
                                    break;
                                }
                                case 3: 
                                case 5: 
                                case 6: {
                                    skip += 4;
                                    break;
                                }
                                case 7: {
                                    skip += 8;
                                    break;
                                }
                                case 8: 
                                case 9: {
                                    ++skip;
                                }
                            }
                            ++j;
                        }
                        this.in.skipBytes(skip);
                    } else if (dataType == 20) {
                        int skip = 0;
                        dataType = this.in.readInt();
                        if (dataType == 15) {
                            skip += this.in.readInt();
                            int numFields = this.in.readInt();
                            j = 0;
                            while (j < numFields) {
                                skip += this.in.readInt();
                                dataType = this.in.readInt();
                                switch (dataType) {
                                    case 2: 
                                    case 4: {
                                        skip += 2;
                                        break;
                                    }
                                    case 3: 
                                    case 5: 
                                    case 6: {
                                        skip += 4;
                                        break;
                                    }
                                    case 7: {
                                        skip += 8;
                                        break;
                                    }
                                    case 8: 
                                    case 9: {
                                        ++skip;
                                    }
                                }
                                ++j;
                            }
                        }
                        this.in.skipBytes(skip *= this.in.readInt());
                    }
                }
            } else if (type == 20) {
                this.in.skipBytes(2);
                this.parseTags(this.in.readInt(), labelString);
            }
            ++i;
        }
    }
}

