/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.StringTokenizer;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;

public class FluoviewReader
extends BaseTiffReader {
    private static final int BLOCK_CHECK_LEN = 16384;
    private static final String FLUOVIEW_MAGIC_STRING = "FLUOVIEW";
    private static final int MMHEADER = 34361;
    private static final int MMSTAMP = 34362;
    private boolean isFluoview;
    private float voxelX = 0.0f;
    private float voxelY = 0.0f;
    private float voxelZ = 0.0f;
    private float voxelC = 0.0f;
    private float voxelT = 0.0f;
    private BufferedImage zeroImage = null;

    public FluoviewReader() {
        super("Olympus Fluoview/ABD TIFF", new String[]{"tif", "tiff"});
    }

    public boolean isThisType(byte[] block) {
        if (!TiffTools.isValidHeader(block)) {
            return false;
        }
        if (block.length < 3) {
            return false;
        }
        if (block.length < 8) {
            return true;
        }
        String test = new String(block);
        if (test.indexOf(FLUOVIEW_MAGIC_STRING) != -1) {
            this.isFluoview = true;
            return true;
        }
        int ifdlocation = DataTools.bytesToInt(block, 4, true);
        if (ifdlocation < 0 || ifdlocation + 1 > block.length) {
            return false;
        }
        int ifdnumber = DataTools.bytesToInt(block, ifdlocation, 2, true);
        int i = 0;
        while (i < ifdnumber) {
            if (ifdlocation + 3 + i * 12 > block.length) {
                return false;
            }
            int ifdtag = DataTools.bytesToInt(block, ifdlocation + 2 + i * 12, 2, true);
            if (ifdtag == 34361 || ifdtag == 34362) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        if ((long)this.core.sizeY[0] == TiffTools.getImageLength(this.ifds[0])) {
            return super.openBytes(no);
        }
        return this.openBytes(no, new byte[this.core.sizeX[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0])]);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        if ((long)this.core.sizeY[0] == TiffTools.getImageLength(this.ifds[0])) {
            return super.openBytes(no, buf);
        }
        FormatTools.assertId(this.currentId, false, 1);
        if (no < 0 || no >= this.core.imageCount[0]) {
            throw new FormatException("Invalid image number: " + no);
        }
        if (buf.length < this.core.sizeX[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0])) {
            throw new FormatException("Buffer too small.");
        }
        byte[] b = super.openBytes(0);
        System.arraycopy(b, 0, buf, 0, buf.length);
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        if ((long)this.core.sizeY[0] == TiffTools.getImageLength(this.ifds[0])) {
            return super.openImage(no);
        }
        if (this.zeroImage == null) {
            this.zeroImage = super.openImage(0);
        }
        return this.zeroImage.getSubimage(0, no, this.core.sizeX[0], 1);
    }

    public void close() throws IOException {
        super.close();
        this.zeroImage = null;
    }

    public boolean isThisType(String name, boolean open) {
        if (!super.isThisType(name, open)) {
            return false;
        }
        return open ? this.checkBytes(name, 16384) : true;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        String comment;
        super.initStandardMetadata();
        byte[] buf = new byte[16384];
        this.in.seek(0L);
        this.in.read(buf);
        this.isFluoview = new String(buf).indexOf(FLUOVIEW_MAGIC_STRING) != -1;
        short[] s = TiffTools.getIFDShortArray(this.ifds[0], 34361, true);
        byte[] mmheader = new byte[s.length];
        int i = 0;
        while (i < mmheader.length) {
            mmheader[i] = (byte)s[i];
            if (mmheader[i] < 0) {
                int n = i;
                mmheader[n] = (byte)(mmheader[n] + 1);
            }
            ++i;
        }
        RandomAccessStream ras = new RandomAccessStream(mmheader);
        ras.order(this.isLittleEndian());
        this.put("Header Flag", ras.readShort());
        this.put("Image Type", (char)ras.read());
        this.put("Image name", ras.readString(257));
        ras.skipBytes(4);
        this.put("Number of colors", ras.readInt());
        ras.skipBytes(4);
        ras.skipBytes(4);
        this.put("Comment size", ras.readInt());
        ras.skipBytes(4);
        String[] names = new String[10];
        int[] sizes = new int[10];
        double[] resolutions = new double[10];
        int i2 = 0;
        while (i2 < 10) {
            names[i2] = ras.readString(16);
            sizes[i2] = ras.readInt();
            double origin = ras.readDouble();
            resolutions[i2] = ras.readDouble();
            this.put("Dimension " + (i2 + 1) + " Name", names[i2]);
            this.put("Dimension " + (i2 + 1) + " Size", sizes[i2]);
            this.put("Dimension " + (i2 + 1) + " Origin", origin);
            this.put("Dimension " + (i2 + 1) + " Resolution", resolutions[i2]);
            this.put("Dimension " + (i2 + 1) + " Units", ras.readString(64));
            ++i2;
        }
        ras.skipBytes(4);
        this.put("Map type", ras.readShort());
        this.put("Map min", ras.readDouble());
        this.put("Map max", ras.readDouble());
        this.put("Min value", ras.readDouble());
        this.put("Max value", ras.readDouble());
        ras.skipBytes(4);
        this.put("Gamma", ras.readDouble());
        this.put("Offset", ras.readDouble());
        this.put("Gray Channel Name", ras.readString(16));
        this.put("Gray Channel Size", ras.readInt());
        this.put("Gray Channel Origin", ras.readDouble());
        this.put("Gray Channel Resolution", ras.readDouble());
        this.put("Gray Channel Units", ras.readString(64));
        ras.skipBytes(4);
        this.put("Voice field", ras.readInt());
        ras.skipBytes(4);
        double[][] stamps = new double[8][this.ifds.length];
        int i3 = 0;
        while (i3 < this.ifds.length) {
            s = TiffTools.getIFDShortArray(this.ifds[i3], 34362, true);
            byte[] stamp = new byte[s.length];
            int j = 0;
            while (j < s.length) {
                stamp[j] = (byte)s[j];
                if (stamp[j] < 0) {
                    int n = j;
                    stamp[n] = (byte)(stamp[n] + 1);
                }
                ++j;
            }
            ras = new RandomAccessStream(stamp);
            j = 0;
            while (j < 8) {
                stamps[j][i3] = ras.readDouble();
                ++j;
            }
            ++i3;
        }
        this.core.sizeT[0] = 1;
        this.core.sizeC[0] = 1;
        this.core.sizeZ[0] = 1;
        this.core.currentOrder[0] = "XY";
        i3 = 0;
        while (i3 < 10) {
            String name = names[i3];
            int size = sizes[i3];
            float voxel = (float)resolutions[i3];
            if (name != null && size != 0 && (name = name.toLowerCase().trim()).length() != 0) {
                if (name.equals("x")) {
                    this.core.sizeX[0] = size;
                    this.voxelX = voxel;
                } else if (name.equals("y")) {
                    this.core.sizeY[0] = size;
                    this.voxelY = voxel;
                } else if (name.equals("z") || name.equals("event")) {
                    this.core.sizeZ[0] = this.core.sizeZ[0] * size;
                    if (this.core.currentOrder[0].indexOf("Z") == -1) {
                        this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + "Z";
                    }
                    this.voxelZ = voxel;
                } else if (name.equals("ch") || name.equals("wavelength")) {
                    this.core.sizeC[0] = this.core.sizeC[0] * size;
                    if (this.core.currentOrder[0].indexOf("C") == -1) {
                        this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + "C";
                    }
                    this.voxelC = voxel;
                } else {
                    this.core.sizeT[0] = this.core.sizeT[0] * size;
                    if (this.core.currentOrder[0].indexOf("T") == -1) {
                        this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + "T";
                    }
                    this.voxelT = voxel;
                }
            }
            ++i3;
        }
        if (this.core.currentOrder[0].indexOf("Z") == -1) {
            this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + "Z";
        }
        if (this.core.currentOrder[0].indexOf("T") == -1) {
            this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + "T";
        }
        if (this.core.currentOrder[0].indexOf("C") == -1) {
            this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + "C";
        }
        this.core.imageCount[0] = this.ifds.length;
        if (!(this.core.imageCount[0] != 1 || this.core.sizeT[0] != this.core.sizeY[0] && this.core.sizeZ[0] != this.core.sizeY[0] || this.core.sizeT[0] <= this.core.imageCount[0] && this.core.sizeZ[0] <= this.core.imageCount[0])) {
            this.core.sizeY[0] = 1;
            this.core.imageCount[0] = this.core.sizeZ[0] * this.core.sizeT[0] * this.core.sizeC[0];
        }
        if ((comment = (String)this.getMeta("Comment")) != null && comment.startsWith("[")) {
            int start = comment.indexOf("[Acquisition Parameters]");
            int end = comment.indexOf("[Acquisition Parameters End]");
            if (start != -1 && end != -1 && end > start) {
                String parms = comment.substring(start + 24, end).trim();
                StringTokenizer st = new StringTokenizer(parms, "\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    int eq = token.indexOf("=");
                    if (eq == -1) continue;
                    String key = token.substring(0, eq);
                    String value = token.substring(eq + 1);
                    this.addMeta(key, value);
                }
            }
            start = comment.indexOf("[Version Info]");
            end = comment.indexOf("[Version Info End]");
            if (start != -1 && end != -1 && end > start) {
                comment = comment.substring(start + 14, end).trim();
                start = comment.indexOf("=") + 1;
                end = comment.indexOf("\n");
                comment = end > start ? comment.substring(start, end).trim() : comment.substring(start).trim();
            } else {
                comment = "";
            }
        }
        this.addMeta("Comment", comment);
    }

    protected void initMetadataStore() {
        super.initMetadataStore();
        MetadataStore store = this.getMetadataStore();
        store.setDimensions(new Float(this.voxelX), new Float(this.voxelY), new Float(this.voxelZ), new Float(this.voxelC), new Float(this.voxelT), null);
        Double gamma = (Double)this.getMeta("Gamma");
        int i = 0;
        while (i < this.core.sizeC[0]) {
            store.setDisplayChannel(new Integer(i), null, null, gamma == null ? null : new Float(gamma.floatValue()), null);
            String gain = (String)this.getMeta("Gain Ch" + (i + 1));
            String voltage = (String)this.getMeta("PMT Voltage Ch" + (i + 1));
            String offset = (String)this.getMeta("Offset Ch" + (i + 1));
            if (gain != null || voltage != null || offset != null) {
                store.setDetector((String)this.getMeta("System Configuration"), null, null, null, gain == null ? null : new Float(gain), voltage == null ? null : new Float(voltage), offset == null ? null : new Float(offset), null, new Integer(i));
            }
            ++i;
        }
        String mag = (String)this.getMeta("Magnification");
        if (mag != null && mag.toLowerCase().endsWith("x")) {
            mag = mag.substring(0, mag.length() - 1);
        } else if (mag == null) {
            mag = "1";
        }
        store.setObjective((String)this.getMeta("Objective Lens"), null, null, null, new Float(mag), null, null);
    }
}

