/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class FitsReader
extends FormatReader {
    private int count;

    public FitsReader() {
        super("Flexible Image Transport System", "fits");
    }

    public boolean isThisType(byte[] block) {
        return true;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] buf = new byte[this.core.sizeX[0] * this.core.sizeY[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0])];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        if (buf.length < this.core.sizeX[0] * this.core.sizeY[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0])) {
            throw new FormatException("Buffer too small.");
        }
        this.in.seek(2880 + 2880 * ((this.count * 80 - 1) / 2880));
        int line = this.core.sizeX[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0]);
        int y = this.core.sizeY[0] - 1;
        while (y >= 0) {
            this.in.read(buf, y * line, line);
            --y;
        }
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], this.core.sizeC[0], this.core.interleaved[0], FormatTools.getBytesPerPixel(this.core.pixelType[0]), this.core.littleEndian[0]);
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.count = 1;
        String line = this.in.readString(80);
        if (!line.startsWith("SIMPLE")) {
            throw new FormatException("Unsupported FITS file.");
        }
        while (true) {
            String value;
            String key;
            block18: {
                block17: {
                    int ndx;
                    ++this.count;
                    line = this.in.readString(80);
                    int comment = line.indexOf("/", ndx = line.indexOf("="));
                    if (comment < 0) {
                        comment = line.length();
                    }
                    key = "";
                    value = "";
                    if (ndx >= 0) {
                        key = line.substring(0, ndx).trim();
                        value = line.substring(ndx + 1, comment).trim();
                    } else {
                        key = line.trim();
                    }
                    if (key.equals("END")) break;
                    if (!key.equals("BITPIX")) break block17;
                    int bits = Integer.parseInt(value);
                    switch (bits) {
                        case 8: {
                            this.core.pixelType[0] = 1;
                            break block18;
                        }
                        case 16: {
                            this.core.pixelType[0] = 3;
                            break block18;
                        }
                        case 32: {
                            this.core.pixelType[0] = 5;
                            break block18;
                        }
                        case -32: {
                            this.core.pixelType[0] = 6;
                            break block18;
                        }
                        default: {
                            throw new FormatException("Unsupported pixel type: " + bits);
                        }
                    }
                }
                if (key.equals("NAXIS1")) {
                    this.core.sizeX[0] = Integer.parseInt(value);
                } else if (key.equals("NAXIS2")) {
                    this.core.sizeY[0] = Integer.parseInt(value);
                } else if (key.equals("NAXIS3")) {
                    this.core.sizeZ[0] = Integer.parseInt(value);
                }
            }
            this.addMeta(key, value);
        }
        this.core.sizeC[0] = 1;
        this.core.sizeT[0] = 1;
        if (this.core.sizeZ[0] == 0) {
            this.core.sizeZ[0] = 1;
        }
        this.core.imageCount[0] = this.core.sizeZ[0];
        this.core.rgb[0] = false;
        this.core.littleEndian[0] = false;
        this.core.interleaved[0] = false;
        this.core.currentOrder[0] = "XYZCT";
        MetadataStore store = this.getMetadataStore();
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(!this.core.littleEndian[0]), this.core.currentOrder[0], null, null);
        store.setLogicalChannel(0, null, null, null, null, "monochrome", null, null);
    }
}

