/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.TiffTools;

public class EPSReader
extends FormatReader {
    private int bps;
    private int start;
    private boolean binary;
    private boolean isTiff;
    private Hashtable[] ifds;

    public EPSReader() {
        super("Encapsulated PostScript", new String[]{"eps", "epsi", "ps"});
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] buf = new byte[this.core.sizeX[0] * this.core.sizeY[0] * this.core.sizeC[0] * (this.bps / 8)];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        if (buf.length < this.core.sizeX[0] * this.core.sizeY[0] * this.core.sizeC[0] * (this.bps / 8)) {
            throw new FormatException("Buffer too small.");
        }
        if (this.isTiff) {
            long[] offsets = TiffTools.getStripOffsets(this.ifds[0]);
            this.in.seek(offsets[0]);
            int[] map = TiffTools.getIFDIntArray(this.ifds[0], 320, false);
            if (map == null) {
                this.in.read(buf);
                return buf;
            }
            byte[] b = new byte[this.core.sizeX[0] * this.core.sizeY[0]];
            int i = 0;
            while (i < b.length) {
                b[i] = (byte)this.in.read();
                this.in.read();
                ++i;
            }
            i = 0;
            while (i < b.length) {
                int ndx = b[i];
                if (ndx < 0) {
                    ndx += 256;
                }
                int j = 0;
                while (j < this.core.sizeC[0]) {
                    buf[i * this.core.sizeC[0] + j] = (byte)map[ndx + j * 256];
                    ++j;
                }
                ++i;
            }
            return buf;
        }
        RandomAccessStream ras = new RandomAccessStream(this.currentId);
        int line = 0;
        while (line <= this.start) {
            ras.readLine();
            ++line;
        }
        if (this.binary) {
            ras.read(buf, 0, buf.length);
        } else {
            long pos = ras.getFilePointer();
            String len = ras.readLine();
            ras.seek(pos);
            int numLines = buf.length / len.trim().length();
            char[] chars = new char[2];
            int i = 0;
            while (i < buf.length) {
                chars[0] = (char)ras.read();
                while (chars[0] == '\n') {
                    chars[0] = (char)ras.read();
                }
                chars[1] = (char)ras.read();
                while (chars[1] == '\n') {
                    chars[1] = (char)ras.read();
                }
                String s = new String(chars);
                buf[i] = (byte)Integer.parseInt(s, 16);
                ++i;
            }
        }
        ras.close();
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], this.core.sizeC[0], this.core.interleaved[0], FormatTools.getBytesPerPixel(this.core.pixelType[0]), this.core.littleEndian[0]);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("EPSReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Verifying EPS format");
        String line = this.in.readLine();
        if (!line.trim().startsWith("%!PS")) {
            this.isTiff = true;
            this.in.order(true);
            this.in.seek(20L);
            int offset = this.in.readInt();
            int len = this.in.readInt();
            byte[] b = new byte[len];
            this.in.seek(offset);
            this.in.read(b);
            this.in = new RandomAccessStream(b);
            this.ifds = TiffTools.getIFDs(this.in);
            this.core.sizeX[0] = (int)TiffTools.getImageWidth(this.ifds[0]);
            this.core.sizeY[0] = (int)TiffTools.getImageLength(this.ifds[0]);
            this.core.sizeZ[0] = 1;
            this.core.sizeT[0] = 1;
            this.core.sizeC[0] = TiffTools.getSamplesPerPixel(this.ifds[0]);
            if (this.core.sizeC[0] == 2) {
                this.core.sizeC[0] = 3;
            }
            this.core.littleEndian[0] = TiffTools.isLittleEndian(this.ifds[0]);
            this.core.interleaved[0] = true;
            this.core.rgb[0] = this.core.sizeC[0] > 1;
            this.bps = TiffTools.getBitsPerSample(this.ifds[0])[0];
            switch (this.bps) {
                case 16: {
                    this.core.pixelType[0] = 3;
                    break;
                }
                case 32: {
                    this.core.pixelType[0] = 5;
                    break;
                }
                default: {
                    this.core.pixelType[0] = 1;
                }
            }
            this.core.imageCount[0] = 1;
            this.core.currentOrder[0] = "XYCZT";
            return;
        }
        this.status("Finding image data");
        this.binary = false;
        String image = "image";
        int lineNum = 1;
        line = this.in.readLine();
        while (line != null) {
            block21: {
                block19: {
                    block22: {
                        block20: {
                            if (line.trim().equals(image) || line.trim().endsWith(image)) {
                                if (line.trim().endsWith(image) && !line.trim().startsWith(image)) {
                                    if (line.indexOf("colorimage") != -1) {
                                        this.core.sizeC[0] = 3;
                                    }
                                    StringTokenizer t = new StringTokenizer(line, " ");
                                    try {
                                        this.core.sizeX[0] = Integer.parseInt(t.nextToken());
                                        this.core.sizeY[0] = Integer.parseInt(t.nextToken());
                                        this.bps = Integer.parseInt(t.nextToken());
                                    }
                                    catch (Exception exc) {
                                        if (debug) {
                                            this.trace(exc);
                                        }
                                        this.core.sizeC[0] = Integer.parseInt(t.nextToken());
                                    }
                                }
                                this.start = lineNum;
                                break;
                            }
                            if (!line.startsWith("%%")) break block19;
                            if (!line.startsWith("%%BoundingBox:")) break block20;
                            line = line.substring(14);
                            StringTokenizer t = new StringTokenizer(line, " ");
                            int originX = Integer.parseInt(t.nextToken());
                            int originY = Integer.parseInt(t.nextToken());
                            this.core.sizeX[0] = Integer.parseInt(t.nextToken()) - originX;
                            this.core.sizeY[0] = Integer.parseInt(t.nextToken()) - originY;
                            this.addMeta("X-coordinate of origin", new Integer(originX));
                            this.addMeta("Y-coordinate of origin", new Integer(originY));
                            break block21;
                        }
                        if (!line.startsWith("%%BeginBinary")) break block22;
                        this.binary = true;
                        break block21;
                    }
                    int ndx = line.indexOf(":");
                    if (ndx == -1) break block21;
                    String key = line.substring(0, ndx);
                    String value = line.substring(ndx + 1);
                    this.addMeta(key, value);
                    break block21;
                }
                if (line.startsWith("%ImageData:")) {
                    line = line.substring(11);
                    StringTokenizer t = new StringTokenizer(line, " ");
                    this.core.sizeX[0] = Integer.parseInt(t.nextToken());
                    this.core.sizeY[0] = Integer.parseInt(t.nextToken());
                    this.bps = Integer.parseInt(t.nextToken());
                    this.core.sizeC[0] = Integer.parseInt(t.nextToken());
                    while (t.hasMoreTokens()) {
                        image = t.nextToken().trim();
                        if (image.length() <= 1) continue;
                        image = image.substring(1, image.length() - 1);
                    }
                }
            }
            ++lineNum;
            line = this.in.readLine();
        }
        this.status("Populating metadata");
        if (this.bps == 0) {
            this.bps = 8;
        }
        if (this.core.sizeC[0] == 0) {
            this.core.sizeC[0] = 1;
        }
        this.core.sizeZ[0] = 1;
        this.core.sizeT[0] = 1;
        this.core.currentOrder[0] = "XYCZT";
        this.core.pixelType[0] = 1;
        this.core.rgb[0] = this.core.sizeC[0] == 3;
        this.core.interleaved[0] = true;
        this.core.littleEndian[0] = true;
        this.core.imageCount[0] = 1;
        MetadataStore store = this.getMetadataStore();
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), Boolean.FALSE, this.core.currentOrder[0], null, null);
        int i = 0;
        while (i < this.core.sizeC[0]) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null);
            ++i;
        }
    }
}

