/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.LogTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class DeltavisionReader
extends FormatReader {
    private static final short LITTLE_ENDIAN = -16224;
    protected byte[] header;
    protected byte[] extHeader;
    private int bytesPerPixel;
    protected int wSize;
    protected int zSize;
    protected int tSize;
    protected int numIntsPerSection;
    protected int numFloatsPerSection;
    protected DVExtHdrFields[][][] extHdrFields = null;

    public DeltavisionReader() {
        super("Deltavision", new String[]{"dv", "r3d", "r3d_d3d"});
    }

    public boolean isMetadataComplete() {
        return true;
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] buf = new byte[this.core.sizeX[0] * this.core.sizeY[0] * this.bytesPerPixel];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.core.imageCount[0]) {
            throw new FormatException("Invalid image number: " + no);
        }
        long offset = this.header.length + this.extHeader.length;
        long bytes = this.core.sizeX[0] * this.core.sizeY[0] * this.bytesPerPixel;
        this.in.seek(offset += bytes * (long)no);
        this.in.read(buf);
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], 1, false, this.bytesPerPixel, this.core.littleEndian[0]);
    }

    protected void initFile(String id) throws FormatException, IOException {
        String imageSequence;
        String imageType;
        String pixel;
        if (debug) {
            this.debug("DeltavisionReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Reading header");
        this.header = new byte[1024];
        this.in.read(this.header);
        short endian = DataTools.bytesToShort(this.header, 96, 2, true);
        this.core.littleEndian[0] = endian == -16224;
        RandomAccessStream hstream = new RandomAccessStream(this.header);
        hstream.order(this.core.littleEndian[0]);
        hstream.skipBytes(8);
        this.core.imageCount[0] = hstream.readInt();
        hstream.seek(92L);
        int extSize = hstream.readInt();
        this.extHeader = new byte[extSize];
        this.in.read(this.extHeader);
        hstream.seek(0L);
        this.core.sizeX[0] = hstream.readInt();
        this.core.sizeY[0] = hstream.readInt();
        Integer xSize = new Integer(this.core.sizeX[0]);
        Integer ySize = new Integer(this.core.sizeY[0]);
        this.addMeta("ImageWidth", xSize);
        this.addMeta("ImageHeight", ySize);
        this.addMeta("NumberOfImages", new Integer(hstream.readInt()));
        int filePixelType = hstream.readInt();
        switch (filePixelType) {
            case 0: {
                pixel = "8 bit unsigned integer";
                this.core.pixelType[0] = 1;
                this.bytesPerPixel = 1;
                break;
            }
            case 1: {
                pixel = "16 bit signed integer";
                this.core.pixelType[0] = 3;
                this.bytesPerPixel = 2;
                break;
            }
            case 2: {
                pixel = "32 bit floating point";
                this.core.pixelType[0] = 6;
                this.bytesPerPixel = 4;
                break;
            }
            case 3: {
                pixel = "32 bit complex";
                this.core.pixelType[0] = 5;
                this.bytesPerPixel = 4;
                break;
            }
            case 4: {
                pixel = "64 bit complex";
                this.core.pixelType[0] = 6;
                this.bytesPerPixel = 8;
                break;
            }
            case 6: {
                pixel = "16 bit unsigned integer";
                this.core.pixelType[0] = 3;
                this.bytesPerPixel = 2;
                break;
            }
            default: {
                pixel = "unknown";
                this.core.pixelType[0] = 1;
                this.bytesPerPixel = 1;
            }
        }
        this.addMeta("PixelType", pixel);
        this.addMeta("Sub-image starting point (X)", new Integer(hstream.readInt()));
        this.addMeta("Sub-image starting point (Y)", new Integer(hstream.readInt()));
        this.addMeta("Sub-image starting point (Z)", new Integer(hstream.readInt()));
        this.addMeta("Pixel sampling size (X)", new Integer(hstream.readInt()));
        this.addMeta("Pixel sampling size (Y)", new Integer(hstream.readInt()));
        this.addMeta("Pixel sampling size (Z)", new Integer(hstream.readInt()));
        float pixX = hstream.readFloat();
        float pixY = hstream.readFloat();
        float pixZ = hstream.readFloat();
        this.addMeta("X element length (in um)", new Float(pixX));
        this.addMeta("Y element length (in um)", new Float(pixY));
        this.addMeta("Z element length (in um)", new Float(pixZ));
        this.addMeta("X axis angle", new Float(hstream.readFloat()));
        this.addMeta("Y axis angle", new Float(hstream.readFloat()));
        this.addMeta("Z axis angle", new Float(hstream.readFloat()));
        this.addMeta("Column axis sequence", new Integer(hstream.readInt()));
        this.addMeta("Row axis sequence", new Integer(hstream.readInt()));
        this.addMeta("Section axis sequence", new Integer(hstream.readInt()));
        Float wave1Min = new Float(hstream.readFloat());
        this.addMeta("Wavelength 1 min. intensity", wave1Min);
        Float wave1Max = new Float(hstream.readFloat());
        this.addMeta("Wavelength 1 max. intensity", wave1Max);
        this.addMeta("Wavelength 1 mean intensity", new Float(hstream.readFloat()));
        this.addMeta("Space group number", new Integer(hstream.readInt()));
        hstream.seek(132L);
        this.addMeta("Number of Sub-resolution sets", new Integer(hstream.readShort()));
        this.addMeta("Z axis reduction quotient", new Integer(hstream.readShort()));
        Float wave2Min = new Float(hstream.readFloat());
        this.addMeta("Wavelength 2 min. intensity", wave2Min);
        Float wave2Max = new Float(hstream.readFloat());
        this.addMeta("Wavelength 2 max. intensity", wave2Max);
        Float wave3Min = new Float(hstream.readFloat());
        this.addMeta("Wavelength 3 min. intensity", wave3Min);
        Float wave3Max = new Float(hstream.readFloat());
        this.addMeta("Wavelength 3 max. intensity", wave3Max);
        Float wave4Min = new Float(hstream.readFloat());
        this.addMeta("Wavelength 4 min. intensity", wave4Min);
        Float wave4Max = new Float(hstream.readFloat());
        this.addMeta("Wavelength 4 max. intensity", wave4Max);
        short type = hstream.readShort();
        switch (type) {
            case 0: {
                imageType = "normal";
                break;
            }
            case 1: {
                imageType = "Tilt-series";
                break;
            }
            case 2: {
                imageType = "Stereo tilt-series";
                break;
            }
            case 3: {
                imageType = "Averaged images";
                break;
            }
            case 4: {
                imageType = "Averaged stereo pairs";
                break;
            }
            default: {
                imageType = "unknown";
            }
        }
        this.addMeta("Image Type", imageType);
        this.addMeta("Lens ID Number", new Integer(hstream.readShort()));
        hstream.seek(172L);
        Float wave5Min = new Float(hstream.readFloat());
        this.addMeta("Wavelength 5 min. intensity", wave5Min);
        Float wave5Max = new Float(hstream.readFloat());
        this.addMeta("Wavelength 5 max. intensity", wave5Max);
        this.core.sizeT[0] = hstream.readShort();
        this.addMeta("Number of timepoints", new Integer(this.core.sizeT[0]));
        short sequence = hstream.readShort();
        switch (sequence) {
            case 0: {
                imageSequence = "ZTW";
                this.core.currentOrder[0] = "XYZTC";
                break;
            }
            case 1: {
                imageSequence = "WZT";
                this.core.currentOrder[0] = "XYCZT";
                break;
            }
            case 2: {
                imageSequence = "ZWT";
                this.core.currentOrder[0] = "XYZCT";
                break;
            }
            case 65536: {
                imageSequence = "WZT";
                this.core.currentOrder[0] = "XYCZT";
                break;
            }
            default: {
                imageSequence = "unknown";
                this.core.currentOrder[0] = "XYZTC";
            }
        }
        this.addMeta("Image sequence", imageSequence);
        this.addMeta("X axis tilt angle", new Float(hstream.readFloat()));
        this.addMeta("Y axis tilt angle", new Float(hstream.readFloat()));
        this.addMeta("Z axis tilt angle", new Float(hstream.readFloat()));
        this.core.sizeC[0] = hstream.readShort();
        this.addMeta("Number of wavelengths", new Integer(this.core.sizeC[0]));
        this.core.sizeZ[0] = this.core.imageCount[0] / (this.core.sizeC[0] * this.core.sizeT[0]);
        this.addMeta("Number of focal planes", new Integer(this.core.sizeZ[0]));
        this.core.rgb[0] = false;
        this.core.interleaved[0] = false;
        short[] waves = new short[5];
        int i = 0;
        while (i < waves.length) {
            waves[i] = hstream.readShort();
            ++i;
        }
        this.addMeta("Wavelength 1 (in nm)", new Integer(waves[0]));
        this.addMeta("Wavelength 2 (in nm)", new Integer(waves[1]));
        this.addMeta("Wavelength 3 (in nm)", new Integer(waves[2]));
        this.addMeta("Wavelength 4 (in nm)", new Integer(waves[3]));
        this.addMeta("Wavelength 5 (in nm)", new Integer(waves[4]));
        this.addMeta("X origin (in um)", new Float(hstream.readFloat()));
        this.addMeta("Y origin (in um)", new Float(hstream.readFloat()));
        this.addMeta("Z origin (in um)", new Float(hstream.readFloat()));
        MetadataStore store = this.getMetadataStore();
        String title = null;
        int i2 = 10;
        while (i2 >= 1) {
            title = new String(this.header, 224 + 80 * (i2 - 1), 80).replaceAll("\u0000", "");
            this.addMeta("Title " + i2, title);
            --i2;
        }
        this.status("Reading extended header");
        hstream.seek(128L);
        this.numIntsPerSection = hstream.readShort();
        this.numFloatsPerSection = hstream.readShort();
        this.setOffsetInfo(sequence, this.core.sizeZ[0], this.core.sizeC[0], this.core.sizeT[0]);
        this.extHdrFields = new DVExtHdrFields[this.core.sizeZ[0]][this.core.sizeC[0]][this.core.sizeT[0]];
        hstream.close();
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(!this.core.littleEndian[0]), this.core.currentOrder[0], null, null);
        store.setDimensions(new Float(pixX), new Float(pixY), new Float(pixZ), null, null, null);
        if (title == null) {
            title = "";
        }
        title = title.length() == 0 ? null : title;
        store.setImage(id, null, title, null);
        int z = 0;
        while (z < this.core.sizeZ[0]) {
            int t = 0;
            while (t < this.core.sizeT[0]) {
                int w = 0;
                while (w < this.core.sizeC[0]) {
                    long entryWidths;
                    long totalOffset = this.getTotalOffset(z, w, t);
                    if (totalOffset + (entryWidths = (long)((this.numIntsPerSection + this.numFloatsPerSection) * 4)) < (long)this.extHeader.length) {
                        this.extHdrFields[z][w][t] = new DVExtHdrFields(this.getTotalOffset(z, w, t), this.numIntsPerSection, this.extHeader, this.core.littleEndian[0]);
                        store.setPlaneInfo(z, w, t, new Float(this.extHdrFields[z][w][t].getTimeStampSeconds()), new Float(this.extHdrFields[z][w][t].getExpTime()), null);
                    }
                    ++w;
                }
                ++t;
            }
            ++z;
        }
        this.status("Populating metadata");
        int w = 0;
        while (w < this.core.sizeC[0]) {
            store.setLogicalChannel(w, null, new Float(this.extHdrFields[0][w][0].getNdFilter()), new Integer(waves[w]), new Integer((int)this.extHdrFields[0][w][0].getExFilter()), "Monochrome", "Wide-field", null);
            ++w;
        }
        store.setStageLabel("ome", new Float(this.extHdrFields[0][0][0].getStageXCoord()), new Float(this.extHdrFields[0][0][0].getStageYCoord()), new Float(this.extHdrFields[0][0][0].getStageZCoord()), null);
        if (this.core.sizeC[0] > 0) {
            store.setChannelGlobalMinMax(0, new Double(wave1Min.floatValue()), new Double(wave1Max.floatValue()), null);
        }
        if (this.core.sizeC[0] > 1) {
            store.setChannelGlobalMinMax(1, new Double(wave2Min.floatValue()), new Double(wave2Max.floatValue()), null);
        }
        if (this.core.sizeC[0] > 2) {
            store.setChannelGlobalMinMax(2, new Double(wave3Min.floatValue()), new Double(wave3Max.floatValue()), null);
        }
        if (this.core.sizeC[0] > 3) {
            store.setChannelGlobalMinMax(3, new Double(wave4Min.floatValue()), new Double(wave4Max.floatValue()), null);
        }
        if (this.core.sizeC[0] > 4) {
            store.setChannelGlobalMinMax(4, new Double(wave5Min.floatValue()), new Double(wave5Max.floatValue()), null);
        }
    }

    private void setOffsetInfo(int imgSequence, int numZSections, int numWaves, int numTimes) {
        int smallOffset = (this.numIntsPerSection + this.numFloatsPerSection) * 4;
        switch (imgSequence) {
            case 0: {
                this.zSize = smallOffset;
                this.tSize = this.zSize * numZSections;
                this.wSize = this.tSize * numTimes;
                break;
            }
            case 1: {
                this.wSize = smallOffset;
                this.zSize = this.wSize * numWaves;
                this.tSize = this.zSize * numZSections;
                break;
            }
            case 2: {
                this.zSize = smallOffset;
                this.wSize = this.zSize * numZSections;
                this.tSize = this.wSize * numWaves;
            }
        }
    }

    public int getTotalOffset(int currentZ, int currentW, int currentT) {
        return this.zSize * currentZ + this.wSize * currentW + this.tSize * currentT;
    }

    public int getPlaneNumber(int currentZ, int currentW, int currentT) {
        int smallOffset = (this.numIntsPerSection + this.numFloatsPerSection) * 4;
        return this.getTotalOffset(currentZ, currentW, currentT) / smallOffset;
    }

    private class DVExtHdrFields {
        private int offsetWithInts;
        private float oDFilter;
        private float photosensorReading;
        private float timeStampSeconds;
        private float stageXCoord;
        private float stageYCoord;
        private float stageZCoord;
        private float minInten;
        private float maxInten;
        private float meanInten;
        private float expTime;
        private float ndFilter;
        private float exFilter;
        private float emFilter;
        private float exWavelen;
        private float emWavelen;
        private float intenScaling;
        private float energyConvFactor;

        public String toString() {
            String s = new String();
            s = String.valueOf(s) + "photosensorReading: " + this.photosensorReading + "\n";
            s = String.valueOf(s) + "timeStampSeconds: " + this.timeStampSeconds + "\n";
            s = String.valueOf(s) + "stageXCoord: " + this.stageXCoord + "\n";
            s = String.valueOf(s) + "stageYCoord: " + this.stageYCoord + "\n";
            s = String.valueOf(s) + "stageZCoord: " + this.stageZCoord + "\n";
            s = String.valueOf(s) + "minInten: " + this.minInten + "\n";
            s = String.valueOf(s) + "maxInten: " + this.maxInten + "\n";
            s = String.valueOf(s) + "meanInten: " + this.meanInten + "\n";
            s = String.valueOf(s) + "expTime: " + this.expTime + "\n";
            s = String.valueOf(s) + "ndFilter: " + this.ndFilter + "\n";
            s = String.valueOf(s) + "exFilter: " + this.exFilter + "\n";
            s = String.valueOf(s) + "emFilter: " + this.emFilter + "\n";
            s = String.valueOf(s) + "exWavelen: " + this.exWavelen + "\n";
            s = String.valueOf(s) + "emWavelen: " + this.emWavelen + "\n";
            s = String.valueOf(s) + "intenScaling: " + this.intenScaling + "\n";
            s = String.valueOf(s) + "energyConvFactor: " + this.energyConvFactor + "\n";
            return s;
        }

        protected DVExtHdrFields(int startingOffset, int numIntsPerSection, byte[] extHeader, boolean little) {
            try {
                RandomAccessStream ext = new RandomAccessStream(extHeader);
                ext.order(little);
                this.offsetWithInts = startingOffset + numIntsPerSection * 4;
                ext.seek(this.offsetWithInts + 36);
                this.oDFilter = ext.readFloat();
                ext.seek(this.offsetWithInts);
                this.photosensorReading = ext.readFloat();
                this.timeStampSeconds = ext.readFloat();
                this.stageXCoord = ext.readFloat();
                this.stageYCoord = ext.readFloat();
                this.stageZCoord = ext.readFloat();
                this.minInten = ext.readFloat();
                this.maxInten = ext.readFloat();
                this.meanInten = ext.readFloat();
                this.expTime = ext.readFloat();
                this.ndFilter = (float)Math.pow(10.0, -this.oDFilter);
                ext.skipBytes(4);
                this.exFilter = ext.readFloat();
                this.emFilter = ext.readFloat();
                this.exWavelen = ext.readFloat();
                this.emWavelen = ext.readFloat();
                this.intenScaling = ext.readFloat();
                this.energyConvFactor = ext.readFloat();
            }
            catch (IOException e) {
                LogTools.trace(e);
            }
        }

        public float getPhotosensorReading() {
            return this.photosensorReading;
        }

        public float getTimeStampSeconds() {
            return this.timeStampSeconds;
        }

        public float getStageXCoord() {
            return this.stageXCoord;
        }

        public float getStageYCoord() {
            return this.stageYCoord;
        }

        public float getStageZCoord() {
            return this.stageZCoord;
        }

        public float getMinInten() {
            return this.minInten;
        }

        public float getMaxInten() {
            return this.maxInten;
        }

        public float getMeanInten() {
            return this.meanInten;
        }

        public float getExpTime() {
            return this.expTime;
        }

        public float getNdFilter() {
            return this.ndFilter;
        }

        public float getExFilter() {
            return this.exFilter;
        }

        public float getEmFilter() {
            return this.emFilter;
        }

        public float getExWavelen() {
            return this.exWavelen;
        }

        public float getEmWavelen() {
            return this.emWavelen;
        }

        public float getIntenScaling() {
            return this.intenScaling;
        }
    }
}

