/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class BioRadReader
extends FormatReader {
    private static final int PIC_FILE_ID = 12345;
    private static final boolean LITTLE_ENDIAN = true;
    private static final String[] MERGE_NAMES = new String[]{"MERGE_OFF", "MERGE_16", "MERGE_ALTERNATE", "MERGE_COLUMN", "MERGE_ROW", "MERGE_MAXIMUM", "MERGE_OPT12", "MERGE_OPT12_V2"};
    public static final String[] NOTE_NAMES = new String[]{"0", "LIVE", "FILE1", "NUMBER", "USER", "LINE", "COLLECT", "FILE2", "SCALEBAR", "MERGE", "THRUVIEW", "ARROW", "12", "13", "14", "15", "16", "17", "18", "19", "VARIABLE", "STRUCTURE", "4D SERIES"};
    private boolean byteFormat;
    private Vector used;

    public BioRadReader() {
        super("Bio-Rad PIC", "pic");
    }

    public boolean isMetadataComplete() {
        return true;
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 56) {
            return false;
        }
        return DataTools.bytesToShort(block, 54, 2, true) == 12345;
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.used.toArray(new String[0]);
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] buf = new byte[this.core.sizeX[0] * this.core.sizeY[0] * (this.byteFormat ? 1 : 2)];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.core.imageCount[0]) {
            throw new FormatException("Invalid image number: " + no);
        }
        if (buf.length < this.core.sizeX[0] * this.core.sizeY[0] * (this.byteFormat ? 1 : 2)) {
            throw new FormatException("Buffer too small.");
        }
        long offset = no * this.core.sizeX[0] * this.core.sizeY[0] * (this.byteFormat ? 1 : 2);
        this.in.seek(offset + 76L);
        this.in.read(buf);
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], 1, false, this.byteFormat ? 1 : 2, true);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("BioRadReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.in.order(true);
        this.used = new Vector();
        this.used.add(this.currentId);
        this.status("Reading image dimensions");
        this.core.sizeX[0] = this.in.readShort();
        this.core.sizeY[0] = this.in.readShort();
        this.core.imageCount[0] = this.in.readShort();
        short ramp1min = this.in.readShort();
        short ramp1max = this.in.readShort();
        boolean notes = (this.in.read() | this.in.read() | this.in.read() | this.in.read()) != 0;
        this.byteFormat = this.in.readShort() != 0;
        short imageNumber = this.in.readShort();
        String name = this.in.readString(32);
        short merged = this.in.readShort();
        short color1 = this.in.readShort();
        short fileId = this.in.readShort();
        short ramp2min = this.in.readShort();
        short ramp2max = this.in.readShort();
        short color2 = this.in.readShort();
        short edited = this.in.readShort();
        short lens = this.in.readShort();
        float magFactor = this.in.readFloat();
        if (fileId != 12345) {
            throw new FormatException("Invalid file header : " + fileId);
        }
        this.addMeta("nx", new Integer(this.core.sizeX[0]));
        this.addMeta("ny", new Integer(this.core.sizeY[0]));
        this.addMeta("npic", new Integer(this.core.imageCount[0]));
        this.addMeta("ramp1_min", new Integer(ramp1min));
        this.addMeta("ramp1_max", new Integer(ramp1max));
        this.addMeta("notes", new Boolean(notes));
        this.addMeta("byte_format", new Boolean(this.byteFormat));
        this.addMeta("image_number", new Integer(imageNumber));
        this.addMeta("name", name);
        this.addMeta("merged", MERGE_NAMES[merged]);
        this.addMeta("color1", new Integer(color1));
        this.addMeta("file_id", new Integer(fileId));
        this.addMeta("ramp2_min", new Integer(ramp2min));
        this.addMeta("ramp2_max", new Integer(ramp2max));
        this.addMeta("color2", new Integer(color2));
        this.addMeta("edited", new Integer(edited));
        this.addMeta("lens", new Integer(lens));
        this.addMeta("mag_factor", new Float(magFactor));
        int imageLen = this.core.sizeX[0] * this.core.sizeY[0];
        int bpp = this.byteFormat ? 1 : 2;
        this.in.skipBytes(bpp * this.core.imageCount[0] * imageLen + 6);
        Vector<String> pixelSize = new Vector<String>();
        this.core.sizeZ[0] = this.core.imageCount[0];
        this.core.sizeC[0] = 1;
        this.core.sizeT[0] = 1;
        this.core.orderCertain[0] = false;
        this.core.rgb[0] = false;
        this.core.interleaved[0] = false;
        this.core.littleEndian[0] = true;
        this.status("Reading notes");
        String zoom = null;
        String zstart = null;
        String zstop = null;
        String mag = null;
        String gain1 = null;
        String gain2 = null;
        String gain3 = null;
        String offset1 = null;
        String offset2 = null;
        String offset3 = null;
        String ex1 = null;
        String ex2 = null;
        String ex3 = null;
        String em1 = null;
        String em2 = null;
        String em3 = null;
        int noteCount = 0;
        while (notes) {
            short level = this.in.readShort();
            notes = (this.in.read() | this.in.read() | this.in.read() | this.in.read()) != 0;
            short num = this.in.readShort();
            short status = this.in.readShort();
            short type = this.in.readShort();
            short x = this.in.readShort();
            short y = this.in.readShort();
            String text = this.in.readString(80);
            int ndx = text.length();
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) == '\u0000') {
                    ndx = i;
                    i = text.length();
                }
                ++i;
            }
            text = text.substring(0, ndx).trim();
            ++noteCount;
            switch (type) {
                case 8: {
                    int eq = text.indexOf("=");
                    if (eq == -1) break;
                    text = text.substring(eq + 1).trim();
                    String len = text.substring(0, text.indexOf(" ")).trim();
                    String angle = text.substring(text.indexOf(" ")).trim();
                    this.addMeta("Scalebar length (in microns)", len);
                    this.addMeta("Scalebar angle (in degrees)", angle);
                    break;
                }
                case 11: {
                    int eq = text.indexOf("=");
                    if (eq == -1) break;
                    text = text.substring(eq + 1).trim();
                    StringTokenizer st = new StringTokenizer(text, " ");
                    this.addMeta("Arrow width", st.nextToken());
                    this.addMeta("Arrow height", st.nextToken());
                    this.addMeta("Arrow angle", st.nextToken());
                    this.addMeta("Arrow fill type", st.nextToken());
                    break;
                }
                case 20: {
                    int eq = text.indexOf("=");
                    if (eq == -1) break;
                    String key = text.substring(0, eq);
                    String value = text.substring(eq + 1);
                    this.addMeta(key, value);
                    break;
                }
                case 21: {
                    int structType = (x & 0xFF00) >> 8;
                    int structVersion = x & 0xFF;
                    StringTokenizer st = new StringTokenizer(text, " ");
                    String[] keys = new String[]{};
                    int idx = 0;
                    switch (y) {
                        case 1: {
                            keys = new String[]{"Scan Channel", "Both Mode", "Speed", "Filter", "Factor", "Number of scans", "Photon counting mode (channel 1)", "Photon counting detector (channel 1)", "Photon counting mode (channel 2)", "Photon counting detector (channel 2)", "Photon mode", "Objective lens magnification", "Zoom factor (user selected)", "Motor on", "Z step size"};
                            break;
                        }
                        case 2: {
                            keys = new String[]{"Z start", "Z stop", "Scan area - cx", "Scan area - cy", "Scan area - lx", "Scan area - ly"};
                            break;
                        }
                        case 3: {
                            keys = new String[]{"PMT 1 Iris", "PMT 1 Gain", "PMT 1 Black level", "PMT 1 Emission filter", "PMT 2 Iris", "PMT 2 Gain", "PMT 2 Black level", "PMT 2 Emission filter", "PMT 3 Iris", "PMT 3 Gain", "PMT 3 Black level", "PMT 3 Emission filter", "Multiplier of channel 1", "Multiplier of channel 2", "Multiplier of channel 3"};
                            break;
                        }
                        case 4: {
                            keys = new String[]{"Number of lasers", "Number of transmission detectors", "Number of PMTs", "Shutter present for laser 1", "Shutter present for laser 2", "Shutter present for laser 3", "Neutral density filter for laser 1", "Excitation filter for laser 1", "Use laser 1", "Neutral density filter for laser 2", "Excitation filter for laser 2", "Use laser 2", "Neutral density filter for laser 3", "Excitation filter for laser 3", "Use laser 3", "Neutral density filter name - laser 1", "Neutral density filter name - laser 2", "Neutral density filter name - laser 3"};
                            break;
                        }
                        case 5: {
                            keys = new String[]{"Excitation filter name - laser 1", "Excitation filter name - laser 2", "Excitation filter name - laser 3"};
                            break;
                        }
                        case 6: {
                            keys = new String[]{"Emission filter name - laser 1", "Emission filter name - laser 2", "Emission filter name - laser 3"};
                            break;
                        }
                        case 7: {
                            keys = new String[]{"Mixer 0 - enhanced", "Mixer 0 - PMT 1 percentage", "Mixer 0 - PMT 2 percentage", "Mixer 0 - PMT 3 percentage", "Mixer 0 - Transmission 1 percentage", "Mixer 0 - Transmission 2 percentage", "Mixer 0 - Transmission 3 percentage", "Mixer 1 - enhanced", "Mixer 1 - PMT 1 percentage", "Mixer 1 - PMT 2 percentage", "Mixer 1 - PMT 3 percentage", "Mixer 1 - Transmission 1 percentage", "Mixer 1 - Transmission 2 percentage", "Mixer 1 - Transmission 3 percentage", "Mixer 0 - low signal on", "Mixer 1 - low signal on"};
                            break;
                        }
                        case 8: {
                            keys = new String[]{"Laser 1 name"};
                            break;
                        }
                        case 9: {
                            keys = new String[]{"Laser 2 name"};
                            break;
                        }
                        case 10: {
                            keys = new String[]{"Laser 3 name"};
                            break;
                        }
                        case 11: {
                            keys = new String[]{"Transmission detector 1 - offset", "Transmission detector 1 - gain", "Transmission detector 1 - black level", "Transmission detector 2 - offset", "Transmission detector 2 - gain", "Transmission detector 2 - black level", "Transmission detector 3 - offset", "Transmission detector 3 - gain", "Transmission detector 3 - black level"};
                            break;
                        }
                        case 12: {
                            keys = new String[]{"Part number of laser 1", "Part number of excitation filter for laser 1", "Part number of ND filter for laser 1", "Part number of emission filter for laser 1", "Part number of laser 2", "Part number of excitation filter for laser 2", "Part number of ND filter for laser 2", "Part number of emission filter for laser 2"};
                            break;
                        }
                        case 13: {
                            keys = new String[]{"Part number of laser 3", "Part number of excitation filter for laser 3", "Part number of ND filter for laser 3", "Part number of emission filter for laser 3", "Part number of filter block 1", "Part number of filter block 2", "Filter block 1", "Filter block 2"};
                            break;
                        }
                        case 14: {
                            keys = new String[]{"Filter block 1 name", "Filter block 2 name"};
                            break;
                        }
                        case 15: {
                            keys = new String[]{"Image band 1 status", "Image band 1 min", "Image band 1 max", "Image band 2 status", "Image band 2 min", "Image band 2 max", "Image band 3 status", "Image band 3 min", "Image band 3 max", "Image band 4 status", "Image band 4 min", "Image band 4 max", "Image band 5 status", "Image band 5 min", "Image band 5 max"};
                            break;
                        }
                        case 16: {
                            keys = new String[]{"Image band 5 status", "Image band 5 min", "Image band 5 max"};
                            break;
                        }
                        case 17: {
                            keys = new String[]{"Date stamp (seconds)", "Date stamp (minutes)", "Date stamp (hours)", "Date stamp (day of month)", "Date stamp (month)", "Date stamp (year: actual year - 1900)", "Date stamp (day of week)", "Date stamp (day of year)", "Daylight savings?"};
                            break;
                        }
                        case 18: {
                            keys = new String[]{"Mixer 3 - enhanced", "Mixer 3 - PMT 1 percentage", "Mixer 3 - PMT 2 percentage", "Mixer 3 - PMT 3 percentage", "Mixer 3 - Transmission 1 percentage", "Mixer 3 - Transmission 2 percentage", "Mixer 3 - Transmission 3 percentage", "Mixer 3 - low signal on", "Mixer 3 - photon counting 1", "Mixer 3 - photon counting 2", "Mixer 3 - photon counting 3", "Mixer 3 - mode"};
                            break;
                        }
                        case 19: {
                            keys = new String[]{"Mixer 1 - photon counting 1", "Mixer 1 - photon counting 2", "Mixer 1 - photon counting 3", "Mixer 1 - mode", "Mixer2 - photon counting 1", "Mixer 2 - photon counting 2", "Mixer 2 - photon counting 3", "Mixer 2 - mode"};
                            break;
                        }
                        case 20: {
                            keys = new String[]{"Display mode", "Course", "Time Course - experiment type", "Time Course - kd factor"};
                            break;
                        }
                        case 21: {
                            keys = new String[]{"Time Course - ion name"};
                            break;
                        }
                        case 22: {
                            keys = new String[]{"PIC file generated on Isoscan (lite)", "Photon counting used (PMT 1)", "Photon counting used (PMT 2)", "Photon counting used (PMT 3)", "Hot spot filter used (PMT 1)", "Hot spot filter used (PMT 2)", "Hot spot filter used (PMT 3)", "Tx selector used (TX 1)", "Tx selected used (TX 2)", "Tx selector used (TX 3)"};
                        }
                    }
                    while (st.hasMoreTokens() && idx < keys.length) {
                        String value = st.nextToken();
                        this.addMeta(keys[idx], value);
                        if (keys[idx].equals("Zoom factor (user selected)")) {
                            zoom = value;
                        } else if (keys[idx].equals("Z start")) {
                            zstart = value;
                        } else if (keys[idx].equals("Z stop")) {
                            zstop = value;
                        } else if (keys[idx].equals("Transmission detector 1 - gain")) {
                            gain1 = value;
                        } else if (keys[idx].equals("Transmission detector 2 - gain")) {
                            gain2 = value;
                        } else if (keys[idx].equals("Transmission detector 3 - gain")) {
                            gain3 = value;
                        } else if (keys[idx].equals("Transmission detector 1 - offset")) {
                            offset1 = value;
                        } else if (keys[idx].equals("Transmission detector 2 - offset")) {
                            offset2 = value;
                        } else if (keys[idx].equals("Transmission detector 3 - offset")) {
                            offset3 = value;
                        } else if (keys[idx].equals("Part number of excitation filter for laser 1")) {
                            ex1 = value;
                        } else if (keys[idx].equals("Part number of excitation filter for laser 2")) {
                            ex2 = value;
                        } else if (keys[idx].equals("Part number of excitation filter for laser 3")) {
                            ex3 = value;
                        } else if (keys[idx].equals("Part number of emission filter for laser 1")) {
                            em1 = value;
                        } else if (keys[idx].equals("Part number of emission filter for laser 2")) {
                            em2 = value;
                        } else if (keys[idx].equals("Part number of emission filter for laser 3")) {
                            em3 = value;
                        } else if (keys[idx].equals("Objective lens magnification")) {
                            mag = value;
                        }
                        ++idx;
                    }
                    break;
                }
                default: {
                    this.addMeta("note" + noteCount, this.noteString(num, level, status, type, x, y, text));
                }
            }
            if (text.indexOf("AXIS") == -1) continue;
            StringTokenizer st = new StringTokenizer(text);
            String key = st.nextToken();
            String noteType = "";
            if (st.hasMoreTokens()) {
                noteType = st.nextToken();
            }
            int axisType = Integer.parseInt(noteType);
            Vector<String> params = new Vector<String>();
            while (st.hasMoreTokens()) {
                params.add(st.nextToken());
            }
            if (params.size() <= 1) continue;
            switch (axisType) {
                case 1: {
                    String dx = (String)params.get(0);
                    String dy = (String)params.get(1);
                    this.addMeta(String.valueOf(key) + " distance (X) in microns", dx);
                    this.addMeta(String.valueOf(key) + " distance (Y) in microns", dy);
                    pixelSize.add(dy);
                    break;
                }
                case 2: {
                    if (text.indexOf("AXIS_4") == -1) break;
                    this.addMeta(String.valueOf(key) + " time (X) in seconds", params.get(0));
                    this.addMeta(String.valueOf(key) + " time (Y) in seconds", params.get(1));
                    this.core.sizeZ[0] = 1;
                    this.core.sizeT[0] = this.core.imageCount[0];
                    this.core.orderCertain[0] = true;
                    break;
                }
                case 3: {
                    this.addMeta(String.valueOf(key) + " angle (X) in degrees", params.get(0));
                    this.addMeta(String.valueOf(key) + " angle (Y) in degrees", params.get(1));
                    break;
                }
                case 4: {
                    this.addMeta(String.valueOf(key) + " intensity (X)", params.get(0));
                    this.addMeta(String.valueOf(key) + " intensity (Y)", params.get(1));
                    break;
                }
                case 6: {
                    this.addMeta(String.valueOf(key) + " ratio (X)", params.get(0));
                    this.addMeta(String.valueOf(key) + " ratio (Y)", params.get(1));
                    break;
                }
                case 7: {
                    this.addMeta(String.valueOf(key) + " log ratio (X)", params.get(0));
                    this.addMeta(String.valueOf(key) + " log ratio (Y)", params.get(1));
                    break;
                }
                case 9: {
                    this.addMeta(String.valueOf(key) + " noncalibrated intensity min", params.get(0));
                    this.addMeta(String.valueOf(key) + " noncalibrated intensity max", params.get(1));
                    this.addMeta(String.valueOf(key) + " calibrated intensity min", params.get(2));
                    this.addMeta(String.valueOf(key) + " calibrated intensity max", params.get(3));
                    break;
                }
                case 11: {
                    this.addMeta(String.valueOf(key) + " RGB type (X)", params.get(0));
                    this.addMeta(String.valueOf(key) + " RGB type (Y)", params.get(1));
                    break;
                }
                case 14: {
                    this.addMeta(String.valueOf(key) + " time course type (X)", params.get(0));
                    this.addMeta(String.valueOf(key) + " time course type (Y)", params.get(1));
                    break;
                }
                case 15: {
                    this.addMeta(String.valueOf(key) + " inverse sigmoid calibrated intensity (min)", params.get(0));
                    this.addMeta(String.valueOf(key) + " inverse sigmoid calibrated intensity (max)", params.get(1));
                    this.addMeta(String.valueOf(key) + " inverse sigmoid calibrated intensity (beta)", params.get(2));
                    this.addMeta(String.valueOf(key) + " inverse sigmoid calibrated intensity (Kd)", params.get(3));
                    this.addMeta(String.valueOf(key) + " inverse sigmoid calibrated intensity " + "(calibrated max)", params.get(0));
                    break;
                }
                case 16: {
                    this.addMeta(String.valueOf(key) + " log inverse sigmoid calibrated " + "intensity (min)", params.get(0));
                    this.addMeta(String.valueOf(key) + " log inverse sigmoid calibrated " + "intensity (max)", params.get(1));
                    this.addMeta(String.valueOf(key) + " log inverse sigmoid calibrated " + "intensity (beta)", params.get(2));
                    this.addMeta(String.valueOf(key) + " log inverse sigmoid calibrated " + "intensity (Kd)", params.get(3));
                    this.addMeta(String.valueOf(key) + " log inverse sigmoid calibrated " + "intensity (calibrated max)", params.get(0));
                }
            }
        }
        this.status("Reading color table");
        int numLuts = 0;
        byte[][] lut = new byte[3][768];
        boolean eof = false;
        while (!eof && numLuts < 3) {
            if (this.in.getFilePointer() + (long)lut[numLuts].length <= this.in.length()) {
                this.in.read(lut[numLuts]);
                ++numLuts;
                continue;
            }
            eof = true;
        }
        if (debug && debugLevel >= 2) {
            this.debug(String.valueOf(numLuts) + " color table" + (numLuts == 1 ? "" : "s") + " present.");
        }
        float[][][] colors = new float[numLuts][3][256];
        int i = 0;
        while (i < numLuts) {
            int l = 0;
            while (l < 256) {
                int qr = 0xFF & lut[i][l];
                int qg = 0xFF & lut[i][l + 256];
                int qb = 0xFF & lut[i][l + 512];
                colors[i][0][l] = qr;
                colors[i][1][l] = qg;
                colors[i][2][l] = qb;
                ++l;
            }
            ++i;
        }
        String colorString = "";
        int i2 = 0;
        while (i2 < numLuts) {
            int j = 0;
            while (j < 256) {
                int k = 0;
                while (k < 3) {
                    colorString = String.valueOf(colorString) + colors[i2][k][j];
                    if (j != 255 || k != 2) {
                        colorString = String.valueOf(colorString) + ",";
                    }
                    ++k;
                }
                ++j;
            }
            colorString = String.valueOf(colorString) + "\n\n";
            ++i2;
        }
        this.addMeta("luts", colorString);
        this.status("Populating metadata");
        Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
        String[] list = parent.list();
        int i3 = 0;
        while (i3 < list.length) {
            if (list[i3].endsWith("data.raw")) {
                RandomAccessStream raw = new RandomAccessStream(new Location(parent.getAbsolutePath(), list[i3]).getAbsolutePath());
                this.used.add(new Location(parent.getAbsolutePath(), list[i3]).getAbsolutePath());
                String line = raw.readLine();
                while (line != null && line.length() > 0) {
                    if (line.charAt(0) != '[') {
                        String key = line.substring(0, line.indexOf("="));
                        String value = line.substring(line.indexOf("=") + 1);
                        this.addMeta(key.trim(), value.trim());
                    }
                    line = raw.readLine();
                }
                raw.close();
            } else if (list[i3].endsWith("lse.xml")) {
                RandomAccessStream raw = new RandomAccessStream(new Location(parent.getAbsolutePath(), list[i3]).getAbsolutePath());
                this.used.add(new Location(parent.getAbsolutePath(), list[i3]).getAbsolutePath());
                byte[] b = new byte[(int)raw.length()];
                raw.read(b);
                String xml = new String(b);
                if (xml.indexOf("SectionInfo") != -1) {
                    int start = xml.indexOf("<SectionInfo>") + 13;
                    int end = xml.indexOf("</SectionInfo>");
                    xml = xml.substring(start, end);
                    while (xml.length() > 0) {
                        String element = xml.substring(0, xml.indexOf(">") + 1);
                        xml = xml.substring(xml.indexOf(">") + 1);
                        int ndx = element.indexOf("TimeCompleted") + 15;
                        String stamp = element.substring(ndx, element.indexOf("\"", ndx));
                        String key = element.substring(1, element.indexOf("\"", element.indexOf("\"") + 1));
                        key = key.replace('\"', '\u0000');
                        key = key.replace('=', ' ');
                        this.addMeta(String.valueOf(key) + " Timestamp", stamp);
                    }
                }
                raw.close();
                b = null;
            }
            ++i3;
        }
        MetadataStore store = this.getMetadataStore();
        store.setImage(name, null, null, null);
        this.in.seek(14L);
        this.core.pixelType[0] = this.in.readShort() == 1 ? 1 : 3;
        this.core.currentOrder[0] = "XY";
        int[] dims = new int[]{this.core.sizeZ[0], this.core.sizeC[0], this.core.sizeT[0]};
        int max = 0;
        int min = Integer.MAX_VALUE;
        int median = 1;
        int i4 = 0;
        while (i4 < dims.length) {
            if (dims[i4] < min) {
                min = dims[i4];
            }
            if (dims[i4] > max) {
                max = dims[i4];
            } else {
                median = dims[i4];
            }
            ++i4;
        }
        int[] orderedDims = new int[]{max, median, min};
        int i5 = 0;
        while (i5 < orderedDims.length) {
            this.core.currentOrder[0] = orderedDims[i5] == this.core.sizeZ[0] && this.core.currentOrder[0].indexOf("Z") == -1 ? String.valueOf(this.core.currentOrder[0]) + "Z" : (orderedDims[i5] == this.core.sizeC[0] && this.core.currentOrder[0].indexOf("C") == -1 ? String.valueOf(this.core.currentOrder[0]) + "C" : String.valueOf(this.core.currentOrder[0]) + "T");
            ++i5;
        }
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), Boolean.FALSE, this.core.currentOrder[0], null, null);
        int size = pixelSize.size();
        Float pixelSizeX = null;
        Float pixelSizeY = null;
        Float pixelSizeZ = null;
        if (size >= 1) {
            pixelSizeX = new Float((String)pixelSize.get(0));
        }
        if (size >= 2) {
            pixelSizeY = new Float((String)pixelSize.get(1));
        }
        if (size >= 3) {
            pixelSizeZ = new Float((String)pixelSize.get(2));
        }
        store.setDimensions(pixelSizeX, pixelSizeY, pixelSizeZ, null, null, null);
        int i6 = 0;
        while (i6 < this.core.sizeC[0]) {
            store.setLogicalChannel(i6, null, null, null, null, null, null, null);
            store.setDisplayChannel(new Integer(i6), new Double(ramp1max), new Double(ramp1min), null, null);
            ++i6;
        }
        store.setDisplayOptions(zoom == null ? null : new Float(zoom), new Boolean(this.core.sizeC[0] > 1), new Boolean(this.core.sizeC[0] >= 2), new Boolean(this.core.sizeC[0] >= 3), Boolean.FALSE, null, zstart == null ? null : new Integer((int)new Double(zstart).doubleValue()), zstop == null ? null : new Integer((int)new Double(zstop).doubleValue()), null, null, null, null, this.core.sizeC[0] > 1 ? new Integer(0) : null, this.core.sizeC[0] > 1 ? new Integer(1) : null, this.core.sizeC[0] > 1 ? new Integer(2) : null, new Integer(0));
        i6 = 0;
        while (i6 < 3) {
            String ems;
            String exc;
            String offset;
            String gain;
            String string = i6 == 0 ? gain1 : (gain = i6 == 1 ? gain2 : gain3);
            String string2 = i6 == 0 ? offset1 : (offset = i6 == 1 ? gain2 : gain3);
            if (gain != null || offset != null) {
                store.setDetector(null, null, null, null, gain == null ? null : new Float(gain), null, offset == null ? null : new Float(offset), null, new Integer(i6));
            }
            String string3 = i6 == 0 ? ex1 : (exc = i6 == 1 ? ex2 : ex3);
            String string4 = i6 == 0 ? em1 : (ems = i6 == 1 ? em2 : em3);
            if (exc != null) {
                store.setExcitationFilter(null, null, exc, null, null);
            }
            if (ems != null) {
                store.setEmissionFilter(null, null, ems, null, null);
            }
            ++i6;
        }
        if (mag != null) {
            store.setObjective(null, null, null, null, new Float(mag), null, null);
        }
    }

    private String noteString(int n, int l, int s, int t, int x, int y, String p) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("level=");
        sb.append(l);
        sb.append("; num=");
        sb.append(n);
        sb.append("; status=");
        sb.append(s);
        sb.append("; type=");
        sb.append(NOTE_NAMES[t]);
        sb.append("; x=");
        sb.append(x);
        sb.append("; y=");
        sb.append(y);
        sb.append("; text=");
        sb.append(p == null ? "null" : p.trim());
        return sb.toString();
    }
}

