/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.TiffRational;
import loci.formats.TiffTools;

public abstract class BaseTiffReader
extends FormatReader {
    protected Hashtable[] ifds;

    public BaseTiffReader(String name, String suffix) {
        super(name, suffix);
    }

    public BaseTiffReader(String name, String[] suffixes) {
        super(name, suffixes);
    }

    public int[] getTiffDimensions() throws FormatException, IOException {
        if (this.ifds == null || this.ifds.length == 0) {
            return null;
        }
        return new int[]{TiffTools.getIFDIntValue(this.ifds[0], 256, false, -1), TiffTools.getIFDIntValue(this.ifds[0], 257, false, -1), this.core.imageCount[0]};
    }

    public boolean isThisType(byte[] block) {
        return TiffTools.isValidHeader(block);
    }

    public Object getMetadataValue(String field) {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getMeta(field);
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        int bytesPerPixel = FormatTools.getBytesPerPixel(this.getPixelType());
        byte[] buf = new byte[this.getSizeX() * this.getSizeY() * bytesPerPixel * this.getRGBChannelCount()];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        TiffTools.getSamples(this.ifds[no], this.in, buf);
        return this.swapIfRequired(buf);
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        return TiffTools.getImage(this.ifds[no], this.in);
    }

    protected void initMetadata() throws FormatException, IOException {
        this.initStandardMetadata();
        this.initMetadataStore();
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        Hashtable ifd = this.ifds[0];
        this.put("ImageWidth", ifd, 256);
        this.put("ImageLength", ifd, 257);
        this.put("BitsPerSample", ifd, 258);
        int comp = TiffTools.getIFDIntValue(ifd, 259);
        String compression = null;
        switch (comp) {
            case 1: {
                compression = "None";
                break;
            }
            case 2: {
                compression = "CCITT Group 3 1-Dimensional Modified Huffman";
                break;
            }
            case 3: {
                compression = "CCITT T.4 bilevel encoding";
                break;
            }
            case 4: {
                compression = "CCITT T.6 bilevel encoding";
                break;
            }
            case 5: {
                compression = "LZW";
                break;
            }
            case 7: {
                compression = "JPEG";
                break;
            }
            case 32773: {
                compression = "PackBits";
            }
        }
        this.put("Compression", compression);
        int photo = TiffTools.getIFDIntValue(ifd, 262);
        String photoInterp = null;
        String metaDataPhotoInterp = null;
        switch (photo) {
            case 0: {
                photoInterp = "WhiteIsZero";
                metaDataPhotoInterp = "Monochrome";
                break;
            }
            case 1: {
                photoInterp = "BlackIsZero";
                metaDataPhotoInterp = "Monochrome";
                break;
            }
            case 2: {
                photoInterp = "RGB";
                metaDataPhotoInterp = "RGB";
                break;
            }
            case 3: {
                photoInterp = "Palette";
                metaDataPhotoInterp = "Monochrome";
                break;
            }
            case 4: {
                photoInterp = "Transparency Mask";
                metaDataPhotoInterp = "RGB";
                break;
            }
            case 5: {
                photoInterp = "CMYK";
                metaDataPhotoInterp = "CMYK";
                break;
            }
            case 6: {
                photoInterp = "YCbCr";
                metaDataPhotoInterp = "RGB";
                break;
            }
            case 8: {
                photoInterp = "CIELAB";
                metaDataPhotoInterp = "RGB";
                break;
            }
            case -32733: {
                photoInterp = "Color Filter Array";
                metaDataPhotoInterp = "RGB";
            }
        }
        this.put("PhotometricInterpretation", photoInterp);
        this.put("MetaDataPhotometricInterpretation", metaDataPhotoInterp);
        this.putInt("CellWidth", ifd, 264);
        this.putInt("CellLength", ifd, 265);
        int or = TiffTools.getIFDIntValue(ifd, 274);
        if (or == 8) {
            this.put("ImageWidth", ifd, 257);
            this.put("ImageLength", ifd, 256);
        }
        String orientation = null;
        switch (or) {
            case 1: {
                orientation = "1st row -> top; 1st column -> left";
                break;
            }
            case 2: {
                orientation = "1st row -> top; 1st column -> right";
                break;
            }
            case 3: {
                orientation = "1st row -> bottom; 1st column -> right";
                break;
            }
            case 4: {
                orientation = "1st row -> bottom; 1st column -> left";
                break;
            }
            case 5: {
                orientation = "1st row -> left; 1st column -> top";
                break;
            }
            case 6: {
                orientation = "1st row -> right; 1st column -> top";
                break;
            }
            case 7: {
                orientation = "1st row -> right; 1st column -> bottom";
                break;
            }
            case 8: {
                orientation = "1st row -> left; 1st column -> bottom";
            }
        }
        this.put("Orientation", orientation);
        this.putInt("SamplesPerPixel", ifd, 277);
        this.put("Software", ifd, 305);
        this.put("Instrument Make", ifd, 271);
        this.put("Instrument Model", ifd, 272);
        this.put("Document Name", ifd, 269);
        this.put("DateTime", ifd, 306);
        this.put("Artist", ifd, 315);
        this.put("HostComputer", ifd, 316);
        this.put("Copyright", ifd, 33432);
        this.put("NewSubfileType", ifd, 254);
        int thresh = TiffTools.getIFDIntValue(ifd, 263);
        String threshholding = null;
        switch (thresh) {
            case 1: {
                threshholding = "No dithering or halftoning";
                break;
            }
            case 2: {
                threshholding = "Ordered dithering or halftoning";
                break;
            }
            case 3: {
                threshholding = "Randomized error diffusion";
            }
        }
        this.put("Threshholding", threshholding);
        int fill = TiffTools.getIFDIntValue(ifd, 266);
        String fillOrder = null;
        switch (fill) {
            case 1: {
                fillOrder = "Pixels with lower column values are stored in the higher order bits of a byte";
                break;
            }
            case 2: {
                fillOrder = "Pixels with lower column values are stored in the lower order bits of a byte";
            }
        }
        this.put("FillOrder", fillOrder);
        this.putInt("Make", ifd, 271);
        this.putInt("Model", ifd, 272);
        this.putInt("MinSampleValue", ifd, 280);
        this.putInt("MaxSampleValue", ifd, 281);
        this.putInt("XResolution", ifd, 282);
        this.putInt("YResolution", ifd, 283);
        int planar = TiffTools.getIFDIntValue(ifd, 284);
        String planarConfig = null;
        switch (planar) {
            case 1: {
                planarConfig = "Chunky";
                break;
            }
            case 2: {
                planarConfig = "Planar";
            }
        }
        this.put("PlanarConfiguration", planarConfig);
        this.putInt("XPosition", ifd, 286);
        this.putInt("YPosition", ifd, 287);
        this.putInt("FreeOffsets", ifd, 288);
        this.putInt("FreeByteCounts", ifd, 289);
        this.putInt("GrayResponseUnit", ifd, 290);
        this.putInt("GrayResponseCurve", ifd, 291);
        this.putInt("T4Options", ifd, 292);
        this.putInt("T6Options", ifd, 293);
        int res = TiffTools.getIFDIntValue(ifd, 296);
        String resUnit = null;
        switch (res) {
            case 1: {
                resUnit = "None";
                break;
            }
            case 2: {
                resUnit = "Inch";
                break;
            }
            case 3: {
                resUnit = "Centimeter";
            }
        }
        this.put("ResolutionUnit", resUnit);
        this.putInt("PageNumber", ifd, 297);
        this.putInt("TransferFunction", ifd, 301);
        int predict = TiffTools.getIFDIntValue(ifd, 317);
        String predictor = null;
        switch (predict) {
            case 1: {
                predictor = "No prediction scheme";
                break;
            }
            case 2: {
                predictor = "Horizontal differencing";
            }
        }
        this.put("Predictor", predictor);
        this.putInt("WhitePoint", ifd, 318);
        this.putInt("PrimaryChromacities", ifd, 319);
        this.putInt("HalftoneHints", ifd, 321);
        this.putInt("TileWidth", ifd, 322);
        this.putInt("TileLength", ifd, 323);
        this.putInt("TileOffsets", ifd, 324);
        this.putInt("TileByteCounts", ifd, 325);
        int ink = TiffTools.getIFDIntValue(ifd, 332);
        String inkSet = null;
        switch (ink) {
            case 1: {
                inkSet = "CMYK";
                break;
            }
            case 2: {
                inkSet = "Other";
            }
        }
        this.put("InkSet", inkSet);
        this.putInt("InkNames", ifd, 333);
        this.putInt("NumberOfInks", ifd, 334);
        this.putInt("DotRange", ifd, 336);
        this.put("TargetPrinter", ifd, 337);
        this.putInt("ExtraSamples", ifd, 338);
        int fmt = TiffTools.getIFDIntValue(ifd, 339);
        String sampleFormat = null;
        switch (fmt) {
            case 1: {
                sampleFormat = "unsigned integer";
                break;
            }
            case 2: {
                sampleFormat = "two's complement signed integer";
                break;
            }
            case 3: {
                sampleFormat = "IEEE floating point";
                break;
            }
            case 4: {
                sampleFormat = "undefined";
            }
        }
        this.put("SampleFormat", sampleFormat);
        this.putInt("SMinSampleValue", ifd, 340);
        this.putInt("SMaxSampleValue", ifd, 341);
        this.putInt("TransferRange", ifd, 342);
        int jpeg = TiffTools.getIFDIntValue(ifd, 512);
        String jpegProc = null;
        switch (jpeg) {
            case 1: {
                jpegProc = "baseline sequential process";
                break;
            }
            case 14: {
                jpegProc = "lossless process with Huffman coding";
            }
        }
        this.put("JPEGProc", jpegProc);
        this.putInt("JPEGInterchangeFormat", ifd, 513);
        this.putInt("JPEGRestartInterval", ifd, 515);
        this.putInt("JPEGLosslessPredictors", ifd, 517);
        this.putInt("JPEGPointTransforms", ifd, 518);
        this.putInt("JPEGQTables", ifd, 519);
        this.putInt("JPEGDCTables", ifd, 520);
        this.putInt("JPEGACTables", ifd, 521);
        this.putInt("YCbCrCoefficients", ifd, 529);
        int ycbcr = TiffTools.getIFDIntValue(ifd, 530);
        String subSampling = null;
        switch (ycbcr) {
            case 1: {
                subSampling = "chroma image dimensions = luma image dimensions";
                break;
            }
            case 2: {
                subSampling = "chroma image dimensions are half the luma image dimensions";
                break;
            }
            case 4: {
                subSampling = "chroma image dimensions are 1/4 the luma image dimensions";
            }
        }
        this.put("YCbCrSubSampling", subSampling);
        this.putInt("YCbCrPositioning", ifd, 531);
        this.putInt("ReferenceBlackWhite", ifd, 532);
        Object bpsObj = TiffTools.getIFDValue(ifd, 258);
        int bps = -1;
        int numC = 3;
        if (bpsObj instanceof int[]) {
            int[] q = (int[])bpsObj;
            bps = q[0];
            numC = q.length;
        } else if (bpsObj instanceof Number) {
            bps = ((Number)bpsObj).intValue();
            numC = 1;
        }
        int p = TiffTools.getIFDIntValue(ifd, 262);
        if (p == 3 || p == -32733) {
            numC = 3;
            bps *= 3;
        }
        this.put("BitsPerSample", bps);
        this.put("NumberOfChannels", numC);
        String comment = null;
        Object o = TiffTools.getIFDValue(ifd, 270);
        if (o instanceof String) {
            comment = (String)o;
        } else if (o instanceof String[]) {
            String[] s = (String[])o;
            if (s.length > 0) {
                comment = s[0];
            }
        } else if (o != null) {
            comment = o.toString();
        }
        if (comment != null) {
            comment = comment.replaceAll("\r\n", "\n");
            comment = comment.replaceAll("\r", "\n");
            this.put("Comment", comment);
        }
        int samples = TiffTools.getIFDIntValue(this.ifds[0], 277, false, 1);
        this.core.rgb[0] = samples > 1 || p == 3 || p == -32733 || p == 2;
        this.core.interleaved[0] = true;
        this.core.littleEndian[0] = TiffTools.isLittleEndian(this.ifds[0]);
        this.core.sizeX[0] = TiffTools.getIFDIntValue(this.ifds[0], 256, false, 0);
        this.core.sizeY[0] = TiffTools.getIFDIntValue(this.ifds[0], 257, false, 0);
        this.core.sizeZ[0] = 1;
        this.core.sizeC[0] = this.core.rgb[0] ? 3 : 1;
        this.core.sizeT[0] = this.ifds.length;
        int bitFormat = TiffTools.getIFDIntValue(this.ifds[0], 339);
        while (bps % 8 != 0) {
            ++bps;
        }
        if (bps == 24 || bps == 48) {
            bps /= 3;
        }
        if (bitFormat == 3) {
            this.core.pixelType[0] = 6;
        } else if (bitFormat == 2) {
            switch (bps) {
                case 16: {
                    this.core.pixelType[0] = 2;
                    break;
                }
                case 32: {
                    this.core.pixelType[0] = 4;
                    break;
                }
                default: {
                    this.core.pixelType[0] = 1;
                    break;
                }
            }
        } else {
            switch (bps) {
                case 16: {
                    this.core.pixelType[0] = 3;
                    break;
                }
                case 32: {
                    this.core.pixelType[0] = 5;
                    break;
                }
                default: {
                    this.core.pixelType[0] = 1;
                }
            }
        }
        this.core.currentOrder[0] = "XYCZT";
    }

    protected void initMetadataStore() {
        Hashtable ifd = this.ifds[0];
        try {
            Float stageY;
            Float stageX;
            MetadataStore store = this.getMetadataStore();
            store.setPixels(new Integer(this.getSizeX()), new Integer(this.getSizeY()), new Integer(this.getSizeZ()), new Integer(this.getSizeC()), new Integer(this.getSizeT()), new Integer(this.getPixelType()), new Boolean(!this.isLittleEndian()), this.getDimensionOrder(), null, null);
            String artist = (String)TiffTools.getIFDValue(ifd, 315);
            if (artist != null) {
                String firstName = null;
                String lastName = null;
                int ndx = artist.indexOf(" ");
                if (ndx < 0) {
                    lastName = artist;
                } else {
                    firstName = artist.substring(0, ndx);
                    lastName = artist.substring(ndx + 1);
                }
                String email = (String)TiffTools.getIFDValue(ifd, 316);
                store.setExperimenter(firstName, lastName, email, null, null, null, null);
            }
            String creationDate = this.getImageCreationDate();
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                SimpleDateFormat parse = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
                Date date = parse.parse(creationDate, new ParsePosition(0));
                creationDate = sdf.format(date);
            }
            catch (Exception e) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    SimpleDateFormat parse = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SS");
                    Date date = parse.parse(creationDate, new ParsePosition(0));
                    creationDate = sdf.format(date);
                }
                catch (Exception exc) {
                    if (debug) {
                        this.trace(exc);
                    }
                    creationDate = null;
                }
            }
            store.setImage(this.getImageName(), creationDate, this.getImageDescription(), null);
            int i = 0;
            while (i < this.getSizeC()) {
                block21: {
                    try {
                        this.setLogicalChannel(i);
                    }
                    catch (FormatException exc) {
                        if (debug) {
                            this.trace(exc);
                        }
                    }
                    catch (IOException exc) {
                        if (!debug) break block21;
                        this.trace(exc);
                    }
                }
                ++i;
            }
            int resolutionUnit = TiffTools.getIFDIntValue(ifd, 296);
            TiffRational xResolution = TiffTools.getIFDRationalValue(ifd, 282, false);
            TiffRational yResolution = TiffTools.getIFDRationalValue(ifd, 283, false);
            float pixX = xResolution == null ? 0.0f : xResolution.floatValue();
            float pixY = yResolution == null ? 0.0f : yResolution.floatValue();
            switch (resolutionUnit) {
                case 2: {
                    pixX = (float)((double)pixX * 0.0254);
                    pixY = (float)((double)pixY * 0.0254);
                    break;
                }
                case 3: {
                    pixX /= 100.0f;
                    pixY /= 100.0f;
                }
            }
            store.setDimensions(new Float(pixX), new Float(pixY), null, null, null, null);
            Object x = TiffTools.getIFDValue(ifd, 286);
            Object y = TiffTools.getIFDValue(ifd, 287);
            if (x instanceof TiffRational) {
                stageX = x == null ? null : new Float(((TiffRational)x).floatValue());
                stageY = y == null ? null : new Float(((TiffRational)y).floatValue());
            } else {
                stageX = x == null ? null : new Float((String)x);
                stageY = y == null ? null : new Float((String)y);
            }
            store.setStageLabel(null, stageX, stageY, null, null);
            String model = (String)TiffTools.getIFDValue(ifd, 272);
            String serialNumber = (String)TiffTools.getIFDValue(ifd, 271);
            store.setInstrument(null, model, serialNumber, null, null);
        }
        catch (FormatException exc) {
            this.trace(exc);
        }
    }

    protected String getImageName() {
        return this.currentId;
    }

    protected String getImageCreationDate() {
        return (String)TiffTools.getIFDValue(this.ifds[0], 306);
    }

    protected String getImageDescription() {
        return (String)this.getMeta("Comment");
    }

    protected byte[] swapIfRequired(byte[] byteArray) throws FormatException, IOException {
        int bitsPerSample = TiffTools.getBitsPerSample(this.ifds[0])[0];
        if (bitsPerSample == 8 || bitsPerSample == 32) {
            return byteArray;
        }
        if (this.isLittleEndian()) {
            if (bitsPerSample == 16) {
                ShortBuffer buf = ByteBuffer.wrap(byteArray).asShortBuffer();
                int i = 0;
                while (i < byteArray.length / 2) {
                    buf.put(i, DataTools.swap(buf.get(i)));
                    ++i;
                }
            } else {
                throw new FormatException("Unsupported sample bit width: '" + bitsPerSample + "'");
            }
        }
        return byteArray;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("BaseTiffReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.in.order(this.in.readShort() == 18761);
        this.status("Reading IFDs");
        this.ifds = TiffTools.getIFDs(this.in);
        if (this.ifds == null) {
            throw new FormatException("No IFDs found");
        }
        this.status("Populating metadata");
        this.core.imageCount[0] = this.ifds.length;
        this.initMetadata();
    }

    private void setLogicalChannel(int i) throws FormatException, IOException {
        this.getMetadataStore().setLogicalChannel(i, this.getChannelName(i), this.getNdFilter(i), this.getEmWave(i), this.getExWave(i), this.getPhotometricInterpretation(i), this.getMode(i), null);
    }

    private String getChannelName(int i) {
        return null;
    }

    private Float getNdFilter(int i) {
        return null;
    }

    Integer getEmWave(int i) {
        return null;
    }

    private Integer getExWave(int i) {
        return null;
    }

    private String getPhotometricInterpretation(int i) throws FormatException, IOException {
        return (String)this.getMetadataValue("metaDataPhotometricInterpretation");
    }

    private String getMode(int i) {
        return null;
    }

    protected void put(String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            value = ((String)value).trim();
        }
        this.addMeta(key, value);
    }

    protected void put(String key, int value) {
        if (value == -1) {
            return;
        }
        this.addMeta(key, new Integer(value));
    }

    protected void put(String key, boolean value) {
        this.put(key, new Boolean(value));
    }

    protected void put(String key, byte value) {
        this.put(key, new Byte(value));
    }

    protected void put(String key, char value) {
        this.put(key, new Character(value));
    }

    protected void put(String key, double value) {
        this.put(key, new Double(value));
    }

    protected void put(String key, float value) {
        this.put(key, new Float(value));
    }

    protected void put(String key, long value) {
        this.put(key, new Long(value));
    }

    protected void put(String key, short value) {
        this.put(key, new Short(value));
    }

    protected void put(String key, Hashtable ifd, int tag) {
        this.put(key, TiffTools.getIFDValue(ifd, tag));
    }

    protected void putInt(String key, Hashtable ifd, int tag) {
        this.put(key, TiffTools.getIFDIntValue(ifd, tag));
    }
}

