/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class BMPReader
extends FormatReader {
    protected int offset;
    protected int bpp;
    protected byte[][] palette;
    protected int compression;
    private long global;

    public BMPReader() {
        super("Windows Bitmap", "bmp");
    }

    public boolean isThisType(byte[] block) {
        if (block.length != 14) {
            return false;
        }
        return block[0] == 66 && block[1] == 77;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] buf = new byte[this.core.sizeX[0] * this.core.sizeY[0] * this.core.sizeC[0]];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        int pixels = this.core.sizeX[0] * this.core.sizeY[0];
        if (buf.length < pixels * (this.bpp / 8)) {
            throw new FormatException("Buffer too small.");
        }
        if (this.compression != 0) {
            throw new FormatException("Compression type " + this.compression + " not supported");
        }
        this.in.seek(this.global);
        if (this.palette != null && this.palette[0].length > 0) {
            int y = this.core.sizeY[0] - 1;
            while (y >= 0) {
                int x = 0;
                while (x < this.core.sizeX[0]) {
                    int val = this.in.read();
                    if (val < 0) {
                        val += 127;
                    }
                    buf[y * this.core.sizeX[0] + x] = this.palette[0][val];
                    buf[y * this.core.sizeX[0] + x + pixels] = this.palette[1][val];
                    buf[y * this.core.sizeX[0] + x + 2 * pixels] = this.palette[2][val];
                    ++x;
                }
                --y;
            }
        } else if (this.core.sizeC[0] == 1) {
            int y = this.core.sizeY[0] - 1;
            while (y >= 0) {
                int x = 0;
                while (x < this.core.sizeX[0]) {
                    buf[y * this.core.sizeX[0] + x] = (byte)(this.in.read() & 0xFF);
                    ++x;
                }
                --y;
            }
        } else {
            int y = this.core.sizeY[0] - 1;
            while (y >= 0) {
                int x = 0;
                while (x < this.core.sizeX[0]) {
                    int off = y * this.core.sizeX[0] + x;
                    buf[2 * this.core.sizeX[0] * this.core.sizeY[0] + off] = (byte)(this.in.read() & 0xFF);
                    buf[this.core.sizeX[0] * this.core.sizeY[0] + off] = (byte)(this.in.read() & 0xFF);
                    buf[off] = (byte)(this.in.read() & 0xFF);
                    ++x;
                }
                --y;
            }
        }
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], this.core.sizeC[0], false);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("BMPReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Reading bitmap header");
        this.in.order(true);
        this.addMeta("Magic identifier", this.in.readString(2));
        this.addMeta("File size (in bytes)", "" + this.in.readInt());
        this.in.skipBytes(4);
        this.offset = this.in.readInt();
        this.in.skipBytes(4);
        this.core.sizeX[0] = this.in.readInt();
        this.core.sizeY[0] = this.in.readInt();
        if (this.core.sizeX[0] < 1 || this.core.sizeY[0] < 1) {
            throw new FormatException("Invalid image dimensions: " + this.core.sizeX[0] + " x " + this.core.sizeY[0]);
        }
        this.addMeta("Image width", "" + this.core.sizeX[0]);
        this.addMeta("Image height", "" + this.core.sizeY[0]);
        this.addMeta("Color planes", "" + this.in.readShort());
        this.bpp = this.in.readShort();
        this.addMeta("Bits per pixel", "" + this.bpp);
        this.compression = this.in.readInt();
        String comp = "invalid";
        switch (this.compression) {
            case 0: {
                comp = "None";
                break;
            }
            case 1: {
                comp = "8 bit run length encoding";
                break;
            }
            case 2: {
                comp = "4 bit run length encoding";
                break;
            }
            case 3: {
                comp = "RGB bitmap with mask";
            }
        }
        this.addMeta("Compression type", comp);
        this.in.skipBytes(4);
        int pixelSizeX = this.in.readInt();
        int pixelSizeY = this.in.readInt();
        this.addMeta("X resolution", "" + pixelSizeX);
        this.addMeta("Y resolution", "" + pixelSizeY);
        int nColors = this.in.readInt();
        this.in.skipBytes(4);
        if ((long)this.offset != this.in.getFilePointer() && nColors > 0) {
            this.palette = new byte[3][nColors];
            int i = 0;
            while (i < nColors) {
                int j = this.palette.length;
                while (j > 0) {
                    this.palette[j][i] = (byte)(this.in.read() & 0xFF);
                    --j;
                }
                this.in.read();
                ++i;
            }
        }
        this.global = this.in.getFilePointer();
        this.addMeta("Indexed color", this.palette == null ? "false" : "true");
        this.status("Populating metadata");
        int n = this.core.sizeC[0] = this.palette == null && this.bpp == 8 ? 1 : 3;
        if (this.bpp > 8) {
            this.bpp /= 3;
        }
        while (this.bpp % 8 != 0) {
            ++this.bpp;
        }
        switch (this.bpp) {
            case 8: {
                this.core.pixelType[0] = 1;
                break;
            }
            case 16: {
                this.core.pixelType[0] = 3;
                break;
            }
            case 32: {
                this.core.pixelType[0] = 5;
            }
        }
        if (this.core.sizeX[0] % 2 == 1) {
            this.core.sizeX[0] = this.core.sizeX[0] + 1;
        }
        this.core.rgb[0] = this.core.sizeC[0] > 1;
        this.core.littleEndian[0] = true;
        this.core.interleaved[0] = true;
        this.core.imageCount[0] = 1;
        this.core.sizeZ[0] = 1;
        this.core.sizeT[0] = 1;
        this.core.currentOrder[0] = "XYCTZ";
        MetadataStore store = this.getMetadataStore();
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(false), this.core.currentOrder[0], null, null);
        float correctedX = 1.0f / (float)pixelSizeX * 1000000.0f;
        float correctedY = 1.0f / (float)pixelSizeY * 1000000.0f;
        store.setDimensions(new Float(correctedX), new Float(correctedY), null, null, null, null);
        int i = 0;
        while (i < this.core.sizeC[0]) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null);
            ++i;
        }
    }
}

