/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class AliconaReader
extends FormatReader {
    private int textureOffset;
    private int numBytes;

    public AliconaReader() {
        super("Alicona AL3D", "al3d");
    }

    public boolean isThisType(byte[] block) {
        return new String(block).indexOf("Alicona") != -1;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] buf = new byte[this.core.sizeX[0] * this.core.sizeY[0] * this.numBytes];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        int pad = (8 - this.core.sizeX[0] % 8) % 8;
        if (buf.length < this.core.sizeX[0] * this.core.sizeY[0] * this.numBytes) {
            throw new FormatException("Buffer too small.");
        }
        int i = 0;
        while (i < this.numBytes) {
            this.in.seek(this.textureOffset + no * (this.core.sizeX[0] + pad) * this.core.sizeY[0] * (i + 1));
            int j = 0;
            while (j < this.core.sizeX[0] * this.core.sizeY[0]) {
                buf[j * this.numBytes + i] = (byte)(this.in.read() & 0xFF);
                if (j % this.core.sizeX[0] == this.core.sizeX[0] - 1) {
                    this.in.skipBytes(pad);
                }
                ++j;
            }
            ++i;
        }
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], 1, false, this.numBytes, true);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("AliconaReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Verifying Alicona format");
        String magicString = this.in.readString(17);
        if (!magicString.trim().equals("AliconaImaging")) {
            throw new FormatException("Invalid magic string : expected 'AliconaImaging', got " + magicString);
        }
        this.status("Reading tags");
        int count = 2;
        boolean hasC = false;
        String voltage = null;
        String magnification = null;
        String pntX = null;
        String pntY = null;
        String pntZ = null;
        int i = 0;
        while (i < count) {
            String key = this.in.readString(20);
            String value = this.in.readString(30);
            key = key.trim();
            value = value.trim();
            this.addMeta(key, value);
            this.in.skipBytes(2);
            if (key.equals("TagCount")) {
                count += Integer.parseInt(value);
            } else if (key.equals("Rows")) {
                this.core.sizeY[0] = Integer.parseInt(value);
            } else if (key.equals("Cols")) {
                this.core.sizeX[0] = Integer.parseInt(value);
            } else if (key.equals("NumberOfPlanes")) {
                this.core.imageCount[0] = Integer.parseInt(value);
            } else if (key.equals("TextureImageOffset")) {
                this.textureOffset = Integer.parseInt(value);
            } else if (key.equals("TexturePtr") && !value.equals("7")) {
                hasC = true;
            } else if (key.equals("Voltage")) {
                voltage = value;
            } else if (key.equals("Magnification")) {
                magnification = value;
            } else if (key.equals("PlanePntX")) {
                pntX = value;
            } else if (key.equals("PlanePntY")) {
                pntY = value;
            } else if (key.equals("PlanePntZ")) {
                pntZ = value;
            }
            ++i;
        }
        this.status("Populating metadata");
        this.numBytes = (int)(this.in.length() - (long)this.textureOffset) / (this.core.sizeX[0] * this.core.sizeY[0] * this.core.imageCount[0]);
        this.core.sizeC[0] = hasC ? 3 : 1;
        this.core.sizeZ[0] = 1;
        this.core.sizeT[0] = this.core.imageCount[0] / this.core.sizeC[0];
        this.core.rgb[0] = false;
        this.core.interleaved[0] = false;
        this.core.littleEndian[0] = true;
        this.core.pixelType[0] = this.numBytes == 2 ? 3 : 1;
        this.core.currentOrder[0] = "XYCTZ";
        MetadataStore store = this.getMetadataStore();
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(!this.core.littleEndian[0]), this.core.currentOrder[0], null, null);
        if (voltage != null) {
            store.setDetector(null, null, null, null, null, new Float(voltage), null, null, null);
        }
        if (magnification != null) {
            store.setObjective(null, null, null, null, new Float(magnification), null, null);
        }
        if (pntX != null && pntY != null && pntZ != null) {
            store.setDimensions(new Float(pntX.trim()), new Float(pntY.trim()), new Float(pntZ.trim()), null, null, null);
        }
        int i2 = 0;
        while (i2 < this.core.sizeC[0]) {
            store.setLogicalChannel(i2, null, null, null, null, null, null, null);
            ++i2;
        }
    }
}

