/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.codec.BitBuffer;
import loci.formats.codec.MSRLECodec;

public class AVIReader
extends FormatReader {
    private Vector offsets;
    private Vector lengths;
    private String type = "error";
    private String fcc = "error";
    private int size = -1;
    private long pos;
    private int bmpColorsUsed;
    private int bmpWidth;
    private int bmpCompression;
    private int bmpScanLineSize;
    private int bmpActualColorsUsed;
    private short bmpBitsPerPixel;
    private byte[] pr = null;
    private byte[] pg = null;
    private byte[] pb = null;
    private boolean isRLE = false;
    private byte[] lastImage;

    public AVIReader() {
        super("Audio Video Interleave", "avi");
    }

    public String readStringBytes() throws IOException {
        byte[] list = new byte[4];
        this.in.read(list);
        return new String(list);
    }

    private void whine(String msg) throws FormatException {
        throw new FormatException(msg);
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int bytes = FormatTools.getBytesPerPixel(this.core.pixelType[0]);
        double p = (double)this.bmpScanLineSize / (double)this.bmpBitsPerPixel;
        int effectiveWidth = (int)((double)this.bmpScanLineSize / p);
        if (effectiveWidth == 0 || effectiveWidth < this.core.sizeX[0]) {
            effectiveWidth = this.core.sizeX[0];
        }
        byte[] buf = new byte[this.core.sizeY[0] * effectiveWidth * bytes * this.core.sizeC[0]];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        int bytes = FormatTools.getBytesPerPixel(this.core.pixelType[0]);
        double p = (double)this.bmpScanLineSize / (double)this.bmpBitsPerPixel;
        int effectiveWidth = (int)((double)this.bmpScanLineSize / p);
        if (effectiveWidth == 0 || effectiveWidth < this.core.sizeX[0]) {
            effectiveWidth = this.core.sizeX[0];
        }
        if (buf.length < this.core.sizeY[0] * effectiveWidth * bytes * this.core.sizeC[0]) {
            throw new FormatException("Buffer too small.");
        }
        long fileOff = (Long)this.offsets.get(no);
        this.in.seek(fileOff);
        if (this.isRLE) {
            byte[] b = new byte[(int)((Long)this.lengths.get(no)).longValue()];
            this.in.read(b);
            Object[] options = new Object[2];
            options[1] = this.lastImage;
            options[0] = new int[]{this.core.sizeX[0], this.core.sizeY[0]};
            MSRLECodec codec = new MSRLECodec();
            b = codec.decompress(b, (Object)options);
            this.lastImage = b;
            if (no == this.core.imageCount[0] - 1) {
                this.lastImage = null;
            }
            byte[] colors = new byte[b.length * 3];
            int i = 0;
            while (i < b.length) {
                int ndx = b[i];
                if (ndx < 0) {
                    ndx += 256;
                }
                colors[i * 3] = this.pr[ndx];
                colors[i * 3 + 1] = this.pg[ndx];
                colors[i * 3 + 2] = this.pb[ndx];
                ++i;
            }
            return colors;
        }
        if (this.bmpBitsPerPixel < 8) {
            int rawSize = bytes * this.core.sizeY[0] * effectiveWidth * this.core.sizeC[0];
            byte[] b = new byte[rawSize /= 8 / this.bmpBitsPerPixel];
            int len = rawSize / this.core.sizeY[0];
            int y = 0;
            while (y < this.core.sizeY[0]) {
                this.in.read(b, (this.core.sizeY[0] - y - 1) * len, len);
                ++y;
            }
            BitBuffer bb = new BitBuffer(b);
            int i = 0;
            while (i < buf.length) {
                buf[i] = (byte)bb.getBits(this.bmpBitsPerPixel);
                ++i;
            }
            return buf;
        }
        int pad = this.bmpScanLineSize - this.core.sizeX[0] * (this.bmpBitsPerPixel / 8);
        int scanline = this.core.sizeX[0] * (this.bmpBitsPerPixel / 8);
        int i = this.core.sizeY[0] - 1;
        while (i >= 0) {
            this.in.read(buf, i * scanline, scanline);
            if (this.bmpBitsPerPixel == 24) {
                int j = 0;
                while (j < this.core.sizeX[0]) {
                    byte r = buf[i * scanline + j * 3 + 2];
                    buf[i * scanline + j * 3 + 2] = buf[i * scanline + j * 3];
                    buf[i * scanline + j * 3] = r;
                    ++j;
                }
            }
            this.in.skipBytes(pad * (this.bmpBitsPerPixel / 8));
            --i;
        }
        if (this.bmpBitsPerPixel == 16) {
            byte[] r = new byte[this.core.sizeX[0] * this.core.sizeY[0] * 2];
            System.arraycopy(buf, 2 * (buf.length / 3), r, 0, r.length);
            System.arraycopy(buf, 0, buf, 2 * (buf.length / 3), r.length);
            System.arraycopy(r, 0, buf, 0, r.length);
        }
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], this.core.sizeC[0], !this.core.interleaved[0], FormatTools.getBytesPerPixel(this.core.pixelType[0]), this.core.littleEndian[0]);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("AVIReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.in.order(true);
        this.status("Verifying AVI format");
        this.offsets = new Vector();
        this.lengths = new Vector();
        byte[] list = new byte[4];
        this.type = this.readStringBytes();
        this.size = this.in.readInt();
        this.fcc = this.readStringBytes();
        if (this.type.equals("RIFF")) {
            if (!this.fcc.equals("AVI ")) {
                this.whine("Sorry, AVI RIFF format not found.");
            }
        } else {
            this.whine("Not an AVI file");
        }
        long spos = this.pos = this.in.getFilePointer();
        this.status("Searching for image data");
        while (this.in.length() - this.in.getFilePointer() > 4L) {
            this.in.read(list);
            this.in.seek(this.pos);
            String listString = new String(list);
            if (listString.equals(" JUN")) {
                this.in.skipBytes(1);
                ++this.pos;
            }
            if (listString.equals("JUNK")) {
                this.type = this.readStringBytes();
                this.size = this.in.readInt();
                if (this.type.equals("JUNK")) {
                    this.in.skipBytes(this.size);
                }
            } else if (listString.equals("LIST")) {
                spos = this.in.getFilePointer();
                this.type = this.readStringBytes();
                this.size = this.in.readInt();
                this.fcc = this.readStringBytes();
                this.in.seek(spos);
                if (this.fcc.equals("hdrl")) {
                    this.type = this.readStringBytes();
                    this.size = this.in.readInt();
                    this.fcc = this.readStringBytes();
                    if (this.type.equals("LIST") && this.fcc.equals("hdrl")) {
                        this.type = this.readStringBytes();
                        this.size = this.in.readInt();
                        if (this.type.equals("avih")) {
                            spos = this.in.getFilePointer();
                            this.addMeta("Microseconds per frame", new Integer(this.in.readInt()));
                            this.addMeta("Max. bytes per second", new Integer(this.in.readInt()));
                            this.in.skipBytes(8);
                            this.addMeta("Total frames", new Integer(this.in.readInt()));
                            this.addMeta("Initial frames", new Integer(this.in.readInt()));
                            this.in.skipBytes(8);
                            this.core.sizeX[0] = this.in.readInt();
                            this.addMeta("Frame height", new Integer(this.in.readInt()));
                            this.addMeta("Scale factor", new Integer(this.in.readInt()));
                            this.addMeta("Frame rate", new Integer(this.in.readInt()));
                            this.addMeta("Start time", new Integer(this.in.readInt()));
                            this.addMeta("Length", new Integer(this.in.readInt()));
                            this.addMeta("Frame width", new Integer(this.core.sizeX[0]));
                            if (spos + (long)this.size <= this.in.length()) {
                                this.in.seek(spos + (long)this.size);
                            }
                        }
                    }
                } else if (this.fcc.equals("strl")) {
                    long startPos = this.in.getFilePointer();
                    long streamSize = this.size;
                    this.type = this.readStringBytes();
                    this.size = this.in.readInt();
                    this.fcc = this.readStringBytes();
                    if (this.type.equals("LIST")) {
                        if (this.fcc.equals("strl")) {
                            this.type = this.readStringBytes();
                            this.size = this.in.readInt();
                            if (this.type.equals("strh")) {
                                spos = this.in.getFilePointer();
                                this.readStringBytes();
                                this.in.skipBytes(36);
                                this.addMeta("Stream quality", new Integer(this.in.readInt()));
                                this.addMeta("Stream sample size", new Integer(this.in.readInt()));
                                if (spos + (long)this.size <= this.in.length()) {
                                    this.in.seek(spos + (long)this.size);
                                }
                            }
                            this.type = this.readStringBytes();
                            this.size = this.in.readInt();
                            if (this.type.equals("strf")) {
                                spos = this.in.getFilePointer();
                                this.in.skipBytes(4);
                                this.bmpWidth = this.in.readInt();
                                this.core.sizeY[0] = this.in.readInt();
                                this.in.skipBytes(2);
                                this.bmpBitsPerPixel = this.in.readShort();
                                this.bmpCompression = this.in.readInt();
                                this.in.skipBytes(4);
                                this.addMeta("Horizontal resolution", new Integer(this.in.readInt()));
                                this.addMeta("Vertical resolution", new Integer(this.in.readInt()));
                                this.bmpColorsUsed = this.in.readInt();
                                this.in.skipBytes(4);
                                this.addMeta("Bitmap compression value", new Integer(this.bmpCompression));
                                this.addMeta("Number of colors used", new Integer(this.bmpColorsUsed));
                                this.addMeta("Bits per pixel", new Integer(this.bmpBitsPerPixel));
                                int npad = this.bmpWidth % 4;
                                if (npad > 0) {
                                    npad = 4 - npad;
                                }
                                this.bmpScanLineSize = (this.bmpWidth + npad) * (this.bmpBitsPerPixel / 8);
                                this.bmpActualColorsUsed = this.bmpColorsUsed != 0 ? this.bmpColorsUsed : (this.bmpBitsPerPixel < 16 ? 1 << this.bmpBitsPerPixel : 0);
                                if (this.bmpCompression == 1) {
                                    this.isRLE = true;
                                } else if (this.bmpCompression != 0) {
                                    this.whine("Sorry, compressed AVI files not supported.");
                                }
                                if (this.bmpBitsPerPixel != 4 && this.bmpBitsPerPixel != 8 && this.bmpBitsPerPixel != 24 && this.bmpBitsPerPixel != 16 && this.bmpBitsPerPixel != 32) {
                                    this.whine("Sorry, " + this.bmpBitsPerPixel + " bits per pixel not " + "supported");
                                }
                                if (this.bmpActualColorsUsed != 0) {
                                    this.pr = new byte[this.bmpColorsUsed];
                                    this.pg = new byte[this.bmpColorsUsed];
                                    this.pb = new byte[this.bmpColorsUsed];
                                    int i = 0;
                                    while (i < this.bmpColorsUsed) {
                                        this.pb[i] = (byte)(this.in.read() & 0xFF);
                                        this.pg[i] = (byte)(this.in.read() & 0xFF);
                                        this.pr[i] = (byte)(this.in.read() & 0xFF);
                                        this.in.read();
                                        ++i;
                                    }
                                }
                                this.in.seek(spos + (long)this.size);
                            }
                        }
                        spos = this.in.getFilePointer();
                        this.type = this.readStringBytes();
                        this.size = this.in.readInt();
                        if (this.type.equals("strd")) {
                            this.in.skipBytes(this.size);
                        } else {
                            this.in.seek(spos);
                        }
                        spos = this.in.getFilePointer();
                        this.type = this.readStringBytes();
                        this.size = this.in.readInt();
                        if (this.type.equals("strn")) {
                            this.in.skipBytes(this.size);
                        } else {
                            this.in.seek(spos);
                        }
                    }
                    if (startPos + streamSize + 8L <= this.in.length()) {
                        this.in.seek(startPos + 8L + streamSize);
                    }
                } else if (this.fcc.equals("movi")) {
                    this.type = this.readStringBytes();
                    this.size = this.in.readInt();
                    this.fcc = this.readStringBytes();
                    if (this.type.equals("LIST") && this.fcc.equals("movi")) {
                        spos = this.in.getFilePointer();
                        if (spos >= this.in.length() - 12L) break;
                        this.type = this.readStringBytes();
                        this.size = this.in.readInt();
                        this.fcc = this.readStringBytes();
                        if (!this.type.equals("LIST") || !this.fcc.equals("rec ")) {
                            this.in.seek(spos);
                        }
                        spos = this.in.getFilePointer();
                        this.type = this.readStringBytes();
                        this.size = this.in.readInt();
                        while (this.type.substring(2).equals("db") || this.type.substring(2).equals("dc") || this.type.substring(2).equals("wb")) {
                            if (this.type.substring(2).equals("db") || this.type.substring(2).equals("dc")) {
                                this.offsets.add(new Long(this.in.getFilePointer()));
                                this.lengths.add(new Long(this.size));
                                this.in.skipBytes(this.size);
                            }
                            spos = this.in.getFilePointer();
                            this.type = this.readStringBytes();
                            this.size = this.in.readInt();
                            if (!this.type.equals("JUNK")) continue;
                            this.in.skipBytes(this.size);
                            spos = this.in.getFilePointer();
                            this.type = this.readStringBytes();
                            this.size = this.in.readInt();
                        }
                        this.in.seek(spos);
                    }
                } else {
                    try {
                        this.in.skipBytes(8 + this.size);
                    }
                    catch (IllegalArgumentException startPos) {}
                }
            } else {
                this.type = this.readStringBytes();
                if (this.in.getFilePointer() + (long)this.size + 4L <= this.in.length()) {
                    this.size = this.in.readInt();
                    this.in.skipBytes(this.size);
                }
            }
            this.pos = this.in.getFilePointer();
        }
        this.status("Populating metadata");
        this.core.imageCount[0] = this.offsets.size();
        this.core.rgb[0] = this.bmpBitsPerPixel > 8 || this.isRLE;
        this.core.sizeZ[0] = 1;
        this.core.sizeC[0] = this.core.rgb[0] ? 3 : 1;
        this.core.sizeT[0] = this.core.imageCount[0];
        this.core.currentOrder[0] = this.core.sizeC[0] == 3 ? "XYCTZ" : "XYTCZ";
        this.core.littleEndian[0] = true;
        boolean bl = this.core.interleaved[0] = this.bmpBitsPerPixel == 16;
        if (this.bmpBitsPerPixel <= 8) {
            this.core.pixelType[0] = 1;
        } else if (this.bmpBitsPerPixel == 16) {
            this.core.pixelType[0] = 3;
        } else if (this.bmpBitsPerPixel == 32) {
            this.core.pixelType[0] = 5;
        } else if (this.bmpBitsPerPixel == 24) {
            this.core.pixelType[0] = 1;
        } else {
            throw new FormatException("Unknown matching for pixel bit width of: " + this.bmpBitsPerPixel);
        }
        MetadataStore store = this.getMetadataStore();
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(!this.core.littleEndian[0]), this.core.currentOrder[0], null, null);
        int i = 0;
        while (i < this.core.sizeC[0]) {
            store.setLogicalChannel(i, null, null, null, null, this.core.sizeC[0] == 1 ? "monochrome" : "RGB", null, null);
            ++i;
        }
    }
}

