/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ProgressMonitor;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import loci.formats.ChannelMerger;
import loci.formats.FileStitcher;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.ImageWriter;
import loci.formats.Location;
import loci.formats.LogTools;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;
import loci.formats.gui.GUITools;

public class ImageViewer
extends JFrame
implements ActionListener,
ChangeListener,
MouseMotionListener {
    protected static final String TITLE = "Bio-Formats Viewer";
    protected static final GraphicsConfiguration GC = ImageTools.getDefaultConfiguration();
    protected JPanel pane;
    protected ImageIcon icon;
    protected JLabel iconLabel;
    protected JPanel sliderPanel;
    protected JSlider nSlider;
    protected JSlider zSlider;
    protected JSlider tSlider;
    protected JSlider cSlider;
    protected JLabel probeLabel;
    protected JMenuItem fileSave;
    protected IFormatReader myReader;
    protected ImageWriter myWriter;
    protected String filename;
    protected IFormatReader in;
    protected BufferedImage[] images;
    protected int sizeZ;
    protected int sizeT;
    protected int sizeC;
    protected StringBuffer sb = new StringBuffer();

    public ImageViewer() {
        super(TITLE);
        this.setDefaultCloseOperation(2);
        this.pane = new JPanel();
        this.pane.setLayout(new BorderLayout());
        this.setContentPane(this.pane);
        this.setSize(350, 350);
        this.sliderPanel = new JPanel();
        this.sliderPanel.setVisible(false);
        this.sliderPanel.setBorder(new EmptyBorder(5, 3, 5, 3));
        this.sliderPanel.setLayout(new BoxLayout(this.sliderPanel, 1));
        this.pane.add("South", this.sliderPanel);
        JPanel nPanel = new JPanel();
        nPanel.setLayout(new BoxLayout(nPanel, 0));
        this.sliderPanel.add(nPanel);
        this.sliderPanel.add(Box.createVerticalStrut(2));
        this.nSlider = new JSlider(1, 1);
        this.nSlider.setEnabled(false);
        this.nSlider.addChangeListener(this);
        nPanel.add(new JLabel("N"));
        nPanel.add(Box.createHorizontalStrut(3));
        nPanel.add(this.nSlider);
        JPanel ztcPanel = new JPanel();
        ztcPanel.setLayout(new BoxLayout(ztcPanel, 0));
        this.sliderPanel.add(ztcPanel);
        this.zSlider = new JSlider(1, 1);
        Dimension dim = this.zSlider.getPreferredSize();
        dim.width = 50;
        this.zSlider.setPreferredSize(dim);
        this.zSlider.setEnabled(false);
        this.zSlider.addChangeListener(this);
        ztcPanel.add(new JLabel("Z"));
        ztcPanel.add(Box.createHorizontalStrut(3));
        ztcPanel.add(this.zSlider);
        ztcPanel.add(Box.createHorizontalStrut(7));
        this.tSlider = new JSlider(1, 1);
        this.tSlider.setPreferredSize(dim);
        this.tSlider.setEnabled(false);
        this.tSlider.addChangeListener(this);
        ztcPanel.add(new JLabel("T"));
        ztcPanel.add(Box.createHorizontalStrut(3));
        ztcPanel.add(this.tSlider);
        ztcPanel.add(Box.createHorizontalStrut(7));
        this.cSlider = new JSlider(1, 1);
        this.cSlider.setPreferredSize(dim);
        this.cSlider.setEnabled(false);
        this.cSlider.addChangeListener(this);
        ztcPanel.add(new JLabel("C"));
        ztcPanel.add(Box.createHorizontalStrut(3));
        ztcPanel.add(this.cSlider);
        ztcPanel.add(Box.createHorizontalStrut(7));
        BufferedImage dummy = ImageTools.makeImage(new byte[1][1], 1, 1);
        this.icon = new ImageIcon(dummy);
        this.iconLabel = new JLabel(this.icon, 2);
        this.iconLabel.setVerticalAlignment(1);
        this.pane.add(new JScrollPane(this.iconLabel));
        this.probeLabel = new JLabel(" ");
        this.probeLabel.setHorizontalAlignment(0);
        this.probeLabel.setBorder(new BevelBorder(0));
        this.pane.add("North", this.probeLabel);
        this.iconLabel.addMouseMotionListener(this);
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        JMenu file = new JMenu("File");
        file.setMnemonic('f');
        menubar.add(file);
        JMenuItem fileOpen = new JMenuItem("Open...");
        fileOpen.setMnemonic('o');
        fileOpen.setActionCommand("open");
        fileOpen.addActionListener(this);
        file.add(fileOpen);
        this.fileSave = new JMenuItem("Save...");
        this.fileSave.setMnemonic('s');
        this.fileSave.setEnabled(false);
        this.fileSave.setActionCommand("save");
        this.fileSave.addActionListener(this);
        file.add(this.fileSave);
        boolean canDoNotes = false;
        try {
            Class<?> c = Class.forName("loci.ome.notes.Notes");
            if (c != null) {
                canDoNotes = true;
            }
        }
        catch (Throwable c) {
            // empty catch block
        }
        if (canDoNotes) {
            JMenuItem fileView = new JMenuItem("View Metadata...");
            fileView.setMnemonic('m');
            fileView.setEnabled(true);
            fileView.setActionCommand("view");
            fileView.addActionListener(this);
            file.add(fileView);
        }
        JMenuItem fileExit = new JMenuItem("Exit");
        fileExit.setMnemonic('x');
        fileExit.setActionCommand("exit");
        fileExit.addActionListener(this);
        file.add(fileExit);
        JMenu help = new JMenu("Help");
        help.setMnemonic('h');
        menubar.add(help);
        JMenuItem helpAbout = new JMenuItem("About...");
        helpAbout.setMnemonic('a');
        helpAbout.setActionCommand("about");
        helpAbout.addActionListener(this);
        help.add(helpAbout);
        this.myReader = new ChannelMerger(new FileStitcher());
        this.myWriter = new ImageWriter();
    }

    public void open(String id) {
        this.wait(true);
        try {
            Location f = new Location(id);
            id = f.getAbsolutePath();
            this.myReader.setId(id);
            int num = this.myReader.getImageCount();
            ProgressMonitor progress = new ProgressMonitor(this, "Reading " + id, null, 0, num + 1);
            this.sizeZ = this.myReader.getSizeZ();
            this.sizeT = this.myReader.getSizeT();
            this.sizeC = this.myReader.getEffectiveSizeC();
            progress.setProgress(1);
            BufferedImage[] img = new BufferedImage[num];
            int i = 0;
            while (i < num) {
                if (progress.isCanceled()) break;
                img[i] = this.myReader.openImage(i);
                if (i == 0) {
                    this.setImages(this.myReader, img);
                }
                progress.setProgress(i + 2);
                ++i;
            }
            this.myReader.close(true);
        }
        catch (Exception exc) {
            LogTools.trace(exc);
            this.wait(false);
            return;
        }
        this.wait(false);
    }

    public void save(String id) {
        if (this.images == null) {
            return;
        }
        this.wait(true);
        try {
            this.myWriter.setId(id);
            boolean stack = this.myWriter.canDoStacks();
            ProgressMonitor progress = new ProgressMonitor(this, "Saving " + id, null, 0, stack ? this.images.length : 1);
            if (stack) {
                int i = 0;
                while (i < this.images.length) {
                    progress.setProgress(i);
                    boolean canceled = progress.isCanceled();
                    this.myWriter.saveImage(this.images[i], i == this.images.length - 1 || canceled);
                    if (canceled) break;
                    ++i;
                }
                progress.setProgress(this.images.length);
            } else {
                this.myWriter.saveImage(this.getImage(), true);
                progress.setProgress(1);
            }
        }
        catch (Exception exc) {
            LogTools.trace(exc);
        }
        this.wait(false);
    }

    public void setImages(IFormatReader reader, BufferedImage[] img) {
        String format;
        this.filename = reader.getCurrentFile();
        this.in = reader;
        this.images = img;
        try {
            this.sizeZ = reader.getSizeZ();
            this.sizeT = reader.getSizeT();
            this.sizeC = reader.getEffectiveSizeC();
        }
        catch (Exception exc) {
            LogTools.trace(exc);
        }
        this.fileSave.setEnabled(true);
        this.nSlider.removeChangeListener(this);
        this.zSlider.removeChangeListener(this);
        this.tSlider.removeChangeListener(this);
        this.cSlider.removeChangeListener(this);
        this.nSlider.setValue(1);
        this.nSlider.setMaximum(this.images.length);
        this.nSlider.setEnabled(this.images.length > 1);
        this.zSlider.setValue(1);
        this.zSlider.setMaximum(this.sizeZ);
        this.zSlider.setEnabled(this.sizeZ > 1);
        this.tSlider.setValue(1);
        this.tSlider.setMaximum(this.sizeT);
        this.tSlider.setEnabled(this.sizeT > 1);
        this.cSlider.setValue(1);
        this.cSlider.setMaximum(this.sizeC);
        this.cSlider.setEnabled(this.sizeC > 1);
        this.nSlider.addChangeListener(this);
        this.zSlider.addChangeListener(this);
        this.tSlider.addChangeListener(this);
        this.cSlider.addChangeListener(this);
        this.sliderPanel.setVisible(this.images.length > 1);
        this.updateLabel(-1, -1);
        this.sb.setLength(0);
        if (this.filename != null) {
            this.sb.append(reader.getCurrentFile());
            this.sb.append(" ");
        }
        if ((format = reader.getFormat()) != null) {
            this.sb.append("(");
            this.sb.append(format);
            this.sb.append(")");
            this.sb.append(" ");
        }
        if (this.filename != null || format != null) {
            this.sb.append("- ");
        }
        this.sb.append(TITLE);
        this.setTitle(this.sb.toString());
        this.icon.setImage(this.images == null ? null : this.images[0]);
        this.pack();
    }

    public BufferedImage getImage() {
        int ndx = this.getImageIndex();
        return this.images == null || ndx >= this.images.length ? null : this.images[ndx];
    }

    public int getImageIndex() {
        return this.nSlider.getValue() - 1;
    }

    public int getZ() {
        return this.zSlider.getValue() - 1;
    }

    public int getT() {
        return this.tSlider.getValue() - 1;
    }

    public int getC() {
        return this.cSlider.getValue() - 1;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("open".equals(cmd)) {
            File file;
            this.wait(true);
            JFileChooser chooser = GUITools.buildFileChooser(this.myReader);
            this.wait(false);
            int rval = chooser.showOpenDialog(this);
            if (rval == 0 && (file = chooser.getSelectedFile()) != null) {
                new Thread("ImageViewer-Opener"){

                    public void run() {
                        ImageViewer.this.open(file.getAbsolutePath());
                    }
                }.start();
            }
        } else if ("save".equals(cmd)) {
            File file;
            this.wait(true);
            JFileChooser chooser = GUITools.buildFileChooser(this.myWriter);
            this.wait(false);
            int rval = chooser.showSaveDialog(this);
            if (rval == 0 && (file = chooser.getSelectedFile()) != null) {
                new Thread("ImageViewer-Saver"){

                    public void run() {
                        ImageViewer.this.save(file.getPath());
                    }
                }.start();
            }
        } else if ("view".equals(cmd)) {
            ReflectedUniverse r = new ReflectedUniverse();
            try {
                r.exec("import loci.ome.notes.Notes");
                r.setVar("filename", this.filename);
                r.exec("new Notes(null, filename)");
            }
            catch (ReflectException exc) {
                LogTools.trace(exc);
            }
        } else if ("exit".equals(cmd)) {
            this.dispose();
        } else if ("about".equals(cmd)) {
            this.setDefaultCloseOperation(3);
            JOptionPane.showMessageDialog(this, "LOCI Bio-Formats\nBuilt @date@\n\nThe Bio-Formats library is LOCI software written by\nMelissa Linkert, Curtis Rueden, Chris Allan, Eric Kjellman\nand Brian Loranger.\nhttp://www.loci.wisc.edu/ome/formats.html", "Bio-Formats", 1);
        }
    }

    public void stateChanged(ChangeEvent e) {
        int ndx;
        Object src = e.getSource();
        if (src == this.nSlider) {
            ndx = this.getImageIndex();
            int[] zct = new int[]{-1, -1, -1};
            try {
                zct = this.in.getZCTCoords(ndx);
            }
            catch (Exception exc) {
                LogTools.trace(exc);
            }
            if (zct[0] >= 0) {
                this.zSlider.removeChangeListener(this);
                this.zSlider.setValue(zct[0] + 1);
                this.zSlider.addChangeListener(this);
            }
            if (zct[1] >= 0) {
                this.cSlider.removeChangeListener(this);
                this.cSlider.setValue(zct[1] + 1);
                this.cSlider.addChangeListener(this);
            }
            if (zct[2] >= 0) {
                this.tSlider.removeChangeListener(this);
                this.tSlider.setValue(zct[2] + 1);
                this.tSlider.addChangeListener(this);
            }
        } else {
            ndx = -1;
            try {
                ndx = this.in.getIndex(this.getZ(), this.getC(), this.getT());
            }
            catch (Exception exc) {
                LogTools.trace(exc);
            }
            if (ndx >= 0) {
                this.nSlider.removeChangeListener(this);
                this.nSlider.setValue(ndx + 1);
                this.nSlider.addChangeListener(this);
            }
        }
        this.updateLabel(-1, -1);
        BufferedImage image = this.getImage();
        if (image != null) {
            this.icon.setImage(this.getImage());
        }
        this.iconLabel.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.updateLabel(e.getX(), e.getY());
    }

    public void mouseMoved(MouseEvent e) {
        this.updateLabel(e.getX(), e.getY());
    }

    protected void updateLabel(int x, int y) {
        int h;
        BufferedImage image;
        if (this.images == null) {
            return;
        }
        int ndx = this.getImageIndex();
        this.sb.setLength(0);
        if (this.images.length > 1) {
            this.sb.append("N=");
            this.sb.append(ndx + 1);
            this.sb.append("/");
            this.sb.append(this.images.length);
        }
        if (this.sizeZ > 1) {
            this.sb.append("; Z=");
            this.sb.append(this.getZ() + 1);
            this.sb.append("/");
            this.sb.append(this.sizeZ);
        }
        if (this.sizeT > 1) {
            this.sb.append("; T=");
            this.sb.append(this.getT() + 1);
            this.sb.append("/");
            this.sb.append(this.sizeT);
        }
        if (this.sizeC > 1) {
            this.sb.append("; C=");
            this.sb.append(this.getC() + 1);
            this.sb.append("/");
            this.sb.append(this.sizeC);
        }
        int w = (image = this.images[ndx]) == null ? -1 : image.getWidth();
        int n = h = image == null ? -1 : image.getHeight();
        if (x >= w) {
            x = w - 1;
        }
        if (y >= h) {
            y = h - 1;
        }
        if (x >= 0 && y >= 0) {
            if (this.images.length > 1) {
                this.sb.append("; ");
            }
            this.sb.append("X=");
            this.sb.append(x);
            if (w > 0) {
                this.sb.append("/");
                this.sb.append(w);
            }
            this.sb.append("; Y=");
            this.sb.append(y);
            if (h > 0) {
                this.sb.append("/");
                this.sb.append(h);
            }
            if (image != null) {
                WritableRaster r = image.getRaster();
                double[] pix = r.getPixel(x, y, (double[])null);
                this.sb.append("; value");
                this.sb.append(pix.length > 1 ? "s=(" : "=");
                int i = 0;
                while (i < pix.length) {
                    if (i > 0) {
                        this.sb.append(", ");
                    }
                    this.sb.append(pix[i]);
                    ++i;
                }
                if (pix.length > 1) {
                    this.sb.append(")");
                }
                this.sb.append("; type=");
                int pixelType = ImageTools.getPixelType(image);
                this.sb.append(FormatTools.getPixelTypeString(pixelType));
            }
        }
        this.sb.append(" ");
        this.probeLabel.setText(this.sb.toString());
    }

    protected void wait(boolean wait) {
        this.setCursor(wait ? Cursor.getPredefinedCursor(3) : null);
    }

    public static void main(String[] args) {
        ImageViewer viewer = new ImageViewer();
        viewer.setVisible(true);
        if (args.length > 0) {
            viewer.open(args[0]);
        }
    }
}

