/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import loci.formats.FileStitcher;
import loci.formats.IFormatHandler;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.ReaderWrapper;
import loci.formats.gui.ComboFileFilter;
import loci.formats.gui.ExtensionFileFilter;
import loci.formats.gui.FormatFileFilter;
import loci.formats.gui.PreviewPane;

public final class GUITools {
    private GUITools() {
    }

    public static FileFilter[] buildFileFilters(IFormatHandler handler) {
        FileFilter[] ff = null;
        while (true) {
            if (handler instanceof ReaderWrapper) {
                handler = ((ReaderWrapper)handler).getReader();
                continue;
            }
            if (!(handler instanceof FileStitcher)) break;
            handler = ((FileStitcher)handler).getReader();
        }
        if (handler instanceof ImageReader) {
            IFormatReader[] readers = ((ImageReader)handler).getReaders();
            Vector<FormatFileFilter> v = new Vector<FormatFileFilter>();
            int i = 0;
            while (i < readers.length) {
                v.add(new FormatFileFilter(readers[i], false));
                ++i;
            }
            ff = ComboFileFilter.sortFilters(v);
        } else if (handler instanceof ImageWriter) {
            IFormatWriter[] writers = ((ImageWriter)handler).getWriters();
            Vector<ExtensionFileFilter> v = new Vector<ExtensionFileFilter>();
            int i = 0;
            while (i < writers.length) {
                String[] suffixes = writers[i].getSuffixes();
                String format = writers[i].getFormat();
                v.add(new ExtensionFileFilter(suffixes, format));
                ++i;
            }
            ff = ComboFileFilter.sortFilters(v);
        } else if (handler instanceof IFormatReader) {
            IFormatReader reader = (IFormatReader)handler;
            ff = new FileFilter[]{new FormatFileFilter(reader)};
        } else {
            String[] suffixes = handler.getSuffixes();
            String format = handler.getFormat();
            ff = new FileFilter[]{new ExtensionFileFilter(suffixes, format)};
        }
        return ff;
    }

    public static JFileChooser buildFileChooser(IFormatHandler handler) {
        return GUITools.buildFileChooser(handler, true);
    }

    public static JFileChooser buildFileChooser(IFormatHandler handler, boolean preview) {
        return GUITools.buildFileChooser(GUITools.buildFileFilters(handler), preview);
    }

    public static JFileChooser buildFileChooser(FileFilter[] filters) {
        return GUITools.buildFileChooser(filters, true);
    }

    public static JFileChooser buildFileChooser(final FileFilter[] filters, final boolean preview) {
        final JFileChooser[] jfc = new JFileChooser[1];
        Runnable r = new Runnable(){

            public void run() {
                JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
                FileFilter[] ff = ComboFileFilter.sortFilters(filters);
                ComboFileFilter combo = null;
                if (ff.length > 1) {
                    combo = new ComboFileFilter(ff, "All supported file types");
                    fc.addChoosableFileFilter(combo);
                }
                int i = 0;
                while (i < ff.length) {
                    fc.addChoosableFileFilter(ff[i]);
                    ++i;
                }
                if (combo != null) {
                    fc.setFileFilter(combo);
                }
                if (preview) {
                    new PreviewPane(fc);
                }
                jfc[0] = fc;
            }
        };
        if (Thread.currentThread().getName().startsWith("AWT-EventQueue")) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException exc) {
                return null;
            }
            catch (InvocationTargetException exc) {
                return null;
            }
        }
        return jfc[0];
    }
}

