/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.ByteVector;
import loci.formats.codec.Codec;

public class PackbitsCodec
extends BaseCodec
implements Codec {
    public byte[] compress(byte[] data, int x, int y, int[] dims, Object options) throws FormatException {
        throw new FormatException("Packbits Compression not currently supported");
    }

    public byte[] decompress(byte[] input, Object options) throws FormatException {
        ByteVector output = new ByteVector(input.length);
        int pt = 0;
        while (pt < input.length) {
            int len;
            byte n;
            if ((n = input[pt++]) >= 0) {
                len = pt + n + 1 > input.length ? input.length - pt : n + 1;
                output.add(input, pt, len);
                pt += len;
                continue;
            }
            if (n == -128) continue;
            if (pt >= input.length) break;
            len = -n + 1;
            byte inp = input[pt++];
            int i = 0;
            while (i < len) {
                output.add(inp);
                ++i;
            }
        }
        return output.toByteArray();
    }
}

