/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.BitBuffer;
import loci.formats.codec.BitWriter;
import loci.formats.codec.Codec;

public class NikonCodec
extends BaseCodec
implements Codec {
    private static final int[] NIKON_TREE;

    static {
        int[] nArray = new int[29];
        nArray[1] = 1;
        nArray[2] = 5;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 2;
        nArray[16] = 5;
        nArray[17] = 4;
        nArray[18] = 3;
        nArray[19] = 6;
        nArray[20] = 2;
        nArray[21] = 7;
        nArray[22] = 1;
        nArray[24] = 8;
        nArray[25] = 9;
        nArray[26] = 11;
        nArray[27] = 10;
        nArray[28] = 12;
        NIKON_TREE = nArray;
    }

    public byte[] compress(byte[] data, int x, int y, int[] dims, Object options) throws FormatException {
        throw new FormatException("Nikon Compression not currently supported");
    }

    public byte[] decompress(byte[] input, Object options) throws FormatException {
        BitWriter out = new BitWriter(input.length);
        BitBuffer bb = new BitBuffer(input);
        boolean eof = false;
        while (!eof) {
            boolean codeFound = false;
            int code = 0;
            int bitsRead = 0;
            block1: while (!codeFound) {
                int bit = bb.getBits(1);
                if (bit == -1) {
                    eof = true;
                    break;
                }
                ++bitsRead;
                code >>= 1;
                code += bit;
                int i = 16;
                while (i < NIKON_TREE.length) {
                    if (code == NIKON_TREE[i]) {
                        int ndx = i;
                        int count = 0;
                        while (ndx > 16) {
                            ndx -= NIKON_TREE[count];
                            ++count;
                        }
                        if (ndx < 16) {
                            --count;
                        }
                        if (bitsRead == count + 1) {
                            codeFound = true;
                            i = NIKON_TREE.length;
                            continue block1;
                        }
                    }
                    ++i;
                }
            }
            while (code > 0) {
                out.write(bb.getBits(1), 1);
                --code;
            }
        }
        byte[] b = out.toByteArray();
        return b;
    }
}

