/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.RandomAccessStream;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.ByteVector;
import loci.formats.codec.Codec;
import loci.formats.codec.JPEGCodec;

public class MJPBCodec
extends BaseCodec
implements Codec {
    private static final byte[] HEADER;

    static {
        byte[] byArray = new byte[16];
        byArray[0] = -1;
        byArray[1] = -40;
        byArray[3] = 16;
        byArray[4] = 74;
        byArray[5] = 70;
        byArray[6] = 73;
        byArray[7] = 70;
        byArray[9] = 1;
        byArray[10] = 1;
        byArray[12] = 72;
        byArray[13] = 72;
        HEADER = byArray;
    }

    public byte[] compress(byte[] data, int x, int y, int[] dims, Object options) throws FormatException {
        throw new FormatException("Motion JPEG-B compression not supported.");
    }

    public byte[] decompress(byte[] data, Object options) throws FormatException {
        if (options == null || !(options instanceof int[])) {
            return null;
        }
        int[] o = (int[])options;
        int x = o[0];
        int y = o[1];
        int bits = o[2];
        boolean interlaced = o[3] == 1;
        byte[] raw = null;
        byte[] raw2 = null;
        try {
            RandomAccessStream ras = new RandomAccessStream(data);
            ras.order(false);
            ras.skipBytes(20);
            byte[] lumDcBits = null;
            byte[] lumAcBits = null;
            byte[] lumDc = null;
            byte[] lumAc = null;
            byte[] quant = null;
            byte[] a = new byte[4];
            ras.read(a);
            String s1 = new String(a);
            ras.seek(ras.getFilePointer() - 20L);
            ras.read(a);
            String s2 = new String(a);
            ras.skipBytes(12);
            if (s1.equals("mjpg") || s2.equals("mjpg")) {
                short len;
                int extra = 16;
                if (s2.startsWith("m")) {
                    extra = 0;
                    ras.seek(4L);
                }
                ras.skipBytes(12);
                int offset = ras.readInt() + extra;
                int quantOffset = ras.readInt() + extra;
                int huffmanOffset = ras.readInt() + extra;
                int sof = ras.readInt() + extra;
                int sos = ras.readInt() + extra;
                int sod = ras.readInt() + extra;
                if (quantOffset != 0) {
                    ras.seek(quantOffset);
                    len = ras.readShort();
                    ras.skipBytes(1);
                    quant = new byte[len - 3];
                    ras.read(quant);
                }
                if (huffmanOffset != 0) {
                    ras.seek(huffmanOffset);
                    len = ras.readShort();
                    ras.skipBytes(1);
                    lumDcBits = new byte[16];
                    ras.read(lumDcBits);
                    lumDc = new byte[12];
                    ras.read(lumDc);
                    ras.skipBytes(1);
                    lumAcBits = new byte[16];
                    ras.read(lumAcBits);
                    lumAc = new byte[162];
                    ras.read(lumAc);
                }
                ras.seek(sof + 7);
                int channels = ras.read();
                int[] sampling = new int[channels];
                int i = 0;
                while (i < channels) {
                    ras.skipBytes(1);
                    sampling[i] = ras.read();
                    ras.skipBytes(1);
                    ++i;
                }
                ras.seek(sos + 3);
                int[] tables = new int[channels];
                int i2 = 0;
                while (i2 < channels) {
                    ras.skipBytes(1);
                    tables[i2] = ras.read();
                    ++i2;
                }
                ras.seek(sod);
                int numBytes = (int)((long)offset - ras.getFilePointer());
                if (offset == 0) {
                    numBytes = (int)(ras.length() - ras.getFilePointer());
                }
                raw = new byte[numBytes];
                ras.read(raw);
                if (offset != 0) {
                    ras.seek(offset + 36);
                    int n = ras.readInt();
                    ras.skipBytes(n);
                    ras.seek(ras.getFilePointer() - 40L);
                    numBytes = (int)(ras.length() - ras.getFilePointer());
                    raw2 = new byte[numBytes];
                    ras.read(raw2);
                }
            }
            if (raw == null) {
                raw = data;
            }
            ByteVector b = new ByteVector();
            int i = 0;
            while (i < raw.length) {
                b.add(raw[i]);
                if (raw[i] == -1) {
                    b.add((byte)0);
                }
                ++i;
            }
            if (raw2 == null) {
                raw2 = new byte[]{};
            }
            ByteVector b2 = new ByteVector();
            int i3 = 0;
            while (i3 < raw2.length) {
                b2.add(raw2[i3]);
                if (raw2[i3] == -1) {
                    b2.add((byte)0);
                }
                ++i3;
            }
            ByteVector v = new ByteVector(1000);
            v.add(HEADER);
            v.add(new byte[]{-1, -37});
            int length = 67;
            v.add((byte)(length >>> 8 & 0xFF));
            v.add((byte)(length & 0xFF));
            v.add((byte)0);
            v.add(quant);
            v.add(new byte[]{-1, -60});
            length = (lumDcBits.length + lumDc.length + lumAcBits.length + lumAc.length) * 2 + 6;
            v.add((byte)(length >>> 8 & 0xFF));
            v.add((byte)(length & 0xFF));
            v.add((byte)0);
            v.add(lumDcBits);
            v.add(lumDc);
            v.add((byte)1);
            v.add(lumDcBits);
            v.add(lumDc);
            v.add((byte)16);
            v.add(lumAcBits);
            v.add(lumAc);
            v.add((byte)17);
            v.add(lumAcBits);
            v.add(lumAc);
            v.add((byte)-1);
            v.add((byte)-64);
            length = bits >= 40 ? 11 : 17;
            v.add((byte)(length >>> 8 & 0xFF));
            v.add((byte)(length & 0xFF));
            int fieldHeight = y;
            if (interlaced) {
                fieldHeight /= 2;
            }
            if (y % 2 == 1) {
                ++fieldHeight;
            }
            int c = bits == 24 ? 3 : (bits == 32 ? 4 : 1);
            v.add(bits >= 40 ? (byte)(bits - 32) : (byte)(bits / c));
            v.add((byte)(fieldHeight >>> 8 & 0xFF));
            v.add((byte)(fieldHeight & 0xFF));
            v.add((byte)(x >>> 8 & 0xFF));
            v.add((byte)(x & 0xFF));
            v.add(bits >= 40 ? (byte)1 : 3);
            v.add((byte)1);
            v.add((byte)33);
            v.add((byte)0);
            if (bits < 40) {
                v.add((byte)2);
                v.add((byte)17);
                v.add((byte)1);
                v.add((byte)3);
                v.add((byte)17);
                v.add((byte)1);
            }
            v.add((byte)-1);
            v.add((byte)-38);
            length = bits >= 40 ? 8 : 12;
            v.add((byte)(length >>> 8 & 0xFF));
            v.add((byte)(length & 0xFF));
            v.add(bits >= 40 ? (byte)1 : 3);
            v.add((byte)1);
            v.add((byte)0);
            if (bits < 40) {
                v.add((byte)2);
                v.add((byte)1);
                v.add((byte)3);
                v.add((byte)1);
            }
            v.add((byte)0);
            v.add((byte)63);
            v.add((byte)0);
            if (interlaced) {
                ByteVector v2 = new ByteVector(v.size());
                v2.add(v.toByteArray());
                v.add(b.toByteArray());
                v.add((byte)-1);
                v.add((byte)-39);
                v2.add(b2.toByteArray());
                v2.add((byte)-1);
                v2.add((byte)-39);
                JPEGCodec jpeg = new JPEGCodec();
                byte[] top = jpeg.decompress(v.toByteArray());
                byte[] bottom = jpeg.decompress(v2.toByteArray());
                int bpp = bits < 40 ? bits / 8 : (bits - 32) / 8;
                int ch = bits < 40 ? 3 : 1;
                byte[] result = new byte[x * y * bpp * ch];
                int topNdx = 0;
                int bottomNdx = 0;
                int yy = 0;
                while (yy < y) {
                    if (yy % 2 == 0) {
                        System.arraycopy(top, topNdx * x * bpp, result, yy * x * bpp, x * bpp);
                        ++topNdx;
                    } else {
                        System.arraycopy(bottom, bottomNdx * x * bpp, result, yy * x * bpp, x * bpp);
                        ++bottomNdx;
                    }
                    ++yy;
                }
                return result;
            }
            v.add(b.toByteArray());
            v.add((byte)-1);
            v.add((byte)-39);
            return new JPEGCodec().decompress(v.toByteArray());
        }
        catch (IOException e) {
            throw new FormatException(e);
        }
    }
}

