/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.util.Random;
import loci.formats.LogTools;
import loci.formats.codec.BitBuffer;

public class BitWriter {
    private byte[] buf;
    private int index;
    private int bit;

    public BitWriter() {
        this(10);
    }

    public BitWriter(int size) {
        this.buf = new byte[size];
    }

    public void write(int value, int numBits) {
        byte[] bits = new byte[numBits];
        int i = 0;
        while (i < numBits) {
            bits[i] = (byte)(value & 1);
            value >>= 1;
            ++i;
        }
        i = numBits - 1;
        while (i >= 0) {
            int b = bits[i] << 7 - this.bit;
            int n = this.index++;
            this.buf[n] = (byte)(this.buf[n] | b);
            ++this.bit;
            if (this.bit > 7) {
                this.bit = 0;
                if (this.index >= this.buf.length) {
                    byte[] newBuf = new byte[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
                    this.buf = newBuf;
                }
            }
            --i;
        }
    }

    public void write(String bitString) {
        int i = 0;
        while (i < bitString.length()) {
            if ('1' == bitString.charAt(i)) {
                int b = 1 << 7 - this.bit;
                int n = this.index;
                this.buf[n] = (byte)(this.buf[n] | b);
            } else if ('0' != bitString.charAt(i)) {
                throw new IllegalArgumentException(String.valueOf(bitString.charAt(i)) + "found at character " + i + "; 0 or 1 expected. Write only partially completed.");
            }
            ++this.bit;
            if (this.bit > 7) {
                this.bit = 0;
                ++this.index;
                if (this.index >= this.buf.length) {
                    byte[] newBuf = new byte[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
                    this.buf = newBuf;
                }
            }
            ++i;
        }
    }

    public byte[] toByteArray() {
        int size = this.index;
        if (this.bit > 0) {
            ++size;
        }
        byte[] b = new byte[size];
        System.arraycopy(this.buf, 0, b, 0, size);
        return b;
    }

    public static void main(String[] args) {
        int max = 50000;
        LogTools.println("Generating random list of " + max + " values");
        int[] values = new int[max];
        int[] bits = new int[max];
        double log2 = Math.log(2.0);
        int i = 0;
        while (i < values.length) {
            values[i] = (int)(50000.0 * Math.random()) + 1;
            int minBits = (int)Math.ceil(Math.log(values[i] + 1) / log2);
            bits[i] = (int)(10.0 * Math.random()) + minBits;
            ++i;
        }
        LogTools.println("Writing values to byte array");
        BitWriter out = new BitWriter();
        int i2 = 0;
        while (i2 < values.length) {
            out.write(values[i2], bits[i2]);
            ++i2;
        }
        LogTools.println("Reading values from byte array");
        BitBuffer bb = new BitBuffer(out.toByteArray());
        int i3 = 0;
        while (i3 < values.length) {
            int value = bb.getBits(bits[i3]);
            if (value != values[i3]) {
                LogTools.println("Value #" + i3 + " does not match (got " + value + "; expected " + values[i3] + "; " + bits[i3] + " bits)");
            }
            ++i3;
        }
        Random r = new Random();
        LogTools.println("Generating 5000 random bits for String test");
        StringBuffer sb = new StringBuffer(5000);
        int i4 = 0;
        while (i4 < 5000) {
            sb.append(r.nextInt(2));
            ++i4;
        }
        out = new BitWriter();
        LogTools.println("Writing values to byte array");
        out.write(sb.toString());
        LogTools.println("Reading values from byte array");
        bb = new BitBuffer(out.toByteArray());
        i4 = 0;
        while (i4 < 5000) {
            int expected;
            int value = bb.getBits(1);
            int n = expected = sb.charAt(i4) == '1' ? 1 : 0;
            if (value != expected) {
                LogTools.println("Bit #" + i4 + " does not match (got " + value + "; expected " + expected + ".");
            }
            ++i4;
        }
    }
}

