/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.util.Random;
import loci.formats.FormatException;
import loci.formats.LogTools;
import loci.formats.codec.Codec;

public abstract class BaseCodec
implements Codec {
    public void test() throws FormatException {
        int i;
        byte[] testdata = new byte[50000];
        Random r = new Random();
        LogTools.println("Testing " + this.getClass().getName());
        LogTools.println("Generating random data");
        r.nextBytes(testdata);
        LogTools.println("Compressing data");
        byte[] compressed = this.compress(testdata, 0, 0, null, null);
        LogTools.println("Compressed size: " + compressed.length);
        LogTools.println("Decompressing data");
        byte[] decompressed = this.decompress(compressed);
        LogTools.print("Comparing data... ");
        if (testdata.length != decompressed.length) {
            LogTools.println("Test data differs in length from uncompressed data");
            LogTools.println("Exiting...");
            System.exit(-1);
        } else {
            boolean equalsFlag = true;
            i = 0;
            while (i < testdata.length) {
                if (testdata[i] != decompressed[i]) {
                    LogTools.println("Test data and uncompressed data differs at byte" + i);
                    equalsFlag = false;
                }
                ++i;
            }
            if (!equalsFlag) {
                LogTools.println("Comparison failed. \nExiting...");
                System.exit(-1);
            }
        }
        LogTools.println("Success.");
        LogTools.println("Generating 2D byte array test");
        byte[][] twoDtest = new byte[100][500];
        i = 0;
        while (i < 100) {
            System.arraycopy(testdata, 500 * i, twoDtest[i], 0, 500);
            ++i;
        }
        byte[] twoDcompressed = this.compress(twoDtest, 0, 0, null, null);
        LogTools.print("Comparing compressed data... ");
        if (twoDcompressed.length != compressed.length) {
            LogTools.println("1D and 2D compressed data not same length");
            LogTools.println("Exiting...");
            System.exit(-1);
        }
        boolean equalsFlag = true;
        int i2 = 0;
        while (i2 < twoDcompressed.length) {
            if (twoDcompressed[i2] != compressed[i2]) {
                LogTools.println("1D data and 2D compressed data differs at byte" + i2);
                equalsFlag = false;
            }
            if (!equalsFlag) {
                LogTools.println("Comparison failed. \nExiting...");
                System.exit(-1);
            }
            ++i2;
        }
        LogTools.println("Success.");
        LogTools.println("Test complete.");
    }

    public byte[] compress(byte[][] data, int x, int y, int[] dims, Object options) throws FormatException {
        int len = 0;
        int i = 0;
        while (i < data.length) {
            len += data[i].length;
            ++i;
        }
        byte[] toCompress = new byte[len];
        int curPos = 0;
        int i2 = 0;
        while (i2 < data.length) {
            System.arraycopy(data[i2], 0, toCompress, curPos, data[i2].length);
            curPos += data[i2].length;
            ++i2;
        }
        return this.compress(toCompress, x, y, dims, options);
    }

    public byte[] decompress(byte[] data) throws FormatException {
        return this.decompress(data, null);
    }

    public byte[] decompress(byte[][] data) throws FormatException {
        return this.decompress(data, null);
    }

    public byte[] decompress(byte[][] data, Object options) throws FormatException {
        int len = 0;
        int i = 0;
        while (i < data.length) {
            len += data[i].length;
            ++i;
        }
        byte[] toDecompress = new byte[len];
        int curPos = 0;
        int i2 = 0;
        while (i2 < data.length) {
            System.arraycopy(data[i2], 0, toDecompress, curPos, data[i2].length);
            curPos += data[i2].length;
            ++i2;
        }
        return this.decompress(toDecompress, options);
    }
}

