/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.cache;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.LogTools;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;
import loci.formats.cache.CacheException;
import loci.formats.cache.CacheSource;

public class ImageProcessorSource
extends CacheSource {
    private static final String NO_IJ_MSG = "ImageJ is required to use ImageProcessorSource. Please obtain ij.jar from http://rsb.info.nih.gov/ij/download.html";
    private static boolean noIJ = false;
    private static ReflectedUniverse r = ImageProcessorSource.createReflectedUniverse();

    private static ReflectedUniverse createReflectedUniverse() {
        r = null;
        try {
            r = new ReflectedUniverse();
            r.exec("import ij.process.ByteProcessor");
            r.exec("import ij.process.ColorProcessor");
            r.exec("import ij.process.FloatProcessor");
            r.exec("import ij.process.ImageProcessor");
            r.exec("import ij.process.ShortProcessor");
        }
        catch (Throwable t) {
            noIJ = true;
            LogTools.trace(t);
        }
        return r;
    }

    public ImageProcessorSource(IFormatReader r) {
        super(r);
    }

    public ImageProcessorSource(String id) throws CacheException {
        super(id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObject(int[] len, int[] pos) throws CacheException {
        if (noIJ) {
            throw new CacheException(NO_IJ_MSG);
        }
        int ndx = FormatTools.positionToRaster(len, pos);
        try {
            int w = this.reader.getSizeX();
            int h = this.reader.getSizeY();
            int c = this.reader.getRGBChannelCount();
            int type = this.reader.getPixelType();
            int bpp = FormatTools.getBytesPerPixel(type);
            byte[] b = this.reader.openBytes(ndx);
            if (b.length != w * h * c * bpp && b.length != w * h * bpp) {
                BufferedImage bi = this.reader.openImage(ndx);
                b = ImageTools.padImage(b, this.reader.isInterleaved(), c, bi.getWidth() * bpp, w, h);
            }
            Object pixels = DataTools.makeDataArray(b, bpp, type == 6 || type == 7, this.reader.isLittleEndian());
            r.setVar("ip", null);
            r.setVar("n", null);
            r.setVar("w", w);
            r.setVar("h", h);
            if (pixels instanceof byte[]) {
                byte[] q = (byte[])pixels;
                if (q.length > w * h * c) {
                    byte[] tmp = q;
                    q = new byte[w * h * c];
                    System.arraycopy(tmp, 0, q, 0, q.length);
                }
                r.setVar("q", q);
                if (c == 1) {
                    r.exec("ip = new ByteProcessor(w, h, q, n)");
                    return r.getVar("ip");
                } else {
                    r.exec("ip = new ColorProcessor(w, h)");
                    byte[][] pix = new byte[3][w * h];
                    int i = 0;
                    while (i < c) {
                        System.arraycopy(q, i * w * h, pix[i], 0, w * h);
                        ++i;
                    }
                    r.setVar("red", pix[0]);
                    r.setVar("green", pix[1]);
                    r.setVar("blue", pix[2]);
                    r.exec("ip.setRGB(red, green, blue)");
                }
                return r.getVar("ip");
            }
            if (pixels instanceof short[]) {
                short[] q = (short[])pixels;
                if (q.length > w * h * c) {
                    short[] tmp = q;
                    q = new short[w * h * c];
                    System.arraycopy(tmp, 0, q, 0, q.length);
                }
                r.setVar("q", q);
                if (c == 1) {
                    r.exec("ip = new ShortProcessor(w, h, q, n)");
                    return r.getVar("ip");
                }
                short[][] pix = new short[3][w * h];
                int i = 0;
                while (i < c) {
                    System.arraycopy(q, i * w * h, pix[i], 0, w * h);
                    ++i;
                }
                r.setVar("redS", pix[0]);
                r.setVar("greenS", pix[1]);
                r.setVar("blueS", pix[2]);
                r.setVar("nnull", null);
                r.exec("redProc = new ShortProcessor(w, h, redS, nnull)");
                r.exec("greenProc = new ShortProcessor(w, h, greenS, nnull)");
                r.exec("blueProc = new ShortProcessor(w, h, blueS, nnull)");
                return new Object[]{r.getVar("redProc"), r.getVar("greenProc"), r.getVar("blueProc")};
            }
            if (pixels instanceof int[]) {
                int[] q = (int[])pixels;
                if (q.length > w * h * c) {
                    int[] tmp = q;
                    q = new int[w * h * c];
                    System.arraycopy(tmp, 0, q, 0, q.length);
                }
                r.setVar("q", q);
                if (c == 1) {
                    r.exec("ip = new FloatProcessor(w, h, q)");
                    return r.getVar("ip");
                }
                int[][] pix = new int[3][w * h];
                int i = 0;
                while (i < c) {
                    System.arraycopy(q, i * w * h, pix[i], 0, w * h);
                    ++i;
                }
                r.setVar("redS", pix[0]);
                r.setVar("greenS", pix[1]);
                r.setVar("blueS", pix[2]);
                r.setVar("nnull", null);
                r.exec("redProc = new FloatProcessor(w, h, redS)");
                r.exec("greenProc = new FloatProcessor(w, h, greenS)");
                r.exec("blueProc = new FloatProcessor(w, h, blueS)");
                return new Object[]{r.getVar("redProc"), r.getVar("greenProc"), r.getVar("blueProc")};
            }
            if (pixels instanceof float[]) {
                int i;
                float[] q = (float[])pixels;
                if (q.length > w * h) {
                    float[] tmp = q;
                    q = new float[w * h];
                    System.arraycopy(tmp, 0, q, 0, q.length);
                }
                if (c == 1) {
                    r.setVar("q", q);
                    r.exec("ip = new FloatProcessor(w, h, q, n)");
                    return r.getVar("ip");
                }
                float[][] pix = new float[c][w * h];
                if (!this.reader.isInterleaved()) {
                    i = 0;
                    while (i < q.length) {
                        int j = 0;
                        while (j < c) {
                            pix[j][i / c] = q[i + j];
                            ++j;
                        }
                        i += c;
                    }
                } else {
                    i = 0;
                    while (i < c) {
                        System.arraycopy(q, i * pix[i].length, pix[i], 0, pix[i].length);
                        ++i;
                    }
                }
                byte[][] bytes = new byte[c][w * h];
                int i2 = 0;
                while (i2 < c) {
                    r.setVar("pix", pix[i2]);
                    r.setVar("t", true);
                    r.exec("ip = new FloatProcessor(w, h, pix, n)");
                    r.exec("ip = ip.convertToByte(t)");
                    r.exec("bytes = ip.getPixels()");
                    bytes[i2] = (byte[])r.getVar("bytes");
                    ++i2;
                }
                r.exec("ip = new ColorProcessor(w, h)");
                r.setVar("red", bytes[0]);
                r.setVar("green", bytes[1]);
                r.setVar("blue", pix.length >= 3 ? bytes[2] : new byte[w * h]);
                r.exec("ip.setRGB(red, green, blue)");
                return r.getVar("ip");
            }
            if (!(pixels instanceof double[])) return r.getVar("ip");
            double[] q = (double[])pixels;
            if (q.length > w * h) {
                double[] tmp = q;
                q = new double[w * h];
                System.arraycopy(tmp, 0, q, 0, q.length);
            }
            r.setVar("q", q);
            r.exec("ip = new FloatProcessor(w, h, q)");
            return r.getVar("ip");
        }
        catch (FormatException e) {
            throw new CacheException(e);
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
        catch (ReflectException e) {
            throw new CacheException(e);
        }
    }
}

