/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.cache;

import java.util.Arrays;
import java.util.Comparator;
import loci.formats.FormatTools;
import loci.formats.cache.CacheException;
import loci.formats.cache.ICacheStrategy;

public abstract class CacheStrategy
implements Comparator,
ICacheStrategy {
    public static final int DEFAULT_RANGE = 0;
    protected int[] lengths;
    protected int[] order;
    protected int[] range;
    protected int[] priorities;
    private int[][] positions;
    private boolean dirty;

    public CacheStrategy(int[] lengths) {
        this.lengths = lengths;
        this.order = new int[lengths.length];
        Arrays.fill(this.order, 0);
        this.range = new int[lengths.length];
        Arrays.fill(this.range, 0);
        this.priorities = new int[lengths.length];
        Arrays.fill(this.priorities, 0);
        this.positions = this.getPossiblePositions();
        this.dirty = true;
    }

    protected abstract int[][] getPossiblePositions();

    public int raster(int[] pos) {
        return FormatTools.positionToRaster(this.lengths, pos);
    }

    public int[] pos(int raster) {
        return FormatTools.rasterToPosition(this.lengths, raster);
    }

    public int[] pos(int raster, int[] pos) {
        return FormatTools.rasterToPosition(this.lengths, raster, pos);
    }

    public int length() {
        return FormatTools.getRasterLength(this.lengths);
    }

    public int distance(int axis, int value) {
        switch (this.order[axis]) {
            case 0: {
                if (value == 0) {
                    return 0;
                }
                int vb = this.lengths[axis] - value;
                return value <= vb ? value : vb;
            }
            case 1: {
                return value;
            }
            case -1: {
                return this.lengths[axis] - value;
            }
        }
        throw new IllegalStateException("unknown order: " + this.order[axis]);
    }

    public int compare(Object o1, Object o2) {
        int diff;
        int i;
        int[] p1 = (int[])o1;
        int[] p2 = (int[])o2;
        int p = 10;
        while (p >= -10) {
            int dist1 = 0;
            int dist2 = 0;
            i = 0;
            while (i < p1.length) {
                if (this.priorities[i] == p) {
                    dist1 += this.distance(i, p1[i]);
                    dist2 += this.distance(i, p2[i]);
                }
                ++i;
            }
            diff = dist1 - dist2;
            if (diff != 0) {
                return diff;
            }
            --p;
        }
        p = 10;
        while (p >= -10) {
            int div1 = 0;
            int div2 = 0;
            i = 0;
            while (i < p1.length) {
                if (this.priorities[i] == p) {
                    if (p1[i] != 0) {
                        ++div1;
                    }
                    if (p2[i] != 0) {
                        ++div2;
                    }
                }
                ++i;
            }
            diff = div1 - div2;
            if (diff != 0) {
                return diff;
            }
            --p;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getLoadList(int[] pos) throws CacheException {
        int[][] loadList = null;
        int[][] nArray = this.positions;
        synchronized (this.positions) {
            int j;
            boolean ok;
            int[] ipos;
            if (this.dirty) {
                Arrays.sort(this.positions, this);
                this.dirty = false;
            }
            int c = 0;
            int i = 0;
            while (i < this.positions.length) {
                ipos = this.positions[i];
                ok = true;
                j = 0;
                while (j < ipos.length) {
                    if (this.distance(j, ipos[j]) > this.range[j]) {
                        ok = false;
                        break;
                    }
                    ++j;
                }
                if (ok) {
                    ++c;
                }
                ++i;
            }
            loadList = new int[c][this.lengths.length];
            c = 0;
            i = 0;
            while (i < this.positions.length) {
                ipos = this.positions[i];
                ok = true;
                j = 0;
                while (j < ipos.length && c < loadList.length) {
                    int value;
                    if (this.distance(j, ipos[j]) > this.range[j]) {
                        ok = false;
                        break;
                    }
                    loadList[c][j] = value = (pos[j] + ipos[j]) % this.lengths[j];
                    ++j;
                }
                if (ok) {
                    ++c;
                }
                ++i;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return loadList;
        }
    }

    public int[] getPriorities() {
        return this.priorities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int priority, int axis) {
        if (priority < -10 || priority > 10) {
            throw new IllegalArgumentException("Invalid priority for axis #" + axis + ": " + priority);
        }
        int[][] nArray = this.positions;
        synchronized (this.positions) {
            this.priorities[axis] = priority;
            this.dirty = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public int[] getOrder() {
        return this.order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrder(int order, int axis) {
        if (order != 0 && order != 1 && order != -1) {
            throw new IllegalArgumentException("Invalid order for axis #" + axis + ": " + order);
        }
        int[][] nArray = this.positions;
        synchronized (this.positions) {
            this.order[axis] = order;
            this.dirty = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public int[] getRange() {
        return this.range;
    }

    public void setRange(int planes, int axis) {
        if (planes < 0) {
            throw new IllegalArgumentException("Invalid range for axis #" + axis + ": " + planes);
        }
        this.range[axis] = planes;
    }

    public int[] getLengths() {
        return this.lengths;
    }
}

