/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.cache;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import javax.swing.JFrame;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.LogTools;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;
import loci.formats.cache.BufferedImageSource;
import loci.formats.cache.ByteArraySource;
import loci.formats.cache.CacheException;
import loci.formats.cache.CrosshairStrategy;
import loci.formats.cache.ICacheSource;
import loci.formats.cache.ICacheStrategy;
import loci.formats.cache.ImageProcessorSource;
import loci.formats.cache.RectangleStrategy;

public class Cache {
    private static boolean debug = false;
    private ICacheStrategy strategy;
    private ICacheSource source;
    private int[] currentPos;
    private Object[] cache;
    private boolean[] inCache;

    public Cache(ICacheStrategy strategy, ICacheSource source) throws CacheException {
        if (strategy == null) {
            throw new CacheException("strategy is null");
        }
        if (source == null) {
            throw new CacheException("source is null");
        }
        this.strategy = strategy;
        this.source = source;
        this.reset();
    }

    public Object getObject(int[] pos) throws CacheException {
        if (pos.length != this.strategy.getLengths().length) {
            throw new CacheException("Invalid number of axes; got " + pos.length + "; expected " + this.strategy.getLengths().length);
        }
        int ndx = FormatTools.positionToRaster(this.strategy.getLengths(), pos);
        return this.cache[ndx];
    }

    public void reset() throws CacheException {
        this.currentPos = new int[this.strategy.getLengths().length];
        this.cache = new Object[this.source.getObjectCount()];
        this.inCache = new boolean[this.source.getObjectCount()];
        Arrays.fill(this.inCache, false);
    }

    public ICacheStrategy getStrategy() {
        return this.strategy;
    }

    public ICacheSource getSource() {
        return this.source;
    }

    public int[] getCurrentPos() {
        return this.currentPos;
    }

    public void setStrategy(ICacheStrategy strategy) throws CacheException {
        if (strategy == null) {
            throw new CacheException("strategy is null");
        }
        this.strategy = strategy;
        this.reset();
        this.load(this.currentPos);
    }

    public void setSource(ICacheSource source) throws CacheException {
        if (source == null) {
            throw new CacheException("source is null");
        }
        this.source = source;
        this.reset();
        this.load(this.currentPos);
    }

    public void setCurrentPos(int[] pos) throws CacheException {
        if (pos == null) {
            throw new CacheException("pos is null");
        }
        if (pos.length != this.currentPos.length) {
            throw new CacheException("pos length mismatch (is " + pos.length + ", expected " + this.currentPos.length + ")");
        }
        int[] len = this.strategy.getLengths();
        int i = 0;
        while (i < pos.length) {
            if (pos[i] < 0 || pos[i] >= len[i]) {
                throw new CacheException("invalid pos[" + i + "] (is " + pos[i] + ", expected [0, " + (len[i] - 1) + "])");
            }
            ++i;
        }
        System.arraycopy(pos, 0, this.currentPos, 0, pos.length);
        this.load(this.currentPos);
    }

    private void load(int[] pos) throws CacheException {
        int ndx;
        int[][] indices = this.strategy.getLoadList(pos);
        int[] len = this.strategy.getLengths();
        Arrays.fill(this.inCache, false);
        int i = 0;
        while (i < indices.length) {
            ndx = FormatTools.positionToRaster(len, indices[i]);
            if (ndx >= 0) {
                this.inCache[ndx] = true;
            }
            ++i;
        }
        i = 0;
        while (i < this.cache.length) {
            if (!this.inCache[i]) {
                this.cache[i] = null;
            }
            ++i;
        }
        i = 0;
        while (i < indices.length) {
            ndx = FormatTools.positionToRaster(len, indices[i]);
            if (this.cache[ndx] == null) {
                if (debug) {
                    Cache.printArray("Loading position", indices[i]);
                }
                this.cache[ndx] = this.source.getObject(len, indices[i]);
            } else if (debug) {
                Cache.printArray("Already in cache", indices[i]);
            }
            ++i;
        }
    }

    private static final void printArray(String name, int[] array) {
        LogTools.print(String.valueOf(name) + " =");
        int i = 0;
        while (i < array.length) {
            LogTools.print(" " + array[i]);
            ++i;
        }
        LogTools.println();
    }

    private static final int[] getLengths(IFormatReader r) {
        return new int[]{r.getSizeZ(), r.getSizeC(), r.getSizeT()};
    }

    public static void main(String[] args) throws FormatException, IOException {
        if (args.length < 1) {
            LogTools.println("Please specify a filename containing image data.");
            System.exit(1);
        }
        debug = true;
        ImageReader reader = new ImageReader();
        String id = args[0];
        LogTools.println("Reading " + id);
        reader.setId(id);
        LogTools.println("Initializing cache");
        Cache cache = new Cache(new CrosshairStrategy(Cache.getLengths(reader)), new BufferedImageSource(reader));
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        LogTools.println("Entering Bio-Formats caching test console");
        block16: while (true) {
            LogTools.print("> ");
            String cmd = r.readLine().trim();
            if (cmd.equals("")) continue;
            if (cmd.startsWith("e") || cmd.startsWith("q")) break;
            if (cmd.startsWith("g")) {
                JFrame frame = new JFrame("Cache controls");
                frame.setDefaultCloseOperation(2);
                ReflectedUniverse ru = new ReflectedUniverse();
                try {
                    ru.exec("import loci.formats.gui.CacheComponent");
                    ru.setVar("cache", cache);
                    ru.setVar("doSource", true);
                    ru.setVar("axes", new String[]{"Z", "C", "T"});
                    ru.setVar("id", id);
                    ru.exec("widget = new CacheComponent(cache, doSource, axes, id)");
                    ru.setVar("frame", frame);
                    ru.exec("frame.setContentPane(widget)");
                    frame.pack();
                    frame.setVisible(true);
                }
                catch (ReflectException exc) {
                    LogTools.trace(exc);
                }
                continue;
            }
            if (cmd.startsWith("h")) {
                LogTools.println("Available commands:");
                LogTools.println("  gui      -- pops up a GUI to configure the cache");
                LogTools.println("  info     -- displays the cache state");
                LogTools.println("  position -- changes the current position");
                LogTools.println("  strategy -- changes the cache strategy");
                LogTools.println("  source   -- changes the cache source");
                LogTools.println("  range    -- changes the cache ranges");
                LogTools.println("  priority -- changes the cache priorities");
                LogTools.println("  read     -- gets a plane from the cache");
                LogTools.println("  exit     -- quits the interpreter");
                continue;
            }
            if (cmd.startsWith("i")) {
                Cache.printArray("pos", cache.getCurrentPos());
                ICacheSource source = cache.getSource();
                LogTools.print("source = ");
                Class<?> sourceClass = source.getClass();
                if (sourceClass == BufferedImageSource.class) {
                    LogTools.println("BufferedImage");
                } else if (sourceClass == ByteArraySource.class) {
                    LogTools.println("byte array");
                } else if (sourceClass == ImageProcessorSource.class) {
                    LogTools.println("ImageProcessor");
                } else {
                    LogTools.println("unknown");
                }
                LogTools.println("object count = " + source.getObjectCount());
                ICacheStrategy strategy = cache.getStrategy();
                LogTools.print("strategy = ");
                Class<?> strategyClass = strategy.getClass();
                if (strategyClass == CrosshairStrategy.class) {
                    LogTools.println("crosshair");
                } else if (strategyClass == RectangleStrategy.class) {
                    LogTools.println("crosshair");
                } else {
                    LogTools.println("unknown");
                }
                Cache.printArray("priorities", strategy.getPriorities());
                int[] order = strategy.getOrder();
                LogTools.print("order =");
                int i = 0;
                while (i < order.length) {
                    switch (order[i]) {
                        case 0: {
                            LogTools.print(" C");
                            break;
                        }
                        case 1: {
                            LogTools.print(" F");
                            break;
                        }
                        case -1: {
                            LogTools.print(" B");
                            break;
                        }
                        default: {
                            LogTools.print(" ?");
                        }
                    }
                    ++i;
                }
                LogTools.println();
                Cache.printArray("range", strategy.getRange());
                Cache.printArray("lengths", strategy.getLengths());
                continue;
            }
            if (cmd.startsWith("po")) {
                LogTools.print("Z: ");
                int z = Integer.parseInt(r.readLine().trim());
                LogTools.print("C: ");
                int c = Integer.parseInt(r.readLine().trim());
                LogTools.print("T: ");
                int t = Integer.parseInt(r.readLine().trim());
                cache.setCurrentPos(new int[]{z, c, t});
                continue;
            }
            if (cmd.startsWith("pr")) {
                LogTools.println("-10 => min priority");
                LogTools.println("-5 => low priority");
                LogTools.println("0 => normal priority");
                LogTools.println("5 => high priority");
                LogTools.println("10 => max priority");
                LogTools.print("Z: ");
                int z = Integer.parseInt(r.readLine().trim());
                LogTools.print("C: ");
                int c = Integer.parseInt(r.readLine().trim());
                LogTools.print("T: ");
                int t = Integer.parseInt(r.readLine().trim());
                ICacheStrategy strategy = cache.getStrategy();
                strategy.setPriority(z, 0);
                strategy.setPriority(c, 1);
                strategy.setPriority(t, 2);
                continue;
            }
            if (cmd.startsWith("ra")) {
                LogTools.print("Z: ");
                int z = Integer.parseInt(r.readLine().trim());
                LogTools.print("C: ");
                int c = Integer.parseInt(r.readLine().trim());
                LogTools.print("T: ");
                int t = Integer.parseInt(r.readLine().trim());
                cache.getStrategy().setRange(z, 0);
                cache.getStrategy().setRange(c, 1);
                cache.getStrategy().setRange(t, 2);
                continue;
            }
            if (cmd.startsWith("re")) {
                LogTools.print("Z: ");
                int z = Integer.parseInt(r.readLine().trim());
                LogTools.print("C: ");
                int c = Integer.parseInt(r.readLine().trim());
                LogTools.print("T: ");
                int t = Integer.parseInt(r.readLine().trim());
                LogTools.println("Retrieving Z" + z + "-C" + c + "-T" + t);
                Object o = cache.getObject(new int[]{z, c, t});
                LogTools.println(o);
                continue;
            }
            if (cmd.startsWith("so")) {
                LogTools.println("0: BufferedImage");
                LogTools.println("1: byte array");
                LogTools.println("2: ImageProcessor");
                LogTools.print("> ");
                int n = Integer.parseInt(r.readLine().trim());
                switch (n) {
                    case 0: {
                        cache.setSource(new BufferedImageSource(reader));
                        LogTools.println("Source set to BufferedImage");
                        continue block16;
                    }
                    case 1: {
                        cache.setSource(new ByteArraySource(reader));
                        LogTools.println("Source set to byte array");
                        continue block16;
                    }
                    case 2: {
                        cache.setSource(new ImageProcessorSource(reader));
                        LogTools.println("Source set to ImageProcessor");
                        continue block16;
                    }
                }
                LogTools.println("Unknown source: " + n);
                continue;
            }
            if (cmd.startsWith("st")) {
                LogTools.println("0: crosshair");
                LogTools.println("1: rectangle");
                LogTools.print("> ");
                int n = Integer.parseInt(r.readLine().trim());
                int[] l = Cache.getLengths(reader);
                switch (n) {
                    case 0: {
                        cache.setStrategy(new CrosshairStrategy(l));
                        LogTools.println("Strategy set to crosshair");
                        continue block16;
                    }
                    case 1: {
                        cache.setStrategy(new RectangleStrategy(l));
                        LogTools.println("Strategy set to rectangle");
                        continue block16;
                    }
                }
                LogTools.println("Unknown strategy: " + n);
                continue;
            }
            LogTools.println("Unknown command: " + cmd);
        }
        reader.close();
    }
}

