/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataStore;
import loci.formats.StatusListener;

public abstract class ReaderWrapper
implements IFormatReader {
    protected IFormatReader reader;

    public ReaderWrapper() {
        this(new ImageReader());
    }

    public ReaderWrapper(IFormatReader r) {
        if (r == null) {
            throw new IllegalArgumentException("Format reader cannot be null");
        }
        this.reader = r;
    }

    public IFormatReader getReader() {
        return this.reader;
    }

    public boolean isThisType(byte[] block) {
        return this.reader.isThisType(block);
    }

    public void setId(String id) throws FormatException, IOException {
        this.reader.setId(id);
    }

    public void setId(String id, boolean force) throws FormatException, IOException {
        this.reader.setId(id, force);
    }

    public int getImageCount() {
        return this.reader.getImageCount();
    }

    public boolean isRGB() {
        return this.reader.isRGB();
    }

    public int getSizeX() {
        return this.reader.getSizeX();
    }

    public int getSizeY() {
        return this.reader.getSizeY();
    }

    public int getSizeZ() {
        return this.reader.getSizeZ();
    }

    public int getSizeC() {
        return this.reader.getSizeC();
    }

    public int getSizeT() {
        return this.reader.getSizeT();
    }

    public int getPixelType() {
        return this.reader.getPixelType();
    }

    public int getEffectiveSizeC() {
        return this.getImageCount() / (this.getSizeZ() * this.getSizeT());
    }

    public int getRGBChannelCount() {
        return this.getSizeC() / this.getEffectiveSizeC();
    }

    public int[] getChannelDimLengths() {
        return this.reader.getChannelDimLengths();
    }

    public String[] getChannelDimTypes() {
        return this.reader.getChannelDimTypes();
    }

    public int getThumbSizeX() {
        return this.reader.getThumbSizeX();
    }

    public int getThumbSizeY() {
        return this.reader.getThumbSizeY();
    }

    public boolean isLittleEndian() {
        return this.reader.isLittleEndian();
    }

    public String getDimensionOrder() {
        return this.reader.getDimensionOrder();
    }

    public boolean isOrderCertain() {
        return this.reader.isOrderCertain();
    }

    public boolean isInterleaved() {
        return this.reader.isInterleaved();
    }

    public boolean isInterleaved(int subC) {
        return this.reader.isInterleaved(subC);
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        return this.reader.openImage(no);
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.reader.openBytes(no);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.reader.openBytes(no, buf);
    }

    public BufferedImage openThumbImage(int no) throws FormatException, IOException {
        return this.reader.openThumbImage(no);
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        return this.reader.openThumbBytes(no);
    }

    public void close(boolean fileOnly) throws IOException {
        this.reader.close(fileOnly);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int getSeriesCount() {
        return this.reader.getSeriesCount();
    }

    public void setSeries(int no) {
        this.reader.setSeries(no);
    }

    public int getSeries() {
        return this.reader.getSeries();
    }

    public void setGroupFiles(boolean group) {
        this.reader.setGroupFiles(group);
    }

    public boolean isGroupFiles() {
        return this.reader.isGroupFiles();
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return this.reader.fileGroupOption(id);
    }

    public boolean isMetadataComplete() {
        return this.reader.isMetadataComplete();
    }

    public void setNormalized(boolean normalize) {
        this.reader.setNormalized(normalize);
    }

    public boolean isNormalized() {
        return this.reader.isNormalized();
    }

    public void setMetadataCollected(boolean collect) {
        this.reader.setMetadataCollected(collect);
    }

    public boolean isMetadataCollected() {
        return this.reader.isMetadataCollected();
    }

    public void setOriginalMetadataPopulated(boolean populate) {
        this.reader.setOriginalMetadataPopulated(populate);
    }

    public boolean isOriginalMetadataPopulated() {
        return this.reader.isOriginalMetadataPopulated();
    }

    public String[] getUsedFiles() {
        return this.reader.getUsedFiles();
    }

    public String getCurrentFile() {
        return this.reader.getCurrentFile();
    }

    public int getIndex(int z, int c, int t) {
        return this.reader.getIndex(z, c, t);
    }

    public int[] getZCTCoords(int index) {
        return this.reader.getZCTCoords(index);
    }

    public Object getMetadataValue(String field) {
        return this.reader.getMetadataValue(field);
    }

    public Hashtable getMetadata() {
        return this.reader.getMetadata();
    }

    public CoreMetadata getCoreMetadata() {
        return this.reader.getCoreMetadata();
    }

    public void setMetadataFiltered(boolean filter) {
        this.reader.setMetadataFiltered(filter);
    }

    public boolean isMetadataFiltered() {
        return this.reader.isMetadataFiltered();
    }

    public void setMetadataStore(MetadataStore store) {
        this.reader.setMetadataStore(store);
    }

    public MetadataStore getMetadataStore() {
        return this.reader.getMetadataStore();
    }

    public Object getMetadataStoreRoot() {
        return this.reader.getMetadataStoreRoot();
    }

    public boolean isThisType(String name) {
        return this.reader.isThisType(name);
    }

    public boolean isThisType(String name, boolean open) {
        return this.reader.isThisType(name, open);
    }

    public String getFormat() {
        return this.reader.getFormat();
    }

    public String[] getSuffixes() {
        return this.reader.getSuffixes();
    }

    public void addStatusListener(StatusListener l) {
        this.reader.addStatusListener(l);
    }

    public void removeStatusListener(StatusListener l) {
        this.reader.removeStatusListener(l);
    }

    public StatusListener[] getStatusListeners() {
        return this.reader.getStatusListeners();
    }

    public int getImageCount(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getImageCount();
    }

    public boolean isRGB(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.isRGB();
    }

    public int getSizeX(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getSizeX();
    }

    public int getSizeY(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getSizeY();
    }

    public int getSizeZ(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getSizeZ();
    }

    public int getSizeC(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getSizeC();
    }

    public int getSizeT(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getSizeT();
    }

    public int getPixelType(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getPixelType();
    }

    public int getEffectiveSizeC(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.getImageCount() / (this.getSizeZ() * this.getSizeT());
    }

    public int getRGBChannelCount(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.getSizeC() / this.getEffectiveSizeC();
    }

    public int[] getChannelDimLengths(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getChannelDimLengths();
    }

    public String[] getChannelDimTypes(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getChannelDimTypes();
    }

    public int getThumbSizeX(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getThumbSizeX();
    }

    public int getThumbSizeY(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getThumbSizeY();
    }

    public boolean isLittleEndian(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.isLittleEndian();
    }

    public String getDimensionOrder(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getDimensionOrder();
    }

    public boolean isOrderCertain(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.isOrderCertain();
    }

    public boolean isInterleaved(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.isInterleaved();
    }

    public boolean isInterleaved(String id, int subC) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.isInterleaved(subC);
    }

    public BufferedImage openImage(String id, int no) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.openImage(no);
    }

    public byte[] openBytes(String id, int no) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.openBytes(no);
    }

    public byte[] openBytes(String id, int no, byte[] buf) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.openBytes(no, buf);
    }

    public BufferedImage openThumbImage(String id, int no) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.openThumbImage(no);
    }

    public byte[] openThumbBytes(String id, int no) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.openThumbBytes(no);
    }

    public int getSeriesCount(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getSeriesCount();
    }

    public void setSeries(String id, int no) throws FormatException, IOException {
        this.reader.setId(id);
        this.reader.setSeries(no);
    }

    public int getSeries(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getSeries();
    }

    public String[] getUsedFiles(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getUsedFiles();
    }

    public int getIndex(String id, int z, int c, int t) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getIndex(z, c, t);
    }

    public int[] getZCTCoords(String id, int index) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getZCTCoords(index);
    }

    public Object getMetadataValue(String id, String field) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getMetadataValue(field);
    }

    public Hashtable getMetadata(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getMetadata();
    }

    public CoreMetadata getCoreMetadata(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getCoreMetadata();
    }

    public MetadataStore getMetadataStore(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getMetadataStore();
    }

    public Object getMetadataStoreRoot(String id) throws FormatException, IOException {
        this.reader.setId(id);
        return this.reader.getMetadataStoreRoot();
    }
}

