/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import loci.formats.IRandomAccess;

public class RAUrl
implements IRandomAccess {
    private String url;
    private HttpURLConnection conn;
    private DataInputStream is;
    private DataOutputStream os;
    private long fp;
    private long length;
    private long mark;

    public RAUrl(String url, String mode) throws IOException {
        if (!url.startsWith("http")) {
            url = "http://" + url;
        }
        this.conn = (HttpURLConnection)new URL(url).openConnection();
        if (mode.equals("r")) {
            this.is = new DataInputStream(new BufferedInputStream(this.conn.getInputStream(), 65536));
        } else if (mode.equals("w")) {
            this.conn.setDoOutput(true);
            this.os = new DataOutputStream(this.conn.getOutputStream());
        }
        this.fp = 0L;
        this.length = this.conn.getContentLength();
        if (this.is != null) {
            this.is.mark((int)this.length);
        }
        this.url = url;
    }

    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
        if (this.os != null) {
            this.os.close();
        }
        this.conn.disconnect();
    }

    public long getFilePointer() throws IOException {
        return this.fp;
    }

    public long length() throws IOException {
        return this.length;
    }

    public int read() throws IOException {
        int value = this.is.read();
        while (value == -1 && this.fp < this.length()) {
            value = this.is.read();
        }
        if (value != -1) {
            ++this.fp;
        }
        this.markManager();
        return value;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.is.read(b, off, len);
        if (read != -1) {
            this.fp += (long)read;
        }
        if (read == -1) {
            read = 0;
        }
        this.markManager();
        while (read < len && this.fp < this.length()) {
            int oldRead = read;
            if ((read += this.read(b, off + read, len - read)) >= oldRead) continue;
            read = oldRead;
        }
        return read == 0 ? -1 : read;
    }

    public void seek(long pos) throws IOException {
        if (pos >= this.fp) {
            this.skipBytes((int)(pos - this.fp));
            return;
        }
        if (pos >= this.mark) {
            try {
                this.is.reset();
                this.fp = this.mark;
                this.skipBytes((int)(pos - this.fp));
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.close();
        this.conn = (HttpURLConnection)new URL(this.url).openConnection();
        this.conn.setDoOutput(true);
        if (this.is != null) {
            this.is = new DataInputStream(new BufferedInputStream(this.conn.getInputStream(), 65536));
            this.is.mark((int)this.length());
            this.mark = 0L;
        }
        if (this.os != null) {
            this.os = new DataOutputStream(this.conn.getOutputStream());
        }
        this.url = this.url;
        this.fp = 0L;
        this.skipBytes((int)pos);
    }

    public void setLength(long newLength) throws IOException {
        this.length = newLength;
    }

    public boolean readBoolean() throws IOException {
        ++this.fp;
        return this.is.readBoolean();
    }

    public byte readByte() throws IOException {
        ++this.fp;
        return this.is.readByte();
    }

    public char readChar() throws IOException {
        ++this.fp;
        return this.is.readChar();
    }

    public double readDouble() throws IOException {
        this.fp += 8L;
        return this.is.readDouble();
    }

    public float readFloat() throws IOException {
        this.fp += 4L;
        return this.is.readFloat();
    }

    public void readFully(byte[] b) throws IOException {
        this.fp += (long)b.length;
        this.is.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.fp += (long)len;
        this.is.readFully(b, off, len);
    }

    public int readInt() throws IOException {
        this.fp += 4L;
        return this.is.readInt();
    }

    public String readLine() throws IOException {
        throw new IOException("Unimplemented");
    }

    public long readLong() throws IOException {
        this.fp += 8L;
        return this.is.readLong();
    }

    public short readShort() throws IOException {
        this.fp += 2L;
        return this.is.readShort();
    }

    public int readUnsignedByte() throws IOException {
        ++this.fp;
        return this.is.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        this.fp += 2L;
        return this.is.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        this.fp += 2L;
        return this.is.readUTF();
    }

    public int skipBytes(int n) throws IOException {
        int skipped = 0;
        int i = 0;
        while (i < n) {
            if (this.read() != -1) {
                ++skipped;
            }
            this.markManager();
            ++i;
        }
        return skipped;
    }

    public void write(byte[] b) throws IOException {
        this.os.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.os.write(b);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.os.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.os.writeByte(v);
    }

    public void writeBytes(String s) throws IOException {
        this.os.writeBytes(s);
    }

    public void writeChar(int v) throws IOException {
        this.os.writeChar(v);
    }

    public void writeChars(String s) throws IOException {
        this.os.writeChars(s);
    }

    public void writeDouble(double v) throws IOException {
        this.os.writeDouble(v);
    }

    public void writeFloat(float v) throws IOException {
        this.os.writeFloat(v);
    }

    public void writeInt(int v) throws IOException {
        this.os.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.os.writeLong(v);
    }

    public void writeShort(int v) throws IOException {
        this.os.writeShort(v);
    }

    public void writeUTF(String str) throws IOException {
        this.os.writeUTF(str);
    }

    private void markManager() throws IOException {
        if (this.fp >= this.mark + 65535L) {
            this.mark = this.fp;
            this.is.mark((int)this.length());
        }
    }
}

