/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.EOFException;
import java.io.IOException;
import loci.formats.DataTools;
import loci.formats.IRandomAccess;

public class RABytes
implements IRandomAccess {
    protected byte[] array;
    protected int fp;

    public RABytes(byte[] bytes) {
        this.array = bytes;
        this.fp = 0;
    }

    public byte[] getBytes() {
        return this.array;
    }

    public void close() {
    }

    public long getFilePointer() {
        return this.fp;
    }

    public long length() {
        return this.array.length;
    }

    public int read() {
        return this.fp < this.array.length ? this.array[this.fp++] : 0;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.fp + len > this.array.length) {
            len = this.array.length - this.fp;
        }
        System.arraycopy(this.array, this.fp, b, off, len);
        this.fp += len;
        return len;
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("pos < 0");
        }
        if (pos > Integer.MAX_VALUE) {
            throw new IOException("pos is too large");
        }
        this.fp = (int)pos;
    }

    public void setLength(long newLength) throws IOException {
        if (newLength > Integer.MAX_VALUE) {
            throw new IOException("newLength is too large");
        }
        int len = (int)newLength;
        byte[] bytes = new byte[len];
        System.arraycopy(this.array, 0, bytes, 0, this.array.length < len ? this.array.length : len);
        this.array = bytes;
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public byte readByte() throws IOException {
        if (this.fp + 1 > this.array.length) {
            throw new EOFException();
        }
        return this.array[this.fp++];
    }

    public char readChar() throws IOException {
        if (this.fp + 2 > this.array.length) {
            throw new EOFException();
        }
        char c = (char)DataTools.bytesToShort(this.array, this.fp, false);
        this.fp += 2;
        return c;
    }

    public double readDouble() throws IOException {
        if (this.fp + 8 > this.array.length) {
            throw new EOFException();
        }
        double d = Double.longBitsToDouble(DataTools.bytesToLong(this.array, this.fp, false));
        this.fp += 8;
        return d;
    }

    public float readFloat() throws IOException {
        if (this.fp + 4 > this.array.length) {
            throw new EOFException();
        }
        float f = Float.intBitsToFloat(DataTools.bytesToInt(this.array, this.fp, false));
        this.fp += 4;
        return f;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.fp + len > this.array.length) {
            throw new EOFException();
        }
        System.arraycopy(this.array, this.fp, b, off, len);
        this.fp += len;
    }

    public int readInt() throws IOException {
        if (this.fp + 4 > this.array.length) {
            throw new EOFException();
        }
        int i = DataTools.bytesToInt(this.array, this.fp, false);
        this.fp += 4;
        return i;
    }

    public String readLine() throws IOException {
        throw new IOException("Unimplemented");
    }

    public long readLong() throws IOException {
        if (this.fp + 8 > this.array.length) {
            throw new EOFException();
        }
        long l = DataTools.bytesToLong(this.array, this.fp, false);
        this.fp += 8;
        return l;
    }

    public short readShort() throws IOException {
        if (this.fp + 2 > this.array.length) {
            throw new EOFException();
        }
        short s = DataTools.bytesToShort(this.array, this.fp, false);
        this.fp += 2;
        return s;
    }

    public int readUnsignedByte() throws IOException {
        if (this.fp + 1 > this.array.length) {
            throw new EOFException();
        }
        return DataTools.bytesToInt(this.array, this.fp++, 1, false);
    }

    public int readUnsignedShort() throws IOException {
        if (this.fp + 2 > this.array.length) {
            throw new EOFException();
        }
        int i = DataTools.bytesToInt(this.array, this.fp, 2, false);
        this.fp += 2;
        return i;
    }

    public String readUTF() throws IOException {
        throw new IOException("Unimplemented");
    }

    public int skipBytes(int n) {
        if (n < 0) {
            n = 0;
        }
        if (this.fp + n > this.array.length) {
            n = this.array.length - this.fp;
        }
        this.fp += n;
        return n;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.fp + len > this.array.length) {
            this.setLength(this.fp + len);
        }
        System.arraycopy(b, off, this.array, this.fp, len);
        this.fp += b.length;
    }

    public void write(int b) throws IOException {
        if (this.fp + 1 > this.array.length) {
            this.setLength(this.fp + 1);
        }
        this.array[this.fp++] = (byte)b;
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeBytes(String s) throws IOException {
        char[] c = s.toCharArray();
        byte[] b = new byte[c.length];
        int i = 0;
        while (i < c.length) {
            b[i] = (byte)c[i];
            ++i;
        }
        this.write(b);
    }

    public void writeChar(int v) throws IOException {
        if (this.fp + 2 > this.array.length) {
            this.setLength(this.fp + 2);
        }
        this.array[this.fp++] = (byte)(0xFF & v >> 8);
        this.array[this.fp++] = (byte)(0xFF & v);
    }

    public void writeChars(String s) throws IOException {
        int len = 2 * s.length();
        if (this.fp + len > this.array.length) {
            this.setLength(this.fp + len);
        }
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            char v = c[i];
            this.array[this.fp++] = (byte)(0xFF & v >> 8);
            this.array[this.fp++] = (byte)(0xFF & v);
            ++i;
        }
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeInt(int v) throws IOException {
        if (this.fp + 4 > this.array.length) {
            this.setLength(this.fp + 4);
        }
        this.array[this.fp++] = (byte)(0xFF & v >> 24);
        this.array[this.fp++] = (byte)(0xFF & v >> 16);
        this.array[this.fp++] = (byte)(0xFF & v >> 8);
        this.array[this.fp++] = (byte)(0xFF & v);
    }

    public void writeLong(long v) throws IOException {
        if (this.fp + 8 > this.array.length) {
            this.setLength(this.fp + 8);
        }
        this.array[this.fp++] = (byte)(0xFFL & v >> 56);
        this.array[this.fp++] = (byte)(0xFFL & v >> 48);
        this.array[this.fp++] = (byte)(0xFFL & v >> 40);
        this.array[this.fp++] = (byte)(0xFFL & v >> 32);
        this.array[this.fp++] = (byte)(0xFFL & v >> 24);
        this.array[this.fp++] = (byte)(0xFFL & v >> 16);
        this.array[this.fp++] = (byte)(0xFFL & v >> 8);
        this.array[this.fp++] = (byte)(0xFFL & v);
    }

    public void writeShort(int v) throws IOException {
        if (this.fp + 2 > this.array.length) {
            this.setLength(this.fp + 2);
        }
        this.array[this.fp++] = (byte)(0xFF & v >> 24);
        this.array[this.fp++] = (byte)(0xFF & v >> 16);
        this.array[this.fp++] = (byte)(0xFF & v >> 8);
        this.array[this.fp++] = (byte)(0xFF & v);
    }

    public void writeUTF(String str) throws IOException {
        throw new IOException("Unimplemented");
    }
}

