/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Arrays;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataStore;
import loci.formats.ReaderWrapper;

public class MinMaxCalculator
extends ReaderWrapper {
    protected double[][] chanMin;
    protected double[][] chanMax;
    protected double[][] planeMin;
    protected double[][] planeMax;
    protected int[] minMaxDone;

    public MinMaxCalculator() {
    }

    public MinMaxCalculator(IFormatReader r) {
        super(r);
    }

    public Double getChannelGlobalMinimum(int theC) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (theC < 0 || theC >= this.getSizeC()) {
            throw new FormatException("Invalid channel index: " + theC);
        }
        int series = this.getSeries();
        if (this.minMaxDone == null || this.minMaxDone[series] < this.getImageCount()) {
            return null;
        }
        return new Double(this.chanMin[series][theC]);
    }

    public Double getChannelGlobalMaximum(int theC) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (theC < 0 || theC >= this.getSizeC()) {
            throw new FormatException("Invalid channel index: " + theC);
        }
        int series = this.getSeries();
        if (this.minMaxDone == null || this.minMaxDone[series] < this.getImageCount()) {
            return null;
        }
        return new Double(this.chanMax[series][theC]);
    }

    public Double getChannelKnownMinimum(int theC) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.chanMin == null ? null : new Double(this.chanMin[this.getSeries()][theC]);
    }

    public Double getChannelKnownMaximum(int theC) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.chanMax == null ? null : new Double(this.chanMax[this.getSeries()][theC]);
    }

    public Double[] getPlaneMinimum(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (this.planeMin == null) {
            return null;
        }
        int numRGB = this.getRGBChannelCount();
        int pBase = no * numRGB;
        int series = this.getSeries();
        if (this.planeMin[series][pBase] != this.planeMin[series][pBase]) {
            return null;
        }
        Double[] min = new Double[numRGB];
        int c = 0;
        while (c < numRGB) {
            min[c] = new Double(this.planeMin[series][pBase + c]);
            ++c;
        }
        return min;
    }

    public Double[] getPlaneMaximum(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (this.planeMax == null) {
            return null;
        }
        int numRGB = this.getRGBChannelCount();
        int pBase = no * numRGB;
        int series = this.getSeries();
        if (this.planeMax[series][pBase] != this.planeMax[series][pBase]) {
            return null;
        }
        Double[] max = new Double[numRGB];
        int c = 0;
        while (c < numRGB) {
            max[c] = new Double(this.planeMax[series][pBase + c]);
            ++c;
        }
        return max;
    }

    public boolean isMinMaxPopulated() throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.minMaxDone != null && this.minMaxDone[this.getSeries()] == this.getImageCount();
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        BufferedImage b = super.openImage(no);
        this.updateMinMax(b, no);
        return b;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        byte[] b = super.openBytes(no);
        this.updateMinMax(b, no);
        return b;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        super.openBytes(no, buf);
        this.updateMinMax(buf, no);
        return buf;
    }

    public void close() throws IOException {
        this.reader.close();
        this.chanMin = null;
        this.chanMax = null;
        this.planeMin = null;
        this.planeMax = null;
        this.minMaxDone = null;
    }

    protected void updateMinMax(BufferedImage b, int ndx) throws FormatException, IOException {
        if (b == null) {
            return;
        }
        this.initMinMax();
        int numRGB = this.getRGBChannelCount();
        int series = this.getSeries();
        if (this.planeMin[series][ndx * numRGB] == this.planeMin[series][ndx * numRGB]) {
            return;
        }
        int[] coords = this.getZCTCoords(ndx);
        int cBase = coords[1] * numRGB;
        int pBase = ndx * numRGB;
        int c = 0;
        while (c < numRGB) {
            this.planeMin[series][pBase + c] = Double.POSITIVE_INFINITY;
            this.planeMax[series][pBase + c] = Double.NEGATIVE_INFINITY;
            ++c;
        }
        WritableRaster pixels = b.getRaster();
        int x = 0;
        while (x < b.getWidth()) {
            int y = 0;
            while (y < b.getHeight()) {
                int c2 = 0;
                while (c2 < numRGB) {
                    double v = pixels.getSampleDouble(x, y, c2);
                    if (v > this.chanMax[series][cBase + c2]) {
                        this.chanMax[series][cBase + c2] = v;
                    }
                    if (v < this.chanMin[series][cBase + c2]) {
                        this.chanMin[series][cBase + c2] = v;
                    }
                    if (v > this.planeMax[series][pBase + c2]) {
                        this.planeMax[series][pBase + c2] = v;
                    }
                    if (v < this.planeMin[series][pBase + c2]) {
                        this.planeMin[series][pBase + c2] = v;
                    }
                    ++c2;
                }
                ++y;
            }
            ++x;
        }
        int n = series;
        this.minMaxDone[n] = this.minMaxDone[n] + 1;
        if (this.minMaxDone[series] == this.getImageCount()) {
            MetadataStore store = this.getMetadataStore();
            int c3 = 0;
            while (c3 < this.getSizeC()) {
                store.setChannelGlobalMinMax(c3, new Double(this.chanMin[series][c3]), new Double(this.chanMax[series][c3]), new Integer(this.getSeries()));
                ++c3;
            }
        }
    }

    protected void updateMinMax(byte[] b, int ndx) throws FormatException, IOException {
        int c;
        if (b == null) {
            return;
        }
        this.initMinMax();
        int numRGB = this.getRGBChannelCount();
        int series = this.getSeries();
        if (this.planeMin[series][ndx * numRGB] == this.planeMin[series][ndx * numRGB]) {
            return;
        }
        boolean little = this.isLittleEndian();
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int pixels = this.getSizeX() * this.getSizeY();
        boolean interleaved = this.isInterleaved();
        int[] coords = this.getZCTCoords(ndx);
        int cBase = coords[1] * numRGB;
        int pBase = ndx * numRGB;
        int c2 = 0;
        while (c2 < numRGB) {
            this.planeMin[series][pBase + c2] = Double.POSITIVE_INFINITY;
            this.planeMax[series][pBase + c2] = Double.NEGATIVE_INFINITY;
            ++c2;
        }
        boolean fp = this.getPixelType() == 6 || this.getPixelType() == 7;
        int i = 0;
        while (i < pixels) {
            c = 0;
            while (c < numRGB) {
                double v;
                int idx = bytes * (interleaved ? i * numRGB + c : c * pixels + i);
                long bits = DataTools.bytesToLong(b, idx, bytes, little);
                double d = v = fp ? Double.longBitsToDouble(bits) : (double)bits;
                if (v > this.chanMax[series][cBase + c]) {
                    this.chanMax[series][cBase + c] = v;
                }
                if (v < this.chanMin[series][cBase + c]) {
                    this.chanMin[series][cBase + c] = v;
                }
                if (v > this.planeMax[series][ndx]) {
                    this.planeMax[series][ndx] = v;
                }
                if (v < this.planeMin[series][pBase + c]) {
                    this.planeMin[series][pBase + c] = v;
                }
                ++c;
            }
            ++i;
        }
        int n = series;
        this.minMaxDone[n] = this.minMaxDone[n] + 1;
        if (this.minMaxDone[series] == this.getImageCount()) {
            MetadataStore store = this.getMetadataStore();
            c = 0;
            while (c < this.getSizeC()) {
                store.setChannelGlobalMinMax(c, new Double(this.chanMin[series][c]), new Double(this.chanMax[series][c]), new Integer(this.getSeries()));
                ++c;
            }
        }
    }

    protected void initMinMax() throws FormatException, IOException {
        int numRGB;
        int i;
        int seriesCount = this.getSeriesCount();
        int oldSeries = this.getSeries();
        if (this.chanMin == null) {
            this.chanMin = new double[seriesCount][];
            i = 0;
            while (i < seriesCount) {
                this.setSeries(i);
                this.chanMin[i] = new double[this.getSizeC()];
                Arrays.fill(this.chanMin[i], Double.POSITIVE_INFINITY);
                ++i;
            }
            this.setSeries(oldSeries);
        }
        if (this.chanMax == null) {
            this.chanMax = new double[seriesCount][];
            i = 0;
            while (i < seriesCount) {
                this.setSeries(i);
                this.chanMax[i] = new double[this.getSizeC()];
                Arrays.fill(this.chanMax[i], Double.NEGATIVE_INFINITY);
                ++i;
            }
            this.setSeries(oldSeries);
        }
        if (this.planeMin == null) {
            this.planeMin = new double[seriesCount][];
            i = 0;
            while (i < seriesCount) {
                this.setSeries(i);
                numRGB = this.getRGBChannelCount();
                this.planeMin[i] = new double[this.getImageCount() * numRGB];
                Arrays.fill(this.planeMin[i], Double.NaN);
                ++i;
            }
            this.setSeries(oldSeries);
        }
        if (this.planeMax == null) {
            this.planeMax = new double[seriesCount][];
            i = 0;
            while (i < seriesCount) {
                this.setSeries(i);
                numRGB = this.getRGBChannelCount();
                this.planeMax[i] = new double[this.getImageCount() * numRGB];
                Arrays.fill(this.planeMax[i], Double.NaN);
                ++i;
            }
            this.setSeries(oldSeries);
        }
        if (this.minMaxDone == null) {
            this.minMaxDone = new int[seriesCount];
        }
    }

    public BufferedImage openImage(String id, int no) throws FormatException, IOException {
        this.setId(id);
        BufferedImage b = super.openImage(no);
        this.updateMinMax(b, no);
        return b;
    }

    public byte[] openBytes(String id, int no) throws FormatException, IOException {
        this.setId(id);
        byte[] b = super.openBytes(no);
        this.updateMinMax(b, no);
        return b;
    }

    public byte[] openBytes(String id, int no, byte[] buf) throws FormatException, IOException {
        this.setId(id);
        super.openBytes(no, buf);
        this.updateMinMax(buf, no);
        return buf;
    }
}

