/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import loci.formats.ClassList;
import loci.formats.ConsoleTools;
import loci.formats.FormatException;
import loci.formats.IFormatWriter;
import loci.formats.LogTools;
import loci.formats.StatusListener;

public class ImageWriter
implements IFormatWriter {
    private static ClassList defaultClasses;
    protected IFormatWriter[] writers;
    private String[] suffixes;
    protected String[] compressionTypes;
    protected String currentId;
    protected int current;

    private static ClassList getDefaultWriterClasses() {
        if (defaultClasses == null) {
            try {
                defaultClasses = new ClassList("writers.txt", IFormatWriter.class);
            }
            catch (IOException exc) {
                defaultClasses = new ClassList(IFormatWriter.class);
                LogTools.trace(exc);
            }
        }
        return defaultClasses;
    }

    public ImageWriter() {
        this(ImageWriter.getDefaultWriterClasses());
    }

    public ImageWriter(ClassList classList) {
        Vector<IFormatWriter> v = new Vector<IFormatWriter>();
        Class[] c = classList.getClasses();
        int i = 0;
        while (i < c.length) {
            IFormatWriter writer = null;
            try {
                writer = (IFormatWriter)c[i].newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            if (writer == null) {
                LogTools.println("Error: " + c[i].getName() + " cannot be instantiated.");
            } else {
                v.add(writer);
            }
            ++i;
        }
        this.writers = new IFormatWriter[v.size()];
        v.copyInto(this.writers);
    }

    public String getFormat(String id) throws FormatException, IOException {
        return this.getWriter(id).getFormat();
    }

    public IFormatWriter getWriter(String id) throws FormatException {
        if (!id.equals(this.currentId)) {
            boolean success = false;
            int i = 0;
            while (i < this.writers.length) {
                if (this.writers[i].isThisType(id)) {
                    this.current = i;
                    this.currentId = id;
                    success = true;
                    break;
                }
                ++i;
            }
            if (!success) {
                throw new FormatException("Unknown file format: " + id);
            }
        }
        return this.writers[this.current];
    }

    public IFormatWriter getWriter() {
        return this.writers[this.current];
    }

    public IFormatWriter getWriter(Class c) {
        int i = 0;
        while (i < this.writers.length) {
            if (this.writers[i].getClass().equals(c)) {
                return this.writers[i];
            }
            ++i;
        }
        return null;
    }

    public IFormatWriter[] getWriters() {
        IFormatWriter[] w = new IFormatWriter[this.writers.length];
        System.arraycopy(this.writers, 0, w, 0, this.writers.length);
        return w;
    }

    public void saveBytes(byte[] bytes, boolean last) throws FormatException, IOException {
        this.getWriter().saveBytes(bytes, last);
    }

    public void saveImage(Image image, boolean last) throws FormatException, IOException {
        this.getWriter().saveImage(image, last);
    }

    public boolean canDoStacks() {
        return this.getWriter().canDoStacks();
    }

    public void setColorModel(ColorModel cm) {
        int i = 0;
        while (i < this.writers.length) {
            this.writers[i].setColorModel(cm);
            ++i;
        }
    }

    public ColorModel getColorModel() {
        return this.writers[0].getColorModel();
    }

    public void setFramesPerSecond(int rate) {
        int i = 0;
        while (i < this.writers.length) {
            this.writers[i].setFramesPerSecond(rate);
            ++i;
        }
    }

    public int getFramesPerSecond() {
        return this.writers[0].getFramesPerSecond();
    }

    public String[] getCompressionTypes() {
        if (this.compressionTypes == null) {
            HashSet<String> set = new HashSet<String>();
            int i = 0;
            while (i < this.writers.length) {
                String[] s = this.writers[i].getCompressionTypes();
                if (s != null) {
                    int j = 0;
                    while (j < s.length) {
                        set.add(s[j]);
                        ++j;
                    }
                }
                ++i;
            }
            this.compressionTypes = new String[set.size()];
            set.toArray(this.compressionTypes);
            Arrays.sort(this.compressionTypes);
        }
        return this.compressionTypes;
    }

    public int[] getPixelTypes() {
        return this.getWriter().getPixelTypes();
    }

    public boolean isSupportedType(int type) {
        return this.getWriter().isSupportedType(type);
    }

    public void setCompression(String compress) throws FormatException {
        boolean ok = false;
        int i = 0;
        while (i < this.writers.length) {
            String[] s = this.writers[i].getCompressionTypes();
            int j = 0;
            while (j < s.length) {
                if (s[j].equals(compress)) {
                    this.writers[i].setCompression(compress);
                    ok = true;
                }
                ++j;
            }
            ++i;
        }
        if (!ok) {
            throw new FormatException("Invalid compression type: " + compress);
        }
    }

    public boolean isThisType(String name) {
        return this.isThisType(name, false);
    }

    public boolean isThisType(String name, boolean open) {
        int i = 0;
        while (i < this.writers.length) {
            if (this.writers[i].isThisType(name, open)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getFormat() {
        return this.getWriter().getFormat();
    }

    public String[] getSuffixes() {
        if (this.suffixes == null) {
            HashSet<String> suffixSet = new HashSet<String>();
            int i = 0;
            while (i < this.writers.length) {
                String[] suf = this.writers[i].getSuffixes();
                int j = 0;
                while (j < suf.length) {
                    suffixSet.add(suf[j]);
                    ++j;
                }
                ++i;
            }
            this.suffixes = new String[suffixSet.size()];
            suffixSet.toArray(this.suffixes);
            Arrays.sort(this.suffixes);
        }
        return this.suffixes;
    }

    public void setId(String id) throws FormatException, IOException {
        this.getWriter(id).setId(id);
    }

    public void setId(String id, boolean force) throws FormatException, IOException {
        this.getWriter(id).setId(id, force);
    }

    public void close() throws IOException {
        int i = 0;
        while (i < this.writers.length) {
            this.writers[i].close();
            ++i;
        }
    }

    public void addStatusListener(StatusListener l) {
        int i = 0;
        while (i < this.writers.length) {
            this.writers[i].addStatusListener(l);
            ++i;
        }
    }

    public void removeStatusListener(StatusListener l) {
        int i = 0;
        while (i < this.writers.length) {
            this.writers[i].removeStatusListener(l);
            ++i;
        }
    }

    public StatusListener[] getStatusListeners() {
        return this.writers[0].getStatusListeners();
    }

    public static void main(String[] args) throws FormatException, IOException {
        if (!ConsoleTools.testConvert(new ImageWriter(), args)) {
            System.exit(1);
        }
    }

    public boolean canDoStacks(String id) throws FormatException {
        try {
            this.setId(id);
        }
        catch (IOException exc) {
            throw new FormatException(exc);
        }
        return this.canDoStacks(id);
    }

    public int[] getPixelTypes(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getPixelTypes(id);
    }

    public boolean isSupportedType(String id, int type) throws FormatException, IOException {
        this.setId(id);
        return this.isSupportedType(type);
    }

    public void save(String id, Image image, boolean last) throws FormatException, IOException {
        this.setId(id);
        this.saveImage(image, last);
    }
}

