/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import loci.formats.DataTools;
import loci.formats.LogTools;

public final class ImageTools {
    protected static final Component OBS = new Container();

    private ImageTools() {
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved, int bps, boolean little) {
        return ImageTools.makeImage(data, w, h, c, interleaved, bps, little, null);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved, int bps, boolean little, int[] bits) {
        Object pixels = DataTools.makeDataArray(data, bps % 3 == 0 ? bps / 3 : bps, false, little);
        if (pixels instanceof byte[]) {
            return ImageTools.makeImage((byte[])pixels, w, h, c, interleaved, bits);
        }
        if (pixels instanceof short[]) {
            return ImageTools.makeImage((short[])pixels, w, h, c, interleaved, bits);
        }
        if (pixels instanceof int[]) {
            return ImageTools.makeImage((int[])pixels, w, h, c, interleaved, bits);
        }
        if (pixels instanceof float[]) {
            return ImageTools.makeImage((float[])pixels, w, h, c, interleaved, bits);
        }
        if (pixels instanceof double[]) {
            return ImageTools.makeImage((double[])pixels, w, h, c, interleaved, bits);
        }
        return null;
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved) {
        return ImageTools.makeImage(data, w, h, c, interleaved, null);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved, int[] bits) {
        if (c == 1) {
            return ImageTools.makeImage(data, w, h, bits);
        }
        int dataType = 0;
        if (c == 2) {
            byte[] tmp = data;
            data = new byte[tmp.length / 2 * 3];
            if (interleaved) {
                int i = 0;
                while (i < tmp.length / 2) {
                    data[i * 3] = tmp[i * 2];
                    data[i * 3 + 1] = tmp[i * 2 + 1];
                    ++i;
                }
            } else {
                System.arraycopy(tmp, 0, data, 0, tmp.length);
            }
            ++c;
        }
        DataBufferByte buffer = new DataBufferByte(data, c * w * h);
        return ImageTools.constructImage(c, dataType, w, h, interleaved, buffer, bits);
    }

    public static BufferedImage makeImage(short[] data, int w, int h, int c, boolean interleaved) {
        return ImageTools.makeImage(data, w, h, c, interleaved, null);
    }

    public static BufferedImage makeImage(short[] data, int w, int h, int c, boolean interleaved, int[] bits) {
        if (c == 1) {
            return ImageTools.makeImage(data, w, h, bits);
        }
        int dataType = 1;
        if (c == 2) {
            short[] tmp = data;
            data = new short[tmp.length / 2 * 3];
            if (interleaved) {
                int i = 0;
                while (i < tmp.length / 2) {
                    data[i * 3] = tmp[i * 2];
                    data[i * 3 + 1] = tmp[i * 2 + 1];
                    ++i;
                }
            } else {
                System.arraycopy(tmp, 0, data, 0, tmp.length);
            }
            ++c;
        }
        DataBufferUShort buffer = new DataBufferUShort(data, c * w * h);
        return ImageTools.constructImage(c, dataType, w, h, interleaved, buffer, bits);
    }

    public static BufferedImage makeImage(int[] data, int w, int h, int c, boolean interleaved) {
        return ImageTools.makeImage(data, w, h, c, interleaved, null);
    }

    public static BufferedImage makeImage(int[] data, int w, int h, int c, boolean interleaved, int[] bits) {
        if (c == 1) {
            return ImageTools.makeImage(data, w, h, bits);
        }
        int dataType = 3;
        if (c == 2) {
            int[] tmp = data;
            data = new int[tmp.length / 2 * 3];
            if (interleaved) {
                int i = 0;
                while (i < tmp.length / 2) {
                    data[i * 3] = tmp[i * 2];
                    data[i * 3 + 1] = tmp[i * 2 + 1];
                    ++i;
                }
            } else {
                System.arraycopy(tmp, 0, data, 0, tmp.length);
            }
            ++c;
        }
        DataBufferInt buffer = new DataBufferInt(data, c * w * h);
        return ImageTools.constructImage(c, dataType, w, h, interleaved, buffer, bits);
    }

    public static BufferedImage makeImage(float[] data, int w, int h, int c, boolean interleaved) {
        return ImageTools.makeImage(data, w, h, c, interleaved, null);
    }

    public static BufferedImage makeImage(float[] data, int w, int h, int c, boolean interleaved, int[] bits) {
        if (c == 1) {
            return ImageTools.makeImage(data, w, h, bits);
        }
        int dataType = 4;
        if (c == 2) {
            float[] tmp = data;
            data = new float[tmp.length / 2 * 3];
            if (interleaved) {
                int i = 0;
                while (i < tmp.length / 2) {
                    data[i * 3] = tmp[i * 2];
                    data[i * 3 + 1] = tmp[i * 2 + 1];
                    ++i;
                }
            } else {
                System.arraycopy(tmp, 0, data, 0, tmp.length);
            }
            ++c;
        }
        DataBufferFloat buffer = new DataBufferFloat(data, c * w * h);
        return ImageTools.constructImage(c, dataType, w, h, interleaved, buffer, bits);
    }

    public static BufferedImage makeImage(double[] data, int w, int h, int c, boolean interleaved) {
        return ImageTools.makeImage(data, w, h, c, interleaved, null);
    }

    public static BufferedImage makeImage(double[] data, int w, int h, int c, boolean interleaved, int[] bits) {
        if (c == 1) {
            return ImageTools.makeImage(data, w, h, bits);
        }
        int dataType = 5;
        if (c == 2) {
            double[] tmp = data;
            data = new double[tmp.length / 2 * 3];
            if (interleaved) {
                int i = 0;
                while (i < tmp.length / 2) {
                    data[i * 3] = tmp[i * 2];
                    data[i * 3 + 1] = tmp[i * 2 + 1];
                    ++i;
                }
            } else {
                System.arraycopy(tmp, 0, data, 0, tmp.length);
            }
            ++c;
        }
        DataBufferDouble buffer = new DataBufferDouble(data, c * w * h);
        return ImageTools.constructImage(c, dataType, w, h, interleaved, buffer, bits);
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h, int bps, boolean little) {
        return ImageTools.makeImage(data, w, h, bps, little, null);
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h, int bps, boolean little, int[] bits) {
        if (bps == 1) {
            return ImageTools.makeImage(data, w, h, bits);
        }
        if (bps == 2) {
            short[][] shorts = new short[data.length][data[0].length / bps];
            int i = 0;
            while (i < shorts.length) {
                int j = 0;
                while (j < shorts[0].length) {
                    shorts[i][j] = DataTools.bytesToShort(data[i], j * 2, 2, little);
                    ++j;
                }
                ++i;
            }
            return ImageTools.makeImage(shorts, w, h, bits);
        }
        if (bps == 4) {
            float[][] floats = new float[data.length][data[0].length / bps];
            int i = 0;
            while (i < floats.length) {
                int j = 0;
                while (j < floats[0].length) {
                    floats[i][j] = Float.intBitsToFloat(DataTools.bytesToInt(data[i], j * 4, 4, little));
                    ++j;
                }
                ++i;
            }
            return ImageTools.makeImage(floats, w, h, bits);
        }
        double[][] doubles = new double[data.length][data[0].length / bps];
        int i = 0;
        while (i < doubles.length) {
            int j = 0;
            while (j < doubles[0].length) {
                doubles[i][j] = Double.longBitsToDouble(DataTools.bytesToLong(data[i], j * bps, bps, little));
                ++j;
            }
            ++i;
        }
        return ImageTools.makeImage(doubles, w, h, bits);
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h) {
        return ImageTools.makeImage(data, w, h, null);
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h, int[] bits) {
        int dataType = 0;
        ColorModel colorModel = ImageTools.makeColorModel(data.length, dataType, bits);
        if (colorModel == null) {
            return null;
        }
        BandedSampleModel model = new BandedSampleModel(dataType, w, h, data.length);
        DataBufferByte buffer = new DataBufferByte(data, data[0].length);
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage makeImage(short[][] data, int w, int h) {
        return ImageTools.makeImage(data, w, h, null);
    }

    public static BufferedImage makeImage(short[][] data, int w, int h, int[] bits) {
        int dataType = 1;
        ColorModel colorModel = ImageTools.makeColorModel(data.length, dataType, bits);
        if (colorModel == null) {
            return null;
        }
        BandedSampleModel model = new BandedSampleModel(dataType, w, h, data.length);
        DataBufferUShort buffer = new DataBufferUShort(data, data[0].length);
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage makeImage(int[][] data, int w, int h) {
        return ImageTools.makeImage(data, w, h, null);
    }

    public static BufferedImage makeImage(int[][] data, int w, int h, int[] bits) {
        int dataType = 3;
        ColorModel colorModel = ImageTools.makeColorModel(data.length, dataType, bits);
        if (colorModel == null) {
            return null;
        }
        BandedSampleModel model = new BandedSampleModel(dataType, w, h, data.length);
        DataBufferInt buffer = new DataBufferInt(data, data[0].length);
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage makeImage(float[][] data, int w, int h) {
        return ImageTools.makeImage(data, w, h, null);
    }

    public static BufferedImage makeImage(float[][] data, int w, int h, int[] bits) {
        int dataType = 4;
        ColorModel colorModel = ImageTools.makeColorModel(data.length, dataType, bits);
        if (colorModel == null) {
            return null;
        }
        BandedSampleModel model = new BandedSampleModel(dataType, w, h, data.length);
        DataBufferFloat buffer = new DataBufferFloat(data, data[0].length);
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage makeImage(double[][] data, int w, int h) {
        return ImageTools.makeImage(data, w, h, null);
    }

    public static BufferedImage makeImage(double[][] data, int w, int h, int[] bits) {
        int dataType = 5;
        ColorModel colorModel = ImageTools.makeColorModel(data.length, dataType, bits);
        if (colorModel == null) {
            return null;
        }
        BandedSampleModel model = new BandedSampleModel(dataType, w, h, data.length);
        DataBufferDouble buffer = new DataBufferDouble(data, data[0].length);
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h) {
        return ImageTools.makeImage(data, w, h, null);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int[] bits) {
        return ImageTools.makeImage(new byte[][]{data}, w, h, bits);
    }

    public static BufferedImage makeImage(short[] data, int w, int h) {
        return ImageTools.makeImage(data, w, h, null);
    }

    public static BufferedImage makeImage(short[] data, int w, int h, int[] bits) {
        return ImageTools.makeImage(new short[][]{data}, w, h, bits);
    }

    public static BufferedImage makeImage(int[] data, int w, int h) {
        return ImageTools.makeImage(data, w, h, null);
    }

    public static BufferedImage makeImage(int[] data, int w, int h, int[] bits) {
        return ImageTools.makeImage(new int[][]{data}, w, h, bits);
    }

    public static BufferedImage makeImage(float[] data, int w, int h) {
        return ImageTools.makeImage(data, w, h, null);
    }

    public static BufferedImage makeImage(float[] data, int w, int h, int[] bits) {
        return ImageTools.makeImage(new float[][]{data}, w, h, bits);
    }

    public static BufferedImage makeImage(double[] data, int w, int h) {
        return ImageTools.makeImage(data, w, h, null);
    }

    public static BufferedImage makeImage(double[] data, int w, int h, int[] bits) {
        return ImageTools.makeImage(new double[][]{data}, w, h, bits);
    }

    public static BufferedImage blankImage(int w, int h, int c, int type) {
        int tt = 0;
        DataBuffer buffer = null;
        switch (type) {
            case 0: 
            case 1: {
                tt = 0;
                buffer = new DataBufferByte(new byte[c * w * h], c * w * h);
                break;
            }
            case 2: 
            case 3: {
                tt = 1;
                buffer = new DataBufferUShort(new short[c * w * h], c * w * h);
                break;
            }
            case 4: 
            case 5: {
                tt = 3;
                buffer = new DataBufferInt(new int[c * w * h], c * w * h);
                break;
            }
            case 6: {
                tt = 4;
                buffer = new DataBufferFloat(new float[c * w * h], c * w * h);
                break;
            }
            case 7: {
                tt = 5;
                buffer = new DataBufferDouble(new double[c * w * h], c * w * h);
            }
        }
        return ImageTools.constructImage(c, tt, w, h, true, buffer, null);
    }

    private static BufferedImage constructImage(int c, int type, int w, int h, boolean interleaved, DataBuffer buffer, int[] bits) {
        int scanlineStride;
        ColorModel colorModel = ImageTools.makeColorModel(c, type, bits);
        if (colorModel == null) {
            return null;
        }
        int pixelStride = interleaved ? c : 1;
        int n = scanlineStride = interleaved ? c * w : w;
        if (c == 2) {
            ++c;
        }
        int[] bandOffsets = new int[c];
        int i = 0;
        while (i < c) {
            bandOffsets[i] = interleaved ? i : i * w * h;
            ++i;
        }
        ComponentSampleModel model = new ComponentSampleModel(type, w, h, pixelStride, scanlineStride, bandOffsets);
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static Object getPixels(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        int tt = raster.getTransferType();
        if (tt == 0) {
            return ImageTools.getBytes(image);
        }
        if (tt == 1) {
            return ImageTools.getShorts(image);
        }
        if (tt == 3) {
            return ImageTools.getInts(image);
        }
        if (tt == 4) {
            return ImageTools.getFloats(image);
        }
        if (tt == 5) {
            return ImageTools.getDoubles(image);
        }
        return null;
    }

    public static byte[][] getBytes(BufferedImage image) {
        SampleModel model;
        DataBuffer buffer;
        int dataType = 0;
        WritableRaster r = image.getRaster();
        int tt = r.getTransferType();
        if (tt == dataType && (buffer = r.getDataBuffer()) instanceof DataBufferByte && (model = r.getSampleModel()) instanceof BandedSampleModel) {
            return ((DataBufferByte)buffer).getBankData();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        ColorModel colorModel = ImageTools.makeColorModel(c, dataType, null);
        if (colorModel == null) {
            return null;
        }
        BandedSampleModel model2 = new BandedSampleModel(dataType, w, h, c);
        DataBufferByte buffer2 = new DataBufferByte(w * h, c);
        WritableRaster raster = Raster.createWritableRaster(model2, buffer2, null);
        BufferedImage target = new BufferedImage(colorModel, raster, false, null);
        Graphics2D g2 = target.createGraphics();
        g2.drawRenderedImage(image, null);
        g2.dispose();
        return ImageTools.getBytes(target);
    }

    public static short[][] getShorts(BufferedImage image) {
        DataBuffer buffer;
        WritableRaster r = image.getRaster();
        int tt = r.getTransferType();
        if (tt == 1 && (buffer = r.getDataBuffer()) instanceof DataBufferUShort) {
            return ((DataBufferUShort)buffer).getBankData();
        }
        return ImageTools.getShorts(ImageTools.makeType(image, 1));
    }

    public static int[][] getInts(BufferedImage image) {
        SampleModel model;
        DataBuffer buffer;
        WritableRaster r = image.getRaster();
        int tt = r.getTransferType();
        if (tt == 3 && (buffer = r.getDataBuffer()) instanceof DataBufferInt && (model = r.getSampleModel()) instanceof BandedSampleModel) {
            return ((DataBufferInt)buffer).getBankData();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        int[][] samples = new int[c][w * h];
        int i = 0;
        while (i < c) {
            r.getSamples(0, 0, w, h, i, samples[i]);
            ++i;
        }
        return samples;
    }

    public static float[][] getFloats(BufferedImage image) {
        SampleModel model;
        DataBuffer buffer;
        WritableRaster r = image.getRaster();
        int tt = r.getTransferType();
        if (tt == 4 && (buffer = r.getDataBuffer()) instanceof DataBufferFloat && (model = r.getSampleModel()) instanceof BandedSampleModel) {
            return ((DataBufferFloat)buffer).getBankData();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        float[][] samples = new float[c][w * h];
        int i = 0;
        while (i < c) {
            r.getSamples(0, 0, w, h, i, samples[i]);
            ++i;
        }
        return samples;
    }

    public static double[][] getDoubles(BufferedImage image) {
        SampleModel model;
        DataBuffer buffer;
        WritableRaster r = image.getRaster();
        int tt = r.getTransferType();
        if (tt == 5 && (buffer = r.getDataBuffer()) instanceof DataBufferDouble && (model = r.getSampleModel()) instanceof BandedSampleModel) {
            return ((DataBufferDouble)buffer).getBankData();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        double[][] samples = new double[c][w * h];
        int i = 0;
        while (i < c) {
            r.getSamples(0, 0, w, h, i, samples[i]);
            ++i;
        }
        return samples;
    }

    public static byte[][] getPixelBytes(BufferedImage img, boolean little) {
        Object pixels = ImageTools.getPixels(img);
        if (pixels instanceof byte[][]) {
            return (byte[][])pixels;
        }
        if (pixels instanceof short[][]) {
            short[][] s = (short[][])pixels;
            byte[][] b = new byte[s.length][s[0].length * 2];
            int i = 0;
            while (i < b.length) {
                int j = 0;
                while (j < s[0].length) {
                    short v = s[i][j];
                    if (little) {
                        b[i][j * 2] = (byte)(v & 0xFF);
                        b[i][j * 2 + 1] = (byte)(v >>> 8 & 0xFF);
                    } else {
                        b[i][j * 2] = (byte)(v >>> 8 & 0xFF);
                        b[i][j * 2 + 1] = (byte)(v & 0xFF);
                    }
                    ++j;
                }
                ++i;
            }
            return b;
        }
        if (pixels instanceof int[][]) {
            int[][] in = (int[][])pixels;
            byte[][] b = new byte[in.length][in[0].length * 4];
            int i = 0;
            while (i < b.length) {
                int j = 0;
                while (j < in[0].length) {
                    int v = in[i][j];
                    if (little) {
                        b[i][j * 4] = (byte)(v & 0xFF);
                        b[i][j * 4 + 1] = (byte)(v >> 8 & 0xFF);
                        b[i][j * 4 + 2] = (byte)(v >> 16 & 0xFF);
                        b[i][j * 4 + 3] = (byte)(v >> 24 & 0xFF);
                    } else {
                        b[i][j * 4] = (byte)(v >> 24 & 0xFF);
                        b[i][j * 4 + 1] = (byte)(v >> 16 & 0xFF);
                        b[i][j * 4 + 2] = (byte)(v >> 8 & 0xFF);
                        b[i][j * 4 + 3] = (byte)(v & 0xFF);
                    }
                    ++j;
                }
                ++i;
            }
            return b;
        }
        if (pixels instanceof float[][]) {
            float[][] in = (float[][])pixels;
            byte[][] b = new byte[in.length][in[0].length * 4];
            int i = 0;
            while (i < b.length) {
                int j = 0;
                while (j < in[0].length) {
                    int v = Float.floatToIntBits(in[i][j]);
                    if (little) {
                        b[i][j * 4] = (byte)(v & 0xFF);
                        b[i][j * 4 + 1] = (byte)(v >> 8 & 0xFF);
                        b[i][j * 4 + 2] = (byte)(v >> 16 & 0xFF);
                        b[i][j * 4 + 3] = (byte)(v >> 24 & 0xFF);
                    } else {
                        b[i][j * 4] = (byte)(v >> 24 & 0xFF);
                        b[i][j * 4 + 1] = (byte)(v >> 16 & 0xFF);
                        b[i][j * 4 + 2] = (byte)(v >> 8 & 0xFF);
                        b[i][j * 4 + 3] = (byte)(v & 0xFF);
                    }
                    ++j;
                }
                ++i;
            }
            return b;
        }
        boolean cfr_ignored_0 = pixels instanceof double[][];
        return null;
    }

    public static int getPixelType(BufferedImage image) {
        int type = image.getRaster().getDataBuffer().getDataType();
        switch (type) {
            case 0: {
                return 1;
            }
            case 5: {
                return 7;
            }
            case 4: {
                return 6;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 3;
            }
        }
        return -1;
    }

    public static BufferedImage makeType(BufferedImage image, int type) {
        WritableRaster r = image.getRaster();
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        ColorModel colorModel = ImageTools.makeColorModel(c, type, null);
        if (colorModel == null) {
            return null;
        }
        int s = w * h;
        DataBuffer buf = null;
        if (type == 0) {
            buf = new DataBufferByte(s, c);
        } else if (type == 1) {
            buf = new DataBufferUShort(s, c);
        } else if (type == 3) {
            buf = new DataBufferInt(s, c);
        } else if (type == 2) {
            buf = new DataBufferShort(s, c);
        } else if (type == 4) {
            buf = new DataBufferFloat(s, c);
        } else if (type == 5) {
            buf = new DataBufferDouble(s, c);
        }
        if (buf == null) {
            return null;
        }
        BandedSampleModel model = new BandedSampleModel(type, w, h, c);
        WritableRaster raster = Raster.createWritableRaster(model, buf, null);
        BufferedImage target = new BufferedImage(colorModel, raster, false, null);
        Graphics2D g2 = target.createGraphics();
        g2.drawRenderedImage(image, null);
        g2.dispose();
        return target;
    }

    public static byte[] getBytes(BufferedImage img, boolean separated, int c) {
        byte[][] p = ImageTools.getBytes(img);
        if (separated || p.length == 1) {
            return p[0];
        }
        byte[] rtn = new byte[p.length * p[0].length];
        int i = 0;
        while (i < p.length) {
            System.arraycopy(p[i], 0, rtn, i * p[0].length, p[i].length);
            ++i;
        }
        return rtn;
    }

    public static byte[][] make24Bits(Object pixels, int w, int h, boolean interleaved, boolean reverse) {
        int[] pix = ImageTools.make24Bits(pixels, w, h, interleaved);
        byte[][] rtn = new byte[3][pix.length];
        int i = 0;
        while (i < pix.length) {
            byte r = (byte)(pix[i] >> 16 & 0xFF);
            rtn[1][i] = (byte)(pix[i] >> 8 & 0xFF);
            byte b = (byte)(pix[i] & 0xFF);
            rtn[0][i] = reverse ? b : r;
            rtn[2][i] = reverse ? r : b;
            ++i;
        }
        return rtn;
    }

    public static int[] make24Bits(Object pixels, int w, int h, boolean interleaved) {
        int i;
        Object[] s;
        int[] rtn = new int[w * h];
        int stride = interleaved ? w * h : 1;
        byte[] b = null;
        if (pixels instanceof byte[]) {
            b = (byte[])pixels;
        } else if (pixels instanceof short[]) {
            s = (short[])pixels;
            b = new byte[s.length];
            i = 0;
            while (i < s.length) {
                int v = s[i] & 0xFFFF;
                b[i] = (byte)v;
                ++i;
            }
        } else if (pixels instanceof int[]) {
            s = (int[])pixels;
            b = new byte[s.length];
            i = 0;
            while (i < s.length) {
                int value = s[i] & 0xFFFFFFFF;
                b[i] = (byte)value;
                ++i;
            }
        } else if (pixels instanceof float[]) {
            s = (float[])pixels;
            b = new byte[s.length];
            i = 0;
            while (i < s.length) {
                short value = s[i];
                b[i] = (byte)(255.0f * value);
                ++i;
            }
        } else if (pixels instanceof double[]) {
            s = (double[])pixels;
            b = new byte[s.length];
            i = 0;
            while (i < s.length) {
                short value = s[i];
                b[i] = (byte)Math.round((double)value);
                ++i;
            }
        }
        int c = b.length / rtn.length;
        i = 0;
        while (i < rtn.length) {
            byte[] a = new byte[4];
            int j = c - 1;
            while (j >= 0) {
                a[j] = b[interleaved ? i * c + j : i + j * w * h];
                --j;
            }
            if (c == 1) {
                j = 1;
                while (j < a.length) {
                    a[j] = a[0];
                    ++j;
                }
            }
            byte tmp = a[0];
            a[0] = a[2];
            a[2] = tmp;
            rtn[i] = DataTools.bytesToInt(a, true);
            ++i;
        }
        return rtn;
    }

    public static byte[][] splitChannels(byte[] array, int c, int bytes, boolean reverse, boolean interleaved) {
        byte[][] rtn = new byte[c][array.length / c];
        if (interleaved) {
            if (reverse) {
                int offset = 0;
                int i = c - 1;
                while (i >= 0) {
                    System.arraycopy(array, offset, rtn[i], 0, rtn[i].length);
                    offset += rtn[c].length;
                    --i;
                }
            } else {
                int i = 0;
                while (i < c) {
                    System.arraycopy(array, i * rtn[i].length, rtn[i], 0, rtn[i].length);
                    ++i;
                }
            }
        } else if (reverse) {
            int next = 0;
            int i = 0;
            while (i < array.length) {
                int j = c - 1;
                while (j >= 0) {
                    int k = 0;
                    while (k < bytes) {
                        if (next < rtn[j].length) {
                            rtn[c - j - 1][next] = array[i + j * bytes + k];
                        }
                        ++next;
                        ++k;
                    }
                    next -= bytes;
                    --j;
                }
                next += bytes;
                i += c * bytes;
            }
        } else {
            int next = 0;
            int i = 0;
            while (i < array.length) {
                int j = 0;
                while (j < c) {
                    int k = 0;
                    while (k < bytes) {
                        if (next < rtn[j].length) {
                            rtn[j][next] = array[i + j * bytes + k];
                        }
                        ++next;
                        ++k;
                    }
                    next -= bytes;
                    ++j;
                }
                next += bytes;
                i += c * bytes;
            }
        }
        return rtn;
    }

    public static BufferedImage[] splitChannels(BufferedImage image) {
        BufferedImage[] results;
        block7: {
            Object o;
            int c;
            int h;
            int w;
            block10: {
                block9: {
                    block8: {
                        block6: {
                            w = image.getWidth();
                            h = image.getHeight();
                            c = image.getRaster().getNumBands();
                            if (c == 1) {
                                return new BufferedImage[]{image};
                            }
                            results = new BufferedImage[c];
                            o = ImageTools.getPixels(image);
                            if (!(o instanceof byte[][])) break block6;
                            byte[][] pix = (byte[][])o;
                            int i = 0;
                            while (i < c) {
                                results[i] = ImageTools.makeImage(pix[i], w, h);
                                ++i;
                            }
                            break block7;
                        }
                        if (!(o instanceof short[][])) break block8;
                        short[][] pix = (short[][])o;
                        int i = 0;
                        while (i < c) {
                            results[i] = ImageTools.makeImage(pix[i], w, h);
                            ++i;
                        }
                        break block7;
                    }
                    if (!(o instanceof int[][])) break block9;
                    int[][] pix = (int[][])o;
                    int i = 0;
                    while (i < c) {
                        results[i] = ImageTools.makeImage(pix[i], w, h);
                        ++i;
                    }
                    break block7;
                }
                if (!(o instanceof float[][])) break block10;
                float[][] pix = (float[][])o;
                int i = 0;
                while (i < c) {
                    results[i] = ImageTools.makeImage(pix[i], w, h);
                    ++i;
                }
                break block7;
            }
            if (!(o instanceof double[][])) break block7;
            double[][] pix = (double[][])o;
            int i = 0;
            while (i < c) {
                results[i] = ImageTools.makeImage(pix[i], w, h);
                ++i;
            }
        }
        return results;
    }

    public static BufferedImage mergeChannels(BufferedImage[] images) {
        int[] validBits;
        if (images == null || images.length == 0) {
            return null;
        }
        Object[] list = new Object[images.length];
        int c = 0;
        int type = 0;
        int i = 0;
        while (i < images.length) {
            Object o = ImageTools.getPixels(images[i]);
            if (o instanceof byte[][]) {
                if (i == 0) {
                    type = 0;
                } else if (type != 0) {
                    return null;
                }
                c += ((byte[][])o).length;
            } else if (o instanceof short[][]) {
                if (i == 0) {
                    type = 1;
                } else if (type != 1) {
                    return null;
                }
                c += ((short[][])o).length;
            } else if (o instanceof int[][]) {
                if (i == 0) {
                    type = 3;
                } else if (type != 3) {
                    return null;
                }
                c += ((int[][])o).length;
            } else if (o instanceof float[][]) {
                if (i == 0) {
                    type = 4;
                } else if (type != 4) {
                    return null;
                }
                c += ((float[][])o).length;
            } else if (o instanceof double[][]) {
                if (i == 0) {
                    type = 5;
                } else if (type != 5) {
                    return null;
                }
                c += ((double[][])o).length;
            }
            if (c > 4) {
                return null;
            }
            list[i] = o;
            ++i;
        }
        if (c < 1 || c > 4) {
            return null;
        }
        if (c == 2) {
            c = 3;
        }
        if ((validBits = images[0].getColorModel().getComponentSize()).length < images.length) {
            int vb = validBits[0];
            validBits = new int[c];
            int i2 = 0;
            while (i2 < validBits.length) {
                validBits[i2] = vb;
                ++i2;
            }
        }
        int w = images[0].getWidth();
        int h = images[0].getHeight();
        if (type == 0) {
            byte[][] pix = new byte[c][];
            int ndx = 0;
            int i3 = 0;
            while (i3 < list.length) {
                byte[][] b = (byte[][])list[i3];
                int j = 0;
                while (j < b.length) {
                    pix[ndx++] = b[j];
                    ++j;
                }
                ++i3;
            }
            while (ndx < pix.length) {
                pix[ndx++] = new byte[w * h];
            }
            return ImageTools.makeImage(pix, w, h, validBits);
        }
        if (type == 1) {
            short[][] pix = new short[c][];
            int ndx = 0;
            int i4 = 0;
            while (i4 < list.length) {
                short[][] b = (short[][])list[i4];
                int j = 0;
                while (j < b.length) {
                    pix[ndx++] = b[j];
                    ++j;
                }
                ++i4;
            }
            while (ndx < pix.length) {
                pix[ndx++] = new short[w * h];
            }
            return ImageTools.makeImage(pix, w, h, validBits);
        }
        if (type == 3) {
            int[][] pix = new int[c][];
            int ndx = 0;
            int i5 = 0;
            while (i5 < list.length) {
                int[][] b = (int[][])list[i5];
                int j = 0;
                while (j < b.length) {
                    pix[ndx++] = b[j];
                    ++j;
                }
                ++i5;
            }
            while (ndx < pix.length) {
                pix[ndx++] = new int[w * h];
            }
            return ImageTools.makeImage(pix, w, h, validBits);
        }
        if (type == 4) {
            float[][] pix = new float[c][];
            int ndx = 0;
            int i6 = 0;
            while (i6 < list.length) {
                float[][] b = (float[][])list[i6];
                int j = 0;
                while (j < b.length) {
                    pix[ndx++] = b[j];
                    ++j;
                }
                ++i6;
            }
            while (ndx < pix.length) {
                pix[ndx++] = new float[w * h];
            }
            return ImageTools.makeImage(pix, w, h, validBits);
        }
        if (type == 5) {
            double[][] pix = new double[c][];
            int ndx = 0;
            int i7 = 0;
            while (i7 < list.length) {
                double[][] b = (double[][])list[i7];
                int j = 0;
                while (j < b.length) {
                    pix[ndx++] = b[j];
                    ++j;
                }
                ++i7;
            }
            while (ndx < pix.length) {
                pix[ndx++] = new double[w * h];
            }
            return ImageTools.makeImage(pix, w, h, validBits);
        }
        return null;
    }

    public static BufferedImage padImage(BufferedImage img, int width, int height) {
        boolean needsPadding;
        if (img == null) {
            byte[][] data = new byte[1][width * height];
            return ImageTools.makeImage(data, width, height);
        }
        boolean bl = needsPadding = img.getWidth() != width || img.getHeight() != height;
        if (needsPadding) {
            Object pixels = ImageTools.getPixels(img);
            if (pixels instanceof byte[][]) {
                byte[][] b = (byte[][])pixels;
                byte[][] newBytes = new byte[b.length][width * height];
                int i = 0;
                while (i < b.length) {
                    newBytes[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                    ++i;
                }
                return ImageTools.makeImage(newBytes, width, height);
            }
            if (pixels instanceof short[][]) {
                short[][] b = (short[][])pixels;
                short[][] newShorts = new short[b.length][width * height];
                int i = 0;
                while (i < b.length) {
                    newShorts[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                    ++i;
                }
                return ImageTools.makeImage(newShorts, width, height);
            }
            if (pixels instanceof int[][]) {
                int[][] b = (int[][])pixels;
                int[][] newInts = new int[b.length][width * height];
                int i = 0;
                while (i < b.length) {
                    newInts[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                    ++i;
                }
                return ImageTools.makeImage(newInts, width, height);
            }
            if (pixels instanceof float[][]) {
                float[][] b = (float[][])pixels;
                float[][] newFloats = new float[b.length][width * height];
                int i = 0;
                while (i < b.length) {
                    newFloats[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                    ++i;
                }
                return ImageTools.makeImage(newFloats, width, height);
            }
            if (pixels instanceof double[][]) {
                double[][] b = (double[][])pixels;
                double[][] newDoubles = new double[b.length][width * height];
                int i = 0;
                while (i < b.length) {
                    newDoubles[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                    ++i;
                }
                return ImageTools.makeImage(newDoubles, width, height);
            }
            return null;
        }
        return img;
    }

    public static byte[] padImage(byte[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        byte[] padded = new byte[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                int y = 0;
                while (y < h * c) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                    ++y;
                }
            } else {
                int ch = 0;
                while (ch < c) {
                    int y = 0;
                    while (y < h) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                        ++y;
                    }
                    ++ch;
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static short[] padImage(short[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        short[] padded = new short[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                int y = 0;
                while (y < h * c) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                    ++y;
                }
            } else {
                int ch = 0;
                while (ch < c) {
                    int y = 0;
                    while (y < h) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                        ++y;
                    }
                    ++ch;
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static int[] padImage(int[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        int[] padded = new int[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                int y = 0;
                while (y < h * c) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                    ++y;
                }
            } else {
                int ch = 0;
                while (ch < c) {
                    int y = 0;
                    while (y < h) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                        ++y;
                    }
                    ++ch;
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static float[] padImage(float[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        float[] padded = new float[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                int y = 0;
                while (y < h * c) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                    ++y;
                }
            } else {
                int ch = 0;
                while (ch < c) {
                    int y = 0;
                    while (y < h) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                        ++y;
                    }
                    ++ch;
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static double[] padImage(double[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        double[] padded = new double[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                int y = 0;
                while (y < h * c) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                    ++y;
                }
            } else {
                int ch = 0;
                while (ch < c) {
                    int y = 0;
                    while (y < h) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                        ++y;
                    }
                    ++ch;
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static short[][] demosaic(short[][] input, int w, int h) {
        int off;
        int m;
        int off2;
        float sum;
        int diff;
        int j;
        int i = 0;
        while (i < input[0].length) {
            int j2;
            int[] indices;
            int count;
            int sum2;
            boolean needsRed = i / w % 2 != 1 || i % w % 2 != 1;
            boolean needsBlue = i / w % 2 != 0 || i % w % 2 != 0;
            boolean needsGreen = needsBlue ^ needsRed;
            if (needsRed) {
                sum2 = 0;
                count = 0;
                indices = null;
                indices = !needsBlue ? new int[]{i - w - 1, i - w + 1, i + w - 1, i + w + 1} : (i / w % 2 == 1 ? new int[]{i - 1, i + 1} : new int[]{i - w, i + w});
                j2 = 0;
                while (j2 < indices.length) {
                    if (indices[j2] < input[0].length && indices[j2] >= 0) {
                        sum2 += input[0][indices[j2]];
                        ++count;
                    }
                    ++j2;
                }
                if (count > 0) {
                    input[0][i] = (short)(sum2 / count);
                }
            }
            if (needsGreen) {
                sum2 = 0;
                count = 0;
                indices = new int[]{i - w, i - 1, i + 1, i + w};
                j2 = 0;
                while (j2 < indices.length) {
                    if (indices[j2] < input[0].length && indices[j2] >= 0) {
                        sum2 += input[1][indices[j2]];
                        ++count;
                    }
                    ++j2;
                }
                if (count > 0) {
                    input[1][i] = (short)(sum2 / count);
                }
            }
            if (needsBlue) {
                sum2 = 0;
                count = 0;
                indices = null;
                indices = !needsRed ? new int[]{i - w - 1, i - w + 1, i + w - 1, i + w + 1} : (i / w % 2 == 1 ? new int[]{i - w, i + w} : new int[]{i - 1, i + 1});
                j2 = 0;
                while (j2 < indices.length) {
                    if (indices[j2] < input[0].length && indices[j2] >= 0) {
                        sum2 += input[2][indices[j2]];
                        ++count;
                    }
                    ++j2;
                }
                if (count > 0) {
                    input[2][i] = (short)(sum2 / count);
                }
            }
            ++i;
        }
        short[] newRed = new short[w * h];
        short[] newGreen = new short[w * h];
        short[] newBlue = new short[w * h];
        float[][] kernel = new float[5][5];
        kernel[0] = new float[]{0.458f, 0.823f, 1.0f, 0.823f, 0.458f};
        kernel[1] = new float[]{0.823f, 1.0f, 1.09f, 1.0f, 0.823f};
        kernel[2] = new float[]{1.0f, 1.09f, 1.135f, 1.09f, 1.0f};
        kernel[3] = new float[]{0.823f, 1.0f, 1.09f, 1.0f, 0.823f};
        kernel[4] = new float[]{0.458f, 0.823f, 1.0f, 0.823f, 0.458f};
        int i2 = 0;
        while (i2 < h) {
            j = 0;
            while (j < w) {
                float redRow = 0.0f;
                float greenRow = 0.0f;
                float blueRow = 0.0f;
                float[] kernelRow = kernel[i2 % 5];
                diff = w - j;
                sum = 0.0f;
                if (diff < 5) {
                    while (diff > 0) {
                        off2 = i2 * w + j + diff - 1;
                        redRow += kernelRow[diff - 1] * (float)input[0][off2];
                        greenRow += kernelRow[diff - 1] * (float)input[1][off2];
                        blueRow += kernelRow[diff - 1] * (float)input[2][off2];
                        sum += kernelRow[diff - 1];
                        --diff;
                    }
                } else {
                    m = 0;
                    while (m < 5) {
                        off = i2 * w + j + m;
                        redRow += kernelRow[m] * (float)input[0][off];
                        greenRow += kernelRow[m] * (float)input[1][off];
                        blueRow += kernelRow[m] * (float)input[2][off];
                        sum += kernelRow[m];
                        ++m;
                    }
                }
                if (sum == 0.0f) {
                    sum = 1.0f;
                }
                newRed[i2 * w + j] = (short)(redRow / sum);
                newGreen[i2 * w + j] = (short)(greenRow / sum);
                newBlue[i2 * w + j] = (short)(blueRow / sum);
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < h) {
            j = 0;
            while (j < w) {
                float redCol = 0.0f;
                float greenCol = 0.0f;
                float blueCol = 0.0f;
                float[] kernelCol = kernel[j % 5];
                diff = h - i2;
                sum = 0.0f;
                if (diff < 5) {
                    while (diff > 0) {
                        off2 = (i2 + diff - 1) * w + j;
                        redCol += kernelCol[diff - 1] * (float)newRed[off2];
                        greenCol += kernelCol[diff - 1] * (float)newGreen[off2];
                        blueCol += kernelCol[diff - 1] * (float)newBlue[off2];
                        sum += kernelCol[diff - 1];
                        --diff;
                    }
                } else {
                    m = 0;
                    while (m < 5) {
                        off = (i2 + m) * w + j;
                        redCol += kernelCol[m] * (float)newRed[off];
                        greenCol += kernelCol[m] * (float)newGreen[off];
                        blueCol += kernelCol[m] * (float)newBlue[off];
                        sum += kernelCol[m];
                        ++m;
                    }
                }
                if (sum == 0.0f) {
                    sum = 1.0f;
                }
                input[0][i2 * w + j] = (short)(redCol / sum);
                input[1][i2 * w + j] = (short)(greenCol / sum);
                input[2][i2 * w + j] = (short)(blueCol / sum);
                ++j;
            }
            ++i2;
        }
        return input;
    }

    public static BufferedImage autoscale(BufferedImage img, int min, int max) {
        Object pixels = ImageTools.getPixels(img);
        if (pixels instanceof byte[][]) {
            return img;
        }
        if (pixels instanceof short[][]) {
            short[][] shorts = (short[][])pixels;
            byte[][] out = new byte[shorts.length][shorts[0].length];
            int i = 0;
            while (i < out.length) {
                int j = 0;
                while (j < out[i].length) {
                    if (shorts[i][j] < 0) {
                        short[] sArray = shorts[i];
                        int n = j;
                        sArray[n] = (short)(sArray[n] + Short.MAX_VALUE);
                    }
                    float diff = (float)max - (float)min;
                    float dist = (float)(shorts[i][j] - min) / diff;
                    out[i][j] = shorts[i][j] >= max ? -1 : (shorts[i][j] <= min ? 0 : (int)((int)(dist * 256.0f)));
                    ++j;
                }
                ++i;
            }
            return ImageTools.makeImage(out, img.getWidth(), img.getHeight());
        }
        if (pixels instanceof int[][]) {
            int[][] ints = (int[][])pixels;
            byte[][] out = new byte[ints.length][ints[0].length];
            int i = 0;
            while (i < out.length) {
                int j = 0;
                while (j < out[i].length) {
                    if (ints[i][j] >= max) {
                        out[i][j] = -1;
                    } else if (ints[i][j] <= min) {
                        out[i][j] = 0;
                    } else {
                        int diff = max - min;
                        float dist = (ints[i][j] - min) / diff;
                        out[i][j] = (byte)(dist * 256.0f);
                    }
                    ++j;
                }
                ++i;
            }
            return ImageTools.makeImage(out, img.getWidth(), img.getHeight());
        }
        if (pixels instanceof float[][]) {
            float[][] floats = (float[][])pixels;
            byte[][] out = new byte[floats.length][floats[0].length];
            int i = 0;
            while (i < out.length) {
                int j = 0;
                while (j < out[i].length) {
                    if (floats[i][j] >= (float)max) {
                        out[i][j] = -1;
                    } else if (floats[i][j] <= (float)min) {
                        out[i][j] = 0;
                    } else {
                        int diff = max - min;
                        float dist = (floats[i][j] - (float)min) / (float)diff;
                        out[i][j] = (byte)(dist * 256.0f);
                    }
                    ++j;
                }
                ++i;
            }
            return ImageTools.makeImage(out, img.getWidth(), img.getHeight());
        }
        if (pixels instanceof double[][]) {
            double[][] doubles = (double[][])pixels;
            byte[][] out = new byte[doubles.length][doubles[0].length];
            int i = 0;
            while (i < out.length) {
                int j = 0;
                while (j < out[i].length) {
                    if (doubles[i][j] >= (double)max) {
                        out[i][j] = -1;
                    } else if (doubles[i][j] <= (double)min) {
                        out[i][j] = 0;
                    } else {
                        int diff = max - min;
                        float dist = (float)(doubles[i][j] - (double)min) / (float)diff;
                        out[i][j] = (byte)(dist * 256.0f);
                    }
                    ++j;
                }
                ++i;
            }
            return ImageTools.makeImage(out, img.getWidth(), img.getHeight());
        }
        return img;
    }

    public static byte[] autoscale(byte[] b, int min, int max, int bpp, boolean little) {
        if (bpp == 1) {
            return b;
        }
        byte[] out = new byte[b.length / bpp];
        int i = 0;
        while (i < b.length) {
            int s = DataTools.bytesToInt(b, i, bpp, little);
            if (s >= max) {
                s = 255;
            } else if (s <= min) {
                s = 0;
            } else {
                int diff = max - min;
                float dist = (s - min) / diff;
                s = (int)dist * 256;
            }
            out[i / bpp] = (byte)s;
            i += bpp;
        }
        return out;
    }

    public static Double[] scanData(byte[] plane, int bits, boolean littleEndian) {
        int j;
        int max = 0;
        int min = Integer.MAX_VALUE;
        if (bits <= 8) {
            j = 0;
            while (j < plane.length) {
                if (plane[j] < min) {
                    min = plane[j];
                }
                if (plane[j] > max) {
                    max = plane[j];
                }
                ++j;
            }
        } else if (bits == 16) {
            j = 0;
            while (j < plane.length) {
                int s = DataTools.bytesToShort(plane, j, 2, littleEndian);
                if (s < min) {
                    min = s;
                }
                if (s > max) {
                    max = s;
                }
                j += 2;
            }
        } else if (bits == 32) {
            j = 0;
            while (j < plane.length) {
                int s = DataTools.bytesToInt(plane, j, 4, littleEndian);
                if (s < min) {
                    min = s;
                }
                if (s > max) {
                    max = s;
                }
                j += 4;
            }
        }
        Double[] rtn = new Double[]{new Double(min), new Double(max)};
        return rtn;
    }

    public static BufferedImage copyScaled(BufferedImage source, BufferedImage target, Object hint) {
        if (hint == null) {
            hint = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
        }
        Graphics2D g2 = target.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
        double scalex = (double)target.getWidth() / (double)source.getWidth();
        double scaley = (double)target.getHeight() / (double)source.getHeight();
        AffineTransform xform = AffineTransform.getScaleInstance(scalex, scaley);
        g2.drawRenderedImage(source, xform);
        g2.dispose();
        return target;
    }

    public static BufferedImage scale2D(BufferedImage image, int width, int height, Object hint, GraphicsConfiguration gc) {
        if (gc == null) {
            gc = ImageTools.getDefaultConfiguration();
        }
        int trans = image.getColorModel().getTransparency();
        return ImageTools.copyScaled(image, gc.createCompatibleImage(width, height, trans), hint);
    }

    public static BufferedImage scale2D(BufferedImage image, int width, int height, Object hint, ColorModel cm) {
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isRasterPremultiplied = cm.isAlphaPremultiplied();
        return ImageTools.copyScaled(image, new BufferedImage(cm, raster, isRasterPremultiplied, null), hint);
    }

    public static Image scaleAWT(BufferedImage source, int width, int height, int hint) {
        return source.getScaledInstance(width, height, hint);
    }

    public static BufferedImage scale(BufferedImage source, int width, int height, boolean pad) {
        int w = source.getWidth();
        int h = source.getHeight();
        if (w == width && h == height) {
            return source;
        }
        int finalWidth = width;
        int finalHeight = height;
        if (pad) {
            double r = (double)w / (double)h;
            double ratio = (double)width / (double)height;
            if (r > ratio) {
                height = h * width / w;
            } else {
                width = w * height / h;
            }
        }
        BufferedImage result = null;
        try {
            result = ImageTools.makeBuffered(ImageTools.scaleAWT(source, width, height, 16), source.getColorModel());
        }
        catch (Exception e) {
            result = ImageTools.makeBuffered(ImageTools.scaleAWT(source, width, height, 16));
        }
        return ImageTools.padImage(result, finalWidth, finalHeight);
    }

    public static BufferedImage makeBuffered(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        ImageTools.loadImage(image);
        int w = image.getWidth(OBS);
        int h = image.getHeight(OBS);
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException exc) {
            LogTools.trace(exc);
        }
        BufferedImage result = new BufferedImage(w, h, 1);
        result.setRGB(0, 0, w, h, pixels, 0, w);
        return result;
    }

    public static BufferedImage makeBuffered(Image image, ColorModel cm) {
        BufferedImage bi;
        if (image instanceof BufferedImage && cm.equals((bi = (BufferedImage)image).getColorModel())) {
            return bi;
        }
        ImageTools.loadImage(image);
        int w = image.getWidth(OBS);
        int h = image.getHeight(OBS);
        boolean alphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = cm.createCompatibleWritableRaster(w, h);
        BufferedImage result = new BufferedImage(cm, raster, alphaPremultiplied, null);
        Graphics2D g = result.createGraphics();
        g.drawImage(image, 0, 0, OBS);
        g.dispose();
        return result;
    }

    public static boolean loadImage(Image image) {
        if (image instanceof BufferedImage) {
            return true;
        }
        MediaTracker tracker = new MediaTracker(OBS);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException exc) {
            return false;
        }
        return 8 == tracker.statusID(0, false);
    }

    public static Dimension getSize(Image image) {
        if (image == null) {
            return new Dimension(0, 0);
        }
        if (image instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)image;
            return new Dimension(bi.getWidth(), bi.getHeight());
        }
        ImageTools.loadImage(image);
        return new Dimension(image.getWidth(OBS), image.getHeight(OBS));
    }

    public static BufferedImage makeCompatible(BufferedImage image, GraphicsConfiguration gc) {
        if (gc == null) {
            gc = ImageTools.getDefaultConfiguration();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int trans = image.getColorModel().getTransparency();
        BufferedImage result = gc.createCompatibleImage(w, h, trans);
        Graphics2D g2 = result.createGraphics();
        g2.drawRenderedImage(image, null);
        g2.dispose();
        return result;
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    public static ColorModel makeColorModel(int c, int dataType, int[] bits) {
        int type;
        switch (c) {
            case 1: {
                type = 1003;
                break;
            }
            case 2: {
                type = 1000;
                break;
            }
            case 3: {
                type = 1000;
                break;
            }
            case 4: {
                type = 1000;
                break;
            }
            default: {
                return null;
            }
        }
        if (bits != null) {
            return new ComponentColorModel(ColorSpace.getInstance(type), bits, c == 4, false, 3, dataType);
        }
        return new ComponentColorModel(ColorSpace.getInstance(type), c == 4, false, 3, dataType);
    }
}

