/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.IFormatWriter;

public abstract class FormatWriter
extends FormatHandler
implements IFormatWriter {
    protected int fps = 10;
    protected ColorModel cm;
    protected String[] compressionTypes;
    protected String compression;
    protected boolean initialized;

    public FormatWriter(String format, String suffix) {
        super(format, suffix);
    }

    public FormatWriter(String format, String[] suffixes) {
        super(format, suffixes);
    }

    public void saveBytes(byte[] bytes, boolean last) throws FormatException, IOException {
        throw new FormatException("Not implemented yet.");
    }

    public boolean canDoStacks() {
        return false;
    }

    public void setColorModel(ColorModel model) {
        this.cm = model;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public void setFramesPerSecond(int rate) {
        this.fps = rate;
    }

    public int getFramesPerSecond() {
        return this.fps;
    }

    public String[] getCompressionTypes() {
        return this.compressionTypes;
    }

    public void setCompression(String compress) throws FormatException {
        int i = 0;
        while (i < this.compressionTypes.length) {
            if (this.compressionTypes[i].equals(compress)) {
                this.compression = compress;
                return;
            }
            ++i;
        }
        throw new FormatException("Invalid compression type: " + compress);
    }

    public int[] getPixelTypes() {
        return new int[]{1, 3, 5, 6};
    }

    public boolean isSupportedType(int type) {
        int[] types = this.getPixelTypes();
        int i = 0;
        while (i < types.length) {
            if (type == types[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setId(String id, boolean force) throws FormatException, IOException {
        if (id.equals(this.currentId) && !force) {
            return;
        }
        this.close();
        this.currentId = id;
        this.initialized = false;
    }

    public boolean canDoStacks(String id) throws FormatException {
        try {
            this.setId(id);
        }
        catch (IOException exc) {
            throw new FormatException(exc);
        }
        return this.canDoStacks(id);
    }

    public int[] getPixelTypes(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getPixelTypes(id);
    }

    public boolean isSupportedType(String id, int type) throws FormatException, IOException {
        this.setId(id);
        return this.isSupportedType(type);
    }

    public void save(String id, Image image, boolean last) throws FormatException, IOException {
        this.setId(id);
        this.saveImage(image, last);
    }
}

