/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.File;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Vector;
import loci.formats.Location;
import loci.formats.LogTools;
import loci.formats.NumberFilter;

public class FilePattern {
    private String pattern;
    private boolean valid;
    private String msg;
    private int[] startIndex;
    private int[] endIndex;
    private BigInteger[] begin;
    private BigInteger[] end;
    private BigInteger[] step;
    private int[] count;
    private boolean[] fixed;
    private int[] zeroes;
    private String[] files;

    public FilePattern(Location file) {
        this(FilePattern.findPattern(file));
    }

    public FilePattern(String name, String dir) {
        this(FilePattern.findPattern(name, dir));
    }

    public FilePattern(String pattern) {
        this.pattern = pattern;
        this.valid = false;
        if (pattern == null) {
            this.msg = "Null pattern string.";
            return;
        }
        int len = pattern.length();
        Vector<Integer> lt = new Vector<Integer>(len);
        Vector<Integer> gt = new Vector<Integer>(len);
        int left = -1;
        while ((left = pattern.indexOf("<", left + 1)) >= 0) {
            lt.add(new Integer(left));
        }
        int right = -1;
        while ((right = pattern.indexOf(">", right + 1)) >= 0) {
            gt.add(new Integer(right));
        }
        int num = lt.size();
        if (num != gt.size()) {
            this.msg = "Mismatched numerical block markers.";
            return;
        }
        this.startIndex = new int[num];
        this.endIndex = new int[num];
        int i = 0;
        while (i < num) {
            int val = (Integer)lt.elementAt(i);
            if (i > 0 && val < this.endIndex[i - 1]) {
                this.msg = "Bad numerical block marker order.";
                return;
            }
            this.startIndex[i] = val;
            val = (Integer)gt.elementAt(i);
            if (val <= this.startIndex[i]) {
                this.msg = "Bad numerical block marker order.";
                return;
            }
            this.endIndex[i] = val + 1;
            ++i;
        }
        this.begin = new BigInteger[num];
        this.end = new BigInteger[num];
        this.step = new BigInteger[num];
        this.count = new int[num];
        this.fixed = new boolean[num];
        this.zeroes = new int[num];
        i = 0;
        while (i < num) {
            String s;
            String b;
            String e;
            String block = pattern.substring(this.startIndex[i], this.endIndex[i]);
            int dash = block.indexOf("-");
            if (dash < 0) {
                b = e = block.substring(1, block.length() - 1);
                s = "1";
            } else {
                int colon = block.indexOf(":");
                b = block.substring(1, dash);
                if (colon < 0) {
                    e = block.substring(dash + 1, block.length() - 1);
                    s = "1";
                } else {
                    e = block.substring(dash + 1, colon);
                    s = block.substring(colon + 1, block.length() - 1);
                }
            }
            try {
                this.begin[i] = new BigInteger(b);
                this.end[i] = new BigInteger(e);
                if (this.begin[i].compareTo(this.end[i]) > 0) {
                    this.msg = "Begin value cannot be greater than ending value.";
                    return;
                }
                this.step[i] = new BigInteger(s);
                if (this.step[i].compareTo(BigInteger.ONE) < 0) {
                    this.msg = "Step value must be at least one.";
                    return;
                }
                this.count[i] = this.end[i].subtract(this.begin[i]).divide(this.step[i]).intValue() + 1;
                this.fixed[i] = b.length() == e.length();
                int z = 0;
                z = 0;
                while (z < e.length()) {
                    if (e.charAt(z) != '0') break;
                    ++z;
                }
                this.zeroes[i] = z;
            }
            catch (NumberFormatException exc) {
                this.msg = "Invalid numerical range values.";
                return;
            }
            ++i;
        }
        Vector v = new Vector();
        this.buildFiles("", num, v);
        this.files = new String[v.size()];
        v.copyInto(this.files);
        this.valid = true;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getErrorMessage() {
        return this.msg;
    }

    public BigInteger[] getFirst() {
        return this.begin;
    }

    public BigInteger[] getLast() {
        return this.end;
    }

    public BigInteger[] getStep() {
        return this.step;
    }

    public int[] getCount() {
        return this.count;
    }

    public String[] getFiles() {
        return this.files;
    }

    public String getBlock(int i) {
        if (i < 0 || i >= this.startIndex.length) {
            return null;
        }
        return this.pattern.substring(this.startIndex[i], this.endIndex[i]);
    }

    public String[] getBlocks() {
        String[] s = new String[this.startIndex.length];
        int i = 0;
        while (i < s.length) {
            s[i] = this.getBlock(i);
            ++i;
        }
        return s;
    }

    public String getPrefix() {
        int dot;
        int s = this.pattern.lastIndexOf(File.separator) + 1;
        int e = this.startIndex.length > 0 ? this.startIndex[0] : ((dot = this.pattern.lastIndexOf(".")) < s ? this.pattern.length() : dot);
        return s <= e ? this.pattern.substring(s, e) : "";
    }

    public String getSuffix() {
        return this.endIndex.length > 0 ? this.pattern.substring(this.endIndex[this.endIndex.length - 1]) : this.pattern;
    }

    public String getPrefix(int i) {
        if (i < 0 || i >= this.startIndex.length) {
            return null;
        }
        int s = i > 0 ? this.endIndex[i - 1] : this.pattern.lastIndexOf(File.separator) + 1;
        int e = this.startIndex[i];
        return s <= e ? this.pattern.substring(s, e) : null;
    }

    public String[] getPrefixes() {
        String[] s = new String[this.startIndex.length];
        int i = 0;
        while (i < s.length) {
            s[i] = this.getPrefix(i);
            ++i;
        }
        return s;
    }

    public static String findPattern(Location file) {
        return FilePattern.findPattern(file.getName(), file.getAbsoluteFile().getParent());
    }

    public static String findPattern(File file) {
        return FilePattern.findPattern(file.getName(), file.getAbsoluteFile().getParent());
    }

    public static String findPattern(String name, String dir) {
        if (dir == null) {
            dir = "";
        } else if (!dir.equals("") && !dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        Location dirFile = new Location(dir.equals("") ? "." : dir);
        Location[] f = dirFile.listFiles();
        if (f == null) {
            return null;
        }
        String[] nameList = new String[f.length];
        int i = 0;
        while (i < nameList.length) {
            nameList[i] = f[i].getName();
            ++i;
        }
        return FilePattern.findPattern(name, dir, nameList);
    }

    /*
     * Unable to fully structure code
     */
    public static String findPattern(String name, String dir, String[] nameList) {
        if (dir == null) {
            dir = "";
        } else if (!dir.equals("") && !dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        len = name.length();
        bound = (len + 1) / 2;
        indexList = new int[bound];
        endList = new int[bound];
        q = 0;
        num = false;
        ndx = -1;
        e = 0;
        i = 0;
        while (i < len) {
            c = name.charAt(i);
            if (c >= '0' && c <= '9') {
                if (num) {
                    ++e;
                } else {
                    num = true;
                    ndx = i;
                    e = ndx + 1;
                }
            } else if (num) {
                num = false;
                indexList[q] = ndx;
                endList[q] = e;
                ++q;
            }
            ++i;
        }
        if (num) {
            indexList[q] = ndx;
            endList[q] = e;
            ++q;
        }
        sb = new StringBuffer(dir);
        i = 0;
        while (i < q) {
            block23: {
                block24: {
                    block22: {
                        last = i > 0 ? endList[i - 1] : 0;
                        sb.append(name.substring(last, indexList[i]));
                        pre = name.substring(0, indexList[i]);
                        post = name.substring(endList[i]);
                        filter = new NumberFilter(pre, post);
                        list = FilePattern.matchFiles(nameList, filter);
                        if (list == null || list.length == 0) {
                            return null;
                        }
                        if (list.length != 1) break block22;
                        sb.append(name.substring(indexList[i], endList[i]));
                        break block23;
                    }
                    fix = true;
                    j = 0;
                    while (j < list.length) {
                        if (list[j].length() != len) {
                            fix = false;
                            break;
                        }
                        ++j;
                    }
                    if (!fix) break block24;
                    width = endList[i] - indexList[i];
                    same = new boolean[width];
                    j = 0;
                    while (j < width) {
                        same[j] = true;
                        jx = indexList[i] + j;
                        c = name.charAt(jx);
                        k = 0;
                        while (k < list.length) {
                            if (list[k].charAt(jx) != c) {
                                same[j] = false;
                                break;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < width) {
                        jx = indexList[i] + j;
                        if (!same[j]) ** GOTO lbl87
                        sb.append(name.charAt(jx));
                        ++j;
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            ++j;
lbl87:
                            // 2 sources

                            ** while (j < width && !same[j])
                        }
lbl88:
                        // 1 sources

                        p = FilePattern.findPattern(name, nameList, jx, indexList[i] + j, "");
                        if (p == null) {
                            return null;
                        }
                        sb.append(p);
                    }
                    break block23;
                }
                numbers = new BigInteger[list.length];
                j = 0;
                while (j < list.length) {
                    numbers[j] = filter.getNumber(list[j]);
                    ++j;
                }
                Arrays.sort(numbers);
                bounds = FilePattern.getBounds((BigInteger[])numbers, false);
                if (bounds == null) {
                    return null;
                }
                sb.append(bounds);
            }
            ++i;
        }
        sb.append(q > 0 ? name.substring(endList[q - 1]) : name);
        return sb.toString();
    }

    private static String findPattern(String name, String[] nameList, int ndx, int end, String p) {
        if (ndx == end) {
            return p;
        }
        int i = end - ndx;
        while (i >= 1) {
            String pat;
            NumberFilter filter = new NumberFilter(name.substring(0, ndx), name.substring(ndx + i));
            String[] list = FilePattern.matchFiles(nameList, filter);
            Object[] numbers = new BigInteger[list.length];
            int j = 0;
            while (j < list.length) {
                numbers[j] = new BigInteger(list[j].substring(ndx, ndx + i));
                ++j;
            }
            Arrays.sort(numbers);
            String bounds = FilePattern.getBounds((BigInteger[])numbers, true);
            if (bounds != null && (pat = FilePattern.findPattern(name, nameList, ndx + i, end, String.valueOf(p) + bounds)) != null) {
                return pat;
            }
            --i;
        }
        return null;
    }

    private static String getBounds(BigInteger[] numbers, boolean fixed) {
        if (numbers.length < 2) {
            return null;
        }
        BigInteger b = numbers[0];
        BigInteger e = numbers[numbers.length - 1];
        BigInteger s = numbers[1].subtract(b);
        if (s.equals(BigInteger.ZERO)) {
            return null;
        }
        int i = 2;
        while (i < numbers.length) {
            if (!numbers[i].subtract(numbers[i - 1]).equals(s)) {
                return null;
            }
            ++i;
        }
        String sb = b.toString();
        String se = e.toString();
        StringBuffer bounds = new StringBuffer("<");
        if (fixed) {
            int zeroes = se.length() - sb.length();
            int i2 = 0;
            while (i2 < zeroes) {
                bounds.append("0");
                ++i2;
            }
        }
        bounds.append(sb);
        bounds.append("-");
        bounds.append(se);
        if (!s.equals(BigInteger.ONE)) {
            bounds.append(":");
            bounds.append(s);
        }
        bounds.append(">");
        return bounds.toString();
    }

    private static String[] matchFiles(String[] inFiles, NumberFilter filter) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < inFiles.length) {
            if (filter.accept(inFiles[i])) {
                v.add(inFiles[i]);
            }
            ++i;
        }
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    private void buildFiles(String prefix, int ndx, Vector fileList) {
        int num = this.startIndex.length;
        int n1 = ndx == 0 ? 0 : this.endIndex[ndx - 1];
        int n2 = ndx == num ? this.pattern.length() : this.startIndex[ndx];
        String pre = this.pattern.substring(n1, n2);
        if (ndx == 0) {
            fileList.add(String.valueOf(pre) + prefix);
        } else {
            BigInteger bi = this.begin[--ndx];
            while (bi.compareTo(this.end[ndx]) <= 0) {
                String s = bi.toString();
                int z = this.zeroes[ndx];
                if (this.fixed[ndx]) {
                    z += this.end[ndx].toString().length() - s.length();
                }
                int j = 0;
                while (j < z) {
                    s = "0" + s;
                    ++j;
                }
                this.buildFiles(String.valueOf(s) + pre + prefix, ndx, fileList);
                bi = bi.add(this.step[ndx]);
            }
        }
    }

    public static void main(String[] args) {
        int i;
        String pat = null;
        if (args.length > 0) {
            Location file = new Location(args[0]);
            LogTools.println("File = " + file.getAbsoluteFile());
            pat = FilePattern.findPattern(file);
        } else {
            String[] nameList = new String[289];
            nameList[0] = "outlier.ext";
            int count = 1;
            i = 1;
            while (i <= 2) {
                int j = 1;
                while (j <= 4) {
                    int k = 0;
                    while (k <= 2) {
                        int l = 1;
                        while (l <= 12) {
                            String sl = String.valueOf(l < 10 ? "0" : "") + l;
                            nameList[count++] = "hypothetical" + sl + k + j + "c" + i + ".ext";
                            ++l;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            pat = FilePattern.findPattern(nameList[1], null, nameList);
        }
        if (pat == null) {
            LogTools.println("No pattern found.");
        } else {
            LogTools.println("Pattern = " + pat);
            FilePattern fp = new FilePattern(pat);
            if (fp.isValid()) {
                LogTools.println("Pattern is valid.");
                LogTools.println("Files:");
                String[] ids = fp.getFiles();
                i = 0;
                while (i < ids.length) {
                    LogTools.println("  #" + i + ": " + ids[i]);
                    ++i;
                }
            } else {
                LogTools.println("Pattern is invalid: " + fp.getErrorMessage());
            }
        }
    }
}

