/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import loci.formats.CoreMetadata;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataStore;
import loci.formats.ReaderWrapper;

public class DimensionSwapper
extends ReaderWrapper {
    public DimensionSwapper() {
    }

    public DimensionSwapper(IFormatReader r) {
        super(r);
    }

    public int getSizeX() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata().sizeX[this.getSeries()];
    }

    public int getSizeY() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata().sizeY[this.getSeries()];
    }

    public int getSizeZ() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata().sizeZ[this.getSeries()];
    }

    public int getSizeC() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata().sizeC[this.getSeries()];
    }

    public int getSizeT() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata().sizeT[this.getSeries()];
    }

    public String getDimensionOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata().currentOrder[this.getSeries()];
    }

    public void swapDimensions(String order) {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (order == null) {
            return;
        }
        String oldOrder = this.getDimensionOrder();
        if (order.equals(oldOrder)) {
            return;
        }
        int[] dims = new int[5];
        int xndx = oldOrder.indexOf("X");
        int yndx = oldOrder.indexOf("Y");
        int zndx = oldOrder.indexOf("Z");
        int cndx = oldOrder.indexOf("C");
        int tndx = oldOrder.indexOf("T");
        dims[xndx] = this.getSizeX();
        dims[yndx] = this.getSizeY();
        dims[zndx] = this.getSizeZ();
        dims[cndx] = this.getSizeC();
        dims[tndx] = this.getSizeT();
        int series = this.getSeries();
        CoreMetadata core = this.getCoreMetadata();
        core.sizeX[series] = dims[order.indexOf("X")];
        core.sizeY[series] = dims[order.indexOf("Y")];
        core.sizeZ[series] = dims[order.indexOf("Z")];
        core.sizeC[series] = dims[order.indexOf("C")];
        core.sizeT[series] = dims[order.indexOf("T")];
        core.currentOrder[series] = order;
        MetadataStore store = this.getMetadataStore();
        store.setPixels(new Integer(dims[xndx]), new Integer(dims[yndx]), new Integer(dims[zndx]), new Integer(dims[cndx]), new Integer(dims[tndx]), null, null, order, new Integer(series), null);
    }
}

