/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Hashtable;
import loci.formats.ChannelMerger;
import loci.formats.ChannelSeparator;
import loci.formats.DataTools;
import loci.formats.FilePattern;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageTools;
import loci.formats.Location;
import loci.formats.LogTools;
import loci.formats.MetadataStore;
import loci.formats.MinMaxCalculator;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;
import loci.formats.StatusEvent;
import loci.formats.StatusListener;

public final class ConsoleTools {
    private ConsoleTools() {
    }

    public static boolean testRead(IFormatReader reader, String[] args) throws FormatException, IOException {
        int u;
        String[] used;
        boolean usedValid;
        String id = null;
        boolean pixels = true;
        boolean doMeta = true;
        boolean thumbs = false;
        boolean minmax = false;
        boolean merge = false;
        boolean stitch = false;
        boolean separate = false;
        boolean omexml = false;
        boolean normalize = false;
        boolean fastBlit = false;
        int start = 0;
        int end = Integer.MAX_VALUE;
        int series = 0;
        String map = null;
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith("-") && args.length > 1) {
                    if (args[i].equals("-nopix")) {
                        pixels = false;
                    } else if (args[i].equals("-nometa")) {
                        doMeta = false;
                    } else if (args[i].equals("-thumbs")) {
                        thumbs = true;
                    } else if (args[i].equals("-minmax")) {
                        minmax = true;
                    } else if (args[i].equals("-merge")) {
                        merge = true;
                    } else if (args[i].equals("-stitch")) {
                        stitch = true;
                    } else if (args[i].equals("-separate")) {
                        separate = true;
                    } else if (args[i].equals("-omexml")) {
                        omexml = true;
                    } else if (args[i].equals("-normalize")) {
                        normalize = true;
                    } else if (args[i].equals("-fast")) {
                        fastBlit = true;
                    } else if (args[i].equals("-debug")) {
                        FormatHandler.setDebug(true);
                    } else if (args[i].equals("-level")) {
                        try {
                            FormatHandler.setDebugLevel(Integer.parseInt(args[++i]));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (args[i].equals("-range")) {
                        try {
                            start = Integer.parseInt(args[++i]);
                            end = Integer.parseInt(args[++i]);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (args[i].equals("-series")) {
                        try {
                            series = Integer.parseInt(args[++i]);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (args[i].equals("-map")) {
                        map = args[++i];
                    } else {
                        LogTools.println("Ignoring unknown command flag: " + args[i]);
                    }
                } else if (id == null) {
                    id = args[i];
                } else {
                    LogTools.println("Ignoring unknown argument: " + args[i]);
                }
                ++i;
            }
        }
        if (FormatHandler.debug) {
            LogTools.println("Debugging at level " + FormatHandler.debugLevel);
        }
        if (id == null) {
            String className = reader.getClass().getName();
            String fmt = reader instanceof ImageReader ? "any" : reader.getFormat();
            String[] s = new String[]{"To test read a file in " + fmt + " format, run:", "  java " + className + " [-nopix] [-nometa] [-thumbs] [-minmax]", "    [-merge] [-stitch] [-separate] [-omexml] [-normalize]", "    [-fast] [-debug] [-range start end] [-series num] [-map id] file", "", "      file: the image file to read", "    -nopix: read metadata only, not pixels", "   -nometa: output only core metadata", "   -thumbs: read thumbnails instead of normal pixels", "   -minmax: compute min/max statistics", "    -merge: combine separate channels into RGB image", "   -stitch: stitch files with similar names", " -separate: split RGB image into separate channels", "   -omexml: populate OME-XML metadata", "-normalize: normalize floating point images*", "     -fast: paint RGB images as quickly as possible*", "    -debug: turn on debugging output", "    -range: specify range of planes to read (inclusive)", "   -series: specify which image series to read", "      -map: specify file on disk to which name should be mapped", "", "* = may result in loss of precision", ""};
            int i = 0;
            while (i < s.length) {
                LogTools.println(s[i]);
                ++i;
            }
            return false;
        }
        if (map != null) {
            Location.mapId(id, map);
        }
        if (omexml) {
            try {
                Class<?> c = Class.forName("loci.formats.ome.OMEXMLMetadataStore");
                MetadataStore ms = (MetadataStore)c.newInstance();
                reader.setMetadataStore(ms);
            }
            catch (Throwable c) {
                // empty catch block
            }
        }
        if (reader instanceof ImageReader) {
            ImageReader ir = (ImageReader)reader;
            LogTools.print("Checking file format ");
            LogTools.println("[" + ir.getFormat(id) + "]");
        } else {
            LogTools.print("Checking " + reader.getFormat() + " format ");
            LogTools.println(reader.isThisType(id) ? "[yes]" : "[no]");
        }
        LogTools.println("Initializing reader");
        if (stitch) {
            reader = new FileStitcher(reader, true);
            String pat = FilePattern.findPattern(new Location(id));
            if (pat != null) {
                id = pat;
            }
        }
        if (separate) {
            reader = new ChannelSeparator(reader);
        }
        if (merge) {
            reader = new ChannelMerger(reader);
        }
        MinMaxCalculator minMaxCalc = null;
        if (minmax) {
            minMaxCalc = new MinMaxCalculator(reader);
            reader = minMaxCalc;
        }
        StatusEchoer status = new StatusEchoer();
        reader.addStatusListener(status);
        reader.close();
        reader.setNormalized(normalize);
        reader.setMetadataFiltered(true);
        reader.setMetadataCollected(doMeta);
        long s1 = System.currentTimeMillis();
        reader.setId(id);
        long e1 = System.currentTimeMillis();
        float sec1 = (float)(e1 - s1) / 1000.0f;
        LogTools.println("Initialization took " + sec1 + "s");
        if (!normalize && reader.getPixelType() == 6) {
            throw new FormatException("Sorry, unnormalized floating point data is not supported. Please use the '-normalize' option.");
        }
        LogTools.println();
        LogTools.println("Reading core metadata");
        LogTools.println(stitch ? "File pattern = " + id : "Filename = " + reader.getCurrentFile());
        if (map != null) {
            LogTools.println("Mapped filename = " + map);
        }
        boolean bl = usedValid = (used = reader.getUsedFiles()) != null && used.length > 0;
        if (usedValid) {
            u = 0;
            while (u < used.length) {
                if (used[u] == null) {
                    usedValid = false;
                    break;
                }
                ++u;
            }
        }
        if (!usedValid) {
            LogTools.println("************ Warning: invalid used files list ************");
        }
        if (used == null) {
            LogTools.println("Used files = null");
        } else if (used.length == 0) {
            LogTools.println("Used files = []");
        } else if (used.length > 1) {
            LogTools.println("Used files:");
            u = 0;
            while (u < used.length) {
                LogTools.println("\t" + used[u]);
                ++u;
            }
        } else if (!id.equals(used[0])) {
            LogTools.println("Used files = [" + used[0] + "]");
        }
        int seriesCount = reader.getSeriesCount();
        LogTools.println("Series count = " + seriesCount);
        int j = 0;
        while (j < seriesCount) {
            reader.setSeries(j);
            int imageCount = reader.getImageCount();
            boolean rgb = reader.isRGB();
            int sizeX = reader.getSizeX();
            int sizeY = reader.getSizeY();
            int sizeZ = reader.getSizeZ();
            int sizeC = reader.getSizeC();
            int sizeT = reader.getSizeT();
            int pixelType = reader.getPixelType();
            int effSizeC = reader.getEffectiveSizeC();
            int rgbChanCount = reader.getRGBChannelCount();
            int[] cLengths = reader.getChannelDimLengths();
            String[] cTypes = reader.getChannelDimTypes();
            int thumbSizeX = reader.getThumbSizeX();
            int thumbSizeY = reader.getThumbSizeY();
            boolean little = reader.isLittleEndian();
            String dimOrder = reader.getDimensionOrder();
            boolean orderCertain = reader.isOrderCertain();
            boolean interleaved = reader.isInterleaved();
            LogTools.println("Series #" + j + ":");
            LogTools.println("\tImage count = " + imageCount);
            LogTools.print("\tRGB = " + rgb + " (" + rgbChanCount + ")");
            if (merge) {
                LogTools.print(" (merged)");
            } else if (separate) {
                LogTools.print(" (separated)");
            }
            if (rgb != (rgbChanCount != 1)) {
                LogTools.println("\t************ Warning: RGB mismatch ************");
            }
            LogTools.println();
            LogTools.println("\tInterleaved = " + interleaved);
            LogTools.println("\tWidth = " + sizeX);
            LogTools.println("\tHeight = " + sizeY);
            LogTools.println("\tSizeZ = " + sizeZ);
            LogTools.println("\tSizeT = " + sizeT);
            LogTools.print("\tSizeC = " + sizeC);
            if (sizeC != effSizeC) {
                LogTools.print(" (effectively " + effSizeC + ")");
            }
            int cProduct = 1;
            if (cLengths.length == 1 && "Channel".equals(cTypes[0])) {
                cProduct = cLengths[0];
            } else {
                LogTools.print(" (");
                int i = 0;
                while (i < cLengths.length) {
                    if (i > 0) {
                        LogTools.print(" x ");
                    }
                    LogTools.print(String.valueOf(cLengths[i]) + " " + cTypes[i]);
                    cProduct *= cLengths[i];
                    ++i;
                }
                LogTools.print(")");
            }
            LogTools.println();
            if (cLengths.length == 0 || cProduct != sizeC) {
                LogTools.println("\t************ Warning: C dimension mismatch ************");
            }
            if (imageCount != sizeZ * effSizeC * sizeT) {
                LogTools.println("\t************ Warning: ZCT mismatch ************");
            }
            LogTools.println("\tThumbnail size = " + thumbSizeX + " x " + thumbSizeY);
            LogTools.println("\tEndianness = " + (little ? "intel (little)" : "motorola (big)"));
            LogTools.println("\tDimension order = " + dimOrder + (orderCertain ? " (certain)" : " (uncertain)"));
            LogTools.println("\tPixel type = " + FormatTools.getPixelTypeString(pixelType));
            if (doMeta) {
                int[] indices;
                LogTools.println("\t-----");
                if (imageCount > 6) {
                    int q = imageCount / 2;
                    int[] nArray = new int[7];
                    nArray[1] = q - 2;
                    nArray[2] = q - 1;
                    nArray[3] = q;
                    nArray[4] = q + 1;
                    nArray[5] = q + 2;
                    nArray[6] = imageCount - 1;
                    indices = nArray;
                } else if (imageCount > 2) {
                    int[] nArray = new int[3];
                    nArray[1] = imageCount / 2;
                    nArray[2] = imageCount - 1;
                    indices = nArray;
                } else if (imageCount > 1) {
                    int[] nArray = new int[2];
                    nArray[1] = 1;
                    indices = nArray;
                } else {
                    indices = new int[1];
                }
                int[][] zct = new int[indices.length][];
                int[] indices2 = new int[indices.length];
                int i = 0;
                while (i < indices.length) {
                    zct[i] = reader.getZCTCoords(indices[i]);
                    indices2[i] = reader.getIndex(zct[i][0], zct[i][1], zct[i][2]);
                    LogTools.print("\tPlane #" + indices[i] + " <=> Z " + zct[i][0] + ", C " + zct[i][1] + ", T " + zct[i][2]);
                    if (indices[i] != indices2[i]) {
                        LogTools.println(" [mismatch: " + indices2[i] + "]");
                    } else {
                        LogTools.println();
                    }
                    ++i;
                }
            }
            ++j;
        }
        reader.setSeries(series);
        String s = seriesCount > 1 ? " series #" + series : "";
        int pixelType = reader.getPixelType();
        int sizeC = reader.getSizeC();
        Double[] preGlobalMin = null;
        Double[] preGlobalMax = null;
        Double[] preKnownMin = null;
        Double[] preKnownMax = null;
        Double[] prePlaneMin = null;
        Double[] prePlaneMax = null;
        boolean preIsMinMaxPop = false;
        if (minmax) {
            preGlobalMin = new Double[sizeC];
            preGlobalMax = new Double[sizeC];
            preKnownMin = new Double[sizeC];
            preKnownMax = new Double[sizeC];
            int c = 0;
            while (c < sizeC) {
                preGlobalMin[c] = minMaxCalc.getChannelGlobalMinimum(c);
                preGlobalMax[c] = minMaxCalc.getChannelGlobalMaximum(c);
                preKnownMin[c] = minMaxCalc.getChannelKnownMinimum(c);
                preKnownMax[c] = minMaxCalc.getChannelKnownMaximum(c);
                ++c;
            }
            prePlaneMin = minMaxCalc.getPlaneMinimum(0);
            prePlaneMax = minMaxCalc.getPlaneMaximum(0);
            preIsMinMaxPop = minMaxCalc.isMinMaxPopulated();
        }
        if (pixels) {
            LogTools.println();
            LogTools.print("Reading" + s + " pixel data ");
            status.setVerbose(false);
            int num = reader.getImageCount();
            if (start < 0) {
                start = 0;
            }
            if (start >= num) {
                start = num - 1;
            }
            if (end < 0) {
                end = 0;
            }
            if (end >= num) {
                end = num - 1;
            }
            if (end < start) {
                end = start;
            }
            LogTools.print("(" + start + "-" + end + ") ");
            BufferedImage[] images = new BufferedImage[end - start + 1];
            long s2 = System.currentTimeMillis();
            boolean mismatch = false;
            int i = start;
            while (i <= end) {
                status.setEchoNext(true);
                if (!fastBlit) {
                    images[i - start] = thumbs ? reader.openThumbImage(i) : reader.openImage(i);
                } else {
                    int x = reader.getSizeX();
                    int y = reader.getSizeY();
                    byte[] b = thumbs ? reader.openThumbBytes(i) : reader.openBytes(i);
                    Object pix = DataTools.makeDataArray(b, FormatTools.getBytesPerPixel(reader.getPixelType()), reader.getPixelType() == 6, reader.isLittleEndian());
                    images[i - start] = ImageTools.makeImage(ImageTools.make24Bits(pix, x, y, false, false), x, y);
                }
                int pixType = ImageTools.getPixelType(images[i - start]);
                if (pixType != pixelType && !fastBlit) {
                    if (!mismatch) {
                        LogTools.println();
                        mismatch = true;
                    }
                    LogTools.println("\tPlane #" + i + ": pixel type mismatch: " + FormatTools.getPixelTypeString(pixType) + "/" + FormatTools.getPixelTypeString(pixelType));
                } else {
                    mismatch = false;
                    LogTools.print(".");
                }
                ++i;
            }
            long e2 = System.currentTimeMillis();
            if (!mismatch) {
                LogTools.print(" ");
            }
            LogTools.println("[done]");
            float sec2 = (float)(e2 - s2) / 1000.0f;
            float avg = (float)(e2 - s2) / (float)images.length;
            LogTools.println(String.valueOf(sec2) + "s elapsed (" + avg + "ms per image)");
            if (minmax) {
                int subC;
                Double[] globalMin = new Double[sizeC];
                Double[] globalMax = new Double[sizeC];
                Double[] knownMin = new Double[sizeC];
                Double[] knownMax = new Double[sizeC];
                int c = 0;
                while (c < sizeC) {
                    globalMin[c] = minMaxCalc.getChannelGlobalMinimum(c);
                    globalMax[c] = minMaxCalc.getChannelGlobalMaximum(c);
                    knownMin[c] = minMaxCalc.getChannelKnownMinimum(c);
                    knownMax[c] = minMaxCalc.getChannelKnownMaximum(c);
                    ++c;
                }
                Double[] planeMin = minMaxCalc.getPlaneMinimum(0);
                Double[] planeMax = minMaxCalc.getPlaneMaximum(0);
                boolean isMinMaxPop = minMaxCalc.isMinMaxPopulated();
                LogTools.println();
                LogTools.println("Min/max values:");
                int c2 = 0;
                while (c2 < sizeC) {
                    LogTools.println("\tChannel " + c2 + ":");
                    LogTools.println("\t\tGlobal minimum = " + globalMin[c2] + " (initially " + preGlobalMin[c2] + ")");
                    LogTools.println("\t\tGlobal maximum = " + globalMax[c2] + " (initially " + preGlobalMax[c2] + ")");
                    LogTools.println("\t\tKnown minimum = " + knownMin[c2] + " (initially " + preKnownMin[c2] + ")");
                    LogTools.println("\t\tKnown maximum = " + knownMax[c2] + " (initially " + preKnownMax[c2] + ")");
                    ++c2;
                }
                LogTools.print("\tFirst plane minimum(s) =");
                if (planeMin == null) {
                    LogTools.print(" none");
                } else {
                    subC = 0;
                    while (subC < planeMin.length) {
                        LogTools.print(" " + planeMin[subC]);
                        ++subC;
                    }
                }
                LogTools.print(" (initially");
                if (prePlaneMin == null) {
                    LogTools.print(" none");
                } else {
                    subC = 0;
                    while (subC < prePlaneMin.length) {
                        LogTools.print(" " + prePlaneMin[subC]);
                        ++subC;
                    }
                }
                LogTools.println(")");
                LogTools.print("\tFirst plane maximum(s) =");
                if (planeMax == null) {
                    LogTools.print(" none");
                } else {
                    subC = 0;
                    while (subC < planeMax.length) {
                        LogTools.print(" " + planeMax[subC]);
                        ++subC;
                    }
                }
                LogTools.print(" (initially");
                if (prePlaneMax == null) {
                    LogTools.print(" none");
                } else {
                    subC = 0;
                    while (subC < prePlaneMax.length) {
                        LogTools.print(" " + prePlaneMax[subC]);
                        ++subC;
                    }
                }
                LogTools.println(")");
                LogTools.println("\tMin/max populated = " + isMinMaxPop + " (initially " + preIsMinMaxPop + ")");
            }
            ReflectedUniverse r = new ReflectedUniverse();
            try {
                r.exec("import loci.formats.gui.ImageViewer");
                r.exec("viewer = new ImageViewer()");
                r.setVar("reader", reader);
                r.setVar("images", images);
                r.setVar("true", true);
                r.exec("viewer.setImages(reader, images)");
                r.exec("viewer.setVisible(true)");
            }
            catch (ReflectException exc) {
                throw new FormatException(exc);
            }
        }
        if (doMeta) {
            LogTools.println();
            LogTools.println("Reading" + s + " metadata");
            Hashtable meta = reader.getMetadata();
            Object[] keys = meta.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            int i = 0;
            while (i < keys.length) {
                LogTools.print(String.valueOf(keys[i]) + ": ");
                LogTools.println(reader.getMetadataValue((String)keys[i]));
                ++i;
            }
        }
        if (omexml) {
            LogTools.println();
            LogTools.println("Generating OME-XML");
            MetadataStore ms = reader.getMetadataStore();
            if (ms.getClass().getName().equals("loci.formats.ome.OMEXMLMetadataStore")) {
                try {
                    Method m = ms.getClass().getMethod("dumpXML", null);
                    String xml = (String)m.invoke((Object)ms, null);
                    LogTools.println(FormatTools.indentXML(xml));
                }
                catch (Throwable t) {
                    LogTools.println("Error generating OME-XML:");
                    LogTools.trace(t);
                }
            } else {
                LogTools.println("OME-Java library not found; no OME-XML available");
            }
        }
        return true;
    }

    public static boolean testConvert(IFormatWriter writer, String[] args) throws FormatException, IOException {
        String in = null;
        String out = null;
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith("-") && args.length > 1) {
                    if (args[i].equals("-debug")) {
                        FormatHandler.setDebug(true);
                    } else {
                        LogTools.println("Ignoring unknown command flag: " + args[i]);
                    }
                } else if (in == null) {
                    in = args[i];
                } else if (out == null) {
                    out = args[i];
                } else {
                    LogTools.println("Ignoring unknown argument: " + args[i]);
                }
                ++i;
            }
        }
        if (FormatHandler.debug) {
            LogTools.println("Debugging at level " + FormatHandler.debugLevel);
        }
        String className = writer.getClass().getName();
        if (in == null || out == null) {
            LogTools.println("To convert a file to " + writer.getFormat() + " format, run:");
            LogTools.println("  java " + className + " [-debug] in_file out_file");
            return false;
        }
        long start = System.currentTimeMillis();
        LogTools.print(String.valueOf(in) + " ");
        ImageReader reader = new ImageReader();
        reader.setId(in);
        LogTools.print("[" + reader.getFormat() + "] -> " + out + " ");
        writer.setId(out);
        LogTools.print("[" + writer.getFormat() + "] ");
        long mid = System.currentTimeMillis();
        int num = writer.canDoStacks() ? reader.getImageCount() : 1;
        long read = 0L;
        long write = 0L;
        int i = 0;
        while (i < num) {
            long s = System.currentTimeMillis();
            BufferedImage image = reader.openImage(i);
            long m = System.currentTimeMillis();
            writer.saveImage(image, i == num - 1);
            long e = System.currentTimeMillis();
            LogTools.print(".");
            read += m - s;
            write += e - m;
            ++i;
        }
        long end = System.currentTimeMillis();
        LogTools.println(" [done]");
        float sec = (float)(end - start) / 1000.0f;
        long initial = mid - start;
        float readAvg = (float)read / (float)num;
        float writeAvg = (float)write / (float)num;
        LogTools.println(String.valueOf(sec) + "s elapsed (" + readAvg + "+" + writeAvg + "ms per image, " + initial + "ms overhead)");
        return true;
    }

    private static class StatusEchoer
    implements StatusListener {
        private boolean verbose = true;
        private boolean next = true;

        private StatusEchoer() {
        }

        public void setVerbose(boolean value) {
            this.verbose = value;
        }

        public void setEchoNext(boolean value) {
            this.next = value;
        }

        public void statusUpdated(StatusEvent e) {
            if (this.verbose) {
                LogTools.println("\t" + e.getStatusMessage());
            } else if (this.next) {
                LogTools.print(";");
                this.next = false;
            }
        }
    }
}

