/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.LogTools;

public class ClassList {
    private Class base;
    private Vector classes;

    public ClassList(Class base) {
        this.base = base;
        this.classes = new Vector();
    }

    public ClassList(String file, Class base) throws IOException {
        this.base = base;
        this.classes = new Vector();
        if (file == null) {
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(file)));
        while (true) {
            Class<?> c;
            String line;
            block10: {
                line = null;
                line = in.readLine();
                if (line == null) break;
                int ndx = line.indexOf("#");
                if (ndx >= 0) {
                    line = line.substring(0, ndx);
                }
                if ((line = line.trim()).equals("")) continue;
                c = null;
                try {
                    c = Class.forName(line);
                }
                catch (ClassNotFoundException exc) {
                    if (FormatHandler.debug) {
                        LogTools.trace(exc);
                    }
                }
                catch (NoClassDefFoundError err) {
                    if (FormatHandler.debug) {
                        LogTools.trace(err);
                    }
                }
                catch (ExceptionInInitializerError err) {
                    if (!FormatHandler.debug) break block10;
                    LogTools.trace(err);
                }
            }
            if (c == null || base != null && !base.isAssignableFrom(c)) {
                LogTools.println("Error: \"" + line + "\" is not valid.");
                continue;
            }
            this.classes.add(c);
        }
        in.close();
    }

    public void addClass(Class c) throws FormatException {
        if (this.base != null && !this.base.isAssignableFrom(c)) {
            throw new FormatException("Class is not assignable to the base class");
        }
        this.classes.add(c);
    }

    public void removeClass(Class c) {
        this.classes.remove(c);
    }

    public Class[] getClasses() {
        Object[] c = new Class[this.classes.size()];
        this.classes.copyInto(c);
        return c;
    }
}

