/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.ReaderWrapper;

public class ChannelSeparator
extends ReaderWrapper {
    private byte[] lastImage;
    private int lastImageIndex = -1;
    private int lastImageSeries = -1;

    public ChannelSeparator() {
    }

    public ChannelSeparator(IFormatReader r) {
        super(r);
    }

    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        this.lastImage = null;
        this.lastImageIndex = -1;
        this.lastImageSeries = -1;
    }

    public void setId(String id, boolean force) throws FormatException, IOException {
        super.setId(id, force);
        this.lastImage = null;
        this.lastImageIndex = -1;
        this.lastImageSeries = -1;
    }

    public int getImageCount() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.reader.isRGB() ? this.getSizeC() / this.reader.getEffectiveSizeC() * this.reader.getImageCount() : this.reader.getImageCount();
    }

    public String getDimensionOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        String order = super.getDimensionOrder();
        if (this.reader.isRGB()) {
            String newOrder = "XYC";
            newOrder = order.indexOf("Z") > order.indexOf("T") ? String.valueOf(newOrder) + "TZ" : String.valueOf(newOrder) + "ZT";
            return newOrder;
        }
        return order;
    }

    public boolean isRGB() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return false;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        byte[] b = this.openBytes(no);
        if (this.getPixelType() == 6) {
            float[] f = new float[b.length / 4];
            int i = 0;
            while (i < b.length) {
                f[i / 4] = Float.intBitsToFloat(DataTools.bytesToInt(b, i, 4, this.isLittleEndian()));
                i += 4;
            }
            if (this.isNormalized()) {
                f = DataTools.normalizeFloats(f);
            }
            return ImageTools.makeImage(f, this.getSizeX(), this.getSizeY());
        }
        return ImageTools.makeImage(b, this.getSizeX(), this.getSizeY(), 1, false, bytes, this.isLittleEndian());
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        if (this.reader.isRGB()) {
            int c = this.getSizeC() / this.reader.getEffectiveSizeC();
            int source = no / c;
            int channel = no % c;
            int series = this.getSeries();
            if (source != this.lastImageIndex || series != this.lastImageSeries) {
                this.lastImage = this.reader.openBytes(source);
                this.lastImageIndex = source;
                this.lastImageSeries = series;
            }
            return ImageTools.splitChannels(this.lastImage, c, FormatTools.getBytesPerPixel(this.getPixelType()), false, this.isInterleaved())[channel];
        }
        return this.reader.openBytes(no);
    }

    public BufferedImage openThumbImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return ImageTools.scale(this.openImage(no), this.getThumbSizeX(), this.getThumbSizeY(), true);
    }

    public void close() throws IOException {
        super.close();
        this.lastImage = null;
        this.lastImageIndex = -1;
        this.lastImageSeries = -1;
    }

    public int getIndex(int z, int c, int t) {
        return FormatTools.getIndex(this, z, c, t);
    }

    public int[] getZCTCoords(int index) {
        return FormatTools.getZCTCoords(this, index);
    }
}

