/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tdialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.openmicroscopy.shoola.util.ui.tdialog.SizeButton;
import org.openmicroscopy.shoola.util.ui.tdialog.ThumbnailCanvas;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;
import org.openmicroscopy.shoola.util.ui.tdialog.TitleBar;

public class TinyDialogUI {
    public static final int MAX_WIDTH = 300;
    public static final int MAX_HEIGHT = 300;
    static final int BORDER_THICKNESS = 1;
    static final Color BORDER_COLOR = new Color(99, 130, 191);
    static final Color INNER_BORDER_HIGHLIGHT = new Color(240, 240, 240);
    static final Color INNER_BORDER_SHADOW = new Color(200, 200, 200);
    static final int INNER_PADDING = 1;
    private TinyDialog window;
    private TitleBar titleBar;
    private JComponent canvas;

    private void makeBorders() {
        JRootPane rootPane = this.window.getRootPane();
        rootPane.setBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1));
        if (this.canvas != null) {
            this.canvas.setBorder(BorderFactory.createBevelBorder(1, INNER_BORDER_HIGHLIGHT, INNER_BORDER_SHADOW));
        }
    }

    private void makeComponentsSize(int w, int h) {
        if (this.canvas == null) {
            return;
        }
        Insets i = this.canvas.getInsets();
        int width = w + i.right + i.left;
        int height = h + i.top + i.bottom;
        Dimension d = new Dimension(width, height);
        this.canvas.setPreferredSize(d);
        this.canvas.setSize(d);
    }

    private void buildUI() {
        Container container = this.window.getContentPane();
        container.add((Component)this.titleBar, "North");
        if (this.canvas != null) {
            container.add((Component)this.canvas, "Center");
        }
    }

    private void addComponent(JComponent c) {
        Container container = this.window.getContentPane();
        Component[] comps = container.getComponents();
        boolean in = false;
        for (int i = 0; i < comps.length; ++i) {
            if (!comps[i].equals(c)) continue;
            in = true;
            break;
        }
        if (!in) {
            container.add((Component)c, "Center");
            this.window.repaint();
        }
    }

    private void removeComponent(JComponent c) {
        this.window.getContentPane().remove(c);
    }

    private void attachButtonListener(ActionListener controller, JButton b, int id) {
        if (b == null) {
            return;
        }
        b.addActionListener(controller);
        b.setActionCommand("" + id);
    }

    private void initialize(TinyDialog window) {
        if (window == null) {
            throw new NullPointerException("No window.");
        }
        this.window = window;
        this.titleBar = new TitleBar(window.getTitle(), window.hasClosedButton());
    }

    TinyDialogUI(TinyDialog window, BufferedImage image) {
        this.initialize(window);
        this.canvas = new ThumbnailCanvas(image);
        this.canvas.setToolTipText(window.title);
        this.makeComponentsSize(image.getWidth(), image.getHeight());
        this.makeBorders();
        this.buildUI();
    }

    TinyDialogUI(TinyDialog window, JComponent c) {
        if (c == null) {
            throw new NullPointerException("No component.");
        }
        this.initialize(window);
        this.canvas = c;
        this.makeBorders();
        this.buildUI();
    }

    TinyDialogUI(TinyDialog window) {
        this.initialize(window);
        this.makeBorders();
        this.buildUI();
    }

    void setImage(BufferedImage image) {
        if (this.canvas instanceof ThumbnailCanvas) {
            this.makeComponentsSize(image.getWidth(), image.getHeight());
            ((ThumbnailCanvas)this.canvas).setImage(image);
            this.window.pack();
        }
    }

    void attachMouseWheelListener(MouseWheelListener controller) {
        if (this.canvas instanceof ThumbnailCanvas) {
            this.canvas.addMouseWheelListener(controller);
        }
    }

    void attachActionListener(ActionListener controller) {
        this.attachButtonListener(controller, this.titleBar.getButton(0), 0);
        this.attachButtonListener(controller, this.titleBar.getButton(1), 1);
    }

    void attachMouseMotionListener(MouseMotionListener controller) {
        this.titleBar.addMouseMotionListener(controller);
    }

    void updateTitleBar() {
        this.titleBar.update(this.window.getTitle());
    }

    void updateCollapsedState() {
        SizeButton button = (SizeButton)this.titleBar.getButton(0);
        if (this.window.isCollapsed()) {
            this.removeComponent(this.canvas);
            Dimension d = new Dimension(this.window.getWidth(), 14);
            this.titleBar.setPreferredSize(d);
            button.setActionType(2);
            this.window.setSize(d.width, d.height);
        } else {
            this.addComponent(this.canvas);
            button.setActionType(1);
            Dimension dT = this.titleBar.getPreferredSize();
            Dimension dW = this.window.getRestoreSize();
            this.window.setSize(dT.width, dW.height);
        }
        this.window.validate();
        this.window.repaint();
    }

    void updateClosedState() {
        if (this.window.isClosed()) {
            this.window.setVisible(false);
            this.window.dispose();
        }
    }

    void setDecoration(List l) {
        if (this.titleBar == null) {
            return;
        }
        this.titleBar.setDecoration(l);
    }

    void setCanvas(JComponent c) {
        this.canvas = c;
        this.addComponent(this.canvas);
    }

    public void attachMouseListener(MouseListener controller) {
        this.titleBar.addMouseListener(controller);
        if (this.canvas instanceof ThumbnailCanvas) {
            this.canvas.addMouseListener(controller);
        }
    }
}

