/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.slider;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

class TwoKnobsSliderModel {
    static final int DEFAULT_MIN = 0;
    static final int DEFAULT_MAX = 100;
    private int maximum;
    private int minimum;
    private int startValue;
    private int endValue;
    private boolean enabled;
    private boolean paintLabels;
    private boolean paintTicks;
    private boolean paintEndLabels;
    private int majorTickSpacing;
    private int minorTickSpacing;
    private int increment;
    private Map<Integer, String> labels;
    private int orientation;

    private void createEndLabels() {
        this.labels.put(new Integer(this.minimum), this.render(this.minimum));
        this.labels.put(new Integer(this.maximum), this.render(this.maximum));
    }

    private void createLabels() {
        for (int i = this.minimum; i <= this.maximum; i += this.increment) {
            this.labels.put(new Integer(i), this.render(i));
        }
    }

    private void installDefaults() {
        this.paintTicks = true;
        this.enabled = true;
        this.increment = (this.maximum - this.minimum) / 10;
        this.minorTickSpacing = 1;
        this.majorTickSpacing = 10;
        this.labels = new HashMap<Integer, String>();
        this.setPaintLabels(false);
        this.setPaintEndLabels(true);
        this.setOrientation(100);
    }

    TwoKnobsSliderModel(int maximum, int minimum, int startValue, int endValue) {
        this.checkValues(maximum, minimum, startValue, endValue);
        this.installDefaults();
    }

    void checkValues(int maximum, int minimum, int startValue, int endValue) {
        if (maximum < minimum || startValue < minimum || startValue > maximum || endValue < minimum || endValue > maximum || startValue > endValue) {
            throw new IllegalArgumentException("Invalid range properties");
        }
        this.startValue = startValue;
        this.endValue = endValue;
        this.minimum = minimum;
        this.maximum = maximum;
        this.increment = (maximum - minimum) / 10;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    int getEndValue() {
        return this.endValue;
    }

    int getStartValue() {
        return this.startValue;
    }

    int getMaximum() {
        return this.maximum;
    }

    int getMinimum() {
        return this.minimum;
    }

    void setStartValue(int startValue) {
        if (startValue < this.minimum || startValue >= this.endValue) {
            throw new IllegalArgumentException("Start value not valid.");
        }
        this.startValue = startValue;
    }

    void setEndValue(int endValue) {
        if (endValue <= this.startValue || endValue > this.maximum) {
            throw new IllegalArgumentException("End value not valid.");
        }
        this.endValue = endValue;
    }

    void setMaximum(int maximum) {
        if (maximum <= this.minimum) {
            throw new IllegalArgumentException("Maximum must be greater than minimum.");
        }
        this.maximum = maximum;
    }

    void setMinimum(int minimum) {
        if (minimum >= this.maximum) {
            throw new IllegalArgumentException("Minimum cannot be greaterthan maximum.");
        }
        this.minimum = minimum;
    }

    void setPaintLabels(boolean paintLabels) {
        this.paintLabels = paintLabels;
        if (paintLabels) {
            this.createLabels();
        }
    }

    void setPaintTicks(boolean paintTicks) {
        this.paintTicks = paintTicks;
    }

    void setPaintEndLabels(boolean b) {
        this.paintEndLabels = b;
        if (this.paintEndLabels) {
            this.createEndLabels();
        }
    }

    boolean isPaintLabels() {
        return this.paintLabels;
    }

    boolean isPaintTicks() {
        return this.paintTicks;
    }

    boolean isPaintEndLabels() {
        return this.paintEndLabels;
    }

    int getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    void setMajorTickSpacing(int v) {
        this.majorTickSpacing = v;
    }

    int getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    void setMinorTickSpacing(int v) {
        this.minorTickSpacing = v;
    }

    int getIncrement() {
        return this.increment;
    }

    Map getLabels() {
        return this.labels;
    }

    String render(double value) {
        return new DecimalFormat().format(value);
    }

    int getOrientation() {
        return this.orientation;
    }

    void setOrientation(int v) {
        this.orientation = v;
    }
}

