/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.login;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import layout.TableLayout;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.border.PartialLineBorder;
import org.openmicroscopy.shoola.util.ui.login.ServerTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerEditor
extends JPanel {
    public static final int TITLE_HEIGHT = 70;
    public static final String REMOVE_MESSAGE_PROPERTY = "removeMessage";
    public static final String ADD_MESSAGE_PROPERTY = "addMessage";
    static final String EDIT_PROPERTY = "edit";
    static final String SERVER_PROPERTY = "server";
    static final String REMOVE_PROPERTY = "remove";
    static final String ADD_PROPERTY = "add";
    private static final String EMPTY_MSG = "Server address already exists.";
    private static final String EXAMPLE = "(e.g. test.openmicroscopy.org or 134.20.12.33)";
    private static final String SERVER_NAME_SEPARATOR = ",";
    private static final String OMERO_SERVER = "omeroServer";
    private static final Font FONT = new Font("SansSerif", 2, 10);
    private JButton removeButton;
    private JButton addButton;
    private ServerTable table;
    private JPanel emptyMessagePanel;
    private IconManager icons = IconManager.getInstance();
    private boolean warning;
    private boolean editing;
    private String activeServer;

    private void removeRow(int row) {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        if (row < 0) {
            return;
        }
        if (model.getColumnCount() < 2) {
            return;
        }
        String oldValue = (String)model.getValueAt(row, 1);
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        this.table.removeRow(row);
        int m = model.getRowCount() - 1;
        String newValue = null;
        if (m > -1 && this.table.getColumnCount() > 1) {
            this.table.changeSelection(m, 1, false, false);
            newValue = (String)model.getValueAt(m, 1);
            this.requestFocusInWindow();
        }
        if ((editor = this.table.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        if (model.getRowCount() == 0) {
            this.setEditing(false);
        }
        this.handleServers(this.activeServer);
        this.editing = false;
        this.fireEditProperty(model.getRowCount() != 0);
        this.firePropertyChange(REMOVE_PROPERTY, oldValue, newValue);
    }

    private void addRow() {
        if (this.editing) {
            return;
        }
        this.addButton.setEnabled(false);
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        int m = model.getRowCount();
        Object[] newRow = new Object[]{this.icons.getIcon(23), ""};
        model.insertRow(m, newRow);
        model.fireTableDataChanged();
        this.requesFocusOnEditedCell(m);
        this.setEditing(true);
    }

    private void initComponents(List servers) {
        this.table = new ServerTable(this, servers, this.icons.getIcon(23));
        this.removeButton = new JButton(this.icons.getIcon(24));
        this.removeButton.setToolTipText("Remove the selected server from the list of servers.");
        this.addButton = new JButton(this.icons.getIcon(28));
        this.addButton.setToolTipText("Add a new server to the list of servers.");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerEditor.this.removeRow(ServerEditor.this.table.getSelectedRow());
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerEditor.this.addRow();
            }
        });
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JPanel labels = new JPanel();
        double[] columns = new double[]{-2.0, 5.0, -1.0};
        double[] rows = this.activeServer != null ? new double[]{-1.0, 5.0, -1.0} : new double[]{-1.0};
        TableLayout layout = new TableLayout();
        layout.setColumn(columns);
        layout.setRow(rows);
        labels.setLayout((LayoutManager)layout);
        JLabel label = UIUtilities.setTextFont("Server Address");
        labels.add((Component)label, "0, 0");
        label = new JLabel(EXAMPLE);
        label.setFont(FONT);
        labels.add((Component)label, "2, 0");
        if (this.activeServer != null) {
            labels.add((Component)new JLabel(), "0, 1, 2, 1");
            label = UIUtilities.setTextFont("Connected to ");
            labels.add((Component)label, "0, 2");
            labels.add((Component)new JLabel(this.activeServer), "2, 2");
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        p.add(new JScrollPane(this.table));
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(this.addButton);
        bar.add(this.removeButton);
        p.add(UIUtilities.buildComponentPanel(bar));
        this.add(UIUtilities.buildComponentPanel(labels));
        this.add(p);
    }

    private void setButtonsEnabled(boolean b) {
        this.addButton.setEnabled(b);
        this.removeButton.setEnabled(b);
    }

    private void fireEditProperty(boolean b) {
        Boolean newValue = Boolean.TRUE;
        Boolean oldValue = Boolean.FALSE;
        if (!b) {
            newValue = Boolean.FALSE;
            oldValue = Boolean.TRUE;
        }
        this.firePropertyChange(EDIT_PROPERTY, oldValue, newValue);
    }

    private void buildEmptyPanel() {
        if (this.emptyMessagePanel != null) {
            return;
        }
        this.emptyMessagePanel = new JPanel();
        this.emptyMessagePanel.setOpaque(false);
        this.emptyMessagePanel.setBorder(new PartialLineBorder(Color.BLACK));
        this.emptyMessagePanel.setLayout(new BoxLayout(this.emptyMessagePanel, 0));
        JLabel label = new JLabel(this.icons.getIcon(37));
        this.emptyMessagePanel.add(label);
        int w = label.getWidth();
        label = new JLabel(EMPTY_MSG);
        int h = label.getFontMetrics(label.getFont()).getHeight();
        this.emptyMessagePanel.add(label);
        Insets i = this.emptyMessagePanel.getInsets();
        this.emptyMessagePanel.setBounds(2, 70 - (h += i.top + i.bottom) - 1, 3 * (w += this.getFontMetrics(this.getFont()).stringWidth(EMPTY_MSG)) / 2, h);
    }

    void setEditing(boolean b) {
        this.addButton.setEnabled(!b);
        this.editing = b;
    }

    boolean isEditing() {
        return this.editing;
    }

    void requesFocusOnEditedCell(int m) {
        if (this.table.getColumnCount() > 1) {
            TableCellEditor editor = this.table.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            this.table.editCellAt(m, 1);
            this.table.changeSelection(m, 1, false, false);
        }
    }

    void changeSelection(int row, int previousRow, String text) {
        TableCellEditor editor;
        this.fireEditProperty(row != -1);
        if (previousRow == -1 || previousRow == row) {
            return;
        }
        if (!this.editing) {
            return;
        }
        this.editing = false;
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (i == previousRow) continue;
            values.add((String)this.table.getValueAt(i, 1));
        }
        if (this.activeServer != null && !values.contains(this.activeServer)) {
            values.add(this.activeServer);
        }
        Iterator j = values.iterator();
        boolean found = false;
        while (j.hasNext()) {
            String name = (String)j.next();
            if (!name.equals(text)) continue;
            found = true;
            break;
        }
        this.handleServers(this.activeServer);
        if (found || text == null) {
            this.removeRow(previousRow);
            this.showMessagePanel(false);
        }
        if ((editor = this.table.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
    }

    void showMessagePanel(boolean warning) {
        this.warning = warning;
        this.fireEditProperty(!warning);
        this.setButtonsEnabled(!warning);
        if (warning) {
            if (this.emptyMessagePanel != null) {
                return;
            }
            this.buildEmptyPanel();
            this.firePropertyChange(ADD_MESSAGE_PROPERTY, null, this.emptyMessagePanel);
        } else {
            if (this.emptyMessagePanel == null) {
                return;
            }
            this.firePropertyChange(REMOVE_MESSAGE_PROPERTY, null, this.emptyMessagePanel);
            this.emptyMessagePanel = null;
        }
    }

    void finishEdition(String text) {
        if (!this.editing) {
            return;
        }
        this.editing = false;
        this.setButtonsEnabled(true);
        if (this.warning || text == null || text.length() == 0) {
            this.removeRow(this.table.getSelectedRow());
            this.showMessagePanel(false);
            return;
        }
        this.handleServers(this.activeServer);
    }

    void stopEdition() {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    String getSelectedServer() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return "";
        }
        String v = (String)this.table.getValueAt(row, 1);
        if (v == null) {
            return "";
        }
        return v.trim();
    }

    String getActiveServer() {
        return this.activeServer;
    }

    List<String> getServers() {
        Preferences prefs = Preferences.userNodeForPackage(ServerEditor.class);
        String servers = prefs.get(OMERO_SERVER, null);
        if (servers == null || servers.length() == 0) {
            return null;
        }
        String[] l = servers.split(SERVER_NAME_SEPARATOR, 0);
        if (l == null) {
            return null;
        }
        ArrayList<String> listOfServers = new ArrayList<String>();
        for (int index = 0; index < l.length; ++index) {
            String server = l[index].trim();
            if (server.equals(this.activeServer)) continue;
            listOfServers.add(server);
        }
        return listOfServers;
    }

    void handleServers(String serverName) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            l.add((String)this.table.getValueAt(i, 1));
        }
        if (this.activeServer != null && !l.contains(this.activeServer)) {
            l.add(this.activeServer);
        }
        Preferences prefs = Preferences.userNodeForPackage(ServerEditor.class);
        if (l == null || l.size() == 0) {
            prefs.put(OMERO_SERVER, "");
            return;
        }
        ArrayList<String> servers = new ArrayList<String>(l.size());
        for (String name : l) {
            if (name.equals(serverName)) continue;
            servers.add(name);
        }
        if (serverName != null && serverName.length() != 0) {
            servers.add(serverName);
        }
        Iterator i = servers.iterator();
        int n = servers.size() - 1;
        int index = 0;
        String list = "";
        while (i.hasNext()) {
            list = list + (String)i.next();
            if (index != n) {
                list = list + SERVER_NAME_SEPARATOR;
            }
            ++index;
        }
        if (list.length() != 0) {
            prefs.put(OMERO_SERVER, list);
        }
    }

    public ServerEditor() {
        this((String)null);
    }

    public ServerEditor(String activeServer) {
        this.activeServer = activeServer;
        int n = 0;
        List<String> servers = this.getServers();
        if (servers != null) {
            n = servers.size();
        }
        this.initComponents(servers);
        this.setEditing(n == 0);
        this.buildGUI();
    }

    public void initFocus() {
        int n = 0;
        List<String> servers = this.getServers();
        if (servers != null) {
            n = servers.size();
        }
        if (n == 0) {
            this.requesFocusOnEditedCell(this.table.getRowCount() - 1);
        }
    }
}

