/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.login;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.login.ServerEditor;

class ServerDialog
extends JDialog
implements ComponentListener,
PropertyChangeListener {
    static final String SERVER_PROPERTY = "server";
    static final String CLOSE_PROPERTY = "close";
    static final String REMOVE_PROPERTY = "remove";
    private static final Dimension WINDOW_DIM = new Dimension(400, 450);
    private static final String TITLE = "Servers";
    private static final String TEXT = "Enter a new server or \nselect an existing one.";
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    protected static final Dimension V_SPACER_SIZE = new Dimension(1, 20);
    private JButton cancelButton;
    private JButton finishButton;
    private ServerEditor editor;
    private JLayeredPane titleLayer;
    private TitlePanel titlePanel;

    private void close() {
        this.editor.stopEdition();
        this.setVisible(false);
        this.dispose();
    }

    private void apply() {
        this.editor.stopEdition();
        String server = this.editor.getSelectedServer();
        if (server != null) {
            this.editor.handleServers(server);
        }
        this.firePropertyChange(SERVER_PROPERTY, null, server);
        this.close();
    }

    private void setProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setAlwaysOnTop(true);
    }

    private void initListeners() {
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerDialog.this.close();
            }
        });
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerDialog.this.apply();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ServerDialog.this.close();
            }

            public void windowOpened(WindowEvent e) {
                ServerDialog.this.editor.initFocus();
            }
        });
        this.addComponentListener(this);
    }

    private void initComponents() {
        this.editor.addPropertyChangeListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Close the window.");
        this.finishButton = new JButton("Apply");
        this.finishButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.finishButton);
        IconManager icons = IconManager.getInstance();
        this.titleLayer = new JLayeredPane();
        this.titlePanel = new TitlePanel(TITLE, TEXT, icons.getIcon(27));
        this.titleLayer.add((Component)this.titlePanel, new Integer(0));
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.finishButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.cancelButton);
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        p.setOpaque(true);
        return p;
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        this.setLayout(new BorderLayout(0, 0));
        c.add((Component)this.titleLayer, "North");
        c.add((Component)this.editor, "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    private void showMessagePanel(boolean warning, JComponent p) {
        if (warning) {
            this.titleLayer.add((Component)p, new Integer(1));
            this.titleLayer.validate();
            this.titleLayer.repaint();
        } else {
            if (p == null) {
                return;
            }
            this.titleLayer.remove(p);
            this.titleLayer.repaint();
        }
    }

    ServerDialog(JFrame frame, ServerEditor editor) {
        super(frame);
        this.editor = editor;
        this.setProperties();
        this.initComponents();
        this.initListeners();
        this.buildGUI();
        this.setSize(WINDOW_DIM);
    }

    public void componentResized(ComponentEvent e) {
        Rectangle r = this.getBounds();
        if (this.titleLayer == null) {
            return;
        }
        Dimension d = new Dimension(r.width, 70);
        this.titlePanel.setSize(d);
        this.titlePanel.setPreferredSize(d);
        this.titleLayer.setSize(d);
        this.titleLayer.setPreferredSize(d);
        this.titleLayer.validate();
        this.titleLayer.repaint();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("edit".equals(name)) {
            Boolean value = (Boolean)evt.getNewValue();
            this.finishButton.setEnabled(value);
        } else if ("addMessage".equals(name)) {
            this.showMessagePanel(true, (JComponent)evt.getNewValue());
        } else if ("removeMessage".equals(name)) {
            this.showMessagePanel(false, (JComponent)evt.getNewValue());
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }
}

