/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.login;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import layout.TableLayout;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.login.LoginCredentials;
import org.openmicroscopy.shoola.util.ui.login.ServerDialog;
import org.openmicroscopy.shoola.util.ui.login.ServerEditor;

public class ScreenLogin
extends JFrame
implements ActionListener,
PropertyChangeListener {
    public static final String TO_FRONT_PROPERTY = "toFront";
    public static final String LOGIN_PROPERTY = "login";
    public static final String QUIT_PROPERTY = "quit";
    public static final int USERNAME_FIELD = 0;
    public static final int PASSWORD_FIELD = 1;
    public static final String DEFAULT_SERVER = "Add a new server ->";
    private static final String OMERO_USER = "omeroUser";
    static final Color TEXT_COLOR = Color.WHITE;
    private static final float VERSION_FONT_SIZE = 10.0f;
    private static final int TEXT_FONT_SIZE = 18;
    private static final String TEXT_LOGIN = "Please Log In";
    private static final String USER_TEXT = "Username: ";
    private static final String PASSWORD_TEXT = "Password: ";
    private JTextField user;
    private JPasswordField pass;
    private JButton configButton;
    private JButton login;
    private JButton cancel;
    private String serverName;
    private JTextPane serverText;
    private JTextPane versionInfo;
    private ServerEditor editor;

    private void quit() {
        this.firePropertyChange(QUIT_PROPERTY, Boolean.FALSE, Boolean.TRUE);
    }

    private void login() {
        this.firePropertyChange(TO_FRONT_PROPERTY, Boolean.FALSE, Boolean.TRUE);
        this.requestFocusOnField();
        StringBuffer buf = new StringBuffer();
        buf.append(this.pass.getPassword());
        String usr = this.user.getText().trim();
        String psw = buf.toString();
        String s = this.serverText.getText().trim();
        this.setControlsEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        LoginCredentials lc = new LoginCredentials(usr, psw, s);
        this.setUserName(usr);
        this.firePropertyChange(LOGIN_PROPERTY, null, lc);
    }

    private void config() {
        ServerDialog d = new ServerDialog(this, this.editor);
        d.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(d);
    }

    private void initListeners() {
        this.login.addActionListener(this);
        this.user.addActionListener(this);
        this.pass.addActionListener(this);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScreenLogin.this.quit();
            }
        });
        this.configButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScreenLogin.this.config();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                ScreenLogin.this.requestFocusOnField();
            }
        });
        this.user.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (ScreenLogin.this.user.getText() != null) {
                    ScreenLogin.this.user.selectAll();
                }
            }

            public void mouseClicked(MouseEvent e) {
            }
        });
        this.pass.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    private void setButtonDefault(JButton button) {
        button.setRolloverEnabled(false);
        button.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void initButtons() {
        this.login = new JButton("Login");
        this.login.setMnemonic('L');
        this.login.setToolTipText("Login");
        this.setButtonDefault(this.login);
        UIUtilities.enterPressesWhenFocused(this.login);
        UIUtilities.opacityCheck(this.login);
        this.cancel = new JButton("Quit");
        this.cancel.setMnemonic('Q');
        this.cancel.setToolTipText("Quit the Application");
        this.setButtonDefault(this.cancel);
        UIUtilities.opacityCheck(this.cancel);
        this.configButton = new JButton();
        this.configButton.setMnemonic('X');
        this.configButton.setToolTipText("Config Server");
        this.configButton.setBorderPainted(false);
        this.configButton.setBorder(null);
        this.configButton.setMargin(new Insets(0, 0, 0, 0));
        this.configButton.setFocusPainted(false);
        this.configButton.setContentAreaFilled(false);
        IconManager icons = IconManager.getInstance();
        this.configButton.setIcon(icons.getIcon(25));
        this.configButton.setPressedIcon(icons.getIcon(26));
        this.getRootPane().setDefaultButton(this.login);
    }

    private void initFields(String userName) {
        this.user = new JTextField(20);
        this.user.setText(userName);
        this.user.setToolTipText("Enter your username.");
        this.pass = new JPasswordField();
        this.pass.setToolTipText("Enter your password.");
        List<String> servers = this.editor.getServers();
        this.serverName = servers == null || servers.size() == 0 ? DEFAULT_SERVER : servers.get(servers.size() - 1);
        this.serverText = UIUtilities.buildTextPane(this.serverName, TEXT_COLOR);
    }

    private JPanel buildTextPanel(JTextField field, int mnemonic, String s) {
        double[][] size = new double[][]{{-2.0, -1.0}, {30.0}};
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout((LayoutManager)layout);
        JLabel label = UIUtilities.setTextFont(s);
        label.setForeground(TEXT_COLOR);
        label.setDisplayedMnemonic(mnemonic);
        label.setLabelFor(field);
        label.setOpaque(false);
        panel.add((Component)label, "0, 0, r, c");
        panel.add((Component)field, "1, 0, f, c");
        return panel;
    }

    private JPanel buildTopPanel() {
        double[][] topTable = new double[][]{{245.0, 18.0, 220.0, 28.0}, {32.0, -1.0}};
        JPanel topPanel = new JPanel();
        topPanel.setOpaque(false);
        topPanel.setLayout((LayoutManager)new TableLayout((double[][])topTable));
        topPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JTextPane pleaseLogIn = UIUtilities.buildTextPane(TEXT_LOGIN, TEXT_COLOR);
        Font f = pleaseLogIn.getFont();
        Font newFont = f.deriveFont(1, 18.0f);
        pleaseLogIn.setFont(newFont);
        topPanel.add((Component)pleaseLogIn, "0, 0, l, c");
        topPanel.add((Component)this.serverText, "2, 0, r, c");
        topPanel.add((Component)this.configButton, "3, 0, c, c");
        topPanel.add((Component)this.buildTextPanel(this.user, 85, USER_TEXT), "0, 1, 0, 1");
        topPanel.add((Component)this.buildTextPanel(this.pass, 80, PASSWORD_TEXT), "2, 1, 3, 1");
        return topPanel;
    }

    private JPanel buildMainPanel(String version) {
        double[][] mainTable = new double[][]{{-1.0, 100.0, 5.0, 100.0}, {-1.0, 30.0}};
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout((LayoutManager)new TableLayout((double[][])mainTable));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        mainPanel.setOpaque(false);
        mainPanel.add((Component)this.login, "1, 1, f, c");
        mainPanel.add((Component)this.cancel, "3, 1, f, c");
        this.versionInfo = UIUtilities.buildTextPane(version, TEXT_COLOR);
        Font f = this.versionInfo.getFont();
        Font newFont = f.deriveFont(10.0f);
        this.versionInfo.setFont(newFont);
        mainPanel.add((Component)this.versionInfo, "0, 1, l, b");
        mainPanel.add((Component)this.buildTopPanel(), "0, 0, 3, 0");
        return mainPanel;
    }

    private void buildGUI(Icon logo, String version) {
        JLabel background = new JLabel(logo);
        background.setBorder(BorderFactory.createEmptyBorder());
        JLayeredPane layers = new JLayeredPane();
        int width = logo.getIconWidth();
        int height = logo.getIconHeight();
        layers.setBounds(0, 0, width, height);
        JPanel p = this.buildMainPanel(version);
        background.setBounds(0, 0, width, height);
        p.setBounds(0, 0, width, height);
        layers.add((Component)background, new Integer(0));
        layers.add((Component)p, new Integer(1));
        this.getContentPane().add(layers);
    }

    private String getServerName() {
        String s = this.serverText.getText();
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    private void setNewServer(String s) {
        if (s == null || s.length() == 0) {
            s = DEFAULT_SERVER;
        }
        this.serverText.setText(s);
        this.serverText.validate();
        this.serverText.repaint();
    }

    private void setUserName(String name) {
        if (name == null) {
            return;
        }
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        prefs.put(OMERO_USER, name);
    }

    private String getUserName() {
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        return prefs.get(OMERO_USER, null);
    }

    private void requestFocusOnField() {
        String txt = this.user.getText();
        if (txt == null || txt.trim().length() == 0) {
            this.user.requestFocus();
        } else {
            this.pass.requestFocus();
        }
    }

    private void setProperties(Image frameIcon) {
        this.setIconImage(frameIcon);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setUndecorated(true);
        this.toFront();
    }

    public ScreenLogin(String title, Icon logo, Image frameIcon, String version) {
        this.setTitle(title);
        if (logo == null) {
            throw new NullPointerException("No Frame icon.");
        }
        Dimension d = new Dimension(logo.getIconWidth(), logo.getIconHeight());
        this.setSize(d);
        this.setPreferredSize(d);
        this.editor = new ServerEditor();
        this.editor.addPropertyChangeListener("remove", this);
        this.initFields(this.getUserName());
        this.initButtons();
        this.initListeners();
        this.buildGUI(logo, version);
        this.setProperties(frameIcon);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ScreenLogin.this.firePropertyChange(ScreenLogin.TO_FRONT_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                ScreenLogin.this.requestFocusOnField();
            }
        });
    }

    public ScreenLogin(String title, Icon logo, Image frameIcon) {
        this(title, logo, frameIcon, null);
    }

    public ScreenLogin(Icon logo, Image frameIcon, String version) {
        this(null, logo, frameIcon, version);
    }

    public ScreenLogin(Icon logo, Image frameIcon) {
        this(null, logo, frameIcon, null);
    }

    public void setControlsEnabled(boolean b) {
        this.user.setEnabled(b);
        this.pass.setEnabled(b);
        this.login.setEnabled(b);
        this.login.requestFocus();
        this.configButton.setEnabled(b);
    }

    public void cleanFields() {
        this.setCursor(Cursor.getDefaultCursor());
        this.user.setText("");
        this.pass.setText("");
    }

    public void cleanField(int fieldID) {
        this.setCursor(Cursor.getDefaultCursor());
        switch (fieldID) {
            case 0: {
                this.user.setText("");
                break;
            }
            case 1: {
                this.pass.setText("");
                break;
            }
            default: {
                this.cleanFields();
            }
        }
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("server".equals(name)) {
            String v = this.getServerName();
            String s = (String)evt.getNewValue();
            if (s == null) {
                this.setNewServer(null);
                return;
            }
            String trim = s.trim();
            if (v.equals(trim)) {
                return;
            }
            this.setNewServer(trim);
        } else if ("remove".equals(name)) {
            this.requestFocusOnField();
            String v = this.getServerName();
            String oldValue = (String)evt.getOldValue();
            if (v.equals(oldValue)) {
                this.setNewServer((String)evt.getNewValue());
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.login();
    }
}

