/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.openmicroscopy.shoola.util.ui.lens.LensComponent;
import org.openmicroscopy.shoola.util.ui.lens.LensController;
import org.openmicroscopy.shoola.util.ui.lens.ZoomWindowUI;

class ZoomWindow {
    private ZoomWindowUI zoomWindowUI;
    private LensController lensController;
    private LensComponent lensComponent;

    ZoomWindow(JFrame parent, LensComponent lensComponent) {
        this.lensComponent = lensComponent;
        this.zoomWindowUI = new ZoomWindowUI(parent, lensComponent);
    }

    ZoomWindow(LensComponent lensComponent) {
        if (lensComponent == null) {
            throw new IllegalArgumentException("No parent.");
        }
        this.lensComponent = lensComponent;
        this.zoomWindowUI = new ZoomWindowUI(null, lensComponent);
    }

    void addController(LensController lensController) {
        if (lensController == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.lensController = lensController;
    }

    void setDisplayInPixels(boolean b) {
        this.zoomWindowUI.setDisplayInPixels(b);
    }

    void setMenu(JMenuBar menu) {
        this.zoomWindowUI.setJMenuBar(menu);
    }

    void setXYPixelMicron(float x, float y) {
        this.zoomWindowUI.setXYPixelMicron(x, y);
    }

    void repaint() {
        this.zoomWindowUI.repaint();
    }

    void setVisible(boolean makeVisible) {
        this.zoomWindowUI.setVisible(makeVisible);
    }

    void setZoomImage(BufferedImage zoomImage) {
        this.zoomWindowUI.setZoomImage(zoomImage);
    }

    void setLensXY(int x, int y) {
        this.zoomWindowUI.setLensXY(x, y);
    }

    void setLensWidthHeight(int w, int h) {
        this.zoomWindowUI.setLensWidthHeight(w, h);
    }

    void setLensZoomFactor(float zoomFactor) {
        this.zoomWindowUI.setLensZoomFactor(zoomFactor);
    }

    void setZoomUISize(float w, float h) {
        this.zoomWindowUI.setZoomedImageSize((int)w, (int)h);
    }

    ZoomWindowUI getUI() {
        return this.zoomWindowUI;
    }

    boolean isVisible() {
        return this.zoomWindowUI.isVisible();
    }
}

