/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openmicroscopy.shoola.util.ui.ColorMenuItem;
import org.openmicroscopy.shoola.util.ui.lens.DisplayAction;
import org.openmicroscopy.shoola.util.ui.lens.LensAction;
import org.openmicroscopy.shoola.util.ui.lens.LensColorAction;
import org.openmicroscopy.shoola.util.ui.lens.LensComponent;
import org.openmicroscopy.shoola.util.ui.lens.ZoomAction;

class LensMenu {
    static final String POPUP_MENU_DESCRIPTION = "Magnifying Lens Options";
    static final String POPUP_MENU_TOPOPTION = "Magnifying Lens Options";
    static final String LENS_OPTIONS = "Lens";
    static final String ZOOM_OPTIONS = "Zoom";
    static final String DISPLAY_UNITS = "Units";
    static final String LENS_COLOR_OPTIONS = "Lens Color";
    private LensComponent lensComponent;
    private JPopupMenu popupMenu;
    private JMenuBar menubar;

    private JMenu createLensOptions() {
        JMenu lensOptions = new JMenu(LENS_OPTIONS);
        for (int indexCnt = 0; indexCnt < 10; ++indexCnt) {
            JMenuItem setLensSize = new JMenuItem(new LensAction(this.lensComponent, indexCnt));
            lensOptions.add(setLensSize);
        }
        return lensOptions;
    }

    private JMenu createZoomOptions() {
        JMenu zoomOptions = new JMenu(ZOOM_OPTIONS);
        for (int indexCnt = 0; indexCnt < 10; ++indexCnt) {
            JMenuItem setLensZoom = new JMenuItem(new ZoomAction(this.lensComponent, indexCnt));
            zoomOptions.add(setLensZoom);
        }
        return zoomOptions;
    }

    private JMenu createLensColorOptions() {
        JMenu lensColorOptions = new JMenu(LENS_COLOR_OPTIONS);
        for (int indexCnt = 0; indexCnt < 12; ++indexCnt) {
            LensColorAction lensColorAction = new LensColorAction(this.lensComponent, indexCnt);
            ColorMenuItem lensColor = new ColorMenuItem(lensColorAction.getColor());
            lensColor.addActionListener(lensColorAction);
            lensColor.setText(lensColorAction.getName());
            lensColorOptions.add(lensColor);
        }
        return lensColorOptions;
    }

    private JMenu createDisplayOptions() {
        JMenu displayOptions = new JMenu(DISPLAY_UNITS);
        ButtonGroup displayUnits = new ButtonGroup();
        for (int indexCnt = 0; indexCnt < 2; ++indexCnt) {
            JCheckBoxMenuItem setDisplayScale = new JCheckBoxMenuItem(new DisplayAction(this.lensComponent, indexCnt));
            displayUnits.add(setDisplayScale);
            displayOptions.add(setDisplayScale);
            setDisplayScale.setSelected(indexCnt == 1);
        }
        return displayOptions;
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu("Magnifying Lens Options");
        JMenuItem topOption = new JMenuItem("Magnifying Lens Options");
        this.popupMenu.add(topOption);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createLensOptions());
        this.popupMenu.add(this.createZoomOptions());
        this.popupMenu.add(this.createDisplayOptions());
        this.popupMenu.add(this.createLensColorOptions());
    }

    private void createMenubarMenu() {
        this.menubar = new JMenuBar();
        this.menubar.add(this.createLensOptions());
        this.menubar.add(this.createZoomOptions());
        this.menubar.add(this.createDisplayOptions());
        this.menubar.add(this.createLensColorOptions());
    }

    LensMenu(LensComponent lensComponent) {
        this.lensComponent = lensComponent;
        this.createPopupMenu();
        this.createMenubarMenu();
    }

    JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    JMenuBar getMenubar() {
        return this.menubar;
    }
}

