/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import org.openmicroscopy.shoola.util.ui.lens.LensController;
import org.openmicroscopy.shoola.util.ui.lens.LensMenu;
import org.openmicroscopy.shoola.util.ui.lens.LensModel;
import org.openmicroscopy.shoola.util.ui.lens.LensUI;
import org.openmicroscopy.shoola.util.ui.lens.ZoomWindow;

public class LensComponent
extends AbstractComponent {
    public static String LENS_LOCATION_PROPERTY = "lensLocation";
    static final String ZOOM_WINDOW_CLOSED_PROPERTY = "zoomWindowClosed";
    static final int LENS_DEFAULT_WIDTH = 50;
    static final int LENS_DEFAULT_HEIGHT = 50;
    static final float DEFAULT_ZOOM = 2.0f;
    private LensUI lens;
    private LensMenu menu;
    private LensController lensController;
    private ZoomWindow zoomWindow;
    private LensModel lensModel;

    void setDisplayInPixels(boolean b) {
        this.zoomWindow.setDisplayInPixels(b);
        this.zoomWindow.setLensXY(this.lens.getX(), this.lens.getY());
        this.zoomWindow.setLensWidthHeight(this.lens.getWidth(), this.lens.getHeight());
    }

    void setLensSize(int lensSize) {
        switch (lensSize) {
            case 0: {
                this.lensController.setLensSize(50, 50);
                break;
            }
            case 1: {
                this.lensController.setLensSize(40, 40);
                break;
            }
            case 2: {
                this.lensController.setLensSize(50, 50);
                break;
            }
            case 3: {
                this.lensController.setLensSize(60, 60);
                break;
            }
            case 4: {
                this.lensController.setLensSize(70, 70);
                break;
            }
            case 5: {
                this.lensController.setLensSize(80, 80);
                break;
            }
            case 6: {
                this.lensController.setLensSize(90, 90);
                break;
            }
            case 7: {
                this.lensController.setLensSize(100, 100);
                break;
            }
            case 8: {
                this.lensController.setLensSize(120, 120);
                break;
            }
            case 9: {
                this.lensController.setLensSize(150, 150);
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    void updateLensLocation() {
        Rectangle bounds = this.lensModel.getLensScaledBounds();
        this.firePropertyChange(LENS_LOCATION_PROPERTY, null, bounds);
    }

    public LensComponent(JFrame parent, BufferedImage planeImage) {
        this.lensModel = new LensModel(planeImage);
        this.zoomWindow = new ZoomWindow(parent, this);
        this.lens = new LensUI(this, 50, 50);
        this.lensController = new LensController(this.lensModel, this.lens, this.zoomWindow);
        this.lensModel.setWidth(50);
        this.lensModel.setHeight(50);
        this.lensModel.setImageZoomFactor(1.0f);
        this.lens.addController(this.lensController);
        this.lens.setLensColour(this.lensModel.getLensPreferredColour());
        this.zoomWindow.addController(this.lensController);
        this.menu = new LensMenu(this);
        this.lens.setPopupMenu(this.menu.getPopupMenu());
        this.zoomWindow.setMenu(this.menu.getMenubar());
    }

    public LensComponent(JFrame parent) {
        this(parent, null);
    }

    public void setLensPreferredColour() {
        this.lens.setLensColour(this.lensModel.getLensPreferredColour());
    }

    public void zoomWindowClosed() {
        this.zoomWindow.setVisible(false);
        this.lens.setVisible(false);
    }

    public void setXYPixelMicron(float x, float y) {
        this.zoomWindow.setXYPixelMicron(x, y);
    }

    public void setPlaneImage(BufferedImage img) {
        this.lensModel.setPlaneImage(img);
        this.zoomWindow.setZoomImage(this.lensModel.getZoomedImage());
        this.zoomWindow.repaint();
    }

    public void setVisible(boolean makeVisible) {
        this.lens.setVisible(makeVisible);
        this.zoomWindow.setVisible(makeVisible);
    }

    public void setImageZoomFactor(float imageZoomFactor) {
        this.lensModel.setImageZoomFactor(imageZoomFactor);
        this.lens.setImageZoomFactor();
    }

    public void setZoomFactor(float zoomFactor) {
        this.lensController.setZoomFactor(zoomFactor);
    }

    public void setLensLocation(int x, int y) {
        this.lensController.setLensLocation(x, y);
    }

    public BufferedImage getZoomedImage() {
        return this.lensModel.getZoomedImage();
    }

    public LensUI getLensUI() {
        return this.lens;
    }

    public boolean isVisible() {
        return this.lens.isVisible() && this.zoomWindow.isVisible();
    }

    public void setLensLocation(Point loc) {
        this.setLensLocation(loc.x, loc.y);
    }

    public Dimension getLensScaledSize() {
        return this.lensModel.getLensScaledSize();
    }

    public Point getLensScaledLocation() {
        return this.lensModel.getLensScaledLocation();
    }

    public void setLensColour(Color color) {
        if (color == null) {
            return;
        }
        this.lens.setLensColour(color);
    }

    public Rectangle getLensScaledBounds() {
        return this.lensModel.getLensScaledBounds();
    }

    public Point getLensLocation() {
        return this.lensModel.getLensLocation();
    }

    public Component getZoomWindowUI() {
        return this.zoomWindow.getUI();
    }

    public BufferedImage createZoomedImage(BufferedImage image) {
        if (image == null) {
            return null;
        }
        return this.lensModel.createZoomedImage(image);
    }

    public void resetLens(BufferedImage image, float f, int x, int y) {
        this.lensModel.setImageZoomFactor(f);
        this.lensModel.setPlaneImage(image);
        this.lensModel.setLensLocation(x, y);
        this.lens.setImageZoomFactor();
        this.lensController.setLensLocation(x, y);
        this.zoomWindow.setZoomImage(this.lensModel.getZoomedImage());
        this.zoomWindow.repaint();
    }
}

