/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.graphutils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.openmicroscopy.shoola.util.ui.graphutils.PointRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScatterPlot {
    private static final int SHAPESIZE = 3;
    private JFreeChart freeChart;
    private NumberAxis domainAxis;
    private NumberAxis rangeAxis;
    private ChartPanel charts;
    private JPanel graphPanel;
    private String title;
    private List<String> legends;
    private List<Color> colours;
    private DefaultXYDataset dataset;
    private PointRenderer renderer;
    private List<double[][]> data;
    private List<Shape> shapes;

    private void init() {
        this.legends = new ArrayList<String>();
        this.data = new ArrayList<double[][]>();
        this.colours = new ArrayList<Color>();
        this.shapes = new ArrayList<Shape>();
        this.dataset = new DefaultXYDataset();
    }

    private Ellipse2D createDefaultShape() {
        return new Ellipse2D.Double(-3.0, -3.0, 3.0, 3.0);
    }

    public ScatterPlot() {
        this.init();
    }

    public ScatterPlot(String title, List<String> newLegends, List<double[][]> newData, List<Color> newColours, List<Shape> newShapes) {
        if (newLegends == null || newData == null || newColours == null || newShapes == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size() && newLegends.size() != newShapes.size()) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.title = title;
        this.init();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addSeries(newLegends.get(i), newData.get(i), newColours.get(i), newShapes.get(i));
        }
        this.setDefaultAxis();
    }

    public ScatterPlot(String title, List<String> newLegends, List<double[][]> newData, List<Color> newColours) {
        if (newLegends == null || newData == null || newColours == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size()) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.title = title;
        this.init();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addSeries(newLegends.get(i), newData.get(i), newColours.get(i));
        }
        this.setDefaultAxis();
    }

    public void setDefaultAxis() {
        this.setXAxisName("X");
        this.setYAxisName("Y");
    }

    public void setXAxisRange(double axisMinRange, double axisMaxRange) {
        this.domainAxis.setAutoRange(false);
        this.domainAxis.setRange(axisMinRange, axisMaxRange);
    }

    public void setXAxisName(String axisName) {
        if (axisName == null) {
            throw new IllegalArgumentException("Null parameter for Axis name.");
        }
        this.domainAxis = new NumberAxis(axisName);
    }

    public void setYAxisRange(double axisMinRange, double axisMaxRange) {
        this.rangeAxis.setAutoRange(false);
        this.rangeAxis.setRange(axisMinRange, axisMaxRange);
    }

    public void setYAxisName(String axisName) {
        if (axisName == null) {
            throw new IllegalArgumentException("Null parameter for Axis name.");
        }
        this.rangeAxis = new NumberAxis(axisName);
    }

    public int addSeries(String legend, double[][] newData, Color color, Shape shape) {
        this.legends.add(legend);
        this.data.add(newData);
        this.colours.add(color);
        this.shapes.add(shape);
        this.dataset.addSeries((Comparable)((Object)legend), newData);
        return this.dataset.getSeriesCount();
    }

    public int addSeries(String legend, double[][] newData, Color color) {
        this.legends.add(legend);
        this.data.add(newData);
        this.colours.add(color);
        this.shapes.add(this.createDefaultShape());
        this.dataset.addSeries((Comparable)((Object)legend), newData);
        return this.dataset.getSeriesCount();
    }

    public JPanel getChart() {
        this.renderer = new PointRenderer(this.colours, this.shapes);
        XYPlot plot = new XYPlot((XYDataset)this.dataset, (ValueAxis)this.domainAxis, (ValueAxis)this.rangeAxis, (XYItemRenderer)this.renderer);
        this.freeChart = new JFreeChart(this.title, (Plot)plot);
        this.charts = new ChartPanel(this.freeChart);
        this.graphPanel = new JPanel();
        this.graphPanel.setLayout(new BorderLayout());
        this.graphPanel.add((Component)this.charts, "Center");
        return this.graphPanel;
    }
}

