/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.graphutils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.Rotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieChart {
    private JFreeChart freeChart;
    private NumberAxis domainAxis;
    private NumberAxis rangeAxis;
    private ChartPanel charts;
    private JPanel graphPanel;
    private String title;
    private List<String> legends;
    private List<Color> colours;
    private List<Double> data;
    private DefaultPieDataset dataset;

    private void init() {
        this.legends = new ArrayList<String>();
        this.data = new ArrayList<Double>();
        this.colours = new ArrayList<Color>();
        this.dataset = new DefaultPieDataset();
    }

    public PieChart() {
        this.init();
    }

    public PieChart(String title, List<String> newLegends, List<Double> newData, List<Color> newColours) {
        if (newLegends == null || newData == null || newColours == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size()) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.title = title;
        this.init();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addValue(newLegends.get(i), newData.get(i), newColours.get(i));
        }
        this.setDefaultAxis();
    }

    public void setDefaultAxis() {
        this.setXAxis("X");
        this.setYAxis("Y");
    }

    public void setXAxis(String axisName) {
        if (axisName == null) {
            throw new IllegalArgumentException("Null parameter for Axis name.");
        }
        this.domainAxis = new NumberAxis(axisName);
    }

    public void setYAxis(String axisName) {
        if (axisName == null) {
            throw new IllegalArgumentException("Null parameter for Axis name.");
        }
        this.rangeAxis = new NumberAxis(axisName);
    }

    public int addValue(String legend, double newData, Color color) {
        this.legends.add(legend);
        this.data.add(newData);
        this.colours.add(color);
        this.dataset.setValue((Comparable)((Object)legend), newData);
        return this.dataset.getItemCount();
    }

    public JPanel getChart() {
        this.freeChart = ChartFactory.createPieChart3D((String)this.title, (PieDataset)this.dataset, (boolean)false, (boolean)true, (boolean)false);
        PiePlot3D plot = (PiePlot3D)this.freeChart.getPlot();
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setForegroundAlpha(0.55f);
        this.charts = new ChartPanel(this.freeChart);
        this.graphPanel = new JPanel();
        this.graphPanel.setLayout(new BorderLayout());
        this.graphPanel.add((Component)this.charts, "Center");
        return this.graphPanel;
    }
}

