/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.graphutils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.XYDataset;
import org.openmicroscopy.shoola.util.ui.graphutils.HistogramBarRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistogramPlot {
    private JFreeChart freeChart;
    private NumberAxis domainAxis;
    private NumberAxis rangeAxis;
    private ChartPanel charts;
    private JPanel graphPanel;
    private String title;
    private List<String> legends;
    private List<Color> colours;
    private List<double[]> data;
    private HistogramDataset dataset;
    private HistogramBarRenderer renderer;

    private void init() {
        this.legends = new ArrayList<String>();
        this.data = new ArrayList<double[]>();
        this.colours = new ArrayList<Color>();
        this.dataset = new HistogramDataset();
    }

    public HistogramPlot() {
        this.init();
    }

    public HistogramPlot(String title, List<String> newLegends, List<double[]> newData, List<Color> newColours, int bins) {
        if (newLegends == null || newData == null || newColours == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size() || newLegends.size() == 0 || bins < 1) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.title = title;
        this.init();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addSeries(newLegends.get(i), newData.get(i), newColours.get(i), bins);
        }
        this.setDefaultAxis();
    }

    public HistogramPlot(String title, List<String> newLegends, List<double[]> newData, List<Color> newColours, int bins, double minValue, double maxValue) {
        if (newLegends == null || newData == null || newColours == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size() || newLegends.size() == 0 || bins < 1) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.title = title;
        this.init();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addSeries(newLegends.get(i), newData.get(i), newColours.get(i), bins);
        }
        this.setDefaultAxis();
        this.domainAxis.setRange(minValue, maxValue);
    }

    public void setDefaultAxis() {
        this.setXAxisName("X");
        this.setYAxisName("Y");
    }

    public void setXAxisRange(double axisMinRange, double axisMaxRange) {
        this.domainAxis.setRange(axisMinRange, axisMaxRange);
        this.domainAxis.setAutoRange(false);
    }

    public void setXAxisName(String axisName) {
        if (axisName == null) {
            throw new IllegalArgumentException("Null parameter for Axis name.");
        }
        this.domainAxis = new NumberAxis(axisName);
    }

    public void setYAxisRange(double axisMinRange, double axisMaxRange) {
        this.rangeAxis.setRange(axisMinRange, axisMaxRange);
        this.rangeAxis.setAutoRange(false);
    }

    public void setYAxisName(String axisName) {
        if (axisName == null) {
            throw new IllegalArgumentException("Null parameter for Axis name.");
        }
        this.rangeAxis = new NumberAxis(axisName);
    }

    public int addSeries(String legend, double[] newData, Color color, int bins) {
        if (legend == null || newData == null || color == null || bins < 1) {
            throw new IllegalArgumentException("Illegal argument in addSeries.");
        }
        this.legends.add(legend);
        this.data.add(newData);
        this.colours.add(color);
        this.dataset.addSeries((Comparable)((Object)legend), newData, bins);
        return this.dataset.getSeriesCount();
    }

    public JPanel getChart() {
        this.renderer = new HistogramBarRenderer(this.colours);
        for (int i = 0; i < this.colours.size(); ++i) {
            this.renderer.setSeriesPaint(i, this.colours.get(i));
        }
        XYPlot plot = new XYPlot((XYDataset)this.dataset, (ValueAxis)this.domainAxis, (ValueAxis)this.rangeAxis, (XYItemRenderer)this.renderer);
        this.freeChart = new JFreeChart(this.title, (Plot)plot);
        this.freeChart.setTitle(this.title);
        this.charts = new ChartPanel(this.freeChart);
        this.graphPanel = new JPanel();
        this.graphPanel.setLayout(new BorderLayout());
        this.graphPanel.add((Component)this.charts, "Center");
        return this.graphPanel;
    }
}

