/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.component;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.util.ui.component.ObservableComponent;

public abstract class AbstractComponent
implements ObservableComponent {
    private Set changeRegistry = new HashSet();
    private ChangeEvent changeEvent = new ChangeEvent(this);
    private Map propsRegistry = new HashMap();
    private Object allPropsKey = new Object();

    protected AbstractComponent() {
    }

    protected void fireStateChange() {
        for (ChangeListener observer : this.changeRegistry) {
            observer.stateChanged(this.changeEvent);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return;
        }
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        Set allPropsListeners = (Set)this.propsRegistry.get(this.allPropsKey);
        Set propListeners = (Set)this.propsRegistry.get(propertyName);
        HashSet notificationSet = new HashSet();
        if (allPropsListeners != null) {
            notificationSet.addAll(allPropsListeners);
        }
        if (propListeners != null) {
            notificationSet.addAll(propListeners);
        }
        this.fireStateChange();
        if (notificationSet.size() == 0) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener observer : notificationSet) {
            observer.propertyChange(event);
        }
    }

    public void addChangeListener(ChangeListener observer) {
        if (observer == null) {
            throw new NullPointerException("No observer.");
        }
        this.changeRegistry.add(observer);
    }

    public void removeChangeListener(ChangeListener observer) {
        if (observer == null) {
            throw new NullPointerException("No observer.");
        }
        this.changeRegistry.remove(observer);
    }

    public void addPropertyChangeListener(PropertyChangeListener observer) {
        if (observer == null) {
            throw new NullPointerException("No observer.");
        }
        HashSet<PropertyChangeListener> allPropsListeners = (HashSet<PropertyChangeListener>)this.propsRegistry.get(this.allPropsKey);
        if (allPropsListeners == null) {
            allPropsListeners = new HashSet<PropertyChangeListener>();
            this.propsRegistry.put(this.allPropsKey, allPropsListeners);
        }
        allPropsListeners.add(observer);
    }

    public void removePropertyChangeListener(PropertyChangeListener observer) {
        if (observer == null) {
            throw new NullPointerException("No observer.");
        }
        Set allPropsListeners = (Set)this.propsRegistry.get(this.allPropsKey);
        if (allPropsListeners != null) {
            allPropsListeners.remove(observer);
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener observer) {
        if (propertyName == null) {
            throw new NullPointerException("No property name.");
        }
        if (observer == null) {
            throw new NullPointerException("No observer.");
        }
        HashSet<PropertyChangeListener> propListeners = (HashSet<PropertyChangeListener>)this.propsRegistry.get(propertyName);
        if (propListeners == null) {
            propListeners = new HashSet<PropertyChangeListener>();
            this.propsRegistry.put(propertyName, propListeners);
        }
        propListeners.add(observer);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener observer) {
        if (propertyName == null) {
            throw new NullPointerException("No property name.");
        }
        if (observer == null) {
            throw new NullPointerException("No observer.");
        }
        Set propListeners = (Set)this.propsRegistry.get(propertyName);
        if (propListeners != null) {
            propListeners.remove(observer);
        }
    }
}

