/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourSwatchUI;
import org.openmicroscopy.shoola.util.ui.colourpicker.HSVColourWheelUI;
import org.openmicroscopy.shoola.util.ui.colourpicker.PaintPotUI;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBControl;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBSliderUI;

class TabbedPaneUI
extends JPanel
implements ChangeListener {
    static final int TEXTBOX_COLUMN = 2;
    private static final String COLOURWHEELPANE = "Colour Wheel Pane";
    private static final String RGBSLIDERPANE = "RGB Slider Pane";
    private static final String SWATCHPANE = "Swatch Pane";
    private JToolBar toolbar;
    private JPanel userActionPanel;
    private JToggleButton colourWheelButton;
    private JToggleButton RGBSlidersButton;
    private JToggleButton colourSwatchButton;
    private JButton acceptButton;
    private JButton revertButton;
    private JButton cancelButton;
    private HSVColourWheelUI colourWheelPane;
    private RGBSliderUI RGBSliderPane;
    private ColourSwatchUI swatchPane;
    private CardLayout tabPaneLayout;
    private JPanel tabPanel;
    private PaintPotUI paintPotPane;
    private RGBControl control;
    private ColourPicker parent;

    private void createToolbar() {
        this.toolbar = new JToolBar();
        IconManager icons = IconManager.getInstance();
        this.colourWheelButton = new JToggleButton(icons.getIcon(2));
        UIUtilities.unifiedButtonLookAndFeel(this.colourWheelButton);
        this.colourWheelButton.setBorderPainted(true);
        this.colourWheelButton.setToolTipText("Show HSV Colour Wheel");
        AbstractAction action = new AbstractAction("HSV Wheel Colour Button"){

            public void actionPerformed(ActionEvent evt) {
                TabbedPaneUI.this.clearToggleButtons();
                TabbedPaneUI.this.pickWheelPane();
            }
        };
        this.colourWheelButton.addActionListener(action);
        this.RGBSlidersButton = new JToggleButton(icons.getIcon(0));
        UIUtilities.unifiedButtonLookAndFeel(this.RGBSlidersButton);
        this.RGBSlidersButton.setBorderPainted(true);
        this.RGBSlidersButton.setToolTipText("Show RGB Colour Sliders");
        action = new AbstractAction("RGB Slider Button"){

            public void actionPerformed(ActionEvent evt) {
                TabbedPaneUI.this.clearToggleButtons();
                TabbedPaneUI.this.pickRGBSliderPane();
            }
        };
        this.RGBSlidersButton.addActionListener(action);
        this.colourSwatchButton = new JToggleButton(icons.getIcon(1));
        this.colourSwatchButton.setToolTipText("Show Colour List");
        UIUtilities.unifiedButtonLookAndFeel(this.colourSwatchButton);
        this.colourSwatchButton.setBorderPainted(true);
        action = new AbstractAction("Colour Swatch Button"){

            public void actionPerformed(ActionEvent evt) {
                TabbedPaneUI.this.clearToggleButtons();
                TabbedPaneUI.this.pickSwatchPane();
            }
        };
        this.colourSwatchButton.addActionListener(action);
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.add(this.colourWheelButton);
        this.toolbar.add(this.RGBSlidersButton);
        this.toolbar.add(this.colourSwatchButton);
    }

    private void createActionbar() {
        this.userActionPanel = new JPanel();
        this.userActionPanel.setLayout(new FlowLayout());
        this.acceptButton = new JButton("Accept");
        this.acceptButton.setToolTipText("Accept Current Colour");
        AbstractAction action = new AbstractAction("Accept Button Action"){

            public void actionPerformed(ActionEvent evt) {
                TabbedPaneUI.this.parent.accept();
            }
        };
        this.parent.getRootPane().setDefaultButton(this.acceptButton);
        this.acceptButton.addActionListener(action);
        this.revertButton = new JButton("Revert");
        this.revertButton.setToolTipText("Revert to Original Colour");
        action = new AbstractAction("Revert Button Action"){

            public void actionPerformed(ActionEvent evt) {
                TabbedPaneUI.this.revertAction();
            }
        };
        this.revertButton.addActionListener(action);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Cancel Selection and Close Colour Picker");
        action = new AbstractAction("Cancel Button Action"){

            public void actionPerformed(ActionEvent evt) {
                TabbedPaneUI.this.parent.cancel();
            }
        };
        this.cancelButton.addActionListener(action);
        this.userActionPanel.add(this.acceptButton);
        this.userActionPanel.add(this.revertButton);
        this.userActionPanel.add(this.cancelButton);
    }

    private void createPanels() {
        this.colourWheelPane = new HSVColourWheelUI(this.control);
        this.paintPotPane = new PaintPotUI(this.control.getColour(), this.control);
        this.RGBSliderPane = new RGBSliderUI(this.control);
        this.swatchPane = new ColourSwatchUI(this.control);
    }

    private void createUI() {
        this.createToolbar();
        this.createActionbar();
        this.createPanels();
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)this.toolbar, "West");
        this.setLayout(new BoxLayout(this, 1));
        this.add(container);
        this.paintPotPane.setPreferredSize(new Dimension(260, 24));
        this.add(Box.createVerticalStrut(5));
        this.add(this.paintPotPane);
        this.add(Box.createVerticalStrut(5));
        this.tabPanel = new JPanel();
        this.tabPaneLayout = new CardLayout();
        this.tabPanel.setLayout(this.tabPaneLayout);
        this.tabPanel.add((Component)this.colourWheelPane, COLOURWHEELPANE);
        this.tabPanel.add((Component)this.RGBSliderPane, RGBSLIDERPANE);
        this.tabPanel.add((Component)this.swatchPane, SWATCHPANE);
        this.add(this.tabPanel);
        this.add(this.userActionPanel);
        this.pickSwatchPane();
    }

    private void clearToggleButtons() {
        this.colourWheelButton.setSelected(false);
        this.RGBSlidersButton.setSelected(false);
        this.colourSwatchButton.setSelected(false);
    }

    private void pickWheelPane() {
        this.colourWheelButton.setSelected(true);
        this.colourWheelPane.setActive(true);
        this.tabPaneLayout.show(this.tabPanel, COLOURWHEELPANE);
        this.RGBSliderPane.setActive(false);
        this.swatchPane.setActive(false);
        this.colourWheelPane.findPuck();
        this.colourWheelPane.refresh();
        this.colourWheelPane.repaint();
    }

    private void pickSwatchPane() {
        this.tabPaneLayout.show(this.tabPanel, SWATCHPANE);
        this.colourSwatchButton.setSelected(true);
        this.swatchPane.setActive(true);
        this.RGBSliderPane.setActive(false);
        this.colourWheelPane.setActive(false);
        this.doLayout();
        this.swatchPane.refresh();
    }

    private void pickRGBSliderPane() {
        this.tabPaneLayout.show(this.tabPanel, RGBSLIDERPANE);
        this.RGBSlidersButton.setSelected(true);
        this.RGBSliderPane.setActive(true);
        this.colourWheelPane.setActive(false);
        this.swatchPane.setActive(false);
        this.doLayout();
        this.RGBSliderPane.refresh();
    }

    TabbedPaneUI(ColourPicker parent, RGBControl c) {
        if (parent == null) {
            throw new NullPointerException("No parent.");
        }
        if (c == null) {
            throw new NullPointerException("No control.");
        }
        this.parent = parent;
        this.control = c;
        this.createUI();
        this.control.addListener(this);
    }

    void revertAction() {
        this.control.revert();
    }

    public void stateChanged(ChangeEvent arg0) {
        if (this.RGBSliderPane != null && this.RGBSliderPane.isVisible()) {
            this.RGBSliderPane.refresh();
        }
        if (this.colourWheelPane != null && this.colourWheelPane.isVisible()) {
            this.colourWheelPane.refresh();
        }
        if (this.swatchPane != null && this.swatchPane.isVisible()) {
            this.swatchPane.refresh();
        }
    }
}

