/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Color;

class RGBModel {
    private float originalRed;
    private float originalGreen;
    private float originalBlue;
    private float originalAlpha;
    private float red;
    private float green;
    private float blue;
    private float alpha;

    private void setV(float v) {
        float[] vals = this.RGBtoHSV();
        vals[2] = v;
        float[] rgb = new float[3];
        rgb = this.HSVtoRGB(vals[0], vals[1], vals[2]);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
    }

    private void setH(float h) {
        float[] vals = this.RGBtoHSV();
        vals[0] = h;
        float[] rgb = new float[3];
        rgb = this.HSVtoRGB(vals[0], vals[1], vals[2]);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
    }

    private void setS(float s) {
        float[] vals = this.RGBtoHSV();
        vals[1] = s;
        float[] rgb = new float[3];
        rgb = this.HSVtoRGB(vals[0], vals[1], vals[2]);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
    }

    RGBModel(float r, float g, float b, float a) {
        this.originalRed = r;
        this.originalGreen = g;
        this.originalBlue = b;
        this.originalAlpha = a;
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
    }

    float getRed() {
        return this.red;
    }

    float getGreen() {
        return this.green;
    }

    float getBlue() {
        return this.blue;
    }

    float getAlpha() {
        return this.alpha;
    }

    float getHue() {
        float[] vals = this.RGBtoHSV();
        return vals[0];
    }

    float getSaturation() {
        float[] vals = this.RGBtoHSV();
        return vals[1];
    }

    float getValue() {
        float[] vals = this.RGBtoHSV();
        return vals[2];
    }

    void setValue(float v) {
        this.setV(v);
    }

    void setHue(float h) {
        this.setH(h);
    }

    void setSaturation(float s) {
        this.setS(s);
    }

    void setRed(float r) {
        this.red = r;
    }

    void setGreen(float g) {
        this.green = g;
    }

    void setBlue(float b) {
        this.blue = b;
    }

    void setAlpha(float a) {
        this.alpha = a;
    }

    void setColour(Color c) {
        this.red = (float)c.getRed() / 255.0f;
        this.green = (float)c.getGreen() / 255.0f;
        this.blue = (float)c.getBlue() / 255.0f;
    }

    void setRGBColour(float r, float g, float b, float a) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
    }

    void setHSVColour(float h, float s, float v, float a) {
        float[] rgb = new float[3];
        rgb = this.HSVtoRGB(h, s, v);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
        this.alpha = a;
    }

    Color getColour() {
        return new Color(this.red, this.green, this.blue, this.alpha);
    }

    float[] RGBtoHSV() {
        float s;
        float max;
        float[] hsv = new float[3];
        float min = this.findMin(this.red, this.green, this.blue);
        float v = max = this.findMax(this.red, this.green, this.blue);
        float delta = max - min;
        if (max != 0.0f) {
            s = delta / max;
        } else {
            v = 0.0f;
            s = 0.0f;
            float f = 0.0f;
        }
        float h = 0.0f;
        if (this.red == max) {
            h = (this.green - this.blue) / delta;
        } else if (this.green == max) {
            h = 2.0f + (this.blue - this.red) / delta;
        } else if (this.blue == max) {
            h = 4.0f + (this.red - this.green) / delta;
        }
        h *= 60.0f;
        if (h < 0.0f) {
            h += 360.0f;
        }
        hsv[0] = h /= 360.0f;
        hsv[1] = s;
        hsv[2] = v;
        return hsv;
    }

    float findMin(float a, float b, float c) {
        if (a <= b && a <= c) {
            return a;
        }
        if (b <= a && b <= c) {
            return b;
        }
        if (c <= a && c <= b) {
            return c;
        }
        return c;
    }

    float findMax(float a, float b, float c) {
        if (a >= b && a >= c) {
            return a;
        }
        if (b > a && b > c) {
            return b;
        }
        return c;
    }

    float[] HSVtoRGB(float h, float s, float v) {
        float b;
        float g;
        float r;
        float[] rgb = new float[3];
        if (s == 0.0f) {
            float r2;
            float b2;
            float g2 = b2 = v;
            rgb[0] = r2 = b2;
            rgb[1] = g2;
            rgb[2] = b2;
            return rgb;
        }
        int i = (int)Math.floor(h *= 6.0f);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            default: {
                r = v;
                g = p;
                b = q;
            }
        }
        rgb[0] = r;
        rgb[1] = g;
        rgb[2] = b;
        return rgb;
    }

    Color getOriginalColor() {
        return new Color(this.originalRed, this.originalGreen, this.originalBlue, this.originalAlpha);
    }

    void revert() {
        this.red = this.originalRed;
        this.green = this.originalGreen;
        this.blue = this.originalBlue;
        this.alpha = this.originalAlpha;
    }
}

